/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class CacheMap {
    private final Map entries = new HashMap();
    private boolean enabled = true;
    private boolean fixed = false;
    private Removed removed = Removed.NULL;
    final LRUQueue lru = new LRUQueue(this);
    final TTLQueue ttl = new TTLQueue(this);

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getSize() {
        return this.entries.size();
    }

    public Removed getRemoved() {
        return this.removed;
    }

    public void setFixedOnPut(boolean enabled) {
        this.fixed = enabled;
    }

    public boolean isFixedOnPut() {
        return this.fixed;
    }

    public long getTTL() {
        return this.ttl.duration;
    }

    public void setTTL(long duration) {
        this.ttl.duration = duration;
    }

    public int getLRUMaxSize() {
        return this.lru.max;
    }

    public void setLRUMaxSize(int max) {
        this.lru.setMax(max);
    }

    public boolean isLRUSoft() {
        return this.lru.soft;
    }

    public void setLRUSoft(boolean soft) {
        this.lru.soft = soft;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (!enabled) {
            this.clear();
        }
    }

    public void setRemoved(Removed queue) {
        this.removed = queue != null ? queue : Removed.NULL;
    }

    public Entry get(Object key) {
        Entry entry;
        Entry entry2 = entry = key == null ? null : (Entry)this.entries.get(key);
        if (entry == null) {
            return null;
        }
        if (entry.isExpired() || !this.lru.touch(entry)) {
            this.remove(entry);
            return null;
        }
        return entry;
    }

    public boolean put(Entry entry) {
        if (entry.isQueued() || entry.value == null || !this.enabled) {
            return false;
        }
        this.remove(entry.key);
        if (this.fixed) {
            entry.fixed = true;
        }
        this.attach(entry);
        if (!this.lru.enqueue(entry)) {
            this.detach(entry);
            return false;
        }
        this.ttl.enqueue(entry);
        return true;
    }

    public Entry remove(Object key) {
        Entry entry;
        this.scrub();
        Entry entry2 = entry = key == null ? null : (Entry)this.entries.get(key);
        if (entry == null) {
            return null;
        }
        this.remove(entry);
        return entry.value == null ? null : entry;
    }

    void remove(Entry entry) {
        this.lru.dequeue(entry);
        this.ttl.dequeue(entry);
        this.detach(entry);
        this.removed.add(entry);
    }

    private void attach(Entry entry) {
        this.entries.put(entry.key, entry);
        entry.map = this;
    }

    private void detach(Entry entry) {
        this.entries.remove(entry.key);
        entry.map = null;
    }

    public void scrub() {
        this.lru.scrub();
        this.ttl.scrub();
    }

    public void clear() {
        if (this.entries.size() == 0) {
            return;
        }
        Collection values = this.entries.values();
        Entry[] entries = values.toArray(new Entry[values.size()]);
        for (int i = 0; i < entries.length; ++i) {
            this.remove(entries[i]);
        }
        this.lru.scrub();
        this.removed.clear();
    }

    public Object getValue(Object key) {
        Entry entry = this.get(key);
        return entry == null ? null : entry.getValue();
    }

    public boolean putValue(Object key, Object value) {
        return this.put(new Entry(key, value));
    }

    public Object removeValue(Object key) {
        Entry removed = this.remove(key);
        return removed == null ? null : removed.getValue();
    }

    public Object[] getKeys() {
        this.scrub();
        return this.entries.keySet().toArray();
    }

    public Entry[] getEntries() {
        this.scrub();
        Collection values = this.entries.values();
        return values.toArray(new Entry[values.size()]);
    }

    public Object[] getValues() {
        Entry[] entries = this.getEntries();
        ArrayList<Object> values = new ArrayList<Object>(entries.length);
        for (int i = 0; i < entries.length; ++i) {
            Object value = entries[i].getValue();
            if (value == null) continue;
            values.add(value);
        }
        return values.toArray();
    }

    public static long time() {
        return System.currentTimeMillis();
    }

    public String toString() {
        return "{enabled=" + this.enabled + ", fixed=" + this.fixed + ", entries=" + this.entries + ", lru=" + this.lru + ", ttl=" + this.ttl + ", removed=" + this.removed + "}";
    }

    public static class Removed
    extends Queue {
        public static final Removed NULL = new Removed(0);

        private Removed(int x) {
            super(null, null);
        }

        public Removed() {
            super(null, new Entry(null));
        }

        public Entry poll() {
            if (this.head == null || this.head.lruNext == this.head) {
                return null;
            }
            Entry entry = this.head.lruNext;
            this.detach(entry);
            return entry;
        }

        public void add(Entry entry) {
            if (entry.isQueued()) {
                throw new IllegalStateException("entry.queued");
            }
            if (this.head == null) {
                return;
            }
            this.attach(entry);
        }

        public void clear() {
            if (this.head == null) {
                return;
            }
            while (this.head.lruNext != this.head) {
                this.detach(this.head.lruNext);
            }
        }
    }

    private static final class Reference
    extends SoftReference {
        final Entry entry;

        Reference(Entry entry, ReferenceQueue released) {
            super(entry.value, released);
            this.entry = entry;
        }
    }

    private static final class LRUQueue
    extends Queue {
        int size = 0;
        int max = Integer.MAX_VALUE;
        boolean soft = false;
        private final ReferenceQueue released = new ReferenceQueue();

        LRUQueue(CacheMap map) {
            super(map, new Entry(map));
        }

        void setMax(int max) {
            this.max = max;
            this.scrub();
        }

        boolean setFixed(Entry entry, boolean fixed) {
            if (entry.fixed == fixed) {
                return true;
            }
            if (!this.dequeue(entry)) {
                return false;
            }
            entry.fixed = fixed;
            return this.enqueue(entry);
        }

        boolean touch(Entry entry) {
            if (this.max <= 0 && this.soft && entry.reference != null) {
                return entry.reference.get() != null;
            }
            return this.enqueue(entry);
        }

        boolean enqueue(Entry entry) {
            if (!this.dequeue(entry)) {
                return false;
            }
            if (entry.fixed) {
                return true;
            }
            if (this.max > 0) {
                this.attach(entry);
                return true;
            }
            return this.reference(entry);
        }

        boolean dequeue(Entry entry) {
            if (entry.fixed) {
                return true;
            }
            if (entry.reference != null) {
                return this.dereference(entry);
            }
            if (this.isQueued(entry)) {
                this.detach(entry);
                return true;
            }
            return entry.value != null;
        }

        private boolean reference(Entry entry) {
            if (!this.soft) {
                return false;
            }
            entry.reference = new Reference(entry, this.released);
            entry.value = null;
            return true;
        }

        private boolean dereference(Entry entry) {
            entry.value = entry.reference.get();
            entry.reference = null;
            return entry.value != null;
        }

        void attach(Entry entry, Entry next) {
            super.attach(entry, next);
            if (++this.size > this.max) {
                this.soften(this.head.lruNext);
            }
        }

        void detach(Entry entry) {
            super.detach(entry);
            --this.size;
        }

        void scrub() {
            Reference reference = (Reference)this.released.poll();
            while (reference != null) {
                if (reference.entry.reference != null) {
                    this.map.remove(reference.entry);
                }
                reference = (Reference)this.released.poll();
            }
            while (this.size > this.max && this.head.lruNext != this.head) {
                this.soften(this.head.lruNext);
            }
        }

        private void soften(Entry entry) {
            if (!this.dequeue(entry) || !this.reference(entry)) {
                this.map.remove(entry);
            }
        }

        public String toString() {
            return "{size=" + this.size + ", max=" + (this.max == Integer.MAX_VALUE ? "none" : String.valueOf(this.max)) + ", soft=" + this.soft + ", entries=" + super.toString() + "}";
        }
    }

    private static final class TTLQueue
    extends Queue {
        long duration = Long.MAX_VALUE;

        TTLQueue(CacheMap map) {
            super(map, new Entry(map));
        }

        void setExpiry(Entry entry, long expiry) {
            entry.expiry = expiry;
            this.enqueue(entry);
        }

        void enqueue(Entry entry) {
            long expiry;
            this.dequeue(entry);
            if (entry.expiry == 0L) {
                expiry = CacheMap.time() + (this.duration < 0L ? 0L : this.duration);
                long l = entry.expiry = expiry > 0L ? expiry : Long.MAX_VALUE;
            }
            if ((expiry = entry.expiry) == Long.MAX_VALUE) {
                return;
            }
            if (expiry <= this.head.ttlNext.expiry) {
                this.attach(entry, this.head.ttlNext);
                return;
            }
            Entry next = this.head;
            while (expiry < next.ttlPrev.expiry) {
                next = next.ttlPrev;
            }
            this.attach(entry, next);
        }

        void dequeue(Entry entry) {
            if (!this.isQueued(entry)) {
                return;
            }
            this.detach(entry);
        }

        boolean isQueued(Entry entry) {
            return entry.map == this.map && entry.ttlNext != entry;
        }

        void scrub() {
            long time = CacheMap.time();
            Entry entry = this.head.ttlNext;
            while (entry.expiry <= time && entry != this.head) {
                this.map.remove(entry);
                entry = this.head.ttlNext;
            }
        }

        void attach(Entry entry, Entry next) {
            entry.ttlNext = next;
            entry.ttlPrev = next.ttlPrev;
            next.ttlPrev.ttlNext = entry;
            next.ttlPrev = entry;
        }

        void detach(Entry entry) {
            entry.ttlPrev.ttlNext = entry.ttlNext;
            entry.ttlNext.ttlPrev = entry.ttlPrev;
            entry.ttlNext = entry.ttlPrev = entry;
        }

        public String toString() {
            return "{duration=" + (this.duration == Long.MAX_VALUE ? "max" : String.valueOf(this.duration)) + ", entries=" + super.toString() + "}";
        }
    }

    private static abstract class Queue {
        final CacheMap map;
        final Entry head;

        Queue(CacheMap map, Entry head) {
            this.map = map;
            this.head = head;
        }

        boolean isQueued(Entry entry) {
            return entry.map == this.map && entry.lruNext != entry;
        }

        final void attach(Entry entry) {
            this.attach(entry, this.head);
        }

        void attach(Entry entry, Entry next) {
            entry.lruNext = next;
            entry.lruPrev = next.lruPrev;
            next.lruPrev.lruNext = entry;
            next.lruPrev = entry;
        }

        void detach(Entry entry) {
            entry.lruPrev.lruNext = entry.lruNext;
            entry.lruNext.lruPrev = entry.lruPrev;
            entry.lruNext = entry.lruPrev = entry;
        }

        public String toString() {
            if (this.head == null) {
                return "null";
            }
            StringBuffer buffer = new StringBuffer(1024).append('[');
            Entry next = this.head.lruNext;
            while (next != this.head) {
                buffer.append(next).append(", ");
                next = next.lruNext;
            }
            next = this.head.ttlNext;
            while (next != this.head) {
                buffer.append(next).append(", ");
                next = next.ttlNext;
            }
            if (buffer.length() > 1) {
                buffer.setLength(buffer.length() - 2);
            }
            return buffer.append(']').toString();
        }
    }

    public static class Entry {
        CacheMap map;
        final Object key;
        Object value;
        Reference reference;
        long expiry;
        boolean fixed;
        Entry lruNext = this;
        Entry lruPrev = this;
        Entry ttlNext = this;
        Entry ttlPrev = this;

        Entry(CacheMap map) {
            this.map = map;
            this.key = null;
            this.expiry = Long.MAX_VALUE;
            this.fixed = true;
        }

        public Entry(Object key, Object value) {
            this(key, value, 0L, false);
        }

        public Entry(Object key, Object value, long expiry) {
            this(key, value, expiry, false);
        }

        public Entry(Object key, Object value, long expiry, boolean fixed) {
            if (key == null) {
                throw new NullPointerException("key == null");
            }
            if (value == null) {
                throw new NullPointerException("value == null");
            }
            this.key = key;
            this.value = value;
            this.expiry = expiry;
            this.fixed = fixed;
        }

        public CacheMap getMap() {
            return this.map;
        }

        public Object getKey() {
            return this.key;
        }

        public long getExpiry() {
            return this.expiry;
        }

        public boolean isFixed() {
            return this.fixed;
        }

        boolean isQueued() {
            return this.map != null || this.lruNext != this;
        }

        boolean isExpired() {
            return this.expiry <= CacheMap.time();
        }

        public Object getValue() {
            Object value = this.value;
            if (value == null && this.reference != null && (value = this.reference.get()) == null) {
                this.map.remove(this);
            }
            return value;
        }

        public void setExpiry(long expiry) {
            if (this.map == null) {
                this.expiry = expiry;
            } else {
                this.map.ttl.setExpiry(this, expiry);
            }
        }

        public void setFixed(boolean fixed) {
            if (this.map == null) {
                this.fixed = fixed;
            } else if (!this.map.lru.setFixed(this, fixed)) {
                this.map.remove(this);
            }
        }

        public void remove() {
            if (this.map != null) {
                this.map.remove(this);
            }
        }

        public boolean equals(Object o) {
            return o == this || o instanceof Entry && this.key.equals(((Entry)o).key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public String toString() {
            return "{key=" + this.key + ", value=" + this.value + ", reference=@" + Integer.toHexString(System.identityHashCode(this.reference)) + ", expiry=" + (this.expiry == Long.MAX_VALUE ? "none" : String.valueOf(this.expiry)) + ", fixed=" + this.fixed + "}";
        }
    }
}

