/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.api.action.PendingAction;
import com.filenet.api.constants.MergeMode;
import com.filenet.api.core.Connection;
import com.filenet.api.core.EngineObject;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.property.FilterElement;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.util.Id;
import com.filenet.apiimpl.collection.DefaultPaging;
import com.filenet.apiimpl.collection.Lists;
import com.filenet.apiimpl.collection.RepositoryRowCollectionImpl;
import com.filenet.apiimpl.core.DependentIdentity;
import com.filenet.apiimpl.core.EngineObjectImpl;
import com.filenet.apiimpl.core.ListImpl;
import com.filenet.apiimpl.core.ObjectFactory;
import com.filenet.apiimpl.core.ObjectReferenceBase;
import com.filenet.apiimpl.core.SetImpl;
import com.filenet.apiimpl.core.SubSetImpl;
import com.filenet.apiimpl.property.ClientInputStream;
import com.filenet.apiimpl.property.PropertiesImpl;
import com.filenet.apiimpl.property.PropertyImpl;
import com.filenet.apiimpl.query.RepositoryStoredSearch;
import com.filenet.apiimpl.query.Search;
import com.filenet.apiimpl.query.SearchContext;
import com.filenet.apiimpl.transport.ChangeRequest;
import com.filenet.apiimpl.transport.DuplicateObjectCache;
import com.filenet.apiimpl.util.DelegateInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;

public class BinaryInputStream
extends DelegateInputStream {
    private Connection connection;
    private int level = 0;

    public static BinaryInputStream getInstance(short version, InputStream v, Connection conn) throws IOException {
        if (version <= 5) {
            return new BinaryInputStream(version, v, conn);
        }
        throw new EngineRuntimeException(ExceptionCode.E_UNSUPPORTED_STREAM, new Object[]{new Integer(version), BinaryInputStream.class.getName()});
    }

    public static BinaryInputStream getInstance(short version, ObjectInputStream v, Connection conn) throws IOException {
        if (version <= 5) {
            return new BinaryInputStream(version, v, conn);
        }
        throw new EngineRuntimeException(ExceptionCode.E_UNSUPPORTED_STREAM, new Object[]{new Integer(version), BinaryInputStream.class.getName()});
    }

    protected BinaryInputStream(short versionVal, InputStream v, Connection conn) throws IOException {
        super(versionVal, v);
        this.connection = conn;
    }

    protected BinaryInputStream(short versionVal, ObjectInputStream ois, Connection conn) throws IOException {
        super(versionVal, ois);
        this.connection = conn;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Object getObject() throws IOException, ClassNotFoundException {
        short t = this.readShort();
        switch (t) {
            case 4: {
                return this.getProperty();
            }
            case 3: {
                return this.getProperties();
            }
            case 2: {
                return this.getEngineObject();
            }
            case 7: {
                return this.getRepositoryRowCollection();
            }
            case 5: {
                return this.getSetCollection();
            }
            case 6: {
                return this.getListCollection();
            }
            case 8: {
                return this.getException();
            }
            case 9: {
                return this.getObjectReference();
            }
            case 10: {
                return this.getPendingActions();
            }
            case 11: {
                return this.getPropertyFilter();
            }
            case 12: {
                return this.getClientInputStream();
            }
            case 13: {
                return this.getChangeRequest();
            }
            case 14: {
                return this.getRepositoryStoredSearch();
            }
            case 1: {
                return this.readObject();
            }
        }
        throw new EngineRuntimeException(ExceptionCode.E_INVALID_OBJ_FOR_SERIALIZATION, new Object[]{new Integer(t)});
    }

    protected Object readObjectOverride() throws IOException, ClassNotFoundException {
        return this.delegated.readObject();
    }

    public PendingAction[] getPendingActions() throws IOException, ClassNotFoundException {
        short size = this.readShort();
        PendingAction[] actions = new PendingAction[size];
        for (short lp = 0; lp < size; lp = (short)(lp + 1)) {
            actions[lp] = (PendingAction)this.readObject();
        }
        return actions;
    }

    public PropertyFilter getPropertyFilter() throws IOException, ClassNotFoundException {
        return (PropertyFilter)this.readObject();
    }

    public FilterElement getFilterElement() throws IOException, ClassNotFoundException {
        return (FilterElement)this.readObject();
    }

    public ClientInputStream getClientInputStream() throws IOException, ClassNotFoundException {
        if (this.readBoolean()) {
            return null;
        }
        ClientInputStream cis = new ClientInputStream();
        cis.deserializeValue(this, this.connection);
        return cis;
    }

    public EngineRuntimeException getException() throws IOException, ClassNotFoundException {
        return (EngineRuntimeException)this.readObject();
    }

    public ObjectReferenceBase getObjectReference() throws IOException, ClassNotFoundException {
        ObjectReferenceBase reference = this.createObjectReference(0xFF & this.readByte());
        if (reference != null) {
            reference.deserializeValue((DelegateInputStream)this, this.connection);
        }
        return reference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyImpl getProperty() throws IOException, ClassNotFoundException {
        int mask = this.readInt();
        if (mask == -1) {
            return null;
        }
        String propName = (String)this.readObject();
        int propMask = mask >> 16;
        PropertyImpl pi = this.createPropertyWithNullValue(propName, mask);
        if ((propMask & 0x10) == 0) {
            DuplicateObjectCache origDupCache = null;
            if (propName != null && (propName.equals("SourceObject") || propName.equals("OriginalObject"))) {
                origDupCache = this.dupObjectCache;
                this.dupObjectCache = new DuplicateObjectCache();
            }
            try {
                pi.deserializeValue(this, this.connection);
            }
            finally {
                if (origDupCache != null) {
                    this.dupObjectCache = origDupCache;
                }
            }
        }
        pi.setDirty((propMask & 0x20) != 0);
        return pi;
    }

    public PropertiesImpl getProperties() throws IOException, ClassNotFoundException {
        PropertiesImpl props = new PropertiesImpl();
        short propSize = this.readShort();
        for (short lp = 0; lp < propSize; lp = (short)(lp + 1)) {
            PropertyImpl pi = this.getProperty();
            props.put(pi);
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EngineObjectImpl getEngineObject() throws IOException, ClassNotFoundException {
        int savedLevel = this.level++;
        try {
            if (this.readBoolean()) {
                EngineObjectImpl engineObjectImpl = null;
                return engineObjectImpl;
            }
            ObjectReferenceBase oa = this.getObjectReference();
            EngineObjectImpl fromCache = this.dupObjectCache.getBestChoice(oa, this.level);
            if (fromCache == null) {
                EngineObjectImpl engineObjectImpl = this.readEngineObject(oa);
                return engineObjectImpl;
            }
            EngineObjectImpl engineObjectImpl = fromCache;
            return engineObjectImpl;
        }
        finally {
            this.level = savedLevel;
        }
    }

    private EngineObjectImpl readEngineObject(ObjectReferenceBase oa) throws IOException, ClassNotFoundException {
        short superClassesSize = this.readShort();
        String[] superClasses = new String[superClassesSize];
        for (short lp = 0; lp < superClassesSize; lp = (short)(lp + 1)) {
            superClasses[lp] = (String)this.readObject();
        }
        Integer accessAllowed = (Integer)this.readObject();
        Integer updateSequenceNumber = (Integer)this.readObject();
        PendingAction[] pendingActions = this.getPendingActions();
        EngineObjectImpl eo = ObjectFactory.getInstance(oa, superClasses, this.connection);
        this.dupObjectCache.putInCache(eo, this.level);
        PropertiesImpl props = this.getProperties();
        eo.setProperties(props);
        if (accessAllowed != null) {
            eo.setInternalAccessAllowed(accessAllowed);
        }
        if (updateSequenceNumber != null) {
            eo.setUpdateSequenceNumber(updateSequenceNumber);
        }
        eo.addPendingActions(pendingActions);
        return eo;
    }

    public EngineObjectImpl getDependentObject(DependentIdentity di) throws IOException, ClassNotFoundException {
        if (this.readBoolean()) {
            return null;
        }
        int superClassesSize = this.readInt();
        String[] superClasses = new String[superClassesSize];
        for (int lp = 0; lp < superClassesSize; ++lp) {
            superClasses[lp] = (String)this.readObject();
        }
        Integer accessAllowed = (Integer)this.readObject();
        PropertiesImpl props = this.getProperties();
        EngineObjectImpl eo = ObjectFactory.getInstance(di, superClasses, this.connection);
        eo.setProperties(props);
        if (accessAllowed != null) {
            eo.setInternalAccessAllowed(accessAllowed);
        }
        return eo;
    }

    public RepositoryRowCollectionImpl getRepositoryRowCollection() throws IOException, ClassNotFoundException {
        if (this.readBoolean()) {
            return null;
        }
        RepositoryRowCollectionImpl rrc = new RepositoryRowCollectionImpl(this.connection);
        rrc.deserializeValue(this, this.connection);
        return rrc;
    }

    public RepositoryStoredSearch getRepositoryStoredSearch() throws IOException, ClassNotFoundException {
        if (this.readBoolean()) {
            return null;
        }
        RepositoryStoredSearch rst = new RepositoryStoredSearch();
        rst.deserializeValue(this, this.connection);
        return rst;
    }

    public SetImpl getSetCollection() throws IOException, ClassNotFoundException {
        if (this.readBoolean()) {
            return null;
        }
        SubSetImpl ssi = new SubSetImpl(null, new ArrayList());
        ssi.deserializeValue(this, this.connection);
        return ssi;
    }

    public ListImpl getListCollection() throws IOException, ClassNotFoundException {
        if (this.readBoolean()) {
            return null;
        }
        int size = this.readInt();
        String icName = (String)this.readObject();
        Class<?> ic = icName != null ? Class.forName(icName) : null;
        boolean hasBeenAttached = this.readBoolean();
        if (size < 1) {
            ListImpl li = Lists.createList(ic, null);
            li.setHasBeenAttached(hasBeenAttached);
            return li;
        }
        boolean holdsEO = EngineObject.class.isAssignableFrom(ic);
        ObjectReferenceBase parent = null;
        String propName = null;
        if (holdsEO && size > 0) {
            parent = this.getObjectReference();
            propName = (String)this.readObject();
        }
        ArrayList<Object> vals = new ArrayList<Object>();
        for (int lp = 0; lp < size; ++lp) {
            if (holdsEO) {
                String className = (String)this.readObject();
                DependentIdentity n = new DependentIdentity(className, parent, propName, new Integer(lp));
                vals.add(this.getDependentObject(n));
                continue;
            }
            vals.add(this.readObject());
        }
        ListImpl li = Lists.createList(ic, vals);
        li.setHasBeenAttached(hasBeenAttached);
        return li;
    }

    public SearchContext getSearchContext() throws IOException, ClassNotFoundException {
        if (this.readBoolean()) {
            return null;
        }
        SearchContext context = new SearchContext();
        context.deserializeValue(this, this.connection);
        return context;
    }

    public DefaultPaging getPagingContext() throws IOException, ClassNotFoundException {
        DefaultPaging paging = this.createPagingContext(0xFF & this.readByte());
        if (paging == null) {
            return null;
        }
        paging.deserializeValue((DelegateInputStream)this, this.connection);
        return paging;
    }

    public Search getSearch() throws IOException, ClassNotFoundException {
        return (Search)this.readObject();
    }

    public MergeMode getMergeMode() throws IOException {
        byte value = this.readByte();
        return value == -1 ? null : MergeMode.getInstanceFromInt(value);
    }

    public Id getId() throws IOException, ClassNotFoundException {
        byte[] bytes = (byte[])this.readObject();
        return bytes == null ? null : new Id(bytes);
    }

    public ChangeRequest getChangeRequest() throws IOException, ClassNotFoundException {
        return new ChangeRequest(this.getPendingActions(), this.getObjectReference(), this.getPropertyFilter(), this.getProperties(), (String)this.readObject(), (Integer)this.readObject());
    }
}

