/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.authentication.util.B64;
import com.filenet.apiimpl.util.BaseLogger;
import com.filenet.apiimpl.util.ConfigValueLookup;
import com.filenet.apiimpl.util.NonceCache;
import com.filenet.apiimpl.util.SubSystem;
import com.filenet.apiimpl.util.UTF8Helper;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;

public class BinaryImpersonation {
    private static final BaseLogger logger = BaseLogger.getBaseLogger(BinaryImpersonation.class, SubSystem.Security);
    private byte[] token;
    private SecureRandom rand;
    private MessageDigest msgDigest;
    private int lenDigest;
    private boolean isOk;
    private static final byte VERSION_ONE = 1;
    private static final int MIN_LEN_KEY = 8;
    private static final int POS_VERSION = 0;
    private static final int POS_NONCE = 1;
    private static final int POS_TIMESTAMP = 9;
    private static final int POS_USERNAME = 17;
    public static final int MIN_TOKEN_LEN = 38;
    private static final long MAX_IMP_SEC_DELTA = ConfigValueLookup.getValueAsInt("imp.TimestampTimeToLiveSeconds", 900);
    private static final long MAX_IMP_MSEC_DELTA = 1000L * MAX_IMP_SEC_DELTA;
    private static final int MIN_CACHED_IMP_NONCES = ConfigValueLookup.getValueAsInt("imp.NonceCacheInitialSize", 500);
    private static final int MAX_CACHED_IMP_NONCES = ConfigValueLookup.getValueAsInt("imp.NonceCacheMaxSize", 0);
    private static NonceCache nonces = new NonceCache(MIN_CACHED_IMP_NONCES, MAX_CACHED_IMP_NONCES, MAX_IMP_SEC_DELTA);

    public BinaryImpersonation(String username) {
        this.rand = null;
        this.msgDigest = null;
        this.isOk = false;
        if (username == null || username.length() == 0) {
            return;
        }
        this.initDigester();
        byte[] utf8Username = UTF8Helper.encode(username);
        this.token = new byte[17 + utf8Username.length + this.lenDigest];
        Arrays.fill(this.token, (byte)0);
        this.token[0] = 1;
        System.arraycopy(utf8Username, 0, this.token, 17, utf8Username.length);
        this.isOk = true;
    }

    public char[] generateToken(byte[] key) {
        if (this.isOk && key != null && key.length >= 8) {
            if (this.rand == null) {
                this.rand = new SecureRandom();
            }
            long nonce = this.rand.nextLong();
            long timestamp = System.currentTimeMillis();
            BinaryImpersonation.long2byte(nonce, this.token, 1);
            BinaryImpersonation.long2byte(timestamp, this.token, 9);
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("generate impersonation token; username=" + this.getUsername() + ", nonce=" + nonce + ", timestamp=" + timestamp);
            }
            byte[] digest = this.figureDigest(key);
            int posDigest = this.token.length - this.lenDigest;
            System.arraycopy(digest, 0, this.token, posDigest, this.lenDigest);
            byte[] token2 = new byte[this.token.length];
            System.arraycopy(this.token, 0, token2, 0, 9);
            int i = 9;
            int j = 0;
            while (i < this.token.length) {
                token2[i] = (byte)(this.token[i] ^ this.token[1 + j % 8]);
                ++i;
                ++j;
            }
            return B64.encodeToChars(token2);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BinaryImpersonation(char[] b64Token, byte[] key) {
        block16: {
            this.rand = null;
            this.msgDigest = null;
            this.isOk = false;
            if (b64Token == null || key == null || key.length < 8) {
                return;
            }
            this.initDigester();
            String username = null;
            try {
                this.token = B64.decodeToBytes(b64Token);
                int posDigest = this.token.length - this.lenDigest;
                if (posDigest > 17 && this.token[0] == 1) {
                    int i = 9;
                    int j = 0;
                    while (i < this.token.length) {
                        int n = i++;
                        this.token[n] = (byte)(this.token[n] ^ this.token[1 + j % 8]);
                        ++j;
                    }
                    byte[] digest = this.figureDigest(key);
                    byte[] tokenDigest = new byte[this.lenDigest];
                    System.arraycopy(this.token, posDigest, tokenDigest, 0, this.lenDigest);
                    username = this.getUsername();
                    if (MessageDigest.isEqual(digest, tokenDigest) && username != null) {
                        int i2 = 0;
                        int j2 = 0;
                        while (i2 < posDigest) {
                            int n = j2 % this.lenDigest;
                            this.token[i2] = (byte)(this.token[i2] ^ digest[n] ^ this.token[posDigest + n]);
                            ++i2;
                            ++j2;
                        }
                        long t1 = System.currentTimeMillis();
                        long ts = this.getTimestamp();
                        long tdelta = t1 - ts;
                        if (logger.isDetailTraceEnabled()) {
                            logger.traceDetail("received impersonation token; username=" + username + ", nonce=" + this.getNonce() + ", timestamp=" + ts + ", age=" + tdelta);
                        }
                        if ((tdelta < 0L ? -tdelta : tdelta) > MAX_IMP_MSEC_DELTA) {
                            logger.error("Impersonation token rejected due to timestamp; username=" + username + ", age=" + tdelta);
                            this.token = null;
                        } else {
                            long nonce = this.getNonce();
                            NonceCache nonceCache = nonces;
                            synchronized (nonceCache) {
                                long age;
                                Long ts0;
                                if (nonces == null) {
                                    nonces = new NonceCache(MIN_CACHED_IMP_NONCES, MAX_IMP_SEC_DELTA);
                                }
                                if ((ts0 = nonces.put(nonce, ts)) != null && ((age = t1 - ts0) < 0L ? -age : age) < MAX_IMP_MSEC_DELTA) {
                                    logger.error("Impersonation token rejected because its nonce was duplicated; username=" + username + ", nonce=" + nonce + ", timestamp=" + ts0 + ", age=" + age);
                                    this.token = null;
                                }
                            }
                        }
                        this.isOk = this.token != null;
                        break block16;
                    }
                    this.token = null;
                    logger.error("Impersonation token rejected due to digest mismatch; username=" + username);
                    break block16;
                }
                logger.error("Badly formed impersonation token");
            }
            catch (Exception ex) {
                logger.error("Unexpected exception when handling impersonation token", ex);
            }
        }
        if (!this.isOk) {
            throw new EngineRuntimeException(ExceptionCode.E_NOT_AUTHENTICATED);
        }
    }

    public byte getVersion() {
        return this.token[0];
    }

    public long getNonce() {
        return BinaryImpersonation.byte2long(this.token, 1);
    }

    public long getTimestamp() {
        return BinaryImpersonation.byte2long(this.token, 9);
    }

    public String getUsername() {
        int len = this.token.length - this.lenDigest - 17;
        byte[] utf8Username = new byte[len];
        System.arraycopy(this.token, 17, utf8Username, 0, len);
        return UTF8Helper.decodeString(utf8Username);
    }

    private static void long2byte(long val, byte[] dest, int offset) {
        for (int i = 7; i >= 0; --i) {
            dest[offset + i] = (byte)(val & 0xFFL);
            val >>= 8;
        }
    }

    private static long byte2long(byte[] src, int offset) {
        long val = 0L;
        for (int i = 0; i < 8; ++i) {
            val = (val << 8) + (long)(src[offset + i] & 0xFF);
        }
        return val;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BinaryImpersonation) {
            BinaryImpersonation that = (BinaryImpersonation)obj;
            if (this.token == that.token) {
                return true;
            }
            return Arrays.equals(this.token, that.token);
        }
        return false;
    }

    private void initDigester() {
        try {
            this.msgDigest = MessageDigest.getInstance("SHA-1");
            this.lenDigest = this.msgDigest.getDigestLength();
        }
        catch (NoSuchAlgorithmException e) {
            throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED, (Object[])null);
        }
    }

    private byte[] figureDigest(byte[] key) {
        this.msgDigest.update(this.token, 0, this.token.length - this.lenDigest);
        this.msgDigest.update(key);
        return this.msgDigest.digest();
    }

    private static void debugToken(String label, byte[] token, byte[] key) {
        if (!logger.isDetailTraceEnabled()) {
            return;
        }
        StringBuffer buf = new StringBuffer(200);
        buf.append('\n');
        buf.append(label);
        buf.append(" token:");
        BinaryImpersonation.byte2hex(buf, token, 0, token.length);
        buf.append('\n');
        buf.append(label);
        buf.append(" key:  ");
        BinaryImpersonation.byte2hex(buf, key, 0, key.length);
        logger.traceDetail(buf.toString());
    }

    private static void byte2hex(StringBuffer buf, byte[] src, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            int b;
            if (i % 2 == 0) {
                buf.append(' ');
            }
            if ((b = src[offset + i] & 0xFF) < 16) {
                buf.append('0');
            }
            buf.append(Integer.toHexString(b));
        }
    }
}

