/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ErrorLoggingLevel;
import com.filenet.api.util.UserContext;
import com.filenet.apiimpl.exception.ExceptionContext;
import com.filenet.apiimpl.util.ConfigValueLookup;
import com.filenet.apiimpl.util.SessionLocator;
import com.filenet.apiimpl.util.SubSystem;
import com.filenet.apiimpl.util.TraceFlag;
import java.util.Enumeration;
import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;

public class BaseLogger {
    private static final String FQCN = BaseLogger.class.getName();
    protected static final String baseTraceLoggerName = "filenet_tracing";
    protected static final String traceLoggerPrefix = "filenet_tracing.";
    private static final String errorLoggerPrefix = "filenet_error.";
    static long defaultLoggerRefreshInterval = 2000L;
    static long loggerRefreshInterval = ConfigValueLookup.getValueAsLong("com.filenet.engine.LoggerRefreshInterval", defaultLoggerRefreshInterval);
    private static final String ENTER_STR = "Enter ";
    private static final String EXIT_STR = "Exit  ";
    private SubSystem mSubSystem;
    private String mClassName;
    private String mErrorLoggerName;
    private String mTraceLoggerNamePrefix;
    private static String[] excludePackages;
    volatile boolean summaryTraceEnabled = false;
    volatile long lastCheckSummary = 0L;
    volatile boolean checkingSummaryTrace = false;
    volatile boolean moderateTraceEnabled = false;
    volatile long lastCheckModerate = 0L;
    volatile boolean checkingModerateTrace = false;
    volatile boolean detailTraceEnabled = false;
    volatile long lastCheckDetailTrace = 0L;
    volatile boolean checkingDetailTrace = false;
    volatile boolean timerTraceEnabled = false;
    volatile long lastCheckTimerTrace = 0L;
    volatile boolean checkingTimerTrace = false;

    private static void checkLog4j() {
        Logger rl = Logger.getRootLogger();
        Enumeration appenders = rl.getAllAppenders();
        if (appenders.hasMoreElements()) {
            return;
        }
        ConsoleAppender appender = new ConsoleAppender();
        appender.setName("defaultConsoleAppender");
        PatternLayout layout = new PatternLayout("%d %5p [%t] - %m%n");
        appender.setLayout((Layout)layout);
        appender.activateOptions();
        rl.addAppender((Appender)appender);
        rl.setLevel(Level.ERROR);
    }

    protected BaseLogger() {
    }

    protected BaseLogger(String name, SubSystem subSystem) {
        this.mSubSystem = subSystem;
        this.mClassName = name;
        StringBuffer errBuf = new StringBuffer();
        errBuf.append(errorLoggerPrefix);
        if (subSystem == null) {
            errBuf.append("null");
        } else {
            errBuf.append(this.mSubSystem.toString());
        }
        if (name != null) {
            errBuf.append(".");
            errBuf.append(name);
        }
        this.mErrorLoggerName = errBuf.toString();
        StringBuffer traceBuf = new StringBuffer();
        traceBuf.append(traceLoggerPrefix);
        if (subSystem == null) {
            traceBuf.append("null");
        } else {
            traceBuf.append(subSystem.toString());
        }
        traceBuf.append(".");
        this.mTraceLoggerNamePrefix = traceBuf.toString();
    }

    public static BaseLogger getBaseLogger(Class clazz, SubSystem subSystem) {
        return new BaseLogger(clazz.getName(), subSystem);
    }

    protected void logMethodName(String fqcn, Level lvl, String prefix, String suffix, Throwable t) {
        String methodName = this.getMethodName(t, 3);
        this.getErrorLogger().log(fqcn, (Priority)lvl, (Object)(prefix + methodName + "()" + suffix), t);
    }

    protected void logMethodNameForTrace(Logger traceLogger, String fqcn, Level lvl, String prefix, String suffix, Throwable t) {
        String methodName = this.getMethodName(t, 3);
        traceLogger.log(fqcn, (Priority)lvl, (Object)(prefix + methodName + "()" + suffix), t);
    }

    protected String getMethodName(Throwable t) {
        String methodName = "<unknown>";
        if (t == null) {
            t = new Throwable();
        }
        StackTraceElement[] elems = t.getStackTrace();
        try {
            StackTraceElement caller = elems[0];
            methodName = caller.getMethodName();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        return methodName;
    }

    protected String getMethodName(Throwable t, int position) {
        String methodName = "<unknown>";
        int pos = 0;
        if (t == null) {
            t = new Throwable();
            pos = position;
        }
        StackTraceElement[] elems = t.getStackTrace();
        try {
            StackTraceElement caller = elems[pos];
            methodName = caller.getMethodName();
            String className = caller.getClassName();
            className = className.substring(className.lastIndexOf(".") + 1);
            StringBuffer buf = new StringBuffer(64);
            buf.append(className);
            buf.append(".");
            buf.append(methodName);
            methodName = buf.toString();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        return methodName;
    }

    public static String getClientMethodInfo() {
        String methodInfo = "";
        if (SessionLocator.isExecutingInServer()) {
            return methodInfo;
        }
        Throwable t = new Throwable();
        StackTraceElement[] elems = t.getStackTrace();
        for (int i = 0; i < elems.length; ++i) {
            try {
                boolean found = false;
                StackTraceElement caller = elems[i];
                for (int j = 0; j < excludePackages.length; ++j) {
                    if (!caller.getClassName().startsWith(excludePackages[j])) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                methodInfo = caller.toString();
                break;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                // empty catch block
            }
        }
        return methodInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logError(EngineRuntimeException erte, String principalName, Boolean isInGlobalTran, Boolean isInUserInitTran) {
        if (!this.getErrorLogger().isEnabledFor((Priority)Level.ERROR) || erte.getExceptionCode().getErrorLoggingLevel() != ErrorLoggingLevel.Required) {
            return;
        }
        UserContext orig = UserContext.get();
        try {
            UserContext.set(null);
            String exceptionInfo = erte.getMessage();
            String methodName = this.getMethodName(erte);
            Object[] args = new Object[]{methodName, principalName, isInGlobalTran, isInUserInitTran, exceptionInfo};
            ExceptionContext logFormat = ExceptionContext.E_ERROR_LOG_FORMAT;
            this.getErrorLogger().log(FQCN, (Priority)Level.ERROR, (Object)logFormat.toString(UserContext.get().getLocale(), args), (Throwable)erte);
        }
        finally {
            UserContext.set(orig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logError(EngineRuntimeException erte) {
        if (!this.getErrorLogger().isEnabledFor((Priority)Level.ERROR) || erte.getExceptionCode().getErrorLoggingLevel() != ErrorLoggingLevel.Required) {
            return;
        }
        UserContext orig = UserContext.get();
        String exceptionInfo = erte.getMessage();
        try {
            UserContext.set(null);
            this.getErrorLogger().log(FQCN, (Priority)Level.ERROR, (Object)exceptionInfo, (Throwable)erte);
        }
        finally {
            UserContext.set(orig);
        }
    }

    protected Object toLogObject(Object s) {
        return s.toString();
    }

    public boolean isInfoEnabled() {
        return this.getErrorLogger().isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.getErrorLogger().isEnabledFor((Priority)Level.WARN);
    }

    public boolean isErrorEnabled() {
        return this.getErrorLogger().isEnabledFor((Priority)Level.ERROR);
    }

    public boolean isFatalEnabled() {
        return this.getErrorLogger().isEnabledFor((Priority)Level.FATAL);
    }

    public boolean isDisabled() {
        return this.getErrorLogger().getEffectiveLevel().equals((Object)Level.OFF);
    }

    public void info(Object s) {
        this.getErrorLogger().log(FQCN, (Priority)Level.INFO, this.toLogObject(s), null);
    }

    public void info(Object s, Throwable t) {
        this.getErrorLogger().log(FQCN, (Priority)Level.INFO, this.toLogObject(s), t);
    }

    public void warn(Object s) {
        this.getErrorLogger().log(FQCN, (Priority)Level.WARN, this.toLogObject(s), null);
    }

    public void warn(Object s, Throwable t) {
        this.getErrorLogger().log(FQCN, (Priority)Level.WARN, this.toLogObject(s), t);
    }

    public void error(Object s) {
        this.getErrorLogger().log(FQCN, (Priority)Level.ERROR, this.toLogObject(s), null);
    }

    public void error(Object s, Throwable t) {
        this.getErrorLogger().log(FQCN, (Priority)Level.ERROR, this.toLogObject(s), t);
    }

    public void fatal(Object s) {
        this.getErrorLogger().log(FQCN, (Priority)Level.FATAL, this.toLogObject(s), null);
    }

    public void fatal(Object s, Throwable t) {
        this.getErrorLogger().log(FQCN, (Priority)Level.FATAL, this.toLogObject(s), t);
    }

    private String getLogLevel(Category logger) {
        Level level;
        while ((level = logger.getLevel()) == null && (logger = logger.getParent()) != null) {
        }
        String levelString = "NoLevel";
        if (level != null) {
            levelString = level.toString();
        }
        return levelString;
    }

    public void printTraceFlags() {
        System.out.println();
        System.out.println("========== " + this.mSubSystem.toString() + "_" + this.mClassName);
        System.out.println("-----: Loggers:");
        System.out.print("Error = " + this.getErrorLogger().getName());
        System.out.println(",  LogLevel = " + this.getLogLevel((Category)this.getErrorLogger()));
        Logger logger = null;
        logger = this.getLogger(TraceFlag.Detail);
        if (logger != null) {
            System.out.print("Detail=" + logger.getName());
            System.out.println(", LogLevel=" + this.getLogLevel((Category)logger));
        }
        if ((logger = this.getLogger(TraceFlag.Timer)) != null) {
            System.out.print("Timer=" + logger.getName());
            System.out.println(", LogLevel=" + this.getLogLevel((Category)logger));
        }
        if ((logger = this.getLogger(TraceFlag.Summary)) != null) {
            System.out.print("Summary=" + logger.getName());
            System.out.println(", LogLevel=" + this.getLogLevel((Category)logger));
        }
        if ((logger = this.getLogger(TraceFlag.Moderate)) != null) {
            System.out.print("Moderate=" + logger.getName());
            System.out.println(", LogLevel=" + this.getLogLevel((Category)logger));
        }
    }

    private Logger getErrorLogger() {
        return Logger.getLogger((String)this.mErrorLoggerName);
    }

    private Logger getLogger(TraceFlag flag) {
        StringBuffer buf = new StringBuffer(64);
        buf.append(this.mTraceLoggerNamePrefix);
        buf.append(flag.getLoggerTraceName());
        if (this.mClassName != null) {
            buf.append(".");
            buf.append(this.mClassName);
        }
        return Logger.getLogger((String)buf.toString());
    }

    private String getSummaryMsg(String serverOperationName, long duration, int numElements) {
        StringBuffer buf = new StringBuffer();
        buf.append(serverOperationName);
        buf.append(" takes ");
        buf.append(duration);
        buf.append(" ms. ");
        buf.append(" Number of Elements ");
        buf.append(numElements);
        return buf.toString();
    }

    public boolean isSummaryTraceEnabled() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastCheckSummary > loggerRefreshInterval && !this.checkingSummaryTrace) {
            this.checkingSummaryTrace = true;
            this.summaryTraceEnabled = this.getLogger(TraceFlag.Summary).isDebugEnabled();
            this.checkingSummaryTrace = false;
            this.lastCheckSummary = currentTime;
        }
        return this.summaryTraceEnabled;
    }

    public boolean isModerateTraceEnabled() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastCheckModerate > loggerRefreshInterval && !this.checkingModerateTrace) {
            this.checkingModerateTrace = true;
            this.moderateTraceEnabled = this.getLogger(TraceFlag.Moderate).isDebugEnabled();
            this.checkingModerateTrace = false;
            this.lastCheckModerate = currentTime;
        }
        return this.moderateTraceEnabled;
    }

    public boolean isDetailTraceEnabled() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastCheckDetailTrace > loggerRefreshInterval && !this.checkingDetailTrace) {
            this.checkingDetailTrace = true;
            this.detailTraceEnabled = this.getLogger(TraceFlag.Detail).isDebugEnabled();
            this.checkingDetailTrace = false;
            this.lastCheckDetailTrace = currentTime;
        }
        return this.detailTraceEnabled;
    }

    public boolean isTimerTraceEnabled() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastCheckTimerTrace > loggerRefreshInterval && !this.checkingTimerTrace) {
            this.checkingTimerTrace = true;
            this.timerTraceEnabled = this.getLogger(TraceFlag.Timer).isDebugEnabled();
            this.checkingTimerTrace = false;
            this.lastCheckTimerTrace = currentTime;
        }
        return this.timerTraceEnabled;
    }

    public void traceEnter() {
        this.logMethodNameForTrace(this.getLogger(TraceFlag.Detail), FQCN, Level.DEBUG, ENTER_STR, "", null);
    }

    public void traceExit() {
        this.logMethodNameForTrace(this.getLogger(TraceFlag.Detail), FQCN, Level.DEBUG, EXIT_STR, "", null);
    }

    public void traceExit(boolean returnedVal) {
        this.logMethodNameForTrace(this.getLogger(TraceFlag.Detail), FQCN, Level.DEBUG, EXIT_STR, " = " + returnedVal, null);
    }

    public void traceExit(char returnedVal) {
        this.logMethodNameForTrace(this.getLogger(TraceFlag.Detail), FQCN, Level.DEBUG, EXIT_STR, " = '" + returnedVal + "'", null);
    }

    public void traceExit(byte returnedVal) {
        this.logMethodNameForTrace(this.getLogger(TraceFlag.Detail), FQCN, Level.DEBUG, EXIT_STR, " = " + returnedVal, null);
    }

    public void traceExit(int returnedVal) {
        this.logMethodNameForTrace(this.getLogger(TraceFlag.Detail), FQCN, Level.DEBUG, EXIT_STR, " = " + returnedVal, null);
    }

    public void traceExit(short returnedVal) {
        this.logMethodNameForTrace(this.getLogger(TraceFlag.Detail), FQCN, Level.DEBUG, EXIT_STR, " = " + returnedVal, null);
    }

    public void traceExit(long returnedVal) {
        this.logMethodNameForTrace(this.getLogger(TraceFlag.Detail), FQCN, Level.DEBUG, EXIT_STR, " = " + returnedVal, null);
    }

    public void traceExit(float returnedVal) {
        this.logMethodNameForTrace(this.getLogger(TraceFlag.Detail), FQCN, Level.DEBUG, EXIT_STR, " = " + returnedVal, null);
    }

    public void traceExit(double returnedVal) {
        this.logMethodNameForTrace(this.getLogger(TraceFlag.Detail), FQCN, Level.DEBUG, EXIT_STR, " = " + returnedVal, null);
    }

    public void traceExit(Object returnedVal) {
        String val = " = ";
        val = returnedVal instanceof String ? val + "\"" + returnedVal + "\"" : val + returnedVal;
        this.logMethodNameForTrace(this.getLogger(TraceFlag.Detail), FQCN, Level.DEBUG, EXIT_STR, val, null);
    }

    protected void traceCallSummary(String serverOperationName, long duration, int numOfElements) {
        String buf = this.getSummaryMsg(serverOperationName, duration, numOfElements);
        this.traceSummary(buf);
    }

    protected void traceCallDetail(String serverOperationName, long duration, int numOfElements, Object msg) {
        String buf = this.getSummaryMsg(serverOperationName, duration, numOfElements) + msg.toString();
        this.traceModerate(buf);
    }

    public void traceTimer(String msg) {
        if (this.isTimerTraceEnabled()) {
            this.getLogger(TraceFlag.Timer).log(FQCN, (Priority)Level.DEBUG, (Object)msg, null);
        }
    }

    public void traceTimer(String msg, long startTimeMs, long endTimeMs) {
        if (this.isTimerTraceEnabled()) {
            this.getLogger(TraceFlag.Timer).log(FQCN, (Priority)Level.DEBUG, (Object)(msg + (endTimeMs - startTimeMs) + " ms"), null);
        }
    }

    public void traceSummary(Object obj) {
        if (this.isSummaryTraceEnabled()) {
            this.getLogger(TraceFlag.Summary).log(FQCN, (Priority)Level.DEBUG, obj, null);
        }
    }

    public void traceModerate(Object obj) {
        if (this.isModerateTraceEnabled()) {
            this.getLogger(TraceFlag.Moderate).log(FQCN, (Priority)Level.DEBUG, obj, null);
        }
    }

    public void traceDetail(Object obj) {
        if (this.isDetailTraceEnabled()) {
            this.getLogger(TraceFlag.Detail).log(FQCN, (Priority)Level.DEBUG, obj, null);
        }
    }

    static {
        BaseLogger.checkLog4j();
        excludePackages = new String[]{"com.filenet.apiimpl", "com.filenet.api", "java", "org.apache", "sun"};
    }
}

