/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.transport.ejb;

import com.filenet.api.constants.ConfigurationParameter;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ErrorRecord;
import com.filenet.api.exception.ErrorStack;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.util.UserContext;
import com.filenet.apiimpl.core.ConnectionImpl;
import com.filenet.apiimpl.core.ContentTransferImpl;
import com.filenet.apiimpl.core.IndependentlyPersistableObjectImpl;
import com.filenet.apiimpl.core.ListUpdate;
import com.filenet.apiimpl.core.ObjectReferenceBase;
import com.filenet.apiimpl.core.Session;
import com.filenet.apiimpl.property.PropertyContentImpl;
import com.filenet.apiimpl.property.PropertyImpl;
import com.filenet.apiimpl.transport.ChangeRequest;
import com.filenet.apiimpl.transport.ClientCallContext;
import com.filenet.apiimpl.transport.ContentHandle;
import com.filenet.apiimpl.transport.ContentRequest;
import com.filenet.apiimpl.transport.ExecuteChangesRequest;
import com.filenet.apiimpl.transport.ExecuteChangesResponse;
import com.filenet.apiimpl.transport.GetContentRequest;
import com.filenet.apiimpl.transport.GetContentResponse;
import com.filenet.apiimpl.transport.GetObjectRequest;
import com.filenet.apiimpl.transport.GetObjectResponse;
import com.filenet.apiimpl.transport.MetadataSearchRequest;
import com.filenet.apiimpl.transport.MetadataSearchResponse;
import com.filenet.apiimpl.transport.SearchRequest;
import com.filenet.apiimpl.transport.SearchResponse;
import com.filenet.apiimpl.transport.TransportLogger;
import com.filenet.apiimpl.transport.ejb.ContentEJB;
import com.filenet.apiimpl.transport.ejb.ContentPush;
import com.filenet.apiimpl.transport.ejbstubs.Engine;
import com.filenet.apiimpl.transport.ejbstubs.EngineHome;
import com.filenet.apiimpl.transport.ejbstubs.EngineLocal;
import com.filenet.apiimpl.transport.ejbstubs.EngineLocalHome;
import com.filenet.apiimpl.util.ConfigValueLookup;
import com.filenet.apiimpl.util.J2EEUtil;
import com.filenet.apiimpl.util.J2EEUtilJB;
import com.filenet.apiimpl.util.SessionContext;
import com.filenet.apiimpl.util.SessionHandle;
import com.filenet.apiimpl.util.SessionLocator;
import com.filenet.apiimpl.util.SubSystem;
import java.io.WriteAbortedException;
import java.net.ConnectException;
import java.net.SocketException;
import java.rmi.AccessException;
import java.rmi.MarshalException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.EJBException;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.rmi.PortableRemoteObject;
import javax.security.auth.Subject;
import javax.transaction.TransactionRolledbackException;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.NO_RESPONSE;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.TRANSIENT;

public final class EJBSession
extends Session {
    private static TransportLogger logger = TransportLogger.getLogger(EJBSession.class, SubSystem.EJB);
    static final boolean DFLT_CONTENT_DOWNLOAD_SERVER_AFFINITY_ENABLED = false;
    static final boolean IGNORE_SIZE_FOR_SERVER_AFFINITY = ConfigValueLookup.getValueAsBoolean("com.filenet.ejb.content.IgnoreSizeForAffinity", false);
    private EJBImpl ejb;
    private volatile Object ejbContentAffinityHome;
    private volatile EJBImpl ejbContentAffinity;

    public EJBSession(Object ejbHome, Context cntx) {
        this.ejb = new EJBImpl(ejbHome);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetContentResponse getContent(ConnectionImpl conn, GetContentRequest request, Long contentSize, ClientCallContext optionalClientCallContext) {
        SessionContext orig = SessionContext.getSessionContext();
        try {
            EJBImpl ejbImpl;
            SessionContext.setSessionContext(new SessionContext(conn));
            GetContentResponse resp = null;
            if (optionalClientCallContext == null) {
                optionalClientCallContext = this.getClientCallContext(conn);
            }
            if ((resp = (ejbImpl = this.getContentEjb(conn, request, contentSize)).getContent(request, optionalClientCallContext)) == null || resp.getBatch().length < 1) {
                throw new EngineRuntimeException(ExceptionCode.TRANSPORT_MISSING_SERVER_RESPONSE, null);
            }
            resp.applyConnectionWhereNeeded(conn);
            GetContentResponse getContentResponse = resp;
            return getContentResponse;
        }
        finally {
            SessionContext.setSessionContext(orig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EJBImpl getContentEjb(ConnectionImpl conn, GetContentRequest request, Long contentSize) {
        EJBImpl ejbImpl = this.ejb;
        boolean useAffinity = ConfigValueLookup.getBoolean(ConfigurationParameter.CONTENT_DOWNLOAD_SERVER_AFFINITY_ENABLED, false);
        if (this.ejb.isLocal()) {
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("EJBSession.getContentEjb: running locally w/in server.  Using stateless ContentEJB.");
            }
            useAffinity = false;
        } else if (conn.participatesInTransaction()) {
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("EJBSession.getContentEjb: running w/in a transaction.  Using stateless ContentEJB.");
            }
            useAffinity = false;
        } else {
            ContentRequest[] cReqBatch;
            Object affinityConnParam = conn.getParameter(ConfigurationParameter.CONTENT_DOWNLOAD_SERVER_AFFINITY_ENABLED);
            if (affinityConnParam != null) {
                if (affinityConnParam instanceof Boolean) {
                    useAffinity = (Boolean)affinityConnParam;
                    if (logger.isDetailTraceEnabled()) {
                        logger.traceDetail("EJBSession.getContentEjb: Server affinity specified on connection for ContentEJB.  useAffinity=" + useAffinity);
                    }
                }
            } else if (useAffinity && IGNORE_SIZE_FOR_SERVER_AFFINITY) {
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("EJBSession.getContentEjb: override enabled to ignore content size.  Using stateful ContentEJB.");
                }
                useAffinity = true;
            } else if (request != null && useAffinity && (cReqBatch = request.getBatch()) != null && cReqBatch.length > 0) {
                ContentRequest contentRequest = cReqBatch[0];
                if (contentRequest.getContinueFrom() == null) {
                    Integer chunkSize = contentRequest.getMaxBytes();
                    if (contentSize != null && chunkSize != null) {
                        useAffinity = contentSize > (long)chunkSize.intValue();
                        if (logger.isDetailTraceEnabled()) {
                            logger.traceDetail("EJBSession.getContentEjb: Content size can be checked for first chunk to determine which ContentEJB to use.  contentSize=" + contentSize + "; chunkSize=" + chunkSize + "; useAffinity=" + useAffinity);
                        }
                    } else {
                        useAffinity = false;
                        if (logger.isDetailTraceEnabled()) {
                            logger.traceDetail("EJBSession.getContentEjb: Content size cannot be checked for first chunk to determine which ContentEJB to use.  contentSize=" + contentSize + "; chunkSize=" + chunkSize + "; useAffinity=" + useAffinity);
                        }
                    }
                } else {
                    useAffinity = true;
                }
            }
        }
        if (useAffinity) {
            if (this.ejbContentAffinity == null) {
                EJBSession eJBSession = this;
                synchronized (eJBSession) {
                    if (this.ejbContentAffinity == null) {
                        if (this.ejbContentAffinityHome == null) {
                            this.ejbContentAffinityHome = SessionLocator.getContentEJB(conn, useAffinity);
                        }
                        this.ejbContentAffinity = new EJBImpl(this.ejbContentAffinityHome);
                        this.ejbContentAffinity.setUseAffinity(useAffinity);
                    }
                }
            }
            ejbImpl = this.ejbContentAffinity;
        }
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("EJBSession.getContentEjb: useAffinity=" + useAffinity + "; ejbImpl=" + ejbImpl);
        }
        return ejbImpl;
    }

    public void beginGetContentSession(ConnectionImpl conn) {
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("EJBSession.beginGetContentSession");
        }
        this.getContentEjb(conn, null, null);
    }

    public void finishGetContentSession(ConnectionImpl conn) {
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("EJBSession.finishGetContentSession");
        }
        if (this.ejbContentAffinity != null) {
            this.ejbContentAffinity.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchResponse executeSearch(ConnectionImpl conn, SearchRequest request, ClientCallContext optionalClientCallContext) {
        SessionContext orig = SessionContext.getSessionContext();
        try {
            SessionContext.setSessionContext(new SessionContext(conn));
            if (optionalClientCallContext == null) {
                optionalClientCallContext = this.getClientCallContext(conn);
            }
            SearchResponse resp = this.ejb.executeSearch(request, optionalClientCallContext);
            resp.applyConnectionWhereNeeded(conn);
            SearchResponse searchResponse = resp;
            return searchResponse;
        }
        finally {
            SessionContext.setSessionContext(orig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetadataSearchResponse getSearchMetadata(ConnectionImpl conn, MetadataSearchRequest request, ClientCallContext optionalClientCallContext) {
        SessionContext orig = SessionContext.getSessionContext();
        try {
            MetadataSearchResponse resp;
            SessionContext.setSessionContext(new SessionContext(conn));
            if (optionalClientCallContext == null) {
                optionalClientCallContext = this.getClientCallContext(conn);
            }
            if ((resp = this.ejb.getSearchMetadata(request, optionalClientCallContext)) == null || resp.getClassDescriptionSet() == null) {
                throw new EngineRuntimeException(ExceptionCode.TRANSPORT_EXPECTED_CLASS_DESCRIPTION);
            }
            resp.applyConnectionWhereNeeded(conn);
            MetadataSearchResponse metadataSearchResponse = resp;
            return metadataSearchResponse;
        }
        finally {
            SessionContext.setSessionContext(orig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecuteChangesResponse executeChanges(ConnectionImpl conn, ExecuteChangesRequest request, ArrayList uploadHandles, ClientCallContext optionalClientCallContext) {
        SessionContext orig = SessionContext.getSessionContext();
        try {
            ClientCallContext ccc;
            SessionContext.setSessionContext(new SessionContext(conn));
            ClientCallContext clientCallContext = ccc = optionalClientCallContext == null ? this.getClientCallContext(conn) : optionalClientCallContext;
            if (uploadHandles != null && !uploadHandles.isEmpty()) {
                ContentPush cp = new ContentPush(conn, uploadHandles, UserContext.get().getSubject(), ccc);
                cp.uploadContent();
            }
            ExecuteChangesResponse resp = this.ejb.executeChanges(request, ccc);
            resp.applyConnectionWhereNeeded(conn);
            ExecuteChangesResponse executeChangesResponse = resp;
            return executeChangesResponse;
        }
        finally {
            SessionContext.setSessionContext(orig);
        }
    }

    public void getContentToUpload(IndependentlyPersistableObjectImpl obj, ChangeRequest cr, ArrayList uploadHandles) {
        if (!cr.getProperties().isPropertyPresent("ContentElements")) {
            return;
        }
        PropertyImpl ceProp = (PropertyImpl)cr.getProperties().get("ContentElements");
        List updateList = ceProp.getUpdateListValue();
        for (ListUpdate lu : updateList) {
            PropertyImpl content;
            if (!(lu.getObject() instanceof ContentTransferImpl) || !lu.getObject().getProperties().isPropertyPresent("Content") || !((content = (PropertyImpl)lu.getObject().getProperties().get("Content")) instanceof PropertyContentImpl) || content.getInstanceValue() instanceof String) continue;
            uploadHandles.add(new ContentHandle((ObjectReferenceBase)obj.getObjectReference(), obj.getPropertiesImpl(), lu.getObject().getPropertiesImpl(), obj.isNew()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetObjectResponse getObjects(ConnectionImpl conn, GetObjectRequest request, ClientCallContext optionalClientCallContext) {
        SessionContext orig = SessionContext.getSessionContext();
        try {
            SessionContext.setSessionContext(new SessionContext(conn));
            GetObjectResponse resp = null;
            if (optionalClientCallContext == null) {
                optionalClientCallContext = this.getClientCallContext(conn);
            }
            resp = this.ejb.getObjects(request, optionalClientCallContext);
            resp.applyConnectionWhereNeeded(conn);
            GetObjectResponse getObjectResponse = resp;
            return getObjectResponse;
        }
        finally {
            SessionContext.setSessionContext(orig);
        }
    }

    public void remove() {
        if (this.ejbContentAffinity != null) {
            this.ejbContentAffinity.remove();
            this.ejbContentAffinity = null;
            this.ejbContentAffinityHome = null;
        }
        if (this.ejb != null) {
            this.ejb.remove();
        }
    }

    private static EngineRuntimeException scanForEngineRuntimeException(Throwable t) {
        if (t instanceof EngineRuntimeException) {
            return (EngineRuntimeException)t;
        }
        if (t.getCause() != null) {
            return EJBSession.scanForEngineRuntimeException(t.getCause());
        }
        if (t instanceof RemoteException && ((RemoteException)t).detail != null) {
            return EJBSession.scanForEngineRuntimeException(((RemoteException)t).detail);
        }
        if (t instanceof EJBException && ((EJBException)t).getCausedByException() != null) {
            return EJBSession.scanForEngineRuntimeException(((EJBException)t).getCausedByException());
        }
        return null;
    }

    protected static void throwException(Throwable t, ExceptionCode exCode) {
        EJBSession.throwException(t, exCode, CurrentOp.UNKNOWN);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void throwException(Throwable t, ExceptionCode exCode, CurrentOp currentOp) {
        EngineRuntimeException appErr = EJBSession.scanForEngineRuntimeException(t);
        if (appErr != null) {
            if (currentOp != CurrentOp.GET_CONTENT && currentOp != CurrentOp.PUT_CONTENT) throw appErr;
            ExceptionCode appExCode = appErr.getExceptionCode();
            if (ExceptionCode.TRANSPORT_EJB_UNABLE_TO_CREATE_CONTENT_DOWNLOAD_EJB == appExCode || ExceptionCode.TRANSPORT_EJB_UNABLE_TO_CREATE_CONTENT_UPLOAD_EJB == appExCode || ExceptionCode.TRANSPORT_EJB_UNABLE_TO_CONNECT == appExCode) {
                throw new EngineRuntimeException((Throwable)appErr, ExceptionCode.E_EXCEPTION_RETRY, null);
            }
            if (ExceptionCode.E_UNEXPECTED_EXCEPTION != appExCode) throw appErr;
            if (EJBSession.isRetryableException(appErr, currentOp)) {
                throw new EngineRuntimeException((Throwable)appErr, ExceptionCode.E_EXCEPTION_RETRY, null);
            }
        }
        if (t instanceof TransactionRolledbackException) {
            throw new EngineRuntimeException(t, ExceptionCode.E_TRANSACTION_FAILURE, null);
        }
        if (currentOp != CurrentOp.NO_RETRY && EJBSession.isRetryableException(t, currentOp)) {
            throw new EngineRuntimeException(t, ExceptionCode.E_EXCEPTION_RETRY, null);
        }
        if (t instanceof AccessException) {
            throw new EngineRuntimeException(t, ExceptionCode.E_NOT_AUTHENTICATED, null);
        }
        if (EJBSession.isJBossBadPassword(t)) {
            throw new EngineRuntimeException(t, ExceptionCode.E_NOT_AUTHENTICATED, null);
        }
        if (!EJBSession.isTimedOutException(t)) throw new EngineRuntimeException(t, exCode, null);
        throw new EngineRuntimeException(t, ExceptionCode.E_TRANSACTION_TIMEOUT, null);
    }

    private static boolean isJBossBadPassword(Throwable t) {
        return J2EEUtil.getInstance() instanceof J2EEUtilJB && (t instanceof UnmarshalException || t instanceof MarshalException) && t.getCause() != null && t.getCause() instanceof WriteAbortedException && t.getCause().getMessage() != null && t.getCause().getMessage().indexOf("java.io.NotSerializableException: com.sun.jndi.ldap.LdapCtx") >= 0;
    }

    private static boolean isTimedOutException(Throwable t) {
        if (t instanceof NO_RESPONSE && t.getMessage() != null && t.getMessage().indexOf("timed out") >= 0) {
            return true;
        }
        if (t.getCause() != null) {
            return EJBSession.isTimedOutException(t.getCause());
        }
        return false;
    }

    private static boolean isRetryableException(Throwable t, CurrentOp currentOp) {
        String exName;
        ErrorRecord[] records;
        EngineRuntimeException ert;
        ErrorStack stack;
        if (t instanceof OBJECT_NOT_EXIST || t instanceof COMM_FAILURE || t instanceof NO_PERMISSION || t instanceof NoSuchObjectException) {
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("Got exception [" + t.getClass().getCanonicalName() + "] that can be retried for operation " + (Object)((Object)currentOp));
            }
            return true;
        }
        if ((currentOp == CurrentOp.GET_CONTENT || currentOp == CurrentOp.PUT_CONTENT) && (t instanceof ConnectException || t instanceof java.rmi.ConnectException || t instanceof TRANSIENT || t instanceof MARSHAL || t instanceof SocketException || t instanceof UnmarshalException || t instanceof MarshalException || t instanceof CommunicationException)) {
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("Got exception [" + t.getClass().getCanonicalName() + "] that can be retried for operation " + (Object)((Object)currentOp));
            }
            return true;
        }
        if (t.getCause() != null) {
            return EJBSession.isRetryableException(t.getCause(), currentOp);
        }
        if (t instanceof RemoteException && ((RemoteException)t).detail != null) {
            return EJBSession.isRetryableException(((RemoteException)t).detail, currentOp);
        }
        if (t instanceof EJBException && ((EJBException)t).getCausedByException() != null) {
            return EJBSession.isRetryableException(((EJBException)t).getCausedByException(), currentOp);
        }
        if (t instanceof EngineRuntimeException && (currentOp == CurrentOp.GET_CONTENT || currentOp == CurrentOp.PUT_CONTENT) && (stack = (ert = (EngineRuntimeException)t).getAsErrorStack()) != null && (records = stack.getErrorRecords()) != null) {
            for (int i = 0; i < records.length; ++i) {
                String source = records[i].getSource();
                if (source == null || !source.equals("org.omg.CORBA.COMM_FAILURE") && !source.equals("org.omg.CORBA.BAD_INV_ORDER") && !source.equals("java.rmi.RemoteException") && !source.equals("javax.naming.CommunicationException") && !source.equals("java.rmi.UnmarshalException")) continue;
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("Got server exception [" + source + "] that can be retried for operation " + (Object)((Object)currentOp));
                }
                return true;
            }
        }
        if ((currentOp == CurrentOp.GET_CONTENT || currentOp == CurrentOp.PUT_CONTENT) && (exName = t.getClass().getCanonicalName()).equals("weblogic.rmi.extensions.RemoteRuntimeException")) {
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("Got app-server specific exception [" + exName + "] that can be retried for operation " + (Object)((Object)currentOp));
            }
            return true;
        }
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("Not a retryable exception: " + t.getClass().getCanonicalName());
        }
        return false;
    }

    private static class EJBImpl
    implements PrivilegedExceptionAction {
        private Object engHome;
        private Engine eng;
        private EngineLocal engLocal;
        private ContentEJB contentEjb;
        private Object jaasReq;
        private ClientCallContext clientCallContext;
        private boolean useAffinity = false;

        EJBImpl(Object engHome) {
            this.engHome = engHome;
        }

        public void setUseAffinity(boolean useAffinity) {
            this.useAffinity = useAffinity;
        }

        public Object run() throws Exception {
            if (this.jaasReq instanceof GetObjectRequest) {
                return this._getObjects((GetObjectRequest)this.jaasReq);
            }
            if (this.jaasReq instanceof GetContentRequest) {
                return this._getContent((GetContentRequest)this.jaasReq);
            }
            if (this.jaasReq instanceof ExecuteChangesRequest) {
                return this._executeChanges((ExecuteChangesRequest)this.jaasReq);
            }
            if (this.jaasReq instanceof SearchRequest) {
                return this._executeSearch((SearchRequest)this.jaasReq);
            }
            if (this.jaasReq instanceof MetadataSearchRequest) {
                return this._getSearchMetadata((MetadataSearchRequest)this.jaasReq);
            }
            return null;
        }

        private String getPrincipal(Subject sub) {
            if (sub.getPrincipals().isEmpty()) {
                return "";
            }
            return sub.getPrincipals().toArray()[0].toString();
        }

        public GetObjectResponse getObjects(GetObjectRequest request, ClientCallContext ccc) {
            this.clientCallContext = ccc;
            Subject subject = UserContext.get().getSubject();
            if (subject != null) {
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("Using Principal<" + this.getPrincipal(subject) + "> from UserContext for getObjects call");
                }
                this.jaasReq = request;
                return (GetObjectResponse)J2EEUtil.getInstance().doAs(subject, this);
            }
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("Using Principal<" + this.getPrincipal(J2EEUtil.getInstance().getCurrentSubject()) + "> from ambient context for getObjects call");
            }
            return this._getObjects(request);
        }

        public GetContentResponse getContent(GetContentRequest request, ClientCallContext ccc) {
            this.clientCallContext = ccc;
            Subject subject = UserContext.get().getSubject();
            if (subject != null) {
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("Using Principal<" + this.getPrincipal(subject) + "> from UserContext for getContent call");
                }
                this.jaasReq = request;
                return (GetContentResponse)J2EEUtil.getInstance().doAs(subject, this);
            }
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("Using Principal<" + this.getPrincipal(J2EEUtil.getInstance().getCurrentSubject()) + "> from ambient context with no specified Subject for getContent call");
            }
            return this._getContent(request);
        }

        public ExecuteChangesResponse executeChanges(ExecuteChangesRequest request, ClientCallContext ccc) {
            this.clientCallContext = ccc;
            Subject subject = UserContext.get().getSubject();
            if (subject != null) {
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("Using Principal<" + this.getPrincipal(subject) + "> from UserContext for executeChanges call");
                }
                this.jaasReq = request;
                return (ExecuteChangesResponse)J2EEUtil.getInstance().doAs(subject, this);
            }
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("Using Principal<" + this.getPrincipal(J2EEUtil.getInstance().getCurrentSubject()) + "> from ambient context for executeChanges call");
            }
            return this._executeChanges(request);
        }

        public SearchResponse executeSearch(SearchRequest request, ClientCallContext ccc) {
            this.clientCallContext = ccc;
            Subject subject = UserContext.get().getSubject();
            if (subject != null) {
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("Using Principal<" + this.getPrincipal(subject) + "> from UserContext for executeSearch call");
                }
                this.jaasReq = request;
                return (SearchResponse)J2EEUtil.getInstance().doAs(subject, this);
            }
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("Using Principal<" + this.getPrincipal(J2EEUtil.getInstance().getCurrentSubject()) + "> from ambient context for executeSearch call");
            }
            return this._executeSearch(request);
        }

        public MetadataSearchResponse getSearchMetadata(MetadataSearchRequest request, ClientCallContext ccc) {
            this.clientCallContext = ccc;
            Subject subject = UserContext.get().getSubject();
            if (subject != null) {
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("Using Principal<" + this.getPrincipal(subject) + "> from UserContext for getSearchMetadata call");
                }
                this.jaasReq = request;
                return (MetadataSearchResponse)J2EEUtil.getInstance().doAs(subject, this);
            }
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("Using Principal<" + this.getPrincipal(J2EEUtil.getInstance().getCurrentSubject()) + "> from ambient context for getSearchMetadata call");
            }
            return this._getSearchMetadata(request);
        }

        private GetObjectResponse _getObjects(GetObjectRequest request) {
            GetObjectResponse resp = null;
            try {
                this.createEngineBean();
                resp = this.eng != null ? this.eng.getObjects(request, this.clientCallContext) : this.engLocal.getObjects(request, this.clientCallContext);
            }
            catch (Error e) {
                throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
            }
            catch (Throwable t) {
                EJBSession.throwException(t, ExceptionCode.E_UNEXPECTED);
                resp = null;
            }
            return resp;
        }

        private void createEngineBean() throws Exception {
            if (this.engLocal != null || this.eng != null) {
                return;
            }
            if (this.engHome instanceof EngineLocalHome) {
                this.engLocal = ((EngineLocalHome)this.engHome).create();
            } else {
                EngineHome home = (EngineHome)PortableRemoteObject.narrow((Object)this.engHome, EngineHome.class);
                this.eng = home.create();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private GetContentResponse _getContent(GetContentRequest request) {
            GetContentResponse resp = null;
            boolean failover = false;
            int retry = 0;
            Throwable lastEx = null;
            do {
                try {
                    this.getContentEjb();
                    failover = false;
                    resp = this.contentEjb.getContent(this.clientCallContext, request);
                }
                catch (Error e) {
                    throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
                }
                catch (Throwable t) {
                    block14: {
                        lastEx = t;
                        try {
                            EJBSession.throwException(t, ExceptionCode.E_UNEXPECTED, CurrentOp.GET_CONTENT);
                        }
                        catch (EngineRuntimeException er) {
                            lastEx = er;
                            if (er.getExceptionCode() != ExceptionCode.E_EXCEPTION_RETRY) {
                                throw er;
                            }
                            failover = true;
                            SessionHandle.applyWait();
                            try {
                                this.contentEjb.callComplete();
                                this.contentEjb.flush();
                                this.contentEjb.realRemove();
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            this.contentEjb = null;
                            ++retry;
                            if (!logger.isInfoEnabled()) break block14;
                            logger.info("Failure detected during content retrieval.  Attempting to failover to alternate Content Engine to continue retrieving content.  Retry attempt: " + retry);
                        }
                    }
                    resp = null;
                }
                finally {
                    if (this.contentEjb != null) {
                        this.contentEjb.callComplete();
                    }
                }
            } while (failover && retry <= SessionHandle.MAXIMUM_RETRY);
            if (failover) {
                throw new EngineRuntimeException(lastEx, ExceptionCode.TRANSPORT_EJB_UNABLE_TO_CONNECT, null);
            }
            return resp;
        }

        private void getContentEjb() {
            do {
                if (this.contentEjb != null && !this.contentEjb.isExpired()) continue;
                this.contentEjb = ContentEJB.getContentDownloadEJB(this.engHome, this.eng, this.engLocal, this.useAffinity, UserContext.get().getSubject());
                this.eng = this.contentEjb.getEngineBean();
                this.engLocal = this.contentEjb.getEngineLocalBean();
            } while (this.contentEjb.isExpired());
        }

        public boolean isLocal() {
            return this.engHome instanceof EngineLocalHome;
        }

        public boolean isContentEjbStateful() {
            if (this.contentEjb != null) {
                return this.contentEjb.isStateful();
            }
            return false;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("EJBSession: ");
            buf.append("EJBSession.EJBImpl.hashcode=" + this.hashCode());
            buf.append("; useAffinity=" + this.useAffinity);
            buf.append("; eng=" + ContentEJB.abbrevStr(this.eng));
            buf.append("; engLocal=" + ContentEJB.abbrevStr(this.engLocal));
            buf.append("; contentEjb=" + this.contentEjb);
            return buf.toString();
        }

        public void remove() {
            block8: {
                Object currentEjb = null;
                try {
                    if (this.contentEjb != null) {
                        currentEjb = this.contentEjb;
                        if (logger.isDetailTraceEnabled()) {
                            logger.traceDetail("EJBSession: removing contentEJB: " + this.contentEjb);
                        }
                        this.contentEjb.remove();
                        this.contentEjb = null;
                    }
                    if (this.eng != null) {
                        currentEjb = this.eng;
                        if (logger.isDetailTraceEnabled()) {
                            logger.traceDetail("EJBSession: removing Engine EJB: " + this.eng);
                        }
                        this.eng.remove();
                        this.eng = null;
                    }
                    if (this.engLocal != null) {
                        currentEjb = this.engLocal;
                        if (logger.isDetailTraceEnabled()) {
                            logger.traceDetail("EJBSession: removing EngineLocal EJB: " + this.engLocal);
                        }
                        this.engLocal.remove();
                        this.engLocal = null;
                    }
                }
                catch (Throwable t) {
                    if (!logger.isSummaryTraceEnabled()) break block8;
                    logger.traceSummary("EJBSession could not remove ejb: " + currentEjb + "Exception=" + t);
                }
            }
        }

        private ExecuteChangesResponse _executeChanges(ExecuteChangesRequest request) {
            ExecuteChangesResponse resp = null;
            try {
                this.createEngineBean();
                resp = this.eng != null ? this.eng.executeChanges(request, this.clientCallContext) : this.engLocal.executeChanges(request, this.clientCallContext);
            }
            catch (Error e) {
                throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
            }
            catch (Throwable t) {
                EJBSession.throwException(t, ExceptionCode.E_UNEXPECTED);
                resp = null;
            }
            return resp;
        }

        private SearchResponse _executeSearch(SearchRequest request) {
            SearchResponse resp = null;
            try {
                this.createEngineBean();
                resp = this.eng != null ? this.eng.executeSearch(request, this.clientCallContext) : this.engLocal.executeSearch(request, this.clientCallContext);
            }
            catch (Error e) {
                throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
            }
            catch (Throwable t) {
                EJBSession.throwException(t, ExceptionCode.E_UNEXPECTED);
                resp = null;
            }
            return resp;
        }

        private MetadataSearchResponse _getSearchMetadata(MetadataSearchRequest request) {
            MetadataSearchResponse resp = null;
            try {
                this.createEngineBean();
                resp = this.eng != null ? this.eng.getSearchMetadata(request, this.clientCallContext) : this.engLocal.getSearchMetadata(request, this.clientCallContext);
            }
            catch (Error e) {
                throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
            }
            catch (Throwable t) {
                EJBSession.throwException(t, ExceptionCode.E_UNEXPECTED);
                resp = null;
            }
            return resp;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum CurrentOp {
        UNKNOWN,
        NO_RETRY,
        GET_CONTENT,
        PUT_CONTENT;

    }
}

