/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.transport.ejb;

import com.filenet.api.constants.ConfigurationParameter;
import com.filenet.api.constants.PropertyState;
import com.filenet.api.core.ObjectReference;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.property.Property;
import com.filenet.api.util.Id;
import com.filenet.apiimpl.core.ConnectionImpl;
import com.filenet.apiimpl.core.ObjectReferenceBase;
import com.filenet.apiimpl.core.RepositoryIdentity;
import com.filenet.apiimpl.exception.ExceptionContext;
import com.filenet.apiimpl.exception.Exceptions;
import com.filenet.apiimpl.property.PropertyImpl;
import com.filenet.apiimpl.smm.TimerMeasurement;
import com.filenet.apiimpl.transport.ClientCallContext;
import com.filenet.apiimpl.transport.ContentHandle;
import com.filenet.apiimpl.transport.PutContentBatchRequest;
import com.filenet.apiimpl.transport.PutContentBatchResponse;
import com.filenet.apiimpl.transport.PutContentRequest;
import com.filenet.apiimpl.transport.PutContentResponse;
import com.filenet.apiimpl.transport.TransportLogger;
import com.filenet.apiimpl.transport.ejb.ContentEJB;
import com.filenet.apiimpl.transport.ejb.ContentEJBHome;
import com.filenet.apiimpl.transport.ejb.EJBSession;
import com.filenet.apiimpl.util.ConfigValueLookup;
import com.filenet.apiimpl.util.J2EEUtil;
import com.filenet.apiimpl.util.SessionHandle;
import com.filenet.apiimpl.util.SessionLocator;
import com.filenet.apiimpl.util.SubSystem;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.naming.Context;
import javax.security.auth.Subject;

public class ContentPush {
    private static TransportLogger logger = TransportLogger.getLogger(ContentPush.class, SubSystem.EJB);
    static final int MAX_CONTENT_UPLOAD_THREADS = ConfigValueLookup.getInt(ConfigurationParameter.CONTENT_MAX_UPLOAD_THREADS, 3);
    static final int PUT_CONTENT_NUM_OF_BLOCKS = ConfigValueLookup.getInt(ConfigurationParameter.CONTENT_PUT_BLOCK_SIZE_KB, 1024);
    static final int PUT_CONTENT_MAX_NUM_OF_BLOCKS = 10240;
    static final boolean CONTENT_UPLOAD_SERVER_AFFINITY_ENABLED = ConfigValueLookup.getBoolean(ConfigurationParameter.CONTENT_UPLOAD_SERVER_AFFINITY_ENABLED, false);
    static final boolean IGNORE_SIZE_FOR_SERVER_AFFINITY = ConfigValueLookup.getValueAsBoolean("com.filenet.ejb.content.IgnoreSizeForAffinity", false);
    private static final String PARAM_CA_ID = "caId";
    ArrayList contentHandles;
    ConnectionImpl connection;
    Context cntx;
    Subject runAsSubject;
    ClientCallContext ccc;
    int maxThreads;

    ContentPush(ConnectionImpl conn, ArrayList contentHandlesVal, Subject runAsSubjectVal, ClientCallContext cccVal) {
        this.contentHandles = contentHandlesVal;
        this.connection = conn;
        this.runAsSubject = runAsSubjectVal;
        this.ccc = cccVal;
        this.maxThreads = MAX_CONTENT_UPLOAD_THREADS;
    }

    public ContentPush(Context cntxVal, ArrayList contentHandlesVal, Subject runAsSubjectVal, ClientCallContext cccVal) {
        this.contentHandles = contentHandlesVal;
        this.cntx = cntxVal;
        this.runAsSubject = runAsSubjectVal;
        this.ccc = cccVal;
        this.maxThreads = MAX_CONTENT_UPLOAD_THREADS;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadContent() {
        int numContent = this.contentHandles.size();
        if (numContent < 1) {
            return;
        }
        int numOfThreads = 1;
        if (numContent > 1) {
            numOfThreads = numContent - 1 < this.maxThreads ? numContent - 1 : this.maxThreads;
        }
        EJBImpl[] ejbHandles = this.getEJBHandles(numOfThreads);
        try {
            if (numOfThreads == 1) {
                this.singleThreadUpload(ejbHandles);
                return;
            }
            HashMap<ObjectReferenceBase, Id> actualStorageAreaMap = new HashMap<ObjectReferenceBase, Id>();
            ArrayList<ContentHandle> multiThreadContentHandles = new ArrayList<ContentHandle>();
            for (ContentHandle ch : this.contentHandles) {
                ObjectReferenceBase objRef = ch.getObjectReference();
                Id saId = (Id)actualStorageAreaMap.get(objRef);
                if (null == saId) {
                    this.uploadContent(ejbHandles[0], ch);
                    saId = ch.getActualStorageAreaId();
                    actualStorageAreaMap.put(objRef, saId);
                    continue;
                }
                ch.setActualStorageAreaId(saId);
                multiThreadContentHandles.add(ch);
            }
            Iterator iter = multiThreadContentHandles.iterator();
            RunnableExecutionHandler[] threadHandlers = new RunnableExecutionHandler[numOfThreads];
            int pos = 0;
            while (iter.hasNext()) {
                ContentHandle ch = (ContentHandle)iter.next();
                threadHandlers[pos] = new RunnableExecutionHandler(J2EEUtil.getInstance().getCurrentSubject(), ejbHandles[pos], ch);
                if (!iter.hasNext() || pos == threadHandlers.length - 1) {
                    this.multiThreadUpload(threadHandlers, pos + 1);
                    for (int lp = 0; lp < pos + 1; ++lp) {
                        RunnableExecutionHandler handler = threadHandlers[lp];
                        if (null != handler && null != handler.getException()) {
                            Throwable t = handler.getException();
                            if (t instanceof EngineRuntimeException) {
                                throw (EngineRuntimeException)t;
                            }
                            throw new EngineRuntimeException(t, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
                        }
                        threadHandlers[lp] = null;
                    }
                    pos = 0;
                    continue;
                }
                ++pos;
            }
        }
        finally {
            this.close(ejbHandles);
        }
    }

    void multiThreadUpload(RunnableExecutionHandler[] threadHandlers, int size) {
        int lp;
        Thread[] t = new Thread[size];
        for (lp = 0; lp < size; ++lp) {
            t[lp] = new Thread(threadHandlers[lp]);
            t[lp].start();
        }
        try {
            for (lp = 0; lp < size; ++lp) {
                t[lp].join();
            }
        }
        catch (InterruptedException e) {
            throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
    }

    void singleThreadUpload(EJBImpl[] ejbHandles) {
        HashMap<ObjectReferenceBase, Id> actualStorageAreaMap = new HashMap<ObjectReferenceBase, Id>();
        Iterator iter = this.contentHandles.iterator();
        ContentHandle ch = null;
        while (iter.hasNext()) {
            ch = (ContentHandle)iter.next();
            ObjectReferenceBase objRef = ch.getObjectReference();
            Id saId = (Id)actualStorageAreaMap.get(objRef);
            if (null == saId) {
                this.uploadContent(ejbHandles[0], ch);
                saId = ch.getActualStorageAreaId();
                actualStorageAreaMap.put(objRef, saId);
                continue;
            }
            ch.setActualStorageAreaId(saId);
            this.uploadContent(ejbHandles[0], ch);
        }
    }

    void uploadContent(EJBImpl ejbHandle, ContentHandle ch) {
        try {
            ejbHandle.setContentHandle(ch);
            ejbHandle.uploadContent();
        }
        catch (Throwable t) {
            EJBSession.throwException(t, ExceptionCode.E_UNEXPECTED_EXCEPTION, EJBSession.CurrentOp.NO_RETRY);
        }
    }

    void close(EJBImpl[] handles) {
        if (handles == null || handles.length < 1) {
            return;
        }
        for (int lp = 0; lp < handles.length; ++lp) {
            handles[lp].remove();
        }
    }

    EJBImpl[] getEJBHandles(int numberOf) {
        ContentEJBHome ejbHome = null;
        EJBImpl[] ejbHandles = new EJBImpl[numberOf];
        int chunkSize = PUT_CONTENT_NUM_OF_BLOCKS;
        Boolean affinityOverride = null;
        boolean isLocal = false;
        if (this.connection != null) {
            Object chunkSizeConnParam = this.connection.getParameter(ConfigurationParameter.CONTENT_PUT_BLOCK_SIZE_KB);
            if (chunkSizeConnParam != null && chunkSizeConnParam instanceof Integer) {
                chunkSize = (Integer)chunkSizeConnParam;
            }
            if (this.connection.participatesInTransaction()) {
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("ContentPush.getEJBHandles: running w/in a transaction.  Using stateless ContentEJB.");
                }
                affinityOverride = false;
            } else {
                Object affinityConnParam = this.connection.getParameter(ConfigurationParameter.CONTENT_UPLOAD_SERVER_AFFINITY_ENABLED);
                if (affinityConnParam != null && affinityConnParam instanceof Boolean) {
                    affinityOverride = (Boolean)affinityConnParam;
                }
            }
        } else {
            isLocal = true;
            ejbHome = SessionLocator.getContentEJB(this.cntx);
        }
        chunkSize = chunkSize > 10240 ? 10240 : chunkSize;
        chunkSize = chunkSize > 0 ? chunkSize : PUT_CONTENT_NUM_OF_BLOCKS;
        for (int lp = 0; lp < numberOf; ++lp) {
            ejbHandles[lp] = isLocal ? new EJBImpl(this.runAsSubject, this.ccc, ejbHome, chunkSize) : new EJBImpl(this.runAsSubject, this.ccc, this.connection, chunkSize, affinityOverride);
        }
        return ejbHandles;
    }

    private static class EJBRemover
    implements PrivilegedExceptionAction {
        private ContentEJB contentEjbStateless = null;
        private ContentEJB contentEjbStateful = null;

        EJBRemover(ContentEJB ejbStateless, ContentEJB ejbStateful) {
            this.contentEjbStateless = ejbStateless;
            this.contentEjbStateful = ejbStateful;
        }

        public Object run() throws Exception {
            this.remove();
            return null;
        }

        void remove() {
            block9: {
                block8: {
                    try {
                        if (this.contentEjbStateless != null) {
                            if (logger.isDetailTraceEnabled()) {
                                logger.traceDetail("ContentPush: removing stateless ContentEJB: " + this.contentEjbStateless);
                            }
                            this.contentEjbStateless.remove();
                            this.contentEjbStateless = null;
                        }
                    }
                    catch (Throwable t) {
                        if (!logger.isDetailTraceEnabled()) break block8;
                        logger.traceDetail("ContentPush: Problem removing stateless ContentEJB: " + Exceptions.printStackTrace(t, null, true));
                    }
                }
                try {
                    if (this.contentEjbStateful != null) {
                        if (logger.isDetailTraceEnabled()) {
                            logger.traceDetail("ContentPush: removing stateful ContentEJB: " + this.contentEjbStateful);
                        }
                        this.contentEjbStateful.remove();
                        this.contentEjbStateful = null;
                    }
                }
                catch (Throwable t) {
                    if (!logger.isDetailTraceEnabled()) break block9;
                    logger.traceDetail("ContentPush: Problem removing stateful ContentEJB: " + Exceptions.printStackTrace(t, null, true));
                }
            }
        }
    }

    private static class EJBImpl
    implements PrivilegedExceptionAction {
        private ConnectionImpl connection;
        private ContentEJBHome engHomeStateless = null;
        private ContentEJBHome engHomeStateful = null;
        private ContentEJB contentEjbStateless = null;
        private ContentEJB contentEjbStateful = null;
        private ContentHandle contentHandle;
        private Subject runAsSubject;
        private ClientCallContext ccc;
        private int chunkSize;
        private boolean isLocal = false;
        private Boolean affinityOverride = null;
        private ContentEJBHome engHome = null;
        private ContentEJB contentEjb = null;

        EJBImpl(Subject runAsSubjectVal, ClientCallContext cccVal, ConnectionImpl connVal, int chunkSize, Boolean affinityOverride) {
            this.runAsSubject = runAsSubjectVal;
            this.ccc = cccVal;
            this.connection = connVal;
            this.chunkSize = chunkSize;
            this.affinityOverride = affinityOverride;
            this.isLocal = false;
        }

        EJBImpl(Subject runAsSubjectVal, ClientCallContext cccVal, ContentEJBHome ejbHomeStateless, int chunkSize) {
            this.runAsSubject = runAsSubjectVal;
            this.ccc = cccVal;
            this.engHomeStateless = ejbHomeStateless;
            this.chunkSize = chunkSize;
            this.isLocal = true;
        }

        public void remove() {
            EJBRemover ejbRemover = new EJBRemover(this.contentEjbStateless, this.contentEjbStateful);
            try {
                if (this.runAsSubject != null) {
                    J2EEUtil.getInstance().doAs(this.runAsSubject, ejbRemover);
                } else {
                    ejbRemover.remove();
                }
                this.contentEjbStateless = null;
                this.contentEjbStateful = null;
            }
            catch (Throwable t) {
                EJBSession.throwException(t, ExceptionCode.E_UNEXPECTED_EXCEPTION, EJBSession.CurrentOp.NO_RETRY);
            }
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("ContentPush: ");
            buf.append("ContentPush.EJBImpl.hashcode=" + this.hashCode());
            buf.append("; contentEjb=" + this.contentEjb);
            return buf.toString();
        }

        public void setContentHandle(ContentHandle ch) {
            this.contentHandle = ch;
        }

        public void setRunAsSubject(Subject runAsSubjectVal) {
            this.runAsSubject = runAsSubjectVal;
        }

        public Subject getRunAsSubject() {
            return this.runAsSubject;
        }

        public void uploadContent() {
            try {
                if (this.runAsSubject != null) {
                    J2EEUtil.getInstance().doAs(this.runAsSubject, this);
                } else {
                    this.run();
                }
                this.contentHandle = null;
            }
            catch (Throwable t) {
                EJBSession.throwException(t, ExceptionCode.E_UNEXPECTED_EXCEPTION, EJBSession.CurrentOp.NO_RETRY);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object run() throws Exception {
            try {
                Id storageAreaId;
                String retrievalName = null;
                if (this.contentHandle.getContentProperties().isPropertyPresent("RetrievalName")) {
                    retrievalName = this.contentHandle.getContentProperties().getStringValue("RetrievalName");
                }
                if (null == (storageAreaId = this.contentHandle.getActualStorageAreaId()) && this.contentHandle.getObjectProperties().isPropertyPresent("StorageArea")) {
                    Property prop = this.contentHandle.getObjectProperties().get("StorageArea");
                    if (prop.getState() == PropertyState.NO_VALUE) {
                        storageAreaId = Id.ZERO_ID;
                    } else {
                        PropertyImpl propImpl = (PropertyImpl)this.contentHandle.getObjectProperties().get("StorageArea");
                        if (propImpl != null) {
                            ObjectReference or = propImpl.getObjectReference();
                            storageAreaId = ((RepositoryIdentity)or).getObjectId();
                        }
                    }
                }
                Id storagePolicyId = null;
                if (this.contentHandle.getObjectProperties().isPropertyPresent("StoragePolicy")) {
                    Property prop = this.contentHandle.getObjectProperties().get("StoragePolicy");
                    if (prop.getState() == PropertyState.NO_VALUE) {
                        storagePolicyId = Id.ZERO_ID;
                    } else {
                        PropertyImpl propImpl = (PropertyImpl)this.contentHandle.getObjectProperties().get("StoragePolicy");
                        if (propImpl != null) {
                            ObjectReference or = propImpl.getObjectReference();
                            storagePolicyId = ((RepositoryIdentity)or).getObjectId();
                        }
                    }
                }
                String continueFrom = null;
                InputStream input = null;
                Object content = this.contentHandle.getContentProperties().getObjectValue("Content");
                if (!(content instanceof InputStream)) {
                    if (content instanceof String) {
                        Object var7_7 = null;
                        return var7_7;
                    }
                    String classname = null;
                    if (content != null) {
                        classname = content.getClass().getName();
                    }
                    throw new EngineRuntimeException(ExceptionCode.CONTENT_PC_UNEXPECTED_CONTENT_TYPE, new Object[]{classname, content});
                }
                input = (InputStream)content;
                boolean throwExceptionOnCloseFailure = false;
                long starTime = 0L;
                try {
                    if (this.isLocal) {
                        PutContentResponse[] responseArray;
                        PutContentRequest request = new PutContentRequest(this.contentHandle.getObjectReference(), "1", storageAreaId, storagePolicyId, retrievalName, input, true, this.contentHandle.isNew(), continueFrom);
                        PutContentBatchRequest pcbr = new PutContentBatchRequest(new PutContentRequest[]{request});
                        if (logger.isCallTraceEnabled()) {
                            logger.traceRequest(this.ccc, "putContent       ", pcbr);
                        }
                        starTime = TimerMeasurement.getMillis();
                        PutContentBatchResponse response = this.putContent(pcbr, 0, true);
                        PutContentResponse[] putContentResponseArray = responseArray = response != null ? response.getBatch() : null;
                        if (null == responseArray || responseArray.length != 1) {
                            throw new EngineRuntimeException(ExceptionCode.TRANSPORT_MISSING_SERVER_RESPONSE, null);
                        }
                        if (logger.isCallTraceEnabled()) {
                            logger.traceResponse(this.ccc, "putContent       ", response, starTime);
                        }
                        continueFrom = responseArray[0].getContinueFrom();
                    } else {
                        int bufferSizeBytes = this.chunkSize * 1024;
                        byte[] buffer = new byte[bufferSizeBytes];
                        byte lastByteRead = 0;
                        boolean lastChunk = false;
                        int chunkNum = 1;
                        int bytesRead = this.fillBufferFromStream(input, buffer, 0, buffer.length);
                        do {
                            PutContentResponse[] responseArray;
                            if (bytesRead < buffer.length) {
                                if (bytesRead < 0) {
                                    bytesRead = 0;
                                }
                                byte[] temp = new byte[bytesRead];
                                System.arraycopy(buffer, 0, temp, 0, bytesRead);
                                buffer = temp;
                                lastChunk = true;
                            } else {
                                int value = input.read();
                                if (-1 == value) {
                                    lastChunk = true;
                                } else {
                                    lastByteRead = (byte)value;
                                }
                            }
                            PutContentRequest request = new PutContentRequest(this.contentHandle.getObjectReference(), "1", storageAreaId, storagePolicyId, retrievalName, buffer, lastChunk, this.contentHandle.isNew(), continueFrom);
                            PutContentBatchRequest pcbr = new PutContentBatchRequest(new PutContentRequest[]{request});
                            if (logger.isCallTraceEnabled()) {
                                logger.traceRequest(this.ccc, "putContent       ", pcbr);
                            }
                            starTime = TimerMeasurement.getMillis();
                            PutContentBatchResponse response = this.putContent(pcbr, chunkNum, lastChunk);
                            PutContentResponse[] putContentResponseArray = responseArray = response != null ? response.getBatch() : null;
                            if (null == responseArray || responseArray.length != 1) {
                                throw new EngineRuntimeException(ExceptionCode.TRANSPORT_MISSING_SERVER_RESPONSE, null);
                            }
                            if (logger.isCallTraceEnabled()) {
                                logger.traceResponse(this.ccc, "putContent       ", response, starTime);
                            }
                            continueFrom = responseArray[0].getContinueFrom();
                            if (lastChunk) continue;
                            bytesRead = this.fillBufferFromStream(input, buffer, 1, buffer.length - 1);
                            buffer[0] = lastByteRead;
                            bytesRead = -1 == bytesRead ? 1 : ++bytesRead;
                            ++chunkNum;
                        } while (bytesRead > 0 && !lastChunk);
                    }
                    throwExceptionOnCloseFailure = true;
                }
                catch (EngineRuntimeException er) {
                    if (logger.isCallTraceEnabled()) {
                        logger.traceException(this.ccc, "putContent       ", er, starTime);
                    }
                    throw er;
                }
                catch (IOException e) {
                    EngineRuntimeException er = new EngineRuntimeException(e, ExceptionCode.CONTENT_PC_STREAM_FAILED, null);
                    if (logger.isCallTraceEnabled()) {
                        logger.traceException(this.ccc, "putContent       ", er, starTime);
                    }
                    throw er;
                }
                finally {
                    block46: {
                        try {
                            if (input != null) {
                                input.close();
                            }
                        }
                        catch (IOException e) {
                            if (!throwExceptionOnCloseFailure) break block46;
                            throw new EngineRuntimeException(e, ExceptionCode.CONTENT_PC_CLOSE_STREAM_FAILED, null);
                        }
                    }
                }
                this.contentHandle.getContentProperties().get("Content").setObjectValue(continueFrom);
                Id actualStorageAreaId = this.contentHandle.getActualStorageAreaId();
                if (null == actualStorageAreaId && null != continueFrom) {
                    Id saId = this.getStorageAreaFromCookie(continueFrom);
                    this.contentHandle.setActualStorageAreaId(saId);
                    if (logger.isDetailTraceEnabled()) {
                        logger.traceDetail("Document: " + this.contentHandle.getObjectReference().getObjectId() + " will be stored in storage area id=" + saId);
                    }
                }
            }
            finally {
                this.callComplete();
            }
            return null;
        }

        private void callComplete() {
            if (this.contentEjb != null) {
                this.contentEjb.callComplete();
            }
            this.contentEjb = null;
            this.engHome = null;
        }

        private int fillBufferFromStream(InputStream stream, byte[] buffer, int off, int len) throws IOException {
            int read;
            int totalRead = -1;
            int readLen = len;
            int readOff = off;
            while (totalRead < len && (read = stream.read(buffer, readOff, readLen)) >= 0) {
                if (-1 == totalRead) {
                    totalRead = 0;
                }
                totalRead += read;
                readOff += read;
                readLen -= read;
            }
            return totalRead;
        }

        private PutContentBatchResponse putContent(PutContentBatchRequest request, int chunkNum, boolean lastChunk) {
            PutContentBatchResponse resp;
            boolean failover = false;
            int retry = 0;
            Throwable lastEx = null;
            do {
                try {
                    if (this.contentEjb == null) {
                        this.contentEjb = this.getContentEjbForCall(chunkNum, lastChunk);
                    }
                    failover = false;
                    resp = this.contentEjb.putContent(this.ccc, request);
                }
                catch (Throwable t) {
                    block18: {
                        lastEx = t;
                        try {
                            EJBSession.throwException(t, ExceptionCode.E_UNEXPECTED_EXCEPTION, EJBSession.CurrentOp.PUT_CONTENT);
                        }
                        catch (EngineRuntimeException er) {
                            lastEx = er;
                            if (er.getExceptionCode() != ExceptionCode.E_EXCEPTION_RETRY) {
                                throw er;
                            }
                            boolean allowFailoverAfterFirstChunk = ConfigValueLookup.getValueAsBoolean("com.filenet.ejb.content.AllowUploadFailoverAfterFirstChunk", false);
                            if (chunkNum == 1 || allowFailoverAfterFirstChunk) {
                                block17: {
                                    failover = true;
                                    SessionHandle.applyWait();
                                    try {
                                        if (this.contentEjb == null) {
                                            this.contentEjb = this.getContentEjbForCall(chunkNum, lastChunk);
                                            break block17;
                                        }
                                        boolean isStateful = this.contentEjb.isStateful();
                                        try {
                                            this.contentEjb.callComplete();
                                            this.contentEjb.flush();
                                            this.contentEjb.realRemove();
                                        }
                                        catch (Exception e) {
                                            // empty catch block
                                        }
                                        this.contentEjb = this.getContentEjb(this.engHome, isStateful);
                                    }
                                    catch (Exception e2) {
                                        if (logger.isDetailTraceEnabled()) {
                                            logger.traceDetail("ContentPush failed to get ContentEJB during failover." + Exceptions.printStackTrace(e2, null, true));
                                        }
                                        this.contentEjb = null;
                                        this.contentEjbStateless = null;
                                        this.contentEjbStateful = null;
                                    }
                                }
                                ++retry;
                                if (logger.isInfoEnabled()) {
                                    logger.info("Failure detected during content upload.  Attempting to failover to alternate Content Engine to continue uploading content for chunk " + chunkNum + ".  Retry attempt: " + retry);
                                }
                                break block18;
                            }
                            Throwable cause = er.getCause();
                            if (cause instanceof EngineRuntimeException) {
                                throw (EngineRuntimeException)cause;
                            }
                            throw new EngineRuntimeException(cause, ExceptionCode.TRANSPORT_EJB_UNABLE_TO_CONNECT, null);
                        }
                    }
                    resp = null;
                }
            } while (failover && retry <= SessionHandle.MAXIMUM_RETRY);
            if (failover) {
                throw new EngineRuntimeException(lastEx, ExceptionCode.TRANSPORT_EJB_UNABLE_TO_CONNECT, null);
            }
            return resp;
        }

        private ContentEJBHome getEjbHomeStateful() {
            if (this.engHomeStateful == null) {
                this.engHomeStateful = SessionLocator.getContentEJB(this.connection, true);
            }
            return this.engHomeStateful;
        }

        private ContentEJBHome getEjbHomeStateless() {
            if (this.engHomeStateless == null) {
                this.engHomeStateless = SessionLocator.getContentEJB(this.connection, false);
            }
            return this.engHomeStateless;
        }

        private ContentEJB getContentEjbForCall(int chunkNum, boolean lastChunk) {
            boolean useAffinity = false;
            if (this.isLocal) {
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("ContentPush: running locally w/in server.  Using stateless ContentEJB");
                }
                useAffinity = false;
                this.engHome = this.getEjbHomeStateless();
            } else {
                if (this.affinityOverride != null) {
                    if (logger.isDetailTraceEnabled()) {
                        logger.traceDetail("ContentPush: using affinity override value of " + this.affinityOverride + " for ContentEJB.");
                    }
                    useAffinity = this.affinityOverride;
                } else if (CONTENT_UPLOAD_SERVER_AFFINITY_ENABLED && IGNORE_SIZE_FOR_SERVER_AFFINITY) {
                    if (logger.isDetailTraceEnabled()) {
                        logger.traceDetail("ContentPush: override enabled to ignore content size.  Using stateful ContentEJB");
                    }
                    useAffinity = true;
                } else if (CONTENT_UPLOAD_SERVER_AFFINITY_ENABLED) {
                    if (chunkNum == 1 && lastChunk) {
                        if (logger.isDetailTraceEnabled()) {
                            logger.traceDetail("ContentPush: Content can be transferred in a single chunk.  Using stateless ContentEJB");
                        }
                        useAffinity = false;
                    } else {
                        if (logger.isDetailTraceEnabled()) {
                            logger.traceDetail("ContentPush: Content requires multiple chunks to transfer.  Using stateful ContentEJB");
                        }
                        useAffinity = true;
                    }
                } else {
                    if (logger.isDetailTraceEnabled()) {
                        logger.traceDetail("ContentPush: Server affinity is not enabled. Using stateless ContentEJB");
                    }
                    useAffinity = false;
                }
                this.engHome = useAffinity ? this.getEjbHomeStateful() : this.getEjbHomeStateless();
                this.isLocal = this.engHome.isLocal();
            }
            this.contentEjb = this.getContentEjb(this.engHome, useAffinity);
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("ContentPush: using ContentEJB: " + this.contentEjb);
            }
            return this.contentEjb;
        }

        private ContentEJB getContentEjb(ContentEJBHome ejbHome, boolean useAffinity) {
            ContentEJB ejb = null;
            ejb = useAffinity ? this.contentEjbStateful : this.contentEjbStateless;
            do {
                if (ejb != null && !ejb.isExpired()) continue;
                ejb = ContentEJB.getContentUploadEJB(ejbHome, useAffinity, this.runAsSubject);
            } while (ejb.isExpired());
            if (useAffinity) {
                this.contentEjbStateful = ejb;
            } else {
                this.contentEjbStateless = ejb;
            }
            return ejb;
        }

        private Id getStorageAreaFromCookie(String cookie) {
            Id saId = null;
            Map cookieMap = this.decodeCookie(cookie);
            String saIdStr = (String)cookieMap.get(ContentPush.PARAM_CA_ID);
            if (null != saIdStr && Id.isId(saIdStr)) {
                saId = new Id(saIdStr);
            }
            return saId;
        }

        private Map decodeCookie(String cookie) {
            HashMap<String, String> map = new HashMap<String, String>();
            StringTokenizer st = new StringTokenizer(cookie, ";");
            for (int countTokens = st.countTokens(); countTokens > 0; --countTokens) {
                String nameValue = st.nextToken();
                int pos = nameValue.indexOf(61);
                if (-1 == pos) {
                    throw new EngineRuntimeException(ExceptionCode.CONTENT_CA_INVALID_COOKIE, new Object[]{cookie}, ExceptionContext.CONTENT_CA_COOKIE_MISSING_EQUALS, new Object[]{nameValue});
                }
                String name = nameValue.substring(0, pos).trim();
                String value = nameValue.substring(pos + 1).trim();
                if (0 == name.length() || 0 == value.length()) {
                    throw new EngineRuntimeException(ExceptionCode.CONTENT_CA_INVALID_COOKIE, new Object[]{cookie}, ExceptionContext.CONTENT_CA_COOKIE_EMPTY_NAME_VALUE, new Object[]{nameValue});
                }
                map.put(name, value);
            }
            return map;
        }
    }

    private static class RunnableExecutionHandler
    implements Runnable {
        EJBImpl ejbHandle;
        Subject currentSubject;
        ContentHandle contentHandle;
        Throwable exception;

        RunnableExecutionHandler(Subject s, EJBImpl handle, ContentHandle ch) {
            this.ejbHandle = handle;
            this.currentSubject = s;
            this.contentHandle = ch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Subject specifiedSub = this.ejbHandle.getRunAsSubject();
            try {
                if (specifiedSub == null) {
                    this.ejbHandle.setRunAsSubject(this.currentSubject);
                }
                this.ejbHandle.setContentHandle(this.contentHandle);
                this.ejbHandle.uploadContent();
            }
            catch (Throwable t) {
                this.exception = t;
            }
            finally {
                this.ejbHandle.setRunAsSubject(specifiedSub);
            }
        }

        protected Throwable getException() {
            return this.exception;
        }
    }
}

