/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.transport.ejb;

import com.filenet.apiimpl.exception.Exceptions;
import com.filenet.apiimpl.transport.TransportLogger;
import com.filenet.apiimpl.transport.ejb.ContentEJB;
import com.filenet.apiimpl.util.ConfigValueLookup;
import com.filenet.apiimpl.util.SubSystem;
import java.util.Collection;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentEJBPool {
    private static TransportLogger logger = TransportLogger.getLogger(ContentEJB.class, SubSystem.EJB);
    private static final int MIN_POOL_SIZE = ConfigValueLookup.getValueAsInt("com.filenet.ejb.content.MinPoolSize", 3);
    private static final long ACTIVE_EJB_EXPIRY_TIME = ConfigValueLookup.getValueAsInt("com.filenet.ejb.content.ActiveExpiryTime", 60000);
    private static final long IDLE_EJB_EXPIRY_TIME = ConfigValueLookup.getValueAsInt("com.filenet.ejb.content.IdleExpiryTime", 300000);
    private static final long EXPIRY_REAP_INTERVAL = ConfigValueLookup.getValueAsInt("com.filenet.ejb.content.ExpiryInterval", 120000);
    private static final int AGE_LIMIT = ConfigValueLookup.getValueAsInt("com.filenet.ejb.content.AgeLimit", 600000);
    private static ConcurrentHashMap<String, EJBConnPool> ejbIdlePool = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, EJBConnPool> ejbActivePool = new ConcurrentHashMap();
    private static Timer expiryTimer = null;
    private static TimerTask expiryTimerTask = new EJBExpiryTask();
    private static Thread runtimeShutdownHook = null;
    private static boolean runtimeShuttingDown = false;
    private static boolean initCalled = false;

    private ContentEJBPool() {
    }

    public static ContentEJB get(String conKey) {
        ContentEJB ejb = null;
        if (MIN_POOL_SIZE > 0 && ContentEJBPool.getTotalEjbsForCon(conKey) <= MIN_POOL_SIZE) {
            return null;
        }
        EJBConnPool pool = ejbIdlePool.get(conKey);
        if (pool != null && (ejb = pool.poll()) != null) {
            ContentEJBPool.addToActivePool(conKey, ejb);
        }
        return ejb;
    }

    public static void put(String conKey, ContentEJB ejb) {
        if (!initCalled) {
            ContentEJBPool._init();
        }
        ContentEJBPool.addToActivePool(conKey, ejb);
    }

    public static void release(String conKey, ContentEJB ejb) {
        block4: {
            ContentEJBPool.removeFromActivePool(conKey, ejb);
            long ageLimit = System.currentTimeMillis() - (long)AGE_LIMIT;
            if (ejb.getAge() > ageLimit || AGE_LIMIT == -1) {
                ContentEJBPool.addToIdlePool(conKey, ejb);
            } else {
                try {
                    ejb.realRemove();
                }
                catch (Exception e) {
                    if (!logger.isSummaryTraceEnabled()) break block4;
                    logger.traceSummary("ContentEJBPool: failed to remove ejb that has reached age limit.  " + Exceptions.printStackTrace(e, null, true));
                }
            }
        }
    }

    private static int getTotalEjbsForCon(String conKey) {
        int totalEjbs = 0;
        EJBConnPool pool = ejbActivePool.get(conKey);
        if (pool != null) {
            totalEjbs += pool.size();
        }
        if ((pool = ejbIdlePool.get(conKey)) != null) {
            totalEjbs += pool.size();
        }
        return totalEjbs;
    }

    private static void addToIdlePool(String conKey, ContentEJB ejb) {
        EJBConnPool newPool;
        EJBConnPool pool = ejbIdlePool.get(conKey);
        if (pool == null && (pool = ejbIdlePool.putIfAbsent(conKey, newPool = new EJBConnPool(conKey))) == null) {
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("ContentEJBPool created new idle pool for " + conKey);
            }
            pool = newPool;
        }
        pool.put(ejb);
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("ContentEJBPool idle pool size=" + pool.size());
        }
    }

    private static void addToActivePool(String conKey, ContentEJB ejb) {
        EJBConnPool newPool;
        EJBConnPool pool = ejbActivePool.get(conKey);
        if (pool == null && (pool = ejbActivePool.putIfAbsent(conKey, newPool = new EJBConnPool(conKey))) == null) {
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("ContentEJBPool created new active pool for " + conKey);
            }
            pool = newPool;
        }
        pool.put(ejb);
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("ContentEJBPool active pool size=" + pool.size());
        }
    }

    private static void removeFromActivePool(String conKey, ContentEJB ejb) {
        EJBConnPool pool = ejbActivePool.get(conKey);
        if (pool != null) {
            pool.remove(ejb);
        }
    }

    private static void expireEjbsInPool(Collection<EJBConnPool> pool, long expireTime, String poolType) {
        long expired = System.currentTimeMillis() - expireTime;
        int numExpired = 0;
        int numInPool = 0;
        for (EJBConnPool ejbConnPool : pool) {
            Iterator<ContentEJB> ejbIter = ejbConnPool.iterator();
            while (ejbIter.hasNext()) {
                ContentEJB ejb = ejbIter.next();
                if (expireTime == -1L || ejb.getLastActiveTime() != null && ejb.getLastActiveTime() < expired) {
                    block7: {
                        try {
                            if (logger.isDetailTraceEnabled()) {
                                logger.traceDetail("ContentEJBPool expiring ejb from " + poolType + " pool.  ejb=[" + ejb + "].");
                            }
                            ejb.realRemove();
                            ++numExpired;
                        }
                        catch (Exception e) {
                            if (!logger.isSummaryTraceEnabled()) break block7;
                            logger.traceSummary("ContentEJBPool: failed to remove ejb.  " + Exceptions.printStackTrace(e, null, true));
                        }
                    }
                    ejbIter.remove();
                    continue;
                }
                ++numInPool;
            }
        }
        if (logger.isSummaryTraceEnabled() && numExpired > 0) {
            logger.traceSummary("ContentEJBPool expired " + numExpired + " ejbs from " + poolType + " pool.  Current pool size=" + numInPool);
        }
    }

    private static synchronized void _init() {
        if (initCalled) {
            return;
        }
        if (expiryTimer == null) {
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("ContentEJBPool starting EJB expiry timer task.");
            }
            expiryTimer = new Timer(true);
            expiryTimer.schedule(expiryTimerTask, EXPIRY_REAP_INTERVAL, EXPIRY_REAP_INTERVAL);
        }
        if (runtimeShutdownHook == null) {
            RuntimeShutdownHook hook = new RuntimeShutdownHook();
            Runtime.getRuntime().addShutdownHook(hook);
            runtimeShutdownHook = hook;
        }
        initCalled = true;
    }

    public static synchronized void flush() {
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("ContentEJBPool flush called");
        }
        ContentEJBPool.expireEjbsInPool(ejbIdlePool.values(), -1L, "idle");
    }

    private static synchronized void _destroy() {
        if (!initCalled) {
            return;
        }
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("ContentEJBPool destroy called");
        }
        ContentEJBPool.expireEjbsInPool(ejbActivePool.values(), -1L, "active");
        ContentEJBPool.expireEjbsInPool(ejbIdlePool.values(), -1L, "idle");
        if (expiryTimer != null) {
            expiryTimer.cancel();
            expiryTimer = null;
        }
        if (runtimeShutdownHook != null) {
            if (!runtimeShuttingDown) {
                try {
                    Runtime.getRuntime().removeShutdownHook(runtimeShutdownHook);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            runtimeShutdownHook = null;
        }
        initCalled = false;
    }

    private static class RuntimeShutdownHook
    extends Thread {
        private RuntimeShutdownHook() {
        }

        public void run() {
            runtimeShuttingDown = true;
            ContentEJBPool._destroy();
        }
    }

    private static class EJBExpiryTask
    extends TimerTask {
        private EJBExpiryTask() {
        }

        public void run() {
            ContentEJBPool.expireEjbsInPool(ejbActivePool.values(), ACTIVE_EJB_EXPIRY_TIME, "active");
            ContentEJBPool.expireEjbsInPool(ejbIdlePool.values(), IDLE_EJB_EXPIRY_TIME, "idle");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EJBConnPool {
        private String conKey;
        private ConcurrentLinkedQueue<ContentEJB> ejbList = new ConcurrentLinkedQueue();

        EJBConnPool(String key) {
            this.conKey = key;
        }

        ContentEJB poll() {
            return this.ejbList.poll();
        }

        void put(ContentEJB ejb) {
            this.ejbList.add(ejb);
        }

        void remove(ContentEJB ejb) {
            this.ejbList.remove(ejb);
        }

        int size() {
            return this.ejbList.size();
        }

        Iterator<ContentEJB> iterator() {
            return this.ejbList.iterator();
        }
    }
}

