/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.transport;

import com.filenet.apiimpl.transport.ClientCallContext;
import com.filenet.apiimpl.transport.Message;
import com.filenet.apiimpl.util.BaseLogger;
import com.filenet.apiimpl.util.SessionLocator;
import com.filenet.apiimpl.util.XMLHelper;
import com.filenet.apiimpl.util.XMLTraceReader;
import com.filenet.apiimpl.util.XMLTraceable;

public class TraceDetail
implements XMLTraceable {
    private final Message message;
    private final Throwable exception;
    private final long elapsed;
    private final ClientCallContext ccc;
    private boolean clientCallInfo = false;

    TraceDetail(ClientCallContext cccVal, Message request) {
        this.message = request;
        this.exception = null;
        this.elapsed = -1L;
        this.ccc = cccVal;
    }

    TraceDetail(ClientCallContext cccVal, Message request, boolean clientCallInfo) {
        this.message = request;
        this.exception = null;
        this.elapsed = -1L;
        this.ccc = cccVal;
        this.clientCallInfo = clientCallInfo;
    }

    TraceDetail(ClientCallContext cccVal, Message responseVal, long elapsedVal) {
        this.message = responseVal;
        this.exception = null;
        this.elapsed = elapsedVal;
        this.ccc = cccVal;
    }

    TraceDetail(ClientCallContext cccVal, Throwable exceptionVal, long elapsedVal) {
        this.message = null;
        this.exception = exceptionVal;
        this.elapsed = elapsedVal;
        this.ccc = cccVal;
    }

    public void trace(XMLTraceReader reader, String element) throws Exception {
        String methodInfo;
        if (this.elapsed == -1L) {
            element = element.trim() + "Request";
        } else {
            element = element.trim() + "Response";
            reader.addAttribute("elapsed", String.valueOf(this.elapsed));
        }
        if (this.ccc != null) {
            reader.addAttribute("clientVersion", String.valueOf(this.ccc.getClientVersion()));
            if (this.ccc.getParam("clitype") != null) {
                reader.addAttribute("clientType", (String)((Object)this.ccc.getParam("clitype")));
            }
            if (this.ccc.getParam("clibuild") != null) {
                reader.addAttribute("clientBuild", (String)((Object)this.ccc.getParam("clibuild")));
            }
            if (this.ccc.getParam("ctid") != null) {
                reader.addAttribute("clientId", (String)((Object)this.ccc.getParam("ctid")));
            }
        }
        if (this.clientCallInfo && (methodInfo = BaseLogger.getClientMethodInfo()) != null && !methodInfo.trim().equals("") && !SessionLocator.isExecutingInServer()) {
            reader.addAttribute("clientCaller", XMLHelper.encodeText(methodInfo));
        }
        if (this.exception == null) {
            reader.visitValue(element, this.message);
        } else {
            reader.visitThrowable(element, this.exception);
        }
    }
}

