/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.transport;

import com.filenet.api.core.Connection;
import com.filenet.apiimpl.transport.DuplicateObjectCache;
import com.filenet.apiimpl.transport.Message;
import com.filenet.apiimpl.transport.PutContentResponse;
import com.filenet.apiimpl.transport.Response;
import com.filenet.apiimpl.util.DelegateInputStream;
import com.filenet.apiimpl.util.DelegateOutputStream;
import com.filenet.apiimpl.util.XMLTraceReader;
import com.filenet.apiimpl.util.XMLTraceable;
import java.io.IOException;
import java.io.ObjectStreamField;

public class PutContentBatchResponse
extends Message
implements Response,
XMLTraceable {
    transient PutContentResponse[] batch;
    private static final long serialVersionUID = -2577548241642969950L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];

    public PutContentBatchResponse(PutContentResponse[] batchVal) {
        this.batch = batchVal;
    }

    public PutContentResponse[] getBatch() {
        return this.batch;
    }

    public int getBatchSize() {
        return this.batch == null ? 0 : this.batch.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeBatch(DelegateOutputStream s) throws IOException {
        int size = this.batch != null ? this.batch.length : 0;
        s.writeInt(size);
        DuplicateObjectCache objCache = s.getObjectCache();
        try {
            for (int lp = 0; lp < size; ++lp) {
                s.setObjectCache(new DuplicateObjectCache());
                PutContentResponse or = this.batch[lp];
                s.writeObject(or.correlationId);
                s.writeObject(or.continueFrom);
            }
        }
        finally {
            s.setObjectCache(objCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readBatch(DelegateInputStream s, Connection conn) throws IOException, ClassNotFoundException {
        int size = s.readInt();
        this.batch = new PutContentResponse[size];
        DuplicateObjectCache objCache = s.getObjectCache();
        try {
            for (int lp = 0; lp < size; ++lp) {
                s.setObjectCache(new DuplicateObjectCache());
                PutContentResponse or = new PutContentResponse();
                or.correlationId = (String)s.readObject();
                or.continueFrom = (String)s.readObject();
                this.batch[lp] = or;
            }
        }
        finally {
            s.setObjectCache(objCache);
        }
    }

    public void trace(XMLTraceReader reader, String element) throws Exception {
        this.trace(reader, element, this.batch);
    }
}

