/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.transport;

import com.filenet.api.core.Connection;
import com.filenet.api.util.Id;
import com.filenet.apiimpl.core.ObjectReferenceBase;
import com.filenet.apiimpl.transport.DuplicateObjectCache;
import com.filenet.apiimpl.transport.Message;
import com.filenet.apiimpl.transport.PutContentRequest;
import com.filenet.apiimpl.transport.Request;
import com.filenet.apiimpl.util.DelegateInputStream;
import com.filenet.apiimpl.util.DelegateOutputStream;
import com.filenet.apiimpl.util.XMLTraceReader;
import com.filenet.apiimpl.util.XMLTraceable;
import java.io.IOException;
import java.io.ObjectStreamField;
import java.util.List;

public class PutContentBatchRequest
extends Message
implements Request,
XMLTraceable {
    transient PutContentRequest[] batch;
    private static final long serialVersionUID = 3524501483623667810L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];

    public PutContentBatchRequest(PutContentRequest[] batchVal) {
        this.batch = batchVal;
    }

    public PutContentRequest[] getBatch() {
        return this.batch;
    }

    public int getBatchSize() {
        return this.batch == null ? 0 : this.batch.length;
    }

    public void getObjectStoreReferences(List references) {
        if (this.batch != null) {
            int len = this.batch.length;
            for (int ix = 0; ix < len; ++ix) {
                ObjectReferenceBase o = this.batch[ix].getObjectReference();
                if (o == null || o.getObjectStoreReference() == null) continue;
                references.add(o.getObjectStoreReference());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeBatch(DelegateOutputStream s) throws IOException {
        int size = this.batch != null ? this.batch.length : 0;
        s.writeInt(size);
        DuplicateObjectCache objCache = s.getObjectCache();
        try {
            for (int lp = 0; lp < size; ++lp) {
                s.setObjectCache(new DuplicateObjectCache());
                PutContentRequest cr = this.batch[lp];
                s.writeObject(cr.getContinueFrom());
                s.putObject(cr.getContent());
                s.writeObject(cr.getCorrelationId());
                s.writeBoolean(cr.getIsLastChunk());
                s.putObjectReference(cr.getObjectReference());
                s.writeObject(cr.getRetrievalName());
                s.writeObject(cr.getStorageAreaId() != null ? cr.getStorageAreaId().getBytes() : null);
                s.writeObject(cr.getStoragePolicyId() != null ? cr.getStoragePolicyId().getBytes() : null);
                s.writeBoolean(cr.isNew());
            }
        }
        finally {
            s.setObjectCache(objCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readBatch(DelegateInputStream s, Connection conn) throws IOException, ClassNotFoundException {
        int size = s.readInt();
        this.batch = new PutContentRequest[size];
        DuplicateObjectCache objCache = s.getObjectCache();
        try {
            for (int lp = 0; lp < size; ++lp) {
                s.setObjectCache(new DuplicateObjectCache());
                String continueFrom = (String)s.readObject();
                Object content = s.getObject();
                String correlationId = (String)s.readObject();
                boolean isLastChunk = s.readBoolean();
                ObjectReferenceBase or = s.getObjectReference();
                String retrievalName = (String)s.readObject();
                byte[] storageAreaId = (byte[])s.readObject();
                byte[] policyId = (byte[])s.readObject();
                boolean isNew = false;
                if (s.getVersion() > 1) {
                    isNew = s.readBoolean();
                }
                this.batch[lp] = new PutContentRequest(or, correlationId, storageAreaId != null ? new Id(storageAreaId) : null, policyId != null ? new Id(policyId) : null, retrievalName, content, isLastChunk, isNew, continueFrom);
            }
        }
        finally {
            s.setObjectCache(objCache);
        }
    }

    public void trace(XMLTraceReader reader, String element) throws Exception {
        this.trace(reader, element, this.batch);
    }
}

