/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.transport;

import com.filenet.api.core.Connection;
import com.filenet.api.core.Factory;
import com.filenet.apiimpl.core.ConnectionImpl;
import com.filenet.apiimpl.transport.Request;
import com.filenet.apiimpl.transport.Response;
import com.filenet.apiimpl.util.BaseLogger;
import com.filenet.apiimpl.util.BinaryInputStream;
import com.filenet.apiimpl.util.BinaryOutputStream;
import com.filenet.apiimpl.util.ConfigValueLookup;
import com.filenet.apiimpl.util.DelegateInputStream;
import com.filenet.apiimpl.util.DelegateOutputStream;
import com.filenet.apiimpl.util.SessionContext;
import com.filenet.apiimpl.util.SubSystem;
import com.filenet.apiimpl.util.XMLTraceReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public abstract class Message
implements Serializable {
    private Map vals = new HashMap();
    private short serializationVersion = (short)5;
    private static final BaseLogger logger = BaseLogger.getBaseLogger(Message.class, SubSystem.API);
    private Connection placeholderConnection = null;
    private static final long serialVersionUID = 8479565436855676398L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];
    private static final String DEFAULT_BUILD_VERSION = "<unspecified>";
    private static final String BUILD_VERSION = ConfigValueLookup.getValue("BuildVersion", "<unspecified>").trim();
    private static final Map aliases = XMLTraceReader.getConstantAliases(new Class[]{Request.class, Response.class}, logger);

    protected Message() {
        this.vals = new HashMap();
    }

    protected Message(Map vals) {
        this.vals = vals;
    }

    Map getValues() {
        return this.vals;
    }

    public Object get(String name) {
        return this.vals.get(name);
    }

    public void put(String name, Object val) {
        this.vals.put(name, val);
    }

    public void setPlaceholderConnection(Connection conn) {
        this.placeholderConnection = conn;
    }

    public Connection getPlaceholderConnection() {
        return this.placeholderConnection;
    }

    public void applyConnectionWhereNeeded(Connection c) {
        if (this.placeholderConnection != null) {
            ((ConnectionImpl)this.placeholderConnection).setRealConnection(c);
        }
    }

    public int getBatchSize() {
        return 1;
    }

    public short getSerializationVersion() {
        return this.serializationVersion;
    }

    public void setSerializationVersion(short serializationVersionVal) {
        this.serializationVersion = serializationVersionVal;
    }

    public Object getValue() {
        return this.get("val");
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeShort(this.serializationVersion);
        s.writeObject(BUILD_VERSION);
        BinaryOutputStream tos = BinaryOutputStream.getInstance(this.serializationVersion, s);
        tos.writeInt(this.vals.size());
        for (Object key : this.vals.keySet()) {
            Object val = this.vals.get(key);
            tos.writeObject(key);
            tos.putObject(val);
        }
        this.writeBatch(tos);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        if (SessionContext.getCurrentConnection() == null) {
            Connection placeHolder = Factory.Connection.getConnection("p/l/a/c/e/h/o/l/d/e/r");
            this.setPlaceholderConnection(placeHolder);
            SessionContext.setSessionContext(new SessionContext(placeHolder));
        }
        this.serializationVersion = s.readShort();
        this.checkBuildVersion((String)s.readObject());
        BinaryInputStream tis = BinaryInputStream.getInstance(this.serializationVersion, s, SessionContext.getCurrentConnection());
        int size = tis.readInt();
        this.vals = new HashMap();
        for (int lp = 0; lp < size; ++lp) {
            Object key = tis.readObject();
            Object val = tis.getObject();
            this.vals.put(key, val);
        }
        this.readBatch(tis, SessionContext.getCurrentConnection());
    }

    private void checkBuildVersion(String version) {
        if (logger.isDetailTraceEnabled()) {
            if (version == null || (version = version.trim()).length() == 0) {
                version = DEFAULT_BUILD_VERSION;
            }
            if (!version.equalsIgnoreCase(BUILD_VERSION)) {
                logger.traceDetail("The transport build version does not match the local build version: transport=" + version + ", local=" + BUILD_VERSION);
            }
        }
    }

    protected void writeBatch(DelegateOutputStream s) throws IOException {
    }

    protected void readBatch(DelegateInputStream s, Connection conn) throws IOException, ClassNotFoundException {
    }

    protected void trace(XMLTraceReader reader, String element, Object[] batch) throws Exception {
        Map values = reader.filterValues(this.vals, aliases);
        if (batch != null && batch.length == 1 && values == null) {
            reader.visitValue(element, batch[0]);
            return;
        }
        reader.addAttributes(values);
        reader.startElement(element, this);
        reader.visitElements(values);
        if (batch != null && batch.length > 0) {
            String name = this.getBatchName();
            for (int i = 0; i < batch.length; ++i) {
                reader.visitValue(name, batch[i]);
            }
        }
        reader.endElement(element);
    }

    private String getBatchName() {
        if (this instanceof Request) {
            return "request";
        }
        if (this instanceof Response) {
            return "response";
        }
        if (this.getClass().getName().endsWith("Request")) {
            return "request";
        }
        if (this.getClass().getName().endsWith("Response")) {
            return "response";
        }
        return "operation";
    }
}

