/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.transport;

import com.filenet.api.core.Connection;
import com.filenet.apiimpl.core.ObjectReferenceBase;
import com.filenet.apiimpl.transport.DuplicateObjectCache;
import com.filenet.apiimpl.transport.Message;
import com.filenet.apiimpl.transport.ObjectRequest;
import com.filenet.apiimpl.transport.Request;
import com.filenet.apiimpl.util.DelegateInputStream;
import com.filenet.apiimpl.util.DelegateOutputStream;
import com.filenet.apiimpl.util.XMLTraceReader;
import com.filenet.apiimpl.util.XMLTraceable;
import java.io.IOException;
import java.io.ObjectStreamField;
import java.util.List;

public class GetObjectRequest
extends Message
implements Request,
XMLTraceable {
    transient ObjectRequest[] batch;
    private static final long serialVersionUID = 3524501483623667810L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];

    public GetObjectRequest(ObjectRequest[] batchVal) {
        this.batch = batchVal;
    }

    public ObjectRequest[] getBatch() {
        return this.batch;
    }

    public int getBatchSize() {
        return this.batch == null ? 0 : this.batch.length;
    }

    public void getObjectStoreReferences(List references) {
        if (this.batch != null) {
            int len = this.batch.length;
            for (int ix = 0; ix < len; ++ix) {
                ObjectReferenceBase o = this.batch[ix].getObjectReference();
                if (o == null || o.getObjectStoreReference() == null) continue;
                references.add(o.getObjectStoreReference());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeBatch(DelegateOutputStream s) throws IOException {
        int size = this.batch != null ? this.batch.length : 0;
        s.writeInt(size);
        DuplicateObjectCache objCache = s.getObjectCache();
        try {
            for (int lp = 0; lp < size; ++lp) {
                s.setObjectCache(new DuplicateObjectCache());
                ObjectRequest cr = this.batch[lp];
                s.putObjectReference(cr.objectReference);
                s.putPropertyFilter(cr.refreshFilter);
                s.writeObject(cr.cacheAllowed);
                s.writeObject(cr.correlationId);
                s.writeObject(cr.maxElements);
                s.writeObject(cr.continueFrom);
            }
        }
        finally {
            s.setObjectCache(objCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readBatch(DelegateInputStream s, Connection conn) throws IOException, ClassNotFoundException {
        int size = s.readInt();
        this.batch = new ObjectRequest[size];
        DuplicateObjectCache objCache = s.getObjectCache();
        try {
            for (int lp = 0; lp < size; ++lp) {
                s.setObjectCache(new DuplicateObjectCache());
                this.batch[lp] = new ObjectRequest(s.getObjectReference(), s.getPropertyFilter(), (Boolean)s.readObject(), (String)s.readObject(), (Integer)s.readObject(), (String)s.readObject());
            }
        }
        finally {
            s.setObjectCache(objCache);
        }
    }

    public void trace(XMLTraceReader reader, String element) throws Exception {
        this.trace(reader, element, this.batch);
    }
}

