/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.transport;

import com.filenet.api.core.Connection;
import com.filenet.apiimpl.transport.ContentResponse;
import com.filenet.apiimpl.transport.DuplicateObjectCache;
import com.filenet.apiimpl.transport.Message;
import com.filenet.apiimpl.transport.Response;
import com.filenet.apiimpl.util.DelegateInputStream;
import com.filenet.apiimpl.util.DelegateOutputStream;
import com.filenet.apiimpl.util.XMLTraceReader;
import com.filenet.apiimpl.util.XMLTraceable;
import java.io.IOException;
import java.io.ObjectStreamField;

public class GetContentResponse
extends Message
implements Response,
XMLTraceable {
    transient ContentResponse[] batch;
    private static final long serialVersionUID = -7549548274852120132L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];

    public GetContentResponse(ContentResponse[] batchVal) {
        this.batch = batchVal;
    }

    public ContentResponse[] getBatch() {
        return this.batch;
    }

    public int getBatchSize() {
        return this.batch == null ? 0 : this.batch.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeBatch(DelegateOutputStream s) throws IOException {
        int size = this.batch != null ? this.batch.length : 0;
        s.writeInt(size);
        DuplicateObjectCache objCache = s.getObjectCache();
        try {
            for (int lp = 0; lp < size; ++lp) {
                s.setObjectCache(new DuplicateObjectCache());
                ContentResponse cr = this.batch[lp];
                s.putObject(cr.getValue());
                s.writeObject(cr.getCorrelationId());
                s.writeObject(cr.getRetrievalName());
            }
        }
        finally {
            s.setObjectCache(objCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readBatch(DelegateInputStream s, Connection conn) throws IOException, ClassNotFoundException {
        int size = s.readInt();
        this.batch = new ContentResponse[size];
        DuplicateObjectCache objCache = s.getObjectCache();
        try {
            for (int lp = 0; lp < size; ++lp) {
                s.setObjectCache(new DuplicateObjectCache());
                ContentResponse cr = new ContentResponse();
                cr.putValue(s.getObject());
                cr.setCorrelationId((String)s.readObject());
                cr.setRetrievalName((String)s.readObject());
                this.batch[lp] = cr;
            }
        }
        finally {
            s.setObjectCache(objCache);
        }
    }

    public void trace(XMLTraceReader reader, String element) throws Exception {
        this.trace(reader, element, this.batch);
    }
}

