/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.transport;

import com.filenet.api.core.Connection;
import com.filenet.apiimpl.core.ObjectReferenceBase;
import com.filenet.apiimpl.transport.ContentRequest;
import com.filenet.apiimpl.transport.DuplicateObjectCache;
import com.filenet.apiimpl.transport.Message;
import com.filenet.apiimpl.transport.Request;
import com.filenet.apiimpl.util.DelegateInputStream;
import com.filenet.apiimpl.util.DelegateOutputStream;
import com.filenet.apiimpl.util.XMLTraceReader;
import com.filenet.apiimpl.util.XMLTraceable;
import java.io.IOException;
import java.io.ObjectStreamField;
import java.util.List;

public class GetContentRequest
extends Message
implements Request,
XMLTraceable {
    private transient ContentRequest[] batch;
    private transient boolean validateOnly = false;
    private static final long serialVersionUID = -2349548934852120112L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];

    public GetContentRequest(ContentRequest[] batchRequest) {
        this.batch = batchRequest;
    }

    public ContentRequest[] getBatch() {
        return this.batch;
    }

    public int getBatchSize() {
        return this.batch == null ? 0 : this.batch.length;
    }

    public boolean getValidateOnly() {
        return this.validateOnly;
    }

    public void setValidateOnly(boolean validateOnlyVal) {
        this.validateOnly = validateOnlyVal;
    }

    public void getObjectStoreReferences(List references) {
        if (this.batch != null) {
            int len = this.batch.length;
            for (int ix = 0; ix < len; ++ix) {
                ObjectReferenceBase o = this.batch[ix].getObjectReference();
                if (o == null || o.getObjectStoreReference() == null) continue;
                references.add(o.getObjectStoreReference());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeBatch(DelegateOutputStream s) throws IOException {
        s.writeBoolean(this.validateOnly);
        int size = this.batch != null ? this.batch.length : 0;
        s.writeInt(size);
        DuplicateObjectCache objCache = s.getObjectCache();
        try {
            for (int lp = 0; lp < size; ++lp) {
                s.setObjectCache(new DuplicateObjectCache());
                ContentRequest cr = this.batch[lp];
                s.putObjectReference(cr.objectReference);
                s.writeObject(cr.cacheAllowed);
                s.writeObject(cr.correlationId);
                s.writeObject(cr.elementSequenceNumber);
                s.writeObject(cr.itemIndex);
                s.writeObject(cr.startOffset);
                s.writeObject(cr.maxBytes);
                s.writeObject(cr.continueFrom);
            }
        }
        finally {
            s.setObjectCache(objCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readBatch(DelegateInputStream s, Connection conn) throws IOException, ClassNotFoundException {
        this.validateOnly = s.readBoolean();
        int size = s.readInt();
        this.batch = new ContentRequest[size];
        DuplicateObjectCache objCache = s.getObjectCache();
        try {
            for (int lp = 0; lp < size; ++lp) {
                s.setObjectCache(new DuplicateObjectCache());
                this.batch[lp] = new ContentRequest(s.getObjectReference(), (Boolean)s.readObject(), (String)s.readObject(), (Integer)s.readObject(), (Integer)s.readObject(), (Long)s.readObject(), (Integer)s.readObject(), (String)s.readObject());
            }
        }
        finally {
            s.setObjectCache(objCache);
        }
    }

    public void trace(XMLTraceReader reader, String element) throws Exception {
        reader.addAttribute("validateOnly", String.valueOf(this.validateOnly));
        this.trace(reader, element, this.batch);
    }
}

