/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.smm;

import com.filenet.apiimpl.smm.Measurement;
import java.lang.reflect.Method;

public class TimerMeasurement
extends Measurement {
    private long startTicks;
    private long stopTicks;
    private static long ticksPerSecond;
    private static Object gTimer;
    private static Method highResCounter;

    private static void init() {
        try {
            Class<?> perf = Class.forName("sun.misc.Perf");
            Method highRes = perf.getMethod("getPerf", null);
            gTimer = highRes.invoke(null, null);
            Method highResFrequency = gTimer.getClass().getMethod("highResFrequency", null);
            Object o = highResFrequency.invoke(gTimer, null);
            if (o instanceof Long) {
                ticksPerSecond = (Long)o;
            }
            highResCounter = gTimer.getClass().getMethod("highResCounter", null);
        }
        catch (Throwable t) {
            gTimer = null;
        }
    }

    private static long getCurrentMillisValue() {
        if (gTimer != null) {
            try {
                Object o = highResCounter.invoke(gTimer, null);
                if (o instanceof Long) {
                    long millis = (Long)o;
                    return millis * 1000L / ticksPerSecond;
                }
            }
            catch (Throwable t) {
                gTimer = null;
            }
        }
        return System.currentTimeMillis();
    }

    public static long getMicros() {
        return TimerMeasurement.getCurrentMillisValue() * 1000L;
    }

    public static long getMillis() {
        return TimerMeasurement.getCurrentMillisValue();
    }

    public TimerMeasurement() {
        this.reset();
    }

    public void reset() {
        this.stopTicks = 0L;
        this.startTicks = 0L;
    }

    public void start() {
        this.startTicks = TimerMeasurement.getCurrentMillisValue();
    }

    public void stop() {
        this.stopTicks = TimerMeasurement.getCurrentMillisValue();
    }

    public double getMeasurementValue() {
        return this.getElapsedMillis();
    }

    public long getElapsedMillis() {
        if (this.stopTicks > this.startTicks) {
            return this.stopTicks - this.startTicks;
        }
        return 0L;
    }

    static {
        TimerMeasurement.init();
    }
}

