/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.smm;

import com.filenet.apiimpl.smm.Measurement;
import com.filenet.apiimpl.smm.Statistic;
import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Statistics {
    private static Statistics statsVal = new Statistics();
    private static ThreadLocal cache = null;
    private DecimalFormat tmFormat = this.getTimeFormatter();
    private ConcurrentHashMap stats = new ConcurrentHashMap();

    public static void useThreadLocal(boolean useThreadLocal) {
        cache = useThreadLocal ? new ThreadLocal() : null;
    }

    public static Statistics getStatistics() {
        if (cache != null) {
            Statistics sc = (Statistics)cache.get();
            if (sc == null) {
                sc = new Statistics();
                cache.set(sc);
            }
            return sc;
        }
        return statsVal;
    }

    public void flush() {
        this.stats.clear();
    }

    public ConcurrentHashMap getMeasurements() {
        return this.stats;
    }

    public static void addMeasurementValue(String name, Measurement m) {
        Statistics.getStatistic(name).addMeasurementValue(m);
    }

    public static void addMeasurementValue(String name, double val) {
        Statistics.getStatistic(name).addMeasurementValue(val);
    }

    public static Statistic getStatistic(String name) {
        Statistics sc = Statistics.getStatistics();
        Statistic s = (Statistic)sc.stats.get(name);
        if (s == null) {
            s = new Statistic();
            sc.stats.put(name, s);
        }
        return s;
    }

    public void print(Writer pw) {
        Map.Entry[] ents = this.stats.entrySet().toArray(new Map.Entry[0]);
        Arrays.sort(ents, new StatComparator());
        if (ents == null || ents.length < 1) {
            return;
        }
        this.printHeader(pw);
        for (int lp = 0; lp < ents.length; ++lp) {
            Map.Entry ent = ents[lp];
            this.printResult(pw, (String)ent.getKey(), (Statistic)ent.getValue());
        }
        try {
            pw.flush();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private void printHeader(Writer pw) {
        try {
            pw.write("\n");
            pw.write("                               \t          \t         \t         \t         \t         \tStd. \n");
            pw.write("   Name                        \tIterations\tTotal    \tAvg      \tMin      \tMax      \tDev.\n");
            pw.write("   ----------------------------\t----------\t---------\t---------\t---------\t---------\t---------\n");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private void printResult(Writer pw, String name, Statistic stats) {
        StringBuffer pName = new StringBuffer(32);
        if (name.length() > 28) {
            pName.append(name.substring(0, 28));
        } else {
            pName.append(name);
            while (pName.length() < 28) {
                pName.append(" ");
            }
        }
        String strLog = MessageFormat.format("   {0}\t{1}\t{2}\t{3}\t{4}\t{5}\t{6}", pName.toString(), this.tmFormat.format(stats.getIterations()), this.tmFormat.format(stats.getTotal()), this.tmFormat.format(stats.getAverage()), this.tmFormat.format(stats.getMin()), this.tmFormat.format(stats.getMax()), this.tmFormat.format(stats.getStdDeviation()));
        try {
            pw.write(strLog);
            pw.write("\n");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private DecimalFormat getTimeFormatter() {
        DecimalFormat tmFormat = new DecimalFormat();
        tmFormat.setMinimumFractionDigits(2);
        tmFormat.setMaximumFractionDigits(2);
        tmFormat.setMinimumIntegerDigits(6);
        tmFormat.setMaximumIntegerDigits(30);
        tmFormat.setGroupingUsed(false);
        return tmFormat;
    }

    private DecimalFormat getIntFormatter() {
        DecimalFormat intFormat = new DecimalFormat();
        intFormat.setMaximumFractionDigits(0);
        intFormat.setMinimumIntegerDigits(6);
        intFormat.setGroupingUsed(false);
        return intFormat;
    }

    private static class StatComparator
    implements Comparator {
        private StatComparator() {
        }

        public int compare(Object o1, Object o2) {
            Map.Entry ent1 = (Map.Entry)o1;
            Map.Entry ent2 = (Map.Entry)o2;
            return ((String)ent1.getKey()).compareTo((String)ent2.getKey());
        }

        public boolean equals(Object obj) {
            return obj instanceof StatComparator;
        }
    }
}

