/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.smm;

import com.filenet.apiimpl.smm.Measurement;

public class Statistic {
    private double min;
    private double max;
    private double sum;
    private double sumSquared;
    private long iterations;
    private boolean valsSet = false;

    public Statistic() {
        this.reset();
    }

    public synchronized void reset() {
        this.min = 0.0;
        this.max = 0.0;
        this.sum = 0.0;
        this.sumSquared = 0.0;
        this.iterations = 0L;
        this.valsSet = false;
    }

    public synchronized void addMeasurementValue(Measurement m) {
        this.addMeasurementValue(m.getMeasurementValue());
    }

    public synchronized void addMeasurementValue(double val) {
        ++this.iterations;
        this.sum += val;
        this.sumSquared += val * val;
        if (this.valsSet) {
            if (val < this.min) {
                this.min = val;
            }
            if (val > this.max) {
                this.max = val;
            }
        } else {
            this.min = val;
            this.max = val;
            this.valsSet = true;
        }
    }

    public synchronized double getMin() {
        return this.min;
    }

    public synchronized double getMax() {
        return this.max;
    }

    public synchronized double getTotal() {
        return this.sum;
    }

    public synchronized double getAverage() {
        double ave = 0.0;
        if (this.iterations > 0L && this.sum > 0.0) {
            ave = this.sum / (double)this.iterations;
        }
        return ave;
    }

    public synchronized double getStdDeviation() {
        double stdDev = 0.0;
        if (this.iterations > 1L) {
            double stdSquare = ((double)this.iterations * this.sumSquared - this.sum * this.sum) / (double)(this.iterations * (this.iterations - 1L));
            stdDev = Math.sqrt(stdSquare);
        }
        return stdDev;
    }

    public synchronized long getIterations() {
        return this.iterations;
    }
}

