/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.smm;

import com.filenet.apiimpl.transport.ClientCallContext;
import com.filenet.apiimpl.util.ConfigValueLookup;
import com.filenet.pch.Accumulator;
import com.filenet.pch.Container;
import com.filenet.pch.Duration;
import com.filenet.pch.Event;
import com.filenet.pch.Listener;
import com.filenet.pch.Meter;
import com.filenet.pch.PCHcallable;
import com.filenet.pch.PCHeventClass;
import com.filenet.pch.defaultCallable;

public class PCH {
    private static final String ServerBased = "Server Based Counters";
    public static final String ExecuteChanges = "ExecuteChanges";
    public static final String ExecuteSearch = "ExecuteSearch";
    public static final String GetObjects = "GetObjects";
    public static final String GetSearchMetadata = "GetSearchMetadata";
    public static final String Requests = "Requests";
    public static final String RequestsFailed = "Requests Failed";
    public static final String RequestsInProgress = "Requests In Progress";
    public static final String Duration = "Duration";
    public static final String Loads = "Loads";
    public static final String Inserts = "Inserts";
    public static final String Updates = "Updates";
    public static final String Deletes = "Deletes";
    public static final String Moves = "Moves";
    public static final String RequestForwarding = "Request Forwarding";
    public static final String OutgoingRequestsForwarded = "Outgoing Requests Forwarded";
    public static final String OutgoingRequestsForwardedCompleted = "Outgoing Requests Forwarded Completed";
    public static final String IncomingForwardedRequests = "Incoming Forwarded Requests";
    public static final String IncomingForwardedRequestsCompleted = "Incoming Forwarded Requests Completed";
    public static final String OutgoingRequestForwardingFailures = "Outgoing Request Forwarding Failures";
    public static final String QueueItemProcessing = "Queue Item Processing";
    public static final String PublishRequestProcessing = "Publish Request Processing";
    public static final String ProcessingAttempts = "Attempts";
    public static final String ProcessingAttemptsFailed = "Attempts Failed";
    public static final String PublishRequestHandlerCopy = "Copy Handler";
    public static final String PublishRequestHandlerPDF = "PDF Handler";
    public static final String PublishRequestHandlerHTML = "HTML Handler";
    public static final String PublishRequestHandlerDITA = "DITA Handler";
    public static final String PublishRequestHandlerRender = "Render";
    public static final String FolderCache = "Folder Cache";
    public static final String SecurityDescriptorCache = "Security Descriptor Cache";
    public static final String SecurityProxyCache = "Security Proxy Cache";
    public static final String MarkingSetCache = "Marking Set Cache";
    public static final String CacheAttemptCount = "Cache Attempt Count";
    public static final String CacheHitCount = "Cache Hit Count";
    public static final String CacheMissCount = "Cache Miss Count";
    public static final String CacheFlushCount = "Cache Flush Count";
    public static final String CacheEntries = "Cache Entries";
    public static final String CacheReapLastSize = "Cache Reap Last Size";
    public static final String CacheReapLastTime = "Cache Reap Last Time";
    public static final String CacheReapTotalTime = "Cache Reap Total Time";
    public static final String CacheReapTotalCount = "Cache Reap Total Count";
    public static final String ContentCache = "ContentCache";
    public static final String InBoundMoverQueueEntries = "Cache Inbound Mover Queue Entries";
    public static final String InvalidElementQueueEntries = "Cache Invalid Element Queue Entries";
    public static final String Document = "Document";
    public static final String ContentElement = "ContentElement";
    public static final String ClassDescription = "ClassDescription";
    public static final String PropertyDescription = "PropertyDescription";
    public static final String ObjectRetrieval = "Independent Object Retrieval";
    public static final String RCR = "RCR";
    public static final String Others = "Others";
    public static final String QueueItems = "Queue Items";
    public static final String PublishRequests = "Publish Requests";
    public static final String ItemsInserted = "Items Inserted";
    public static final String ItemsProcessed = "Items Processed";
    public static final String ItemsSucceeded = "Items Process-Succeeded";
    public static final String ItemsFailed = "Items Process-Failed";
    public static final String ItemsPoison = "Items Poison";
    public static final String SynchronousEventsFired = "Synchronous Events Fired";
    public static final String AsynchronousEventsFired = "Asynchronous Events Fired";
    public static final String DocumentClassificationsRequested = "Document Classifications Requested";
    public static final String AdHocQuery = "Ad Hoc Query";
    public static final String Queries = "Queries";
    public static final String QuereriesInProgress = "Queries In Progress";
    public static final String QueryContinuations = "Query Continuations";
    public static final String QueryResultRows = "Query Result Rows";
    public static final String CBRDispatcher = "CBR Dispatcher";
    public static final String DispatchBatch = "Dispatch Batch";
    public static final String CBRExecutor = "CBR Executor";
    public static final String ExecuteBatch = "Batch Size";
    public static final String CBRExecutorForVerity = "CBR Executor for Verity";
    public static final String InsertBatch = "Insert Batch";
    public static final String DeleteBatch = "Delete Batch";
    public static final String VerityIndexBatch = "Verity Index Batch";
    public static final String VerityDeleteBatch = "Verity Delete Batch";
    public static final String IndexOptimization = "Index Optimization";
    public static final String VeritySkipped = "Skipped by Verity";
    public static final String VerityRetry = "Varity Failed Must be Retried";
    public static final String VerityNoRetry = "Varity Failed No Retry";
    public static final String IndexJob = "Index Job";
    public static final String JobExecution = "Job Execution";
    public static final String CreateUpdateRequests = "Create/Update requests submitted";
    public static final String DeleteRequests = "Delete requests submitted";
    public static final String IndexRequestor = "Index Requestor";
    public static final String DocCreatedUpdate = "Create/update Requests Submitted";
    public static final String DocDelete = "Delete Requests Submitted";
    public static final String Items = "Items";
    public static final String BatchDuration = "Batch Duration";
    public static final String BatchSize = "Batch Size";
    public static final String BatchItems = "Batch Items";
    public static final String BatchItemDuration = "Batch Item Duration";
    public static final String TextSearchFilter = "Text Search Filter";
    public static final String TextFilterBatch = "Text Filter Batch";
    public static final String TextFilterCount = "Text Filter Count";
    public static final String TextExtractor = "Text Extraction";
    public static final String FilterTimeOut = "Text Filter Timeout";
    public static final String FilterDuration = "Text Filter Duration";
    public static final String TextSearchIndexProcessor = "Text Search Index Processor";
    public static final String TextSearchCreateItems = "Text Search Create Items";
    public static final String TextSearchDeleteItems = "Text Search Delete Items";
    public static final String TextSearchIndexBatch = "Text Search Index Batch";
    public static final String TextSearchUpdateItems = "Text Search Update Items";
    public static final String TextSearchIndexReissuedCount = "Text Search Index Reissue Count";
    public static final String TextSearchIndexReissuedDuration = "Text Search Index Reissue Duration";
    public static final String TextSearchSkipped = "Skipped by Text Search";
    public static final String TextSearchRetry = "Text Search Failed Must be Retried";
    public static final String TextSearchNoRetry = "Text Search Failed No Retry";
    public static final String Changes = "Changes";
    public static final String ChangesSucceeded = "Changes Succeeded";
    public static final String ChangesFailed = "Changes Failed";
    public static final String ChangesInProgress = "Changes In Progress";
    public static final String RepositoryObjects = "Repository Objects";
    public static final String ObjectsCreated = "Objects Created";
    public static final String ObjectsDeleted = "Objects Deleted";
    public static final String ObjectsUpdated = "Objects Updated";
    public static final String ObjectsLoaded = "Objects Loaded";
    public static final String Enumerations = "Enumerations";
    public static final String EnumerationContinuations = "Enumeration Continuations";
    public static final String Database = "Database";
    public static final String DBCallsForUnIdentifiedOS = "DB Calls For Unindentified ObjectStore";
    public static final String Batches = "Batches";
    public static final String OtherStatements = "Other Statements";
    public static final String SecurityProvider = "SecurityProvider";
    public static final String DirectoryServer = "DirectoryServer";
    public static final String FindGroups = "FindGroups";
    public static final String FindUsers = "FindUsers";
    public static final String GetAllRealms = "GetAllRealms";
    public static final String GetRealm = "GetRealm";
    public static final String GetRealmByPrincipalId = "GetRealmByPrincipalId";
    public static final String GetGroup = "GetGroup";
    public static final String GetUser = "GetUser";
    public static final String GetPrincipalById = "GetPrincipalById";
    public static final String GetPrincipalName = "GetPrincipalName";
    public static final String GetPrincipalProperty = "GetPrincipalProperty";
    public static final String GetSecurityId = "GetSecurityId";
    public static final String GetSecurityIdList = "GetSecurityIdList";
    public static final String DirectoryServiceDriver = "DirectoryServiceDriver";
    public static final String GroupFetch = "GroupFetch";
    public static final String UserFetch = "UserFetch";
    public static final String PrincipalFetchById = "PrincipalFetchById";
    public static final String PrincipalFetchByName = "PrincipalFetchByName";
    public static final String RealmFetch = "RealmFetch";
    public static final String SidFetch = "SidFetch";
    public static final String AccessTokenFetch = "AccessTokenFetch";
    public static final String GroupSearch = "GroupSearch";
    public static final String UserSearch = "UserSearch";
    public static final String GetRealmDistinguishedName = "GetRealmDistinguishedName";
    public static final String GetUserByName = "GetUserByName";
    public static final String GetGroupByName = "GetGroupByName";
    public static final String GetUserBySid = "GetUserBySid";
    public static final String GetGroupBySid = "GetGroupBySid";
    public static final String SearchUsers = "SearchUsers";
    public static final String SearchGroups = "SearchGroups";
    public static final String SecurityProviderCache = "SecurityProviderCache";
    public static final String PrincipalToSidListCache = "Principal To SidList Cache";
    public static final String PrincipalNameToSidCache = "Principal Name To Sid Cache";
    public static final String SidToSecurityPrincipalCache = "Sid To SecurityPrincipal Cache";
    public static final String NameToPrincipalWithParentsCache = "Name To Principal With Parents Cache";
    public static final String LdapConnection = "LDAP Connection";
    public static final String LdapSearch = "LDAP Search";
    public static final String LdapGetAttributes = "LDAP GetAttributes";
    public static final String ContentElementCount = "Number of Content Elements";
    public static final String ContentTotalSize = "Size of Content Elements (KBytes)";
    public static final String ContentElementsAdded = "Content Elements Added";
    public static final String ContentElementsDeleted = "Content Elements Deleted";
    public static final String StorageAreaFreeSpace = "Free Space";
    public static final String DuplicateContentAdded = "Duplicate Content Elements Added";
    public static final String DuplicateContentDeleted = "Duplicate Content Elements Delete";
    public static final String ContentElementsUploaded = "Content Elements Uploaded";
    public static final String ContentUploadedSize = "Content Uploaded Size";
    public static final String ContentUploadRequestsAbandoned = "Content Upload Request Abandoned";
    public static final String ContentUploadReconnects = "Content Upload Reconnects Due to Expired TTL Stream";
    public static final String ContentElementsRetrieved = "Content Elements Retrieved";
    public static final String ContentRetrievedSize = "Content Retrieved Size";
    public static final String ContentRetrievalRequestsAbandoned = "Content Retrieval Request Abandoned";
    public static final String ContentRetrievalTimePerSize = "Content Retrieval Time (msec) Per Size (bytes)";
    public static final String ContentRetrievalReconnects = "Content Retrieval Reconnects Due to Expired TTL Stream";
    public static final String ContentInboundDirectoryCleanup = "Inbound Directory Cleanup";
    public static final String ContentCleanupThreadRunning = "Cleanup Thread Running";
    public static final String ContentCleanupProcessFolder = "Process Folder: ";
    public static final String ContentCleanupFilesExamined = "Files Examined";
    public static final String ContentCleanupFilesAccepted = "Files Accepted";
    public static final String ContentCleanupFilesDeleted = "Files Deleted";
    public static final String ContentCleanupDeleteConfirmation = "Delete Confirmation";
    public static final String ContentCleanupComputeSignature = "Compute File Signature";
    public static final String FinalizeNewElement = "Finalize New Element";
    public static final String FinalizeMovedElement = "Finalize Moved Element";
    public static final String DeleteElement = "Delete Element";
    public static final String DeleteAllElements = "Delete All Elements";
    public static final String MigrateElement = "Migrate Element";
    public static final String MigrateDocument = "Migrate Document";
    public static final String DeleteFixedElement = "Delete Fixed Content Element";
    public static final String DeleteFixedDocument = "Delete Fixed Content Document";
    public static final String FederatedLockDown = "Federated Lockdown";
    public static final String RollForwardRequested = "Roll Forward Requested";
    public static final String RollForwardProcessed = "Roll Forward Processed";
    public static final String InboundFilenameCache = "Inbound Filename Cache";
    public static final String RollForwardDispatcher = "Roll Forward Dispatcher";
    public static final String BatchUpdateAndSelection = "Batch Update and Selection";
    public static final String BatchUpdateAndSelectionRow = "Batch Update and Selection Row";
    public static final String BatchUpdateFailure = "Batch Update Failures";
    public static final String BatchSelectionFailure = "Batch Selection Failures";
    public static final String ExpiredBatchUpdate = "Expired Batch Updates";
    public static final String ExpiredBatchUpdateRow = "Expired Batch Update Rows";
    public static final String ExpiredBatchUpdateFailure = "Expired Batch Update Failures";
    public static final String PendingBatchCount = "Pending Batches";
    public static final String ResolutionPendingBatchCount = "Resolution Pending Batches";
    public static final String ActiveWorkerThread = "Active Worker Threads";
    public static final String BatchesAddedToQueue = "Batches Added To Queue";
    public static final String RequestsAddedToQueue = "Requests Added To Queue";
    public static final String BatchesResolved = "Batches Resolved";
    public static final String RequestsResolved = "Requests Resolved";
    public static final String RequestsRequeuedForRetry = "Requests Re-queued for Retry";
    public static final String RequestsForDeletedAreaPurged = "Requests For Deleted Area Purged";
    public static final String WorkerThreadStartup = "Worker Thread Startup";
    public static final String WorkerThreadCompletion = "Worker Thread Completion";
    public static final String ExpiredQueueCurrentItems = "Expired Queue Current Items";
    public static final String ExpiredQueueItemsAdded = "Expired Queue Items Added";
    public static final String ExpiredQueueItemsProcessed = "Expired Queue Items Processed";
    public static final String ExpiredQueueItemsPruned = "Expired Queue Items Pruned";
    public static final String ExpiredQueueDispatcher = "Expired Queue Dispatcher";
    public static final String ContentUpload = "Content Upload";
    public static final String FilesRenamedSA = "Files Renamed/Finalized";
    public static final String FileRenameFailuresSA = "File Rename Failures";
    public static final String FilesDeletedSA = "Files Deleted";
    public static final String FileDeleteFailuresSA = "File Deletion Failures";
    public static final String FileUploadStartSA = "Start Upload";
    public static final String FileUploadContinueSA = "Continue Upload";
    public static final String FileUploadWriteSA = "Upload Write";
    public static final String FileUploadBytesSA = "Upload Bytes";
    public static final String FileUploadCloseSA = "Upload Close";
    public static final String ContentDownload = "Content Download";
    public static final String FileDownloadStartSA = "Start Download";
    public static final String FileDownloadContinueSA = "Reconnect Stream";
    public static final String FileDownloadReadSA = "Download Read";
    public static final String FileDownloadBytesSA = "Download Bytes";
    public static final String FileDownloadCloseSA = "Download Close";
    public static final String TTLStreams = "TTL Streams";
    public static final String TTLStreamsActive = "TTL Streams Active";
    public static final String TTLStreamsAdded = "TTL Streams Added";
    public static final String TTLStreamsRemoved = "TTL Streams Removed";
    public static final String TTLStreamsExpired = "TTL Streams Expired";
    public static final String FixedDeviceHealth = "Device Health";
    public static final String FCPInUseSize = "FCPs in use";
    public static final String FCPFreePoolSize = "FCPs in free pool";
    public static final String Centera = "Centera FCD";
    public static final String CachedPoolCount = "Cached Pool";
    public static final String PoolsAddedToCache = "Pools Added to Cache";
    public static final String CClipsCreated = "C-Clips Created";
    public static final String CClipCreationFailures = "C-Clip Creation Failures";
    public static final String CClipsDeleted = "C-Clips Deleted";
    public static final String CClipsAuditedDeleted = "C-Clips Deleted With Audit";
    public static final String CClipsPurged = "C-Clips Deleted With Purge";
    public static final String CClipDeletionFailures = "C-Clips Deletion Failures";
    public static final String CClipsOpened = "C-Clips Opened";
    public static final String CClipOpenFailures = "C-Clips Open Failures";
    public static final String CClipsClosed = "C-Clips Closed";
    public static final String TagsOpened = "Tags Opened";
    public static final String TagOpenFailures = "Tag Open Failures";
    public static final String TagsCreated = "Tags Created";
    public static final String TagCreationFailures = "Tag Creation Failures";
    public static final String TotalBytesWrittenToTags = "Total Bytes Written to Tags";
    public static final String TotalBytesReadFromTags = "Total Bytes Read From Tags";
    public static final String FSB = "FSB FCD";
    public static final String Snaplock = "Snaplock FCD";
    public static final String Logon = "Logon";
    public static final String LogonFailures = "Logon Failures";
    public static final String FilesCreated = "Files Created";
    public static final String FileCreationFailures = "File Creation Failures";
    public static final String FilesOpened = "Files Opened";
    public static final String FileOpenFailures = "File Open Failures";
    public static final String FilesClosed = "Files Closed";
    public static final String FilesDeleted = "Files Deleted";
    public static final String FilesPurged = "Files Deleted With Purge";
    public static final String FilesDetroyed = "Files Deleted With Destroy";
    public static final String FileDeletionFailures = "Files Deletion Failures";
    public static final String TotalBytesReadFromFiles = "Total Bytes Read From Files";
    public static final String TotalBytesWrittenToFiles = "Total Bytes Written to Files";
    public static final String GetRetentionTime = "Get Retention Time";
    public static final String GetRetentionTimeFailures = "Get Retention Time Failures";
    public static final String SetRetentionTime = "Set Retention Time";
    public static final String SetRetentionTimeFailures = "Set Retention Time Failures";
    public static final String ISFCD = "Image Services FCD";
    public static final String Logoff = "Logoff";
    public static final String LogoffFailures = "Logoff Failures";
    public static final String DocumentsCreated = "Documents Created";
    public static final String DocumentCreationFailures = "Document Creation Failures";
    public static final String PagesCreated = "Pages Created";
    public static final String DocumentsDeleted = "Documents Deleted";
    public static final String DocumentDeletionFailures = "Document Deletion Failures";
    public static final String FederatedDocumentsDeleted = "Federated Documents Deleted";
    public static final String FederatedDocumentDeletionFailures = "Federated Document Deletion Failures";
    public static final String AnnotationsDeleted = "Annotations Deleted";
    public static final String AnnotationDeletionFailures = "Annotation Deletion Failures";
    public static final String FederatedDocumentsLocked = "Federated Documents Locked";
    public static final String PagesOpened = "Pages Opened";
    public static final String PageOpenFailures = "Pages Open Failures";
    public static final String PagesClosed = "Pages Closed";
    public static final String PagesSeeked = "Pages Seeked";
    public static final String TotalBytesWrittenToIS = "Total Bytes Written to IS";
    public static final String TotalBytesReadFromIS = "Total Bytes Read From IS";
    public static final String PageOpenDuration = "Page Open Duration";
    public static final String PageSeekDuration = "Page Seek Duration";
    public static final String PageReadDuration = "Page Read Duration";
    public static final String PageWriteDuration = "Page Write Duration";
    public static final String CMODFCD = "CMOD FCD";
    public static final String CurrentCMODSessions = "Active CMOD Logon Sessions";
    public static final String ODWEKLogonCalls = "ODWEK ODServer.logon Calls";
    public static final String ODWEKLogoffCalls = "ODWEK ODServer.logoff Calls";
    public static final String ODWEKTerminateCalls = "ODWEK ODServer.terminate Calls";
    public static final String ODWEKFolderCloseCalls = "ODWEK ODFolder.close Calls";
    public static final String ODWEKBuildFolderCalls = "ODWEK ODServer.buildFolder Calls";
    public static final String ODWEKRecreateHitCalls = "ODWEK ODFolder.recreateHit Calls";
    public static final String ODWEKRetrieveCalls = "ODWEK ODHit.retrieve Calls";
    public static final String ODWEKRetrieveSegmentCalls = "ODWEK ODHit.retrieveSegment Calls";
    public static final String ODWEKRetrieveToFileCalls = "ODWEK ODHit.retrieve/File Calls";
    public static final String ODWEKRetrieveSegmentToFileCalls = "ODWEK ODHit.retrieveSegment/File Calls";
    public static final String ODWEGetApplicationGroupCalls = "ODWEK ODServer.getApplicationGroupCalls";
    public static final String ODWEGetApplicationGroupNamesCalls = "ODWEK ODServer.getApplicationGroupNamesCalls";
    public static final String ODWEKCFSODAddHitsCalls = "ODWEK ODFolder.CFSODAddHits Calls";
    public static final String ODWEKCFSODReleaseHitsCalls = "ODWEK ODFolder.CFSODReleaseHits Calls";
    public static final String TSMFCD = "Tivoli Storage Manager FCD";
    public static final String TSMObjectsCreated = "TSM Objects Created";
    public static final String TSMObjectsOpened = "TSM Objects Opened";
    public static final String TSMObjectsDeleted = "TSM Objects Deleted";
    public static final String TSMObjectsRead = "TSM Objects Read";
    public static final String TSMObjectBytesRead = "TSM Bytes Read";
    public static final String TSMObjectBytesWritten = "TSM Bytes Written";
    public static final String TSMObjectsHeld = "TSM Objects Held/Released";
    public static final String TSMOfflineObjects = "TSM Offline Objects";
    public static final String TSMWaitingReaders = "TSM Waiting Reader Threads";
    public static final String TSMManagementClassCache = "TSM Management Class Cache";
    public static final String TSMSDKActiveThreads = " Active Threads";
    public static final String TSMRPCThreads = "TSM RPC Threads";
    public static final String TSMConnections = "Active TSM Connections";
    public static final String HCPFCD = "Hitachi Content Platform FCD";
    public static final String HCPHTTPThreads = "Threads - HTTP";
    public static final String HCPStreamThreads = "Threads - Stream";
    public static final String HCPFileThreads = "Threads - File";
    public static final String HCPOpenURLConnection = "HTTP URL Open Connection";
    public static final String HCPSetRequestMethod = "HTTP Set Request Method:";
    public static final String HCPGetResponseCode = "HTTP Get Response Code";
    public static final String HCPConsumeStream = "HTTP Consume Stream";
    public static final String HCPReadStream = "HTTP Read Stream";
    public static final String HCPWriteStream = "HTTP Write Stream";
    public static final String HCPReadStreamBytes = "HTTP Read Stream Bytes";
    public static final String HCPWriteStreamBytes = "HTTP Write Stream Bytes";
    public static final String HCPExceptions = "HTTP Exceptions";
    public static final String HCPErrors = "HTTP Errors";
    public static final String HCPFileExists = "File Exists";
    public static final String HCPFileCreate = "File Create";
    public static final String HCPFileDelete = "File Delete";
    public static final String HCPFileMkdir = "File Create Directory";
    public static final String HCPFileRead = "File Read";
    public static final String HCPFileAlterRetention = "File Alter Retention";
    public static final String HCPFileRetentionHold = "File Set/Release Retention Hold";
    public static final String IS_PD = "CFS-IS Replication";
    public static final String IS_PD_TotalDocs = "CFS-IS Inbound - Documents";
    public static final String IS_PD_TotalAnnots = "CFS-IS Inbound - Annotations";
    public static final String IS_PD_Exports = "Exports";
    public static final String IS_PD_OutboundDocs = "CFS-IS Outbound - Documents";
    public static final String IS_PD_OutboundAnnots = "CFS-IS Outbound - Annotations";
    public static final String IS_PD_Creates = "Creates";
    public static final String IS_PD_Dereplicates = "Dereplicates";
    public static final String IS_PD_Errors = "Errors";
    public static final String IICEFCD = "IICE FCD";
    public static final String TotalBytesReadFromIICE = "Total Bytes Read From IICE";
    public static final String FederatedDocumentLockdowns = "Federated Documents Locked Down";
    public static final String FederatedDocumentLockdownFailures = "Federated Document Lockdown Failures";
    public static final String FederatedDocumentLockdownDuration = "Federated Document Lockdown Duration";
    public static final String CFSFreezeContent = "CFS Freeze Content";
    public static final String CFSFreezeContentFailures = "CFS Freeze Content Failures";
    public static final String CFSFreezeContentDuration = "CFS Freeze Content Duration";
    public static final String CFSIMPORTAGENT = "CFS Import Agent";
    public static final String GCDNotificationsReceived = "GCD Update Notifications Received";
    public static final String SessionTableQueries = "Session Table Queries";
    public static final String SessionRowsSelected = "Session Rows Selected";
    public static final String SessionRowsUpdated = "Session Rows Updated";
    public static final String SessionRowsDeleted = "Session Rows Deleted";
    public static final String QueueTableQueries = "Queue Table Queries";
    public static final String QueueRowsSelected = "Queue Rows Selected";
    public static final String QueueRowsDeleted = "Queue Rows Deleted";
    public static final String QueueRowsNotProcessed = "Queue Rows Not Processed";
    public static final String VersionSeriesTableQueries = "Version Series Table Queries";
    public static final String VersionSeriesRowsSelected = "Version Series Rows Selected";
    public static final String VersionSeriesRowsInserted = "Version Series Rows Inserted";
    public static final String VersionSeriesRowsUpdated = "Version Series Rows Updated";
    public static final String VersionSeriesRowsDeleted = "Version Series Rows Deleted";
    public static final String VersionSeriesRowsNotUpdated = "Version Series Rows Not Updated";
    public static final String FederatedDocumentsCreated = "Federated Documents Created";
    public static final String FederatedDocumentsLoaded = "Federated Documents Loaded";
    public static final String FederatedDocumentsNotLoaded = "Federated Documents Not Loaded";
    public static final String FederatedDocumentsUpdated = "Federated Documents Updated";
    public static final String FederatedDocumentsCheckedOut = "Federated Documents Checked-out";
    public static final String FederatedDocumentsCheckedIn = "Federated Documents Checked-in";
    public static final String ImportRequestsRejected = "Invalid Import Requests";
    public static final String DocumentObjectsRetvdFromCache = "Document objects retrieved from cache";
    public static final String ExpiredImportRequests = "Expired Requests Returned to Queue";
    public static final String FederatedContentMoved = "Federated Content Moved";
    public static final String FederatedContentNotMoved = "Federated Content Not Moved";
    public static final String FederatedContentMoveFinalized = "Federated Content Move Finalized";
    public static final String ContentCacheArea = "ContentCacheArea";
    public static final String AreaSummaryCategory = "Area Summary";
    public static final String RetrievalsCategory = "Retrievals";
    public static final String UploadsCategory = "Uploads";
    public static final String PruningsCategory = "Prunings";
    public static final String DeletionsCategory = "Deletions";
    public static final String InMemoryStateCacheCategory = "In-memory State Cache";
    public static final String TotalContentSizeBytes = "Size of Content Elements";
    public static final String ContentElementsRemoved = "Content Elements Removed";
    public static final String RetrievalHits = "Retrieval Hits";
    public static final String RetrievalMisses = "Retrieval Misses";
    public static final String RetrievalAttempts = "Retrieval Attempts";
    public static final String RetrievalPopulationsCompleted = "Retrieval Populations Completed";
    public static final String RetrievalsPartiallyServiced = "Retrievals Partially Serviced";
    public static final String UploadsAttempted = "Uploads Attempted";
    public static final String UploadsCompleted = "Uploads Completed";
    public static final String UploadsCommitted = "Uploads Committed";
    public static final String UploadsRolledBack = "Uploads Rolled Back";
    public static final String PruningsStarted = "Prunings Started";
    public static final String PruningsCompleted = "Prunings Completed";
    public static final String CompletedElementsRemoved = "Completed Elements Removed";
    public static final String AllElementsRemoved = "All Elements Removed";
    public static final String BackgroundProcessing = "Background Processing";
    public static final String ScheduledPoolExecutor = "Scheduled Dispatchers";
    public static final String WorkerPoolExecutor = "Workers";
    public static final String NumOfThreadCreated = "Created Threads";
    public static final String NumOfActiveThreads = "Active Threads";
    public static final String NumOfTotalThreads = "Threads";
    public static final String NumOfWorksQueued = "Number Queued";
    public static final String WaitTimeForThread = "Wait Time for Thread";
    public static final String TaskExecution = "Total Tasks Completed";
    public static final String JournalsInserted = "Journal Entries Inserted";
    public static final String JournalsProcessed = "Journal Entries Processed";
    public static final String JournalsSucceeded = "Journal Entries Succeeded";
    public static final String JournalsFailed = "Journal Entries Failed";
    public static final String JournalsPoison = "Journal Entries Poison";
    public static final String JournalExecutors = "Active Outbound Workers";
    public static boolean isRunning;
    private static Listener listener;

    public static void startPchListener() {
        if (!isRunning) {
            String appName = PCH.lookupAppName();
            String appVersion = PCH.lookupAppVersion();
            listener = new Listener(appName, appVersion, (PCHcallable)new defaultCallable());
            isRunning = true;
        }
        System.out.println("Started PCH listener.");
    }

    public static void stopPchListener() {
        if (isRunning) {
            System.out.println("Stopping PCH listener.");
            listener.shutdown();
            isRunning = false;
        }
    }

    public static Event lookupEventByRPCMethod(String methodName, String counterName) {
        Container methodContainer = listener.lookupContainer(methodName);
        return methodContainer.lookupEvent(PCHeventClass.RPC, counterName);
    }

    public static Meter lookupMeterByRPCMethod(String methodName, String counterName) {
        Container methodContainer = listener.lookupContainer(methodName);
        return methodContainer.lookupMeter(counterName);
    }

    public static Duration lookupDurationByRPCMethod(String methodName, String parentEventName, String counterName) {
        Container methodContainer = listener.lookupContainer(methodName);
        Event parentEvent = methodContainer.lookupEvent(PCHeventClass.RPC, parentEventName);
        Accumulator accmt = parentEvent.lookupAccumulator(counterName);
        return listener.durationFactory(accmt);
    }

    public static Event lookupEventByServer(String groupName, String counterName) {
        Container serverContainer = listener.lookupContainer(ServerBased);
        Container groupContainer = serverContainer.lookupContainer(groupName);
        return groupContainer.lookupEvent(PCHeventClass.USER, counterName);
    }

    public static Event lookupEventByServer(String groupName, String subgroupName, String counterName) {
        Container serverContainer = listener.lookupContainer(ServerBased);
        Container groupContainer = serverContainer.lookupContainer(groupName);
        Container subgroupContainer = groupContainer.lookupContainer(subgroupName);
        return subgroupContainer.lookupEvent(PCHeventClass.USER, counterName);
    }

    public static Meter lookupMeterByServer(String groupName, String counterName) {
        Container serverContainer = listener.lookupContainer(ServerBased);
        Container groupContainer = serverContainer.lookupContainer(groupName);
        return groupContainer.lookupMeter(counterName);
    }

    public static Meter lookupMeterByServer(String groupName, String subgroupName, String counterName) {
        Container serverContainer = listener.lookupContainer(ServerBased);
        Container groupContainer = serverContainer.lookupContainer(groupName);
        Container subgroupContainer = groupContainer.lookupContainer(subgroupName);
        return subgroupContainer.lookupMeter(counterName);
    }

    public static Duration lookupDurationByServer(String groupName, String parentEventName, String counterName) {
        Container serverContainer = listener.lookupContainer(ServerBased);
        Container groupContainer = serverContainer.lookupContainer(groupName);
        Event parentEvent = groupContainer.lookupEvent(PCHeventClass.USER, parentEventName);
        Accumulator accmt = parentEvent.lookupAccumulator(counterName);
        return listener.durationFactory(accmt);
    }

    public static void updateEventByServer(String groupName, String counterName) {
        Event event = PCH.lookupEventByServer(groupName, counterName);
        event.recordEvent();
    }

    public static Event lookupEventByObjectStore(String objectStoreName, String groupName, String counterName) {
        Container objectStoreContainer = listener.lookupContainer(objectStoreName);
        Container groupContainer = objectStoreContainer.lookupContainer(groupName);
        return groupContainer.lookupEvent(PCHeventClass.USER, counterName);
    }

    public static Meter lookupMeterByObjectStore(String objectStoreName, String groupName, String counterName) {
        Container objectStoreContainer = listener.lookupContainer(objectStoreName);
        Container groupContainer = objectStoreContainer.lookupContainer(groupName);
        return groupContainer.lookupMeter(counterName);
    }

    public static Duration lookupDurationByObjectStore(String objectStoreName, String groupName, String parentEventName, String counterName) {
        Event parentEvent = PCH.lookupEventByObjectStore(objectStoreName, groupName, parentEventName);
        Accumulator accmt = parentEvent.lookupAccumulator(counterName);
        return listener.durationFactory(accmt);
    }

    public static void updateEventByObjectStore(String objectStoreName, String groupName, String counterName) {
        Event event = PCH.lookupEventByObjectStore(objectStoreName, groupName, counterName);
        event.recordEvent();
    }

    public static Event lookupEventByServerCategory(String category, String groupName, String counterName) {
        Container serverContainer = listener.lookupContainer(ServerBased);
        Container categoryContainer = serverContainer.lookupContainer(category);
        Container groupContainer = categoryContainer.lookupContainer(groupName);
        return groupContainer.lookupEvent(PCHeventClass.USER, counterName);
    }

    public static Meter lookupMeterByServerCategory(String category, String groupName, String counterName) {
        Container serverContainer = listener.lookupContainer(ServerBased);
        Container categoryContainer = serverContainer.lookupContainer(category);
        Container groupContainer = categoryContainer.lookupContainer(groupName);
        return groupContainer.lookupMeter(counterName);
    }

    public static Duration lookupDurationByServerCategory(String category, String groupName, String parentEventName, String counterName) {
        Container serverContainer = listener.lookupContainer(ServerBased);
        Container categoryContainer = serverContainer.lookupContainer(category);
        Container groupContainer = categoryContainer.lookupContainer(groupName);
        Event parentEvent = groupContainer.lookupEvent(PCHeventClass.USER, parentEventName);
        Accumulator accmt = parentEvent.lookupAccumulator(counterName);
        return listener.durationFactory(accmt);
    }

    public static Duration lookupDurationByServerCategoryWithGroupEvent(String category, String groupName, String parentEventName, String counterName) {
        Container serverContainer = listener.lookupContainer(ServerBased);
        Container categoryContainer = serverContainer.lookupContainer(category);
        Event groupEvent = categoryContainer.lookupEvent(PCHeventClass.USER, groupName);
        Event parentEvent = groupEvent.lookupEvent(parentEventName);
        Accumulator accmt = parentEvent.lookupAccumulator(counterName);
        return listener.durationFactory(accmt);
    }

    public static void updateEventByServerCategory(String category, String groupName, String counterName) {
        Event event = PCH.lookupEventByServerCategory(category, groupName, counterName);
        event.recordEvent();
    }

    public static CombinedBatchCounter startCombinedBatchDurationByServer(String groupName, String batchEventName) {
        Container serverContainer = listener.lookupContainer(ServerBased);
        Container groupContainer = serverContainer.lookupContainer(groupName);
        Event batchEvent = groupContainer.lookupEvent(PCHeventClass.USER, batchEventName);
        Accumulator batchDuration = batchEvent.lookupAccumulator(BatchDuration);
        Event itemsEvent = batchEvent.lookupEvent(Items);
        Accumulator itemDuration = itemsEvent.lookupAccumulator(BatchItemDuration);
        Duration dur = listener.durationFactory(batchDuration);
        dur.start();
        return new CombinedBatchCounter(itemDuration, itemsEvent, dur, batchDuration);
    }

    public static CombinedBatchCounter startCombinedBatchDurationByObjectStore(String objectStoreName, String groupName, String batchEventName) {
        Container objectStoreContainer = listener.lookupContainer(objectStoreName);
        Container groupContainer = objectStoreContainer.lookupContainer(groupName);
        Event batchEvent = groupContainer.lookupEvent(PCHeventClass.USER, batchEventName);
        Accumulator batchDuration = batchEvent.lookupAccumulator(BatchDuration);
        Event itemsEvent = batchEvent.lookupEvent(Items);
        Accumulator itemDuration = itemsEvent.lookupAccumulator(BatchItemDuration);
        Duration dur = listener.durationFactory(batchDuration);
        dur.start();
        return new CombinedBatchCounter(itemDuration, itemsEvent, dur, batchDuration);
    }

    public static long stopCombinedBatchDuration(CombinedBatchCounter counter, int batchSize) {
        long duration = 0L;
        if (counter != null && batchSize > 0) {
            counter.itemEvent.recordEvent(batchSize);
            duration = counter.batchDuration.stop(true);
            counter.itemAccumulator.recordValue(duration, false);
        }
        return duration;
    }

    public static void logBatchDataByServer(String groupName, String batchEventName, long value, int batchSize) {
        Container serverContainer = listener.lookupContainer(ServerBased);
        Container groupContainer = serverContainer.lookupContainer(groupName);
        Event batchEvent = groupContainer.lookupEvent(PCHeventClass.USER, batchEventName);
        Accumulator batchDuration = batchEvent.lookupAccumulator(BatchDuration);
        batchDuration.recordValue(value, true);
        Event itemsEvent = batchEvent.lookupEvent(Items);
        Accumulator itemDuration = itemsEvent.lookupAccumulator(BatchItemDuration);
        itemsEvent.recordEvent(batchSize);
        itemDuration.recordValue(value, false);
    }

    public static void logBatchDataByObjectStore(String objectStoreName, String groupName, String batchEventName, long value, int batchSize) {
        Container objectStoreContainer = listener.lookupContainer(objectStoreName);
        Container groupContainer = objectStoreContainer.lookupContainer(groupName);
        Event batchEvent = groupContainer.lookupEvent(PCHeventClass.USER, batchEventName);
        Accumulator batchDuration = batchEvent.lookupAccumulator(BatchDuration);
        batchDuration.recordValue(value, true);
        Event itemsEvent = batchEvent.lookupEvent(Items);
        Accumulator itemDuration = itemsEvent.lookupAccumulator(BatchItemDuration);
        itemsEvent.recordEvent(batchSize);
        itemDuration.recordValue(value, false);
    }

    public static BatchCounter startBatchDurationByServer(String groupName, String batchEventName, String batchItemsName, String batchDurationName) {
        Container serverContainer = listener.lookupContainer(ServerBased);
        Container groupContainer = serverContainer.lookupContainer(groupName);
        Event batchEvent = groupContainer.lookupEvent(PCHeventClass.USER, batchEventName);
        Event itemsEvent = batchEvent.lookupEvent(batchItemsName);
        Duration dur = listener.durationFactory(batchEvent.lookupAccumulator(batchDurationName));
        dur.start();
        return new BatchCounter(batchEvent, itemsEvent, dur);
    }

    public static BatchCounter startBatchDurationByObjectStore(String objectStoreName, String groupName, String batchEventName, String batchItemsName, String batchDurationName) {
        Container objectStoreContainer = listener.lookupContainer(objectStoreName);
        Container groupContainer = objectStoreContainer.lookupContainer(groupName);
        Event batchEvent = groupContainer.lookupEvent(PCHeventClass.USER, batchEventName);
        Event itemsEvent = batchEvent.lookupEvent(batchItemsName);
        Duration dur = listener.durationFactory(batchEvent.lookupAccumulator(batchDurationName));
        dur.start();
        return new BatchCounter(batchEvent, itemsEvent, dur);
    }

    public static long stopBatchDuration(BatchCounter batchCounter, int batchSize) {
        if (batchCounter != null) {
            batchCounter.itemsEvent.recordEvent(batchSize);
            return batchCounter.batchDuration.stop(true);
        }
        return 0L;
    }

    public static boolean isLicenseUsageUpdated(ClientCallContext ccc) {
        Boolean isSetObj = (Boolean)ccc.getParam("iluu");
        return isSetObj == null ? false : isSetObj;
    }

    public static void updateLicenseUsage(ClientCallContext ccc, String userName) {
        listener.usage(userName);
        ccc.putParam("iluu", Boolean.TRUE);
    }

    public static void recordCriticalMessage(String msg) {
        listener.recordCustomMessage(msg, 3);
    }

    private static String lookupAppName() {
        String appName = ConfigValueLookup.getValue("ProductName", null);
        return appName;
    }

    private static String lookupAppVersion() {
        String appVersion = ConfigValueLookup.getValue("ProductVersion", null);
        String buildVersion = ConfigValueLookup.getValue("BuildVersion", null);
        if (buildVersion != null) {
            appVersion = appVersion + " " + buildVersion;
        }
        return appVersion;
    }

    public static void main(String[] args) {
        String appName = PCH.lookupAppName();
        String appVersion = PCH.lookupAppVersion();
        System.out.println("AppName=" + appName + ";AppVersion=" + appVersion + ";");
    }

    static {
        String appName = PCH.lookupAppName();
        String appVersion = PCH.lookupAppVersion();
        listener = new Listener(appName, appVersion, (PCHcallable)new defaultCallable());
        isRunning = true;
    }

    public static class BatchCounter {
        public Event batchEvent;
        public Event itemsEvent;
        public Duration batchDuration;

        public BatchCounter(Event be, Event ie, Duration bd) {
            this.batchEvent = be;
            this.itemsEvent = ie;
            this.batchDuration = bd;
        }
    }

    public static class CombinedBatchCounter {
        public Accumulator itemAccumulator;
        public Event itemEvent;
        public Duration batchDuration;
        public Accumulator batchAccumulator;

        public CombinedBatchCounter(Accumulator ia, Event ie, Duration bd, Accumulator ba) {
            this.itemAccumulator = ia;
            this.itemEvent = ie;
            this.batchDuration = bd;
            this.batchAccumulator = ba;
        }
    }
}

