/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.query;

import com.filenet.api.core.Connection;
import com.filenet.apiimpl.collection.AbstractEngineSet;
import com.filenet.apiimpl.collection.DefaultPaging;
import com.filenet.apiimpl.core.Session;
import com.filenet.apiimpl.query.SearchContext;
import com.filenet.apiimpl.util.DelegateInputStream;
import com.filenet.apiimpl.util.DelegateOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;

public abstract class SearchPaging
extends DefaultPaging {
    private SearchContext context;
    private static final long serialVersionUID = -576960190716551794L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];
    private static final int NULL_SEARCH_CONTEXT = 4;

    protected SearchPaging() {
    }

    protected SearchPaging(SearchContext context, AbstractEngineSet result) {
        this.context = context;
        this.setConnection(context.getConnection());
        this.setPageSize(context.getPageSize());
        this.setContinuation(result.getPaging().getContinuation());
    }

    public void setContext(SearchContext context) {
        this.context = context;
    }

    public SearchContext getContext() {
        return this.context;
    }

    protected boolean isPageable() {
        return this.context != null;
    }

    public void setConnection(Connection connection) {
        super.setConnection(connection);
        this.context.setConnection(connection);
    }

    protected AbstractEngineSet fetchSet(Session session, String continuation) {
        SearchContext ctxt = this.getContext();
        ctxt.setPageSize(this.getPageSize(ctxt.getPageSize()));
        return this.fetchSearchSet(session, ctxt, continuation);
    }

    protected abstract AbstractEngineSet fetchSearchSet(Session var1, SearchContext var2, String var3);

    public String toString() {
        StringBuffer sb = new StringBuffer(1024);
        sb.append(super.toString());
        sb.append(" Context=(").append(this.context).append(')');
        return sb.toString();
    }

    private void writeObject(ObjectOutputStream s) {
    }

    private void readObject(ObjectInputStream s) {
    }

    protected int getStreamFlags() {
        int flags = super.getStreamFlags();
        return flags |= this.context == null ? 4 : 0;
    }

    public void serializeValue(DelegateOutputStream s) throws IOException {
        super.serializeValue(s);
        if (this.context != null) {
            s.putSearchContext(this.context);
        }
    }

    protected void deserializeValue(DelegateInputStream s, int flags) throws IOException, ClassNotFoundException {
        super.deserializeValue(s, flags);
        if ((flags & 4) == 0) {
            this.context = s.getSearchContext();
        }
    }

    protected void copyValue(DefaultPaging src) {
        super.copyValue(src);
        SearchPaging source = (SearchPaging)src;
        this.context = source.context;
    }
}

