/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.query;

import com.filenet.api.constants.MergeMode;
import com.filenet.api.core.Connection;
import com.filenet.api.core.ObjectStore;
import com.filenet.apiimpl.core.EngineObjectImpl;
import com.filenet.apiimpl.core.GlobalIdentity;
import com.filenet.apiimpl.query.Search;
import com.filenet.apiimpl.util.DelegateInputStream;
import com.filenet.apiimpl.util.DelegateOutputStream;
import com.filenet.apiimpl.util.Streams;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

public class SearchContext
implements Serializable {
    private Connection connection;
    private Search search;
    private MergeMode mergeMode;
    private Integer pageSize;
    private Boolean continuable;
    private GlobalIdentity[] objectStores;
    private static final long serialVersionUID = -8877007703049769245L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];
    private static final int NULL_SEARCH = 1;
    private static final int NULL_MERGE_MODE = 2;
    private static final int NULL_PAGE_SIZE = 4;
    private static final int NULL_CONTINUABLE = 8;
    private static final int NULL_OBJECT_STORES = 16;
    private static final int EMPTY_OBJECT_STORES = 32;

    public SearchContext() {
    }

    public SearchContext(Connection connection, Search search, MergeMode mergeMode, Integer pageSize, Boolean continuable, ObjectStore[] objectStores) {
        this.connection = connection;
        this.search = search;
        this.mergeMode = mergeMode;
        this.pageSize = pageSize;
        this.continuable = continuable;
        if (objectStores != null) {
            this.objectStores = new GlobalIdentity[objectStores.length];
            for (int i = 0; i < objectStores.length; ++i) {
                this.objectStores[i] = (GlobalIdentity)((EngineObjectImpl)((Object)objectStores[i])).getObjectReference();
            }
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public Search getSearch() {
        return this.search;
    }

    public MergeMode getMergeMode() {
        return this.mergeMode;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Boolean getContinuable() {
        return this.continuable;
    }

    public GlobalIdentity[] getObjectStores() {
        return this.objectStores;
    }

    public String toString() {
        List<GlobalIdentity> osList = this.objectStores == null ? null : Arrays.asList(this.objectStores);
        StringBuffer sb = new StringBuffer(1024);
        sb.append(" Class=").append(this.getClass().getName());
        sb.append(" Continuable=").append(this.continuable);
        sb.append(" PageSize=").append(this.pageSize);
        sb.append(" Search=(").append(this.search).append(')');
        sb.append(" MergeMode=(").append(this.mergeMode).append(')');
        sb.append(" ObjectStores=(").append(osList).append(')');
        return sb.toString();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeShort(5);
        s.writeObject(this.connection);
        Streams.getInstance().getDelegate(s).putSearchContext(this);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        Streams streams = Streams.getInstance(s.readShort());
        this.connection = streams.readConnection(s);
        this.copyValue(streams.getDelegate(s, this.connection).getSearchContext());
    }

    public void serializeValue(DelegateOutputStream s) throws IOException {
        int size = this.objectStores == null ? -1 : this.objectStores.length;
        int flags = 0;
        flags |= this.search == null ? 1 : 0;
        flags |= this.mergeMode == null ? 2 : 0;
        flags |= this.pageSize == null ? 4 : 0;
        flags |= this.continuable == null ? 8 : 0;
        flags |= this.objectStores == null ? 16 : 0;
        s.writeByte(flags |= size == 0 ? 32 : 0);
        if (this.search != null) {
            s.putSearch(this.search);
        }
        if (this.mergeMode != null) {
            s.putMergeMode(this.mergeMode);
        }
        if (this.pageSize != null) {
            s.writeInt(this.pageSize);
        }
        if (this.continuable != null) {
            s.writeBoolean(this.continuable);
        }
        if (size > 0) {
            s.writeInt(size);
            for (int i = 0; i < size; ++i) {
                s.putObjectReference(this.objectStores[i]);
            }
        }
    }

    public void deserializeValue(DelegateInputStream s, Connection conn) throws IOException, ClassNotFoundException {
        this.connection = conn;
        int flags = 0xFF & s.readByte();
        if ((flags & 1) == 0) {
            this.search = s.getSearch();
        }
        if ((flags & 2) == 0) {
            this.mergeMode = s.getMergeMode();
        }
        if ((flags & 4) == 0) {
            this.pageSize = new Integer(s.readInt());
        }
        if ((flags & 8) == 0) {
            Boolean bl = this.continuable = s.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
        }
        if ((flags & 0x10) == 0) {
            if ((flags & 0x20) == 0) {
                int size = s.readInt();
                this.objectStores = new GlobalIdentity[size];
                for (int i = 0; i < size; ++i) {
                    this.objectStores[i] = (GlobalIdentity)s.getObjectReference();
                }
            } else {
                this.objectStores = new GlobalIdentity[0];
            }
        }
    }

    private void copyValue(SearchContext source) {
        this.search = source.search;
        this.mergeMode = source.mergeMode;
        this.pageSize = source.pageSize;
        this.continuable = source.continuable;
        this.objectStores = source.objectStores;
    }
}

