/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.query;

import com.filenet.api.collection.BinaryList;
import com.filenet.api.collection.BooleanList;
import com.filenet.api.collection.DateTimeList;
import com.filenet.api.collection.DependentObjectList;
import com.filenet.api.collection.Float64List;
import com.filenet.api.collection.IdList;
import com.filenet.api.collection.IndependentObjectSet;
import com.filenet.api.collection.Integer32List;
import com.filenet.api.collection.StringList;
import com.filenet.api.core.EngineObject;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.property.Property;
import com.filenet.api.util.Id;
import com.filenet.apiimpl.property.PropertiesImpl;
import com.filenet.apiimpl.property.PropertyBinaryImpl;
import com.filenet.apiimpl.property.PropertyBinaryListImpl;
import com.filenet.apiimpl.property.PropertyBooleanImpl;
import com.filenet.apiimpl.property.PropertyBooleanListImpl;
import com.filenet.apiimpl.property.PropertyContentImpl;
import com.filenet.apiimpl.property.PropertyDateTimeImpl;
import com.filenet.apiimpl.property.PropertyDateTimeListImpl;
import com.filenet.apiimpl.property.PropertyEngineObjectImpl;
import com.filenet.apiimpl.property.PropertyEngineObjectListImpl;
import com.filenet.apiimpl.property.PropertyEngineObjectSetImpl;
import com.filenet.apiimpl.property.PropertyFloat64Impl;
import com.filenet.apiimpl.property.PropertyFloat64ListImpl;
import com.filenet.apiimpl.property.PropertyIdImpl;
import com.filenet.apiimpl.property.PropertyIdListImpl;
import com.filenet.apiimpl.property.PropertyInteger32Impl;
import com.filenet.apiimpl.property.PropertyInteger32ListImpl;
import com.filenet.apiimpl.property.PropertyStringImpl;
import com.filenet.apiimpl.property.PropertyStringListImpl;
import com.filenet.apiimpl.util.CaseInsensitiveMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

public class RepositoryRowProperties
extends PropertiesImpl {
    private transient Id[] objectIds = null;
    static final long serialVersionUID = 2960677232047030591L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];

    public RepositoryRowProperties() {
        this.properties = new RepositoryMap();
    }

    private RepositoryMap getRepositoryMap() {
        return (RepositoryMap)this.properties;
    }

    public Iterator iterator() {
        return this.getRepositoryMap().values().iterator();
    }

    public void put(int index, Property item) {
        this.getRepositoryMap().put(index, item);
    }

    public void putValue(int index, String propertyName, String value, byte access) {
        this.put(index, new PropertyStringImpl(propertyName, value, access));
    }

    public void putValue(int index, String propertyName, Date value, byte access) {
        this.put(index, new PropertyDateTimeImpl(propertyName, value, access));
    }

    public void putValue(int index, String propertyName, Integer value, byte access) {
        this.put(index, new PropertyInteger32Impl(propertyName, value, access));
    }

    public void putValue(int index, String propertyName, int value, byte access) {
        this.putValue(index, propertyName, new Integer(value), access);
    }

    public void putValue(int index, String propertyName, Boolean value, byte access) {
        this.put(index, new PropertyBooleanImpl(propertyName, value, access));
    }

    public void putValue(int index, String propertyName, boolean value, byte access) {
        this.putValue(index, propertyName, (Boolean)value, access);
    }

    public void putValue(int index, String propertyName, Double value, byte access) {
        this.put(index, new PropertyFloat64Impl(propertyName, value, access));
    }

    public void putValue(int index, String propertyName, double value, byte access) {
        this.putValue(index, propertyName, new Double(value), access);
    }

    public void putValue(int index, String propertyName, byte[] value, byte access) {
        this.put(index, new PropertyBinaryImpl(propertyName, value, access));
    }

    public void putValue(int index, String propertyName, Id value, byte access) {
        this.put(index, new PropertyIdImpl(propertyName, value, access));
    }

    public void putValue(int index, String propertyName, EngineObject value, byte access) {
        this.put(index, new PropertyEngineObjectImpl(propertyName, value, access));
    }

    public void putValue(int index, String propertyName, IndependentObjectSet value, byte access) {
        this.put(new PropertyEngineObjectSetImpl(propertyName, value, access));
    }

    public void putValue(int index, String propertyName, DependentObjectList value, byte access) {
        this.put(new PropertyEngineObjectListImpl(propertyName, value, access));
    }

    public void putValue(int index, String propertyName, StringList value, byte access) {
        this.put(index, new PropertyStringListImpl(propertyName, value, access));
    }

    public void putValue(int index, String propertyName, BooleanList value, byte access) {
        this.put(index, new PropertyBooleanListImpl(propertyName, value, access));
    }

    public void putValue(int index, String propertyName, Integer32List value, byte access) {
        this.put(index, new PropertyInteger32ListImpl(propertyName, value, access));
    }

    public void putValue(int index, String propertyName, Float64List value, byte access) {
        this.put(index, new PropertyFloat64ListImpl(propertyName, value, access));
    }

    public void putValue(int index, String propertyName, DateTimeList value, byte access) {
        this.put(index, new PropertyDateTimeListImpl(propertyName, value, access));
    }

    public void putValue(int index, String propertyName, BinaryList value, byte access) {
        this.put(index, new PropertyBinaryListImpl(propertyName, value, access));
    }

    public void putValue(int index, String propertyName, IdList value, byte access) {
        this.put(index, new PropertyIdListImpl(propertyName, value, access));
    }

    public void putValue(int index, String propertyName, InputStream value, byte access) {
        this.put(index, new PropertyContentImpl(propertyName, value, access));
    }

    public boolean isPropertyPresent(String propertyName) {
        if (null == propertyName) {
            return false;
        }
        return this.properties.containsKey(propertyName.toLowerCase());
    }

    public boolean equals(Object object) {
        if (object instanceof RepositoryRowProperties) {
            RepositoryRowProperties cache = (RepositoryRowProperties)object;
            return cache.properties.equals(this.properties);
        }
        return false;
    }

    public int hashCode() {
        return this.properties.hashCode();
    }

    public Id[] getObjectIds() {
        return this.objectIds;
    }

    public void setObjectIds(Id[] objectIds) {
        this.objectIds = objectIds;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        int size = this.properties.size();
        s.writeInt(size);
        Iterator iter = ((RepositoryMap)this.properties).values().iterator();
        while (iter.hasNext()) {
            s.writeObject(iter.next());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.properties = new RepositoryMap();
        int size = s.readInt();
        for (int lp = 0; lp < size; ++lp) {
            this.put(lp, (Property)s.readObject());
        }
    }

    static class RepositoryMap
    extends CaseInsensitiveMap {
        private ArrayList propCache = new ArrayList();

        RepositoryMap() {
            super(7);
        }

        private int getIndex(Object propertyName) {
            if (propertyName == null) {
                return -1;
            }
            Integer index = (Integer)super.get(propertyName);
            if (index != null) {
                return index;
            }
            return -1;
        }

        public Property getByIndex(int index) {
            if (index < 0 || index > this.propCache.size() - 1) {
                throw new EngineRuntimeException(ExceptionCode.API_PROPERTY_NOT_IN_CACHE, new Integer(index));
            }
            Property ret = (Property)this.propCache.get(index);
            if (ret == null) {
                throw new EngineRuntimeException(ExceptionCode.API_PROPERTY_NOT_IN_CACHE, new Integer(index));
            }
            return ret;
        }

        public void put(int index, Property item) {
            this.propCache.add(index, item);
            String name = item.getPropertyName();
            if (!super.containsKey(name)) {
                super.put(name, new Integer(index));
            }
        }

        public void clear() {
            this.propCache.clear();
            super.clear();
        }

        public boolean equals(Object o) {
            if (!(o instanceof RepositoryMap)) {
                return false;
            }
            RepositoryMap other = (RepositoryMap)o;
            return this.propCache.equals(other.propCache);
        }

        public Object get(Object key) {
            int index = this.getIndex(key);
            if (index < 0 || index > this.propCache.size() - 1) {
                throw new EngineRuntimeException(ExceptionCode.API_PROPERTY_NOT_IN_CACHE, key);
            }
            return this.getByIndex(index);
        }

        public int hashCode() {
            return this.propCache.hashCode();
        }

        public boolean isEmpty() {
            return this.propCache.isEmpty();
        }

        public int size() {
            return this.propCache.size();
        }

        public Collection values() {
            return this.propCache;
        }
    }
}

