/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.property;

import com.filenet.api.collection.BinaryList;
import com.filenet.api.collection.BooleanList;
import com.filenet.api.collection.DateTimeList;
import com.filenet.api.collection.DependentObjectList;
import com.filenet.api.collection.EngineCollection;
import com.filenet.api.collection.Float64List;
import com.filenet.api.collection.IdList;
import com.filenet.api.collection.IndependentObjectSet;
import com.filenet.api.collection.Integer32List;
import com.filenet.api.collection.StringList;
import com.filenet.api.constants.PropertyState;
import com.filenet.api.core.Connection;
import com.filenet.api.core.EngineObject;
import com.filenet.api.core.ObjectReference;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.property.FilterElement;
import com.filenet.api.property.Property;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.util.Id;
import com.filenet.apiimpl.collection.Lists;
import com.filenet.apiimpl.constants.ListMode;
import com.filenet.apiimpl.core.ConnectionImpl;
import com.filenet.apiimpl.core.EngineObjectImpl;
import com.filenet.apiimpl.core.GlobalIdentity;
import com.filenet.apiimpl.core.ListImpl;
import com.filenet.apiimpl.core.ObjectReferenceBase;
import com.filenet.apiimpl.core.ObjectRetriever;
import com.filenet.apiimpl.core.RepositoryIdentity;
import com.filenet.apiimpl.core.Session;
import com.filenet.apiimpl.core.SetImpl;
import com.filenet.apiimpl.property.PropertiesImpl;
import com.filenet.apiimpl.property.PropertyBinaryImpl;
import com.filenet.apiimpl.property.PropertyBinaryListImpl;
import com.filenet.apiimpl.property.PropertyBooleanImpl;
import com.filenet.apiimpl.property.PropertyBooleanListImpl;
import com.filenet.apiimpl.property.PropertyContentImpl;
import com.filenet.apiimpl.property.PropertyDateTimeImpl;
import com.filenet.apiimpl.property.PropertyDateTimeListImpl;
import com.filenet.apiimpl.property.PropertyEngineObjectImpl;
import com.filenet.apiimpl.property.PropertyEngineObjectListImpl;
import com.filenet.apiimpl.property.PropertyFloat64Impl;
import com.filenet.apiimpl.property.PropertyFloat64ListImpl;
import com.filenet.apiimpl.property.PropertyIdImpl;
import com.filenet.apiimpl.property.PropertyIdListImpl;
import com.filenet.apiimpl.property.PropertyInteger32Impl;
import com.filenet.apiimpl.property.PropertyInteger32ListImpl;
import com.filenet.apiimpl.property.PropertyStringImpl;
import com.filenet.apiimpl.property.PropertyStringListImpl;
import com.filenet.apiimpl.property.PropertyUpdateList;
import com.filenet.apiimpl.property.UnevaluatedPropertyValue;
import com.filenet.apiimpl.util.BinaryInputStream;
import com.filenet.apiimpl.util.BinaryOutputStream;
import com.filenet.apiimpl.util.DelegateInputStream;
import com.filenet.apiimpl.util.DelegateOutputStream;
import com.filenet.apiimpl.util.SessionLocator;
import com.filenet.apiimpl.util.UtilityMap;
import com.filenet.apiimpl.util.XMLTraceReader;
import com.filenet.apiimpl.util.XMLTraceable;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.util.Date;
import java.util.List;

public abstract class PropertyImpl
extends UtilityMap.SelfKeyedMember
implements Property,
Cloneable,
XMLTraceable {
    protected boolean isDirty;
    protected byte access;
    protected Object value;
    protected String propertyName;
    protected Connection connection;
    private boolean readOnly = false;
    private static final long serialVersionUID = -8346445280909594938L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];
    public static final short IS_NULL = 16;
    public static final short IS_DIRTY = 32;
    public static final short IS_MULTI_VALUE = 64;
    public static final short IS_DEPENDENT = 128;
    public static final short IS_TYPE_BINARY = 1;
    public static final short IS_TYPE_BOOLEAN = 2;
    public static final short IS_TYPE_DATETIME = 3;
    public static final short IS_TYPE_FLOAT64 = 4;
    public static final short IS_TYPE_ID = 5;
    public static final short IS_TYPE_INTEGER32 = 6;
    public static final short IS_TYPE_ENGINEOBJECT = 7;
    public static final short IS_TYPE_STRING = 8;
    public static final short IS_TYPE_CONTENT = 9;
    public static final short IS_TYPE_UPDATE = 10;

    protected PropertyImpl(String pName, Object val, byte accessMask) {
        this.value = val;
        this.access = accessMask;
        this.propertyName = pName;
        this.isDirty = true;
    }

    protected PropertyImpl(PropertyImpl source) {
        this.access = source.access;
        this.connection = source.connection;
        this.isDirty = source.isDirty;
        this.propertyName = source.propertyName;
        this.value = source.value;
    }

    public Object clone() {
        try {
            PropertyImpl clone = (PropertyImpl)super.clone();
            if (this.value != null) {
                if (this.value instanceof EngineObjectImpl) {
                    clone.value = ((EngineObjectImpl)this.value).clone();
                } else if (this.value instanceof ListImpl) {
                    clone.value = ((ListImpl)this.value).clone();
                } else if (this.value instanceof ObjectReferenceBase) {
                    clone.value = ((ObjectReferenceBase)this.value).clone();
                }
            }
            return clone;
        }
        catch (Throwable t) {
            throw new EngineRuntimeException(t, ExceptionCode.E_OBJECT_CLONE_FAILED, null);
        }
    }

    public Object getMembershipKey() {
        return this.propertyName;
    }

    public void setObjectValue(Object val) {
        if (!(val == null || val instanceof String || val instanceof Date || val instanceof Integer || val instanceof Boolean || val instanceof Double || val instanceof byte[] || val instanceof Id || val instanceof EngineObject || val instanceof InputStream || val instanceof ListImpl || val instanceof ObjectReferenceBase)) {
            throw new EngineRuntimeException(ExceptionCode.API_UNSUPPORTED_PROPERTY_TYPE, val != null ? val.getClass().getName() : "null");
        }
        this.setValue(val);
    }

    protected void setValue(Object val) {
        this.checkSettable();
        this.value = val;
        this.isDirty = true;
    }

    protected void checkSettable() {
        PropertiesImpl.checkSettable(this);
    }

    protected List initListValue(List list, Class type) {
        if (list == null) {
            list = Lists.createList(type, null);
        }
        if (list instanceof ListImpl) {
            ListImpl internal = (ListImpl)list;
            if (internal.hasBeenAttached()) {
                internal = (ListImpl)internal.clone();
                list = internal;
                internal.setDirty(true);
            }
            internal.setHasBeenAttached(true);
            internal.setListMode(ListMode.REPLACE);
        }
        return list;
    }

    protected void constructListValue(List list, Class type) {
        this.value = this.initListValue(list, type);
    }

    protected void setListValue(List list, Class type) {
        this.setValue(this.initListValue(list, type));
    }

    PropertyImpl getModifiedData(EngineObject parent) {
        return this.isDirty() ? this : null;
    }

    public List getUpdateListValue() {
        if (this instanceof PropertyUpdateList) {
            return (List)this.value;
        }
        if (this.value instanceof ListImpl) {
            return ((ListImpl)this.value).getListUpdates();
        }
        return null;
    }

    public List getUpdateListValueWithImplicitMoves() {
        if (this.value instanceof ListImpl) {
            return ((ListImpl)this.value).getListUpdatesWithImplicitMoves();
        }
        if (this.value instanceof ListImpl.ListUpdates) {
            return (List)this.value;
        }
        return null;
    }

    public synchronized Object getObjectValue() {
        this.value = this.getObjectValue(this.value);
        return this.value;
    }

    protected Object getObjectValue(Object value) {
        ListImpl list;
        if (value instanceof ObjectReferenceBase) {
            value = this.fetchValue(value);
        } else if (value instanceof EngineRuntimeException) {
            throw (EngineRuntimeException)value;
        }
        if (value instanceof ListImpl && !PropertiesImpl.isSettable(this) && !(list = (ListImpl)value).isReadOnly()) {
            list.setReadOnly(true);
            this.propagatePropertyAccess();
        }
        return value;
    }

    protected Object fetchValue(Object value) {
        if (value instanceof ObjectRetriever) {
            PropertyImpl pi = this.fetchProperty((ObjectRetriever)value, this.getPropertyName());
            return pi.value;
        }
        if (value instanceof UnevaluatedPropertyValue) {
            PropertyImpl tProp;
            UnevaluatedPropertyValue up = (UnevaluatedPropertyValue)value;
            if (up.getParentReference() instanceof ObjectRetriever) {
                PropertyImpl pi = this.fetchProperty((ObjectRetriever)((Object)up.getParentReference()), up.getPropertyName());
                return pi.value;
            }
            PropertyFilter pf = null;
            if (this instanceof PropertyEngineObjectListImpl) {
                pf = new PropertyFilter();
                pf.setLevelDependents(true);
            }
            return (tProp = this.getSession().getProperty((ConnectionImpl)this.connection, up, null, pf, null)) != null ? tProp.value : null;
        }
        if (value instanceof ObjectReferenceBase) {
            return this.getSession().getObject((ConnectionImpl)this.connection, (ObjectReferenceBase)value, null, null);
        }
        throw new EngineRuntimeException(ExceptionCode.API_PROPERTY_FETCH_FAILED, this.getPropertyName());
    }

    public void resetPropertyAccess(byte accessMask) {
        this.access = accessMask;
    }

    public void setPropertyAccess(byte accessMask) {
        this.access = (byte)(this.access & accessMask);
    }

    public byte getPropertyAccess() {
        return this.access;
    }

    public void propagatePropertyAccess() {
    }

    private PropertyImpl fetchProperty(ObjectRetriever or, String pName) {
        EngineObject eo = or.getObject(this.connection, this.getFilter(pName));
        if (eo.getProperties().isPropertyPresent(this.getPropertyName())) {
            return (PropertyImpl)eo.getProperties().get(pName);
        }
        return null;
    }

    private PropertyFilter getFilter(String pName) {
        PropertyFilter filter = new PropertyFilter();
        filter.addIncludeProperty(new FilterElement(null, null, null, pName, null));
        filter.setMaxRecursion(1);
        return filter;
    }

    protected Session getSession() {
        return SessionLocator.getSession(this.connection);
    }

    public String getStringValue() {
        if (this.value == null) {
            return null;
        }
        if (!(this.value instanceof String) || !(this instanceof PropertyStringImpl)) {
            throw new EngineRuntimeException(ExceptionCode.API_INVALID_PROPERTY_TYPE, new Object[]{this.getClass().getName(), PropertyStringImpl.class.getName()});
        }
        return (String)this.value;
    }

    public Date getDateTimeValue() {
        if (this.value == null) {
            return null;
        }
        if (!(this.value instanceof Date) || !(this instanceof PropertyDateTimeImpl)) {
            throw new EngineRuntimeException(ExceptionCode.API_INVALID_PROPERTY_TYPE, new Object[]{this.getClass().getName(), PropertyDateTimeImpl.class.getName()});
        }
        return (Date)this.value;
    }

    public Integer getInteger32Value() {
        if (this.value == null) {
            return null;
        }
        if (!(this.value instanceof Integer) || !(this instanceof PropertyInteger32Impl)) {
            throw new EngineRuntimeException(ExceptionCode.API_INVALID_PROPERTY_TYPE, new Object[]{this.getClass().getName(), PropertyInteger32Impl.class.getName()});
        }
        return (Integer)this.value;
    }

    public Boolean getBooleanValue() {
        if (this.value == null) {
            return null;
        }
        if (!(this.value instanceof Boolean) || !(this instanceof PropertyBooleanImpl)) {
            throw new EngineRuntimeException(ExceptionCode.API_INVALID_PROPERTY_TYPE, new Object[]{this.getClass().getName(), PropertyBooleanImpl.class.getName()});
        }
        return (Boolean)this.value;
    }

    public Double getFloat64Value() {
        if (this.value == null) {
            return null;
        }
        if (!(this.value instanceof Double) || !(this instanceof PropertyFloat64Impl)) {
            throw new EngineRuntimeException(ExceptionCode.API_INVALID_PROPERTY_TYPE, new Object[]{this.getClass().getName(), PropertyFloat64Impl.class.getName()});
        }
        return (Double)this.value;
    }

    public byte[] getBinaryValue() {
        if (this.value == null) {
            return null;
        }
        if (!(this.value instanceof byte[]) || !(this instanceof PropertyBinaryImpl)) {
            throw new EngineRuntimeException(ExceptionCode.API_INVALID_PROPERTY_TYPE, new Object[]{this.getClass().getName(), PropertyBinaryImpl.class.getName()});
        }
        return (byte[])this.value;
    }

    public Id getIdValue() {
        if (this.value == null) {
            return null;
        }
        if (this.value instanceof Id) {
            return (Id)this.value;
        }
        if (this.value instanceof RepositoryIdentity) {
            return ((RepositoryIdentity)this.value).getObjectId();
        }
        if (this.value instanceof GlobalIdentity) {
            return ((GlobalIdentity)this.value).getObjectId();
        }
        if (this.value instanceof EngineObjectImpl) {
            return ((EngineObjectImpl)this.value).getObjectId();
        }
        throw new EngineRuntimeException(ExceptionCode.API_INVALID_PROPERTY_TYPE, new Object[]{this.getClass().getName(), PropertyIdImpl.class.getName()});
    }

    public EngineObject getEngineObjectValue() {
        Object value = this.getObjectValue();
        if (value == null) {
            return null;
        }
        if (!(value instanceof EngineObject) || !(this instanceof PropertyEngineObjectImpl)) {
            throw new EngineRuntimeException(ExceptionCode.API_INVALID_PROPERTY_TYPE, new Object[]{this.getClass().getName(), PropertyEngineObjectImpl.class.getName()});
        }
        return (EngineObject)value;
    }

    public DependentObjectList getDependentObjectListValue() {
        Object value = this.getObjectValue();
        if (value == null) {
            return null;
        }
        if (!(value instanceof DependentObjectList)) {
            throw new EngineRuntimeException(ExceptionCode.API_INVALID_PROPERTY_TYPE, new Object[]{this.getClass().getName(), DependentObjectList.class.getName()});
        }
        return (DependentObjectList)value;
    }

    public IndependentObjectSet getIndependentObjectSetValue() {
        Object value = this.getObjectValue();
        if (value == null) {
            return null;
        }
        if (!(value instanceof IndependentObjectSet)) {
            throw new EngineRuntimeException(ExceptionCode.API_INVALID_PROPERTY_TYPE, new Object[]{this.getClass().getName(), IndependentObjectSet.class.getName()});
        }
        return (IndependentObjectSet)value;
    }

    public StringList getStringListValue() {
        if (this.getObjectValue(this.value) == null) {
            return null;
        }
        if (!(this.value instanceof StringList) || !(this instanceof PropertyStringListImpl)) {
            throw new EngineRuntimeException(ExceptionCode.API_INVALID_PROPERTY_TYPE, new Object[]{this.getClass().getName(), PropertyStringListImpl.class.getName()});
        }
        return (StringList)this.value;
    }

    public BooleanList getBooleanListValue() {
        if (this.getObjectValue(this.value) == null) {
            return null;
        }
        if (!(this.value instanceof BooleanList) || !(this instanceof PropertyBooleanListImpl)) {
            throw new EngineRuntimeException(ExceptionCode.API_INVALID_PROPERTY_TYPE, new Object[]{this.getClass().getName(), PropertyBooleanListImpl.class.getName()});
        }
        return (BooleanList)this.value;
    }

    public Integer32List getInteger32ListValue() {
        if (this.getObjectValue(this.value) == null) {
            return null;
        }
        if (!(this.value instanceof Integer32List) || !(this instanceof PropertyInteger32ListImpl)) {
            throw new EngineRuntimeException(ExceptionCode.API_INVALID_PROPERTY_TYPE, new Object[]{this.getClass().getName(), PropertyInteger32ListImpl.class.getName()});
        }
        return (Integer32List)this.value;
    }

    public Float64List getFloat64ListValue() {
        if (this.getObjectValue(this.value) == null) {
            return null;
        }
        if (!(this.value instanceof Float64List) || !(this instanceof PropertyFloat64ListImpl)) {
            throw new EngineRuntimeException(ExceptionCode.API_INVALID_PROPERTY_TYPE, new Object[]{this.getClass().getName(), PropertyFloat64ListImpl.class.getName()});
        }
        return (Float64List)this.value;
    }

    public DateTimeList getDateTimeListValue() {
        if (this.getObjectValue(this.value) == null) {
            return null;
        }
        if (!(this.value instanceof DateTimeList) || !(this instanceof PropertyDateTimeListImpl)) {
            throw new EngineRuntimeException(ExceptionCode.API_INVALID_PROPERTY_TYPE, new Object[]{this.getClass().getName(), PropertyDateTimeListImpl.class.getName()});
        }
        return (DateTimeList)this.value;
    }

    public BinaryList getBinaryListValue() {
        if (this.getObjectValue(this.value) == null) {
            return null;
        }
        if (!(this.value instanceof BinaryList) || !(this instanceof PropertyBinaryListImpl)) {
            throw new EngineRuntimeException(ExceptionCode.API_INVALID_PROPERTY_TYPE, new Object[]{this.getClass().getName(), PropertyBinaryListImpl.class.getName()});
        }
        return (BinaryList)this.value;
    }

    public IdList getIdListValue() {
        if (this.getObjectValue(this.value) == null) {
            return null;
        }
        if (!(this.value instanceof IdList) || !(this instanceof PropertyIdListImpl)) {
            throw new EngineRuntimeException(ExceptionCode.API_INVALID_PROPERTY_TYPE, new Object[]{this.getClass().getName(), PropertyIdListImpl.class.getName()});
        }
        return (IdList)this.value;
    }

    public InputStream getInputStreamValue() {
        if (this.value == null) {
            return null;
        }
        if (this instanceof PropertyContentImpl && this.value instanceof byte[]) {
            this.value = new ByteArrayInputStream((byte[])this.value);
        }
        if (!(this.value instanceof InputStream) || !(this instanceof PropertyContentImpl)) {
            throw new EngineRuntimeException(ExceptionCode.API_INVALID_PROPERTY_TYPE, new Object[]{this.getClass().getName(), PropertyContentImpl.class.getName()});
        }
        return (InputStream)this.value;
    }

    public EngineRuntimeException getRetrievalErrorValue() {
        if (this.value instanceof EngineRuntimeException) {
            return (EngineRuntimeException)this.value;
        }
        return null;
    }

    public ObjectReference getObjectReference() {
        if (this.value instanceof ObjectReference) {
            return (ObjectReference)this.value;
        }
        if (this.value instanceof EngineObjectImpl) {
            return ((EngineObjectImpl)this.value).getObjectReference();
        }
        if (this.value == null) {
            return null;
        }
        throw new EngineRuntimeException(ExceptionCode.API_INVALID_PROPERTY_TYPE, new Object[]{this.value.getClass().getName(), this.getClass().getName()});
    }

    public int hashCode() {
        return this.propertyName.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof PropertyImpl)) {
            return false;
        }
        PropertyImpl v = (PropertyImpl)object;
        if (this.propertyName == null && v.propertyName != null) {
            return false;
        }
        if (this.propertyName != null && v.propertyName == null) {
            return false;
        }
        if (!this.propertyName.equalsIgnoreCase(v.propertyName)) {
            return false;
        }
        if (v.value == this.value) {
            return true;
        }
        if (this.value == null && v.value != null) {
            return false;
        }
        if (this.value != null && v.value == null) {
            return false;
        }
        return this.value.equals(v.value);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propName) {
        this.propertyName = propName;
    }

    public boolean isSettable() {
        if (this.value instanceof SetImpl) {
            return false;
        }
        return this.access != 1;
    }

    public boolean isDirty() {
        if (this.value instanceof ListImpl) {
            return this.isDirty ? this.isDirty : ((ListImpl)this.value).isDirty();
        }
        return this.isDirty;
    }

    public void setDirty(boolean val) {
        if (this.value instanceof ListImpl) {
            ((ListImpl)this.value).setDirty(val);
        }
        this.isDirty = val;
    }

    public PropertyState getState() {
        if (this.value == null) {
            return PropertyState.NO_VALUE;
        }
        if (this.value instanceof ListImpl.ListUpdates) {
            return PropertyState.VALUE;
        }
        if (this.value instanceof EngineCollection && ((EngineCollection)this.value).isEmpty()) {
            return PropertyState.NO_VALUE;
        }
        if (this.value instanceof UnevaluatedPropertyValue) {
            return PropertyState.UNEVALUATED;
        }
        if (this.value instanceof ObjectReference) {
            return PropertyState.REFERENCE;
        }
        if (this.value instanceof EngineRuntimeException) {
            return PropertyState.RETRIEVAL_ERROR;
        }
        return PropertyState.VALUE;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(128);
        sb.append(" Class=");
        sb.append(this.getClass().getName());
        sb.append(" PropertyName=");
        sb.append(this.propertyName);
        sb.append(" Value=");
        sb.append(this.value);
        sb.append(" IsDirty=");
        sb.append(this.isDirty);
        sb.append(" Access=");
        sb.append(this.access);
        sb.append(" State=(");
        sb.append(this.getState());
        sb.append(") Connection=(");
        sb.append(this.connection);
        sb.append(")");
        return sb.toString();
    }

    public Object getInstanceValue() {
        return this.value;
    }

    public void setInstanceValue(Object v) {
        this.value = v;
    }

    public Connection getConnection() {
        return this.connection;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeShort(5);
        s.writeObject(this.connection);
        DelegateOutputStream tos = null;
        tos = s instanceof DelegateOutputStream ? (DelegateOutputStream)s : BinaryOutputStream.getInstance((short)5, s);
        tos.putProperty(this);
        tos.flush();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        short version = s.readShort();
        this.connection = (Connection)s.readObject();
        DelegateInputStream tis = null;
        tis = s instanceof DelegateInputStream ? (DelegateInputStream)s : BinaryInputStream.getInstance(version, s, this.connection);
        PropertyImpl n = tis.getProperty();
        this.isDirty = n.isDirty;
        this.access = n.access;
        this.value = n.value;
        this.propertyName = n.propertyName;
    }

    public int getSerializeMask() {
        return (this.getPropertyAccess() | (this.isDirty() ? 32 : 0) | (this.value == null ? 16 : 0)) << 16;
    }

    public abstract void serializeValue(DelegateOutputStream var1) throws IOException;

    public abstract void deserializeValue(DelegateInputStream var1, Connection var2) throws IOException, ClassNotFoundException;

    public void trace(XMLTraceReader reader, String element) throws Exception {
        reader.addAttribute("name", this.propertyName);
        reader.addAttribute("dirty", String.valueOf(this.isDirty));
        reader.addAttribute("access", String.valueOf(this.access));
        reader.startElement(element, this);
        if (this.value == null) {
            reader.addAttribute("null", "true");
            reader.startElement("value");
            reader.endElement("value");
        } else {
            reader.visitObject("value", this.value);
        }
        reader.endElement(element);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }
}

