/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.property;

import com.filenet.api.collection.BinaryList;
import com.filenet.api.collection.BooleanList;
import com.filenet.api.collection.DateTimeList;
import com.filenet.api.collection.DependentObjectList;
import com.filenet.api.collection.Float64List;
import com.filenet.api.collection.IdList;
import com.filenet.api.collection.IndependentObjectSet;
import com.filenet.api.collection.Integer32List;
import com.filenet.api.collection.StringList;
import com.filenet.api.core.Connection;
import com.filenet.api.core.EngineObject;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.property.Properties;
import com.filenet.api.property.Property;
import com.filenet.api.util.Id;
import com.filenet.apiimpl.constants.ListMode;
import com.filenet.apiimpl.core.ListImpl;
import com.filenet.apiimpl.core.ObjectReferenceBase;
import com.filenet.apiimpl.core.SetImpl;
import com.filenet.apiimpl.exception.ExceptionContext;
import com.filenet.apiimpl.property.PropertyBinaryImpl;
import com.filenet.apiimpl.property.PropertyBinaryListImpl;
import com.filenet.apiimpl.property.PropertyBooleanImpl;
import com.filenet.apiimpl.property.PropertyBooleanListImpl;
import com.filenet.apiimpl.property.PropertyContentImpl;
import com.filenet.apiimpl.property.PropertyDateTimeImpl;
import com.filenet.apiimpl.property.PropertyDateTimeListImpl;
import com.filenet.apiimpl.property.PropertyEngineObjectImpl;
import com.filenet.apiimpl.property.PropertyEngineObjectListImpl;
import com.filenet.apiimpl.property.PropertyEngineObjectSetImpl;
import com.filenet.apiimpl.property.PropertyFloat64Impl;
import com.filenet.apiimpl.property.PropertyFloat64ListImpl;
import com.filenet.apiimpl.property.PropertyIdImpl;
import com.filenet.apiimpl.property.PropertyIdListImpl;
import com.filenet.apiimpl.property.PropertyImpl;
import com.filenet.apiimpl.property.PropertyInteger32Impl;
import com.filenet.apiimpl.property.PropertyInteger32ListImpl;
import com.filenet.apiimpl.property.PropertyStringImpl;
import com.filenet.apiimpl.property.PropertyStringListImpl;
import com.filenet.apiimpl.util.CaseInsensitiveMap;
import com.filenet.apiimpl.util.SessionLocator;
import com.filenet.apiimpl.util.UtilityMap;
import com.filenet.apiimpl.util.XMLTraceReader;
import com.filenet.apiimpl.util.XMLTraceable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;

public class PropertiesImpl
implements Properties,
Serializable,
Cloneable,
XMLTraceable {
    protected UtilityMap properties = new CaseInsensitiveMap(32);
    private boolean readOnly;
    static final long serialVersionUID = -508657879226329699L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];

    public Object clone() {
        try {
            PropertiesImpl clone = (PropertiesImpl)super.clone();
            clone.properties = new CaseInsensitiveMap(32);
            Iterator iter = this.properties.getEntries();
            while (iter.hasNext()) {
                PropertyImpl prop = (PropertyImpl)iter.next();
                clone.properties.putMember((PropertyImpl)prop.clone());
            }
            return clone;
        }
        catch (Throwable t) {
            throw new EngineRuntimeException(t, ExceptionCode.E_OBJECT_CLONE_FAILED, null);
        }
    }

    public void clear() {
        this.properties.clear();
    }

    public void put(Property item) {
        this.properties.putMember((PropertyImpl)item);
    }

    public Iterator iterator() {
        return this.properties.getEntries();
    }

    public int size() {
        return this.properties.size();
    }

    public Property get(String propertyName) {
        Property ret = (Property)this.properties.get(propertyName);
        if (ret == null) {
            throw new EngineRuntimeException(ExceptionCode.API_PROPERTY_NOT_IN_CACHE, propertyName);
        }
        return ret;
    }

    public Property find(String propertyName) {
        return (Property)this.properties.get(propertyName);
    }

    public boolean isPropertyPresent(String propertyName) {
        return this.properties.containsKey(propertyName);
    }

    public void removeFromCache(String propertyName) {
        if (this.readOnly || propertyName == null) {
            return;
        }
        this.properties.remove(propertyName);
    }

    public void removeFromCache(String[] propertyNames) {
        if (propertyNames == null || propertyNames.length < 1) {
            return;
        }
        for (int lp = 0; lp < propertyNames.length; ++lp) {
            this.removeFromCache(propertyNames[lp]);
        }
    }

    public PropertiesImpl getInternalModifiedData(EngineObject parent) {
        PropertiesImpl props = new PropertiesImpl();
        Iterator iter = this.properties.getEntries();
        while (iter.hasNext()) {
            Property prop = (Property)iter.next();
            if (!prop.isDirty()) continue;
            if (prop instanceof PropertyEngineObjectListImpl) {
                props.put(((PropertyEngineObjectListImpl)prop).getModifiedData(parent));
                continue;
            }
            props.put(prop);
        }
        return props;
    }

    public PropertiesImpl getModifiedData(EngineObject parent) {
        PropertiesImpl props = new PropertiesImpl();
        Iterator iter = this.properties.getEntries();
        while (iter.hasNext()) {
            Property prop = (Property)iter.next();
            if (!prop.isDirty()) continue;
            if (prop instanceof PropertyImpl) {
                props.put(((PropertyImpl)prop).getModifiedData(parent));
                continue;
            }
            props.put(prop);
        }
        return props;
    }

    public PropertyImpl getModifiedData(EngineObject parent, String propertyName) {
        if (!this.isPropertyPresent(propertyName)) {
            return null;
        }
        Property prop = this.get(propertyName);
        if (prop.isDirty() && prop instanceof PropertyImpl) {
            return ((PropertyImpl)prop).getModifiedData(parent);
        }
        return null;
    }

    public boolean isDirty() {
        Iterator iter = this.properties.getEntries();
        while (iter.hasNext()) {
            Property prop = (Property)iter.next();
            if (!prop.isDirty()) continue;
            return true;
        }
        return false;
    }

    public void setDirty(boolean val) {
        Iterator iter = this.properties.getEntries();
        while (iter.hasNext()) {
            Property prop = (Property)iter.next();
            if (!(prop instanceof PropertyImpl)) continue;
            ((PropertyImpl)prop).setDirty(val);
        }
    }

    public Property[] toArray() {
        Property[] props = new PropertyImpl[this.properties.size()];
        int i = 0;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            PropertyImpl prop = (PropertyImpl)iter.next();
            props[i++] = prop;
        }
        return props;
    }

    public void putEngineObjectReference(String propertyName, ObjectReferenceBase obj, Connection connection, byte access) {
        PropertyEngineObjectImpl ret = new PropertyEngineObjectImpl(propertyName, obj, connection, access);
        this.put(ret);
    }

    public void putObjectValue(String propertyName, Object value) {
        this.checkSettable(propertyName);
        this.putObjectValue(propertyName, value, (byte)7);
    }

    public void putValue(String propertyName, String value) {
        this.checkSettable(propertyName);
        this.putValue(propertyName, value, (byte)7);
    }

    public void putValue(String propertyName, Date value) {
        this.checkSettable(propertyName);
        this.putValue(propertyName, value, (byte)7);
    }

    public void putValue(String propertyName, Integer value) {
        this.checkSettable(propertyName);
        this.putValue(propertyName, value, (byte)7);
    }

    public void putValue(String propertyName, int value) {
        this.checkSettable(propertyName);
        this.putValue(propertyName, value, (byte)7);
    }

    public void putValue(String propertyName, Boolean value) {
        this.checkSettable(propertyName);
        this.putValue(propertyName, value, (byte)7);
    }

    public void putValue(String propertyName, boolean value) {
        this.checkSettable(propertyName);
        this.putValue(propertyName, value, (byte)7);
    }

    public void putValue(String propertyName, Double value) {
        this.checkSettable(propertyName);
        this.putValue(propertyName, value, (byte)7);
    }

    public void putValue(String propertyName, double value) {
        this.checkSettable(propertyName);
        this.putValue(propertyName, value, (byte)7);
    }

    public void putValue(String propertyName, byte[] value) {
        this.checkSettable(propertyName);
        this.putValue(propertyName, value, (byte)7);
    }

    public void putValue(String propertyName, Id value) {
        this.checkSettable(propertyName);
        this.putValue(propertyName, value, (byte)7);
    }

    public void putValue(String propertyName, EngineObject value) {
        this.checkSettable(propertyName);
        this.putValue(propertyName, value, (byte)7);
    }

    public void putValue(String propertyName, ObjectReferenceBase value, Connection conn) {
        this.putValue(propertyName, value, conn, (byte)7);
    }

    public void putValue(String propertyName, DependentObjectList value) {
        this.checkSettable(propertyName);
        this.putValue(propertyName, value, (byte)7, ListMode.REPLACE);
    }

    public void putValue(String propertyName, IndependentObjectSet value) {
        this.checkSettable(propertyName);
        this.putValue(propertyName, value, (byte)7, ListMode.REPLACE);
    }

    public void putValue(String propertyName, StringList value) {
        this.checkSettable(propertyName);
        this.putValue(propertyName, value, (byte)7);
    }

    public void putValue(String propertyName, BooleanList value) {
        this.checkSettable(propertyName);
        this.putValue(propertyName, value, (byte)7);
    }

    public void putValue(String propertyName, Integer32List value) {
        this.checkSettable(propertyName);
        this.putValue(propertyName, value, (byte)7);
    }

    public void putValue(String propertyName, Float64List value) {
        this.checkSettable(propertyName);
        this.putValue(propertyName, value, (byte)7);
    }

    public void putValue(String propertyName, DateTimeList value) {
        this.checkSettable(propertyName);
        this.putValue(propertyName, value, (byte)7);
    }

    public void putValue(String propertyName, BinaryList value) {
        this.checkSettable(propertyName);
        this.putValue(propertyName, value, (byte)7);
    }

    public void putValue(String propertyName, IdList value) {
        this.checkSettable(propertyName);
        this.putValue(propertyName, value, (byte)7);
    }

    public void putValue(String propertyName, InputStream value) {
        this.checkSettable(propertyName);
        this.putValue(propertyName, value, (byte)7);
    }

    private void checkSettable(String propertyName) {
        this.checkReadOnly();
        PropertiesImpl.checkSettable((Property)this.properties.get(propertyName));
    }

    private void checkReadOnly() {
        if (this.readOnly) {
            throw new EngineRuntimeException(ExceptionCode.E_READ_ONLY, null, ExceptionContext.PERSIST_PROPERTY_IS_READ_ONLY, null);
        }
    }

    static boolean isSettable(Property property) {
        if (SessionLocator.isExecutingInServer()) {
            return true;
        }
        return property == null || property.isSettable() && !((PropertyImpl)property).isReadOnly();
    }

    static void checkSettable(Property property) {
        if (!PropertiesImpl.isSettable(property)) {
            throw new EngineRuntimeException(ExceptionCode.E_READ_ONLY, null, ExceptionContext.PERSIST_PROPERTY_IS_READ_ONLY, new Object[]{property.getPropertyName()});
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void putObjectValue(String propertyName, Object value, byte access) {
        if (value instanceof String) {
            this.putValue(propertyName, (String)value, access);
            return;
        } else if (value instanceof Date) {
            this.putValue(propertyName, (Date)value, access);
            return;
        } else if (value instanceof Integer || value == null) {
            this.putValue(propertyName, (Integer)value, access);
            return;
        } else if (value instanceof Boolean) {
            this.putValue(propertyName, (Boolean)value, access);
            return;
        } else if (value instanceof Double) {
            this.putValue(propertyName, (Double)value, access);
            return;
        } else if (value instanceof byte[]) {
            this.putValue(propertyName, (byte[])value, access);
            return;
        } else if (value instanceof Id) {
            this.putValue(propertyName, (Id)value, access);
            return;
        } else if (value instanceof EngineObject) {
            this.putValue(propertyName, (EngineObject)value, access);
            return;
        } else if (value instanceof InputStream) {
            this.putValue(propertyName, (InputStream)value, access);
            return;
        } else if (value instanceof ObjectReferenceBase) {
            this.putValue(propertyName, (ObjectReferenceBase)value, null, access);
            return;
        } else if (value instanceof SetImpl) {
            this.putValue(propertyName, (IndependentObjectSet)value, access, ListMode.REPLACE);
            return;
        } else {
            if (!(value instanceof ListImpl)) throw new EngineRuntimeException(ExceptionCode.API_UNSUPPORTED_PROPERTY_TYPE, value != null ? value.getClass().getName() : "null");
            ListImpl li = (ListImpl)value;
            Class c = li.getContainedType();
            if (String.class.isAssignableFrom(c)) {
                this.putValue(propertyName, (StringList)value, access);
                return;
            } else if (Boolean.class.isAssignableFrom(c)) {
                this.putValue(propertyName, (BooleanList)value, access);
                return;
            } else if (Integer.class.isAssignableFrom(c)) {
                this.putValue(propertyName, (Integer32List)value, access);
                return;
            } else if (Double.class.isAssignableFrom(c)) {
                this.putValue(propertyName, (Float64List)value, access);
                return;
            } else if (Date.class.isAssignableFrom(c)) {
                this.putValue(propertyName, (DateTimeList)value, access);
                return;
            } else if (byte[].class.isAssignableFrom(c)) {
                this.putValue(propertyName, (BinaryList)value, access);
                return;
            } else if (Id.class.isAssignableFrom(c)) {
                this.putValue(propertyName, (IdList)value, access);
                return;
            } else {
                if (!EngineObject.class.isAssignableFrom(c)) throw new EngineRuntimeException(ExceptionCode.API_UNSUPPORTED_PROPERTY_TYPE, value != null ? value.getClass().getName() : "null");
                this.putValue(propertyName, (DependentObjectList)value, access, ListMode.REPLACE);
            }
        }
    }

    public void putValue(String propertyName, String value, byte access) {
        this.put(new PropertyStringImpl(propertyName, value, access));
    }

    public void putValue(String propertyName, Date value, byte access) {
        this.put(new PropertyDateTimeImpl(propertyName, value, access));
    }

    public void putValue(String propertyName, Integer value, byte access) {
        this.put(new PropertyInteger32Impl(propertyName, value, access));
    }

    public void putValue(String propertyName, int value, byte access) {
        this.putValue(propertyName, new Integer(value), access);
    }

    public void putValue(String propertyName, Boolean value, byte access) {
        this.put(new PropertyBooleanImpl(propertyName, value, access));
    }

    public void putValue(String propertyName, boolean value, byte access) {
        this.putValue(propertyName, value ? Boolean.TRUE : Boolean.FALSE, access);
    }

    public void putValue(String propertyName, Double value, byte access) {
        this.put(new PropertyFloat64Impl(propertyName, value, access));
    }

    public void putValue(String propertyName, double value, byte access) {
        this.putValue(propertyName, new Double(value), access);
    }

    public void putValue(String propertyName, byte[] value, byte access) {
        this.put(new PropertyBinaryImpl(propertyName, value, access));
    }

    public void putValue(String propertyName, Id value, byte access) {
        this.put(new PropertyIdImpl(propertyName, value, access));
    }

    public void putValue(String propertyName, EngineObject value, byte access) {
        this.put(new PropertyEngineObjectImpl(propertyName, value, access));
    }

    public void putValue(String propertyName, ObjectReferenceBase value, Connection conn, byte access) {
        this.put(new PropertyEngineObjectImpl(propertyName, value, conn, access));
    }

    public void putValue(String propertyName, DependentObjectList value, byte access, ListMode lm) {
        if (value != null && this.getInstanceValue(propertyName) == value) {
            return;
        }
        PropertyEngineObjectListImpl nv = new PropertyEngineObjectListImpl(propertyName, (DependentObjectList)null, access);
        nv.setValueInternal(value, lm);
        this.put(nv);
    }

    public void putValue(String propertyName, IndependentObjectSet value, byte access, ListMode lm) {
        if (value != null && this.getInstanceValue(propertyName) == value) {
            return;
        }
        this.put(new PropertyEngineObjectSetImpl(propertyName, value, access));
    }

    public void putValue(String propertyName, StringList value, byte access) {
        if (value != null && this.getInstanceValue(propertyName) == value) {
            return;
        }
        this.put(new PropertyStringListImpl(propertyName, value, access));
    }

    public void putValue(String propertyName, BooleanList value, byte access) {
        if (value != null && this.getInstanceValue(propertyName) == value) {
            return;
        }
        this.put(new PropertyBooleanListImpl(propertyName, value, access));
    }

    public void putValue(String propertyName, Integer32List value, byte access) {
        if (value != null && this.getInstanceValue(propertyName) == value) {
            return;
        }
        this.put(new PropertyInteger32ListImpl(propertyName, value, access));
    }

    public void putValue(String propertyName, Float64List value, byte access) {
        if (value != null && this.getInstanceValue(propertyName) == value) {
            return;
        }
        this.put(new PropertyFloat64ListImpl(propertyName, value, access));
    }

    public void putValue(String propertyName, DateTimeList value, byte access) {
        if (value != null && this.getInstanceValue(propertyName) == value) {
            return;
        }
        this.put(new PropertyDateTimeListImpl(propertyName, value, access));
    }

    public void putValue(String propertyName, BinaryList value, byte access) {
        if (value != null && this.getInstanceValue(propertyName) == value) {
            return;
        }
        this.put(new PropertyBinaryListImpl(propertyName, value, access));
    }

    public void putValue(String propertyName, IdList value, byte access) {
        if (value != null && this.getInstanceValue(propertyName) == value) {
            return;
        }
        this.put(new PropertyIdListImpl(propertyName, value, access));
    }

    public void putValue(String propertyName, InputStream value, byte access) {
        this.put(new PropertyContentImpl(propertyName, value, access));
    }

    public Object getObjectValue(String propertyName) {
        return this.get(propertyName).getObjectValue();
    }

    public String getStringValue(String propertyName) {
        return this.get(propertyName).getStringValue();
    }

    public Date getDateTimeValue(String propertyName) {
        return this.get(propertyName).getDateTimeValue();
    }

    public Integer getInteger32Value(String propertyName) {
        return this.get(propertyName).getInteger32Value();
    }

    public Boolean getBooleanValue(String propertyName) {
        return this.get(propertyName).getBooleanValue();
    }

    public Double getFloat64Value(String propertyName) {
        return this.get(propertyName).getFloat64Value();
    }

    public byte[] getBinaryValue(String propertyName) {
        return this.get(propertyName).getBinaryValue();
    }

    public Id getIdValue(String propertyName) {
        return this.get(propertyName).getIdValue();
    }

    public EngineObject getEngineObjectValue(String propertyName) {
        return this.get(propertyName).getEngineObjectValue();
    }

    public DependentObjectList getDependentObjectListValue(String propertyName) {
        return this.get(propertyName).getDependentObjectListValue();
    }

    public IndependentObjectSet getIndependentObjectSetValue(String propertyName) {
        return this.get(propertyName).getIndependentObjectSetValue();
    }

    public StringList getStringListValue(String propertyName) {
        return this.get(propertyName).getStringListValue();
    }

    public BooleanList getBooleanListValue(String propertyName) {
        return this.get(propertyName).getBooleanListValue();
    }

    public Integer32List getInteger32ListValue(String propertyName) {
        return this.get(propertyName).getInteger32ListValue();
    }

    public Float64List getFloat64ListValue(String propertyName) {
        return this.get(propertyName).getFloat64ListValue();
    }

    public DateTimeList getDateTimeListValue(String propertyName) {
        return this.get(propertyName).getDateTimeListValue();
    }

    public BinaryList getBinaryListValue(String propertyName) {
        return this.get(propertyName).getBinaryListValue();
    }

    public IdList getIdListValue(String propertyName) {
        return this.get(propertyName).getIdListValue();
    }

    public InputStream getInputStreamValue(String propertyName) {
        return this.get(propertyName).getInputStreamValue();
    }

    public Object getInstanceValue(String propertyName) {
        if (this.isPropertyPresent(propertyName)) {
            return ((PropertyImpl)this.get(propertyName)).getInstanceValue();
        }
        return null;
    }

    public int hashCode() {
        return this.properties.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof PropertiesImpl) {
            PropertiesImpl cache = (PropertiesImpl)object;
            return cache.properties.equals(this.properties);
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(256);
        sb.append(" Class=");
        sb.append(this.getClass().getName());
        sb.append(" Properties=(");
        sb.append(this.properties);
        sb.append(")");
        return sb.toString();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        if (this.getClass().equals(PropertiesImpl.class)) {
            s.writeShort(5);
            int size = this.properties.size();
            s.writeInt(size);
            Iterator iter = this.properties.getEntries();
            while (iter.hasNext()) {
                s.writeObject(iter.next());
            }
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        if (this.getClass().equals(PropertiesImpl.class)) {
            short version = s.readShort();
            int size = s.readInt();
            this.properties = new CaseInsensitiveMap(size);
            for (int lp = 0; lp < size; ++lp) {
                PropertyImpl prop = (PropertyImpl)s.readObject();
                this.properties.putMember(prop);
            }
        }
    }

    public void trace(XMLTraceReader reader, String element) throws Exception {
        reader.startElement(element, this);
        if (this.properties != null) {
            Iterator i = this.properties.getEntries();
            while (i.hasNext()) {
                reader.visitObject("property", i.next());
            }
        }
        reader.endElement(element);
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        Iterator propIter = this.properties.getEntries();
        while (propIter.hasNext()) {
            Property property = (Property)propIter.next();
            if (!(property instanceof PropertyImpl)) continue;
            ((PropertyImpl)property).setReadOnly(true);
        }
    }
}

