/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.property;

import com.filenet.api.core.Connection;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.util.UserContext;
import com.filenet.apiimpl.core.ConnectionImpl;
import com.filenet.apiimpl.core.ObjectReferenceBase;
import com.filenet.apiimpl.core.Session;
import com.filenet.apiimpl.util.DelegateInputStream;
import com.filenet.apiimpl.util.DelegateOutputStream;
import com.filenet.apiimpl.util.J2EEUtil;
import com.filenet.apiimpl.util.SessionLocator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.security.auth.Subject;

public class ClientInputStream
extends InputStream {
    private ConnectionImpl connection;
    private ObjectReferenceBase source;
    private Integer elementSequenceNumber;
    private String continueFrom;
    private byte[] content;
    private InputStream contentAsStream;
    private Long totalSize;
    private long totalOffset = 0L;
    private int curPos = 0;
    private transient boolean isClosed = false;
    private transient boolean inUse = false;
    private transient Session session = null;
    private Subject originalSubject;

    public ClientInputStream() {
        this.initOriginalSubject();
    }

    public ClientInputStream(ConnectionImpl connection, ObjectReferenceBase source, Integer elementSequenceNumber, String continueFrom, byte[] content, Long totalSize) {
        this.connection = connection;
        this.source = source;
        this.elementSequenceNumber = elementSequenceNumber;
        this.continueFrom = continueFrom;
        this.content = content;
        this.totalSize = totalSize != null && totalSize < 0L ? null : totalSize;
        this.initOriginalSubject();
    }

    public ClientInputStream(ConnectionImpl connection, ObjectReferenceBase source, Integer elementSequenceNumber, String continueFrom, InputStream content, Long totalSize) {
        this.connection = connection;
        this.source = source;
        this.elementSequenceNumber = elementSequenceNumber;
        this.continueFrom = continueFrom;
        this.contentAsStream = content;
        this.totalSize = totalSize != null && totalSize < 0L ? null : totalSize;
        this.initOriginalSubject();
    }

    public Subject getOriginalSubject() {
        return this.originalSubject;
    }

    public void setOriginalSubject(Subject subject) {
        this.originalSubject = subject;
    }

    private void initOriginalSubject() {
        this.originalSubject = UserContext.get().getSubject();
        if (this.originalSubject == null) {
            this.originalSubject = J2EEUtil.getInstance().getCurrentSubject();
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public ObjectReferenceBase getSource() {
        return this.source;
    }

    public Integer getElementSequenceNumber() {
        return this.elementSequenceNumber;
    }

    public byte[] getContent() {
        this.checkClosedRuntime();
        try {
            if (this.contentAsStream != null) {
                this.content = ClientInputStream.gatherStreamToBytes(this.contentAsStream);
                this.contentAsStream = null;
            }
        }
        catch (IOException ioe) {
            throw new EngineRuntimeException(ioe, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
        return this.content;
    }

    public InputStream getContentAsStream() {
        this.checkClosedRuntime();
        if (this.contentAsStream != null) {
            return this.contentAsStream;
        }
        if (this.content != null) {
            return new ByteArrayInputStream(this.content);
        }
        return null;
    }

    public Long getTotalSize() {
        return this.totalSize;
    }

    public String getContinueFrom() {
        return this.continueFrom;
    }

    public int read(byte[] buffer, int off, int len) throws IOException {
        this.checkClosedIO();
        if (null != this.contentAsStream) {
            return this.fillBufferFromStream(buffer, off, len);
        }
        return this.fillBuffer(buffer, off, len);
    }

    public int read(byte[] buffer) throws IOException {
        this.checkClosedIO();
        if (null != this.contentAsStream) {
            return this.fillBufferFromStream(buffer, 0, buffer.length);
        }
        return this.fillBuffer(buffer, 0, buffer.length);
    }

    private int fillBufferFromStream(byte[] buffer, int off, int len) throws IOException {
        int totalBytesRead = -1;
        while (totalBytesRead < len) {
            int read;
            int readLength = len;
            if (totalBytesRead > 0) {
                readLength -= totalBytesRead;
            }
            if (-1 == (read = this.contentAsStream.read(buffer, off, readLength))) {
                if (null != this.continueFrom) {
                    this.nextChunk(this.continueFrom);
                    read = this.contentAsStream.read(buffer, off, readLength);
                } else {
                    this.contentAsStream.close();
                    this.contentAsStream = null;
                    break;
                }
            }
            if (-1 == totalBytesRead) {
                totalBytesRead = 0;
            }
            if (-1 == read) continue;
            totalBytesRead += read;
            off += read;
        }
        return totalBytesRead;
    }

    private int fillBuffer(byte[] buffer, int off, int len) throws IOException {
        int bytesRead;
        int read;
        for (bytesRead = -1; bytesRead < len; bytesRead += read) {
            if (null == this.content && 0L == this.totalOffset && null != this.continueFrom) {
                this.nextChunk(this.continueFrom);
            }
            if (this.content == null || this.content.length <= 0) {
                return bytesRead;
            }
            if (this.curPos >= this.content.length) {
                if (this.continueFrom != null) {
                    this.nextChunk(this.continueFrom);
                    if (this.content == null || this.content.length <= 0) {
                        return bytesRead;
                    }
                } else {
                    return bytesRead;
                }
            }
            if (-1 == bytesRead) {
                bytesRead = 0;
            }
            read = Math.min(len - bytesRead, this.content.length - this.curPos);
            System.arraycopy(this.content, this.curPos, buffer, off, read);
            off += read;
            this.curPos += read;
        }
        return bytesRead;
    }

    public int read() throws IOException {
        this.checkClosedIO();
        if (this.contentAsStream != null) {
            int ret = this.contentAsStream.read();
            if (ret == -1) {
                if (null != this.continueFrom) {
                    this.nextChunk(this.continueFrom);
                    return this.read();
                }
                this.contentAsStream.close();
                this.contentAsStream = null;
            }
            return ret;
        }
        if (null == this.content && 0L == this.totalOffset && null != this.continueFrom) {
            this.nextChunk(this.continueFrom);
            return this.read();
        }
        if (this.content == null || this.content.length <= 0) {
            return -1;
        }
        if (this.curPos >= this.content.length) {
            if (this.continueFrom != null) {
                this.nextChunk(this.continueFrom);
                return this.read();
            }
            return -1;
        }
        return this.content[this.curPos++] & 0xFF;
    }

    private void nextChunk(String contFrom) throws IOException {
        this.checkClosedRuntime();
        if (this.session == null) {
            this.session = SessionLocator.getSession(this.connection);
            this.session.beginGetContentSession(this.connection);
        }
        ClientInputStream res = this.session.getContentStream(this.connection, this.originalSubject, this.source, this.elementSequenceNumber, this.totalSize, contFrom);
        if (this.contentAsStream != null) {
            this.contentAsStream.close();
        }
        this.source = res.source;
        this.elementSequenceNumber = res.elementSequenceNumber;
        this.continueFrom = res.continueFrom;
        this.totalSize = res.totalSize;
        this.content = res.content;
        this.contentAsStream = res.contentAsStream;
        this.curPos = 0;
    }

    public int available() throws IOException {
        this.checkClosedIO();
        if (this.contentAsStream != null) {
            return this.contentAsStream.available();
        }
        if (this.content == null || this.content.length <= 0 || this.content.length - this.curPos <= 0) {
            return 0;
        }
        return this.content.length - this.curPos;
    }

    public static byte[] gatherStreamToBytes(InputStream istr) throws IOException {
        if (istr == null) {
            return new byte[0];
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        byte[] blob = new byte[32768];
        int len = istr.read(blob);
        while (len > 0) {
            out.write(blob, 0, len);
            len = istr.read(blob);
        }
        istr.close();
        return out.toByteArray();
    }

    public void setInUse() {
        this.inUse = true;
    }

    public boolean isInUse() {
        return this.inUse;
    }

    public void close() throws IOException {
        this.isClosed = true;
        this.connection = null;
        this.source = null;
        this.content = null;
        this.curPos = -1;
        if (this.contentAsStream != null) {
            this.contentAsStream.close();
            this.contentAsStream = null;
        }
        if (this.session != null) {
            this.session.finishGetContentSession(this.connection);
            this.session = null;
        }
        super.close();
    }

    private void checkClosedRuntime() throws EngineRuntimeException {
        if (this.isClosed) {
            throw new EngineRuntimeException(ExceptionCode.E_CLOSED_STREAM, null);
        }
    }

    private void checkClosedIO() throws IOException {
        if (this.isClosed) {
            throw new IOException(ExceptionCode.E_CLOSED_STREAM.toString(null));
        }
    }

    public void serializeValue(DelegateOutputStream s) throws IOException {
        s.putObjectReference(this.source);
        s.writeObject(this.elementSequenceNumber);
        s.writeObject(this.continueFrom);
        s.writeObject(this.getContent());
        s.writeObject(this.totalSize);
    }

    public void deserializeValue(DelegateInputStream s, Connection conn) throws IOException, ClassNotFoundException {
        this.connection = (ConnectionImpl)conn;
        this.source = s.getObjectReference();
        this.elementSequenceNumber = (Integer)s.readObject();
        this.continueFrom = (String)s.readObject();
        this.content = (byte[])s.readObject();
        this.totalSize = (Long)s.readObject();
        this.isClosed = false;
        this.inUse = false;
    }
}

