/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.meta;

import com.filenet.api.collection.ClassDescriptionSet;
import com.filenet.api.constants.ConfigurationParameter;
import com.filenet.api.constants.FilteredPropertyType;
import com.filenet.api.constants.GuidConstants;
import com.filenet.api.core.BatchItemHandle;
import com.filenet.api.core.Connection;
import com.filenet.api.core.Domain;
import com.filenet.api.core.EngineObject;
import com.filenet.api.core.Factory;
import com.filenet.api.core.IndependentObject;
import com.filenet.api.core.InstantiatingScope;
import com.filenet.api.core.ObjectReference;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.core.RetrievingBatch;
import com.filenet.api.core.Scope;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.meta.ClassDescription;
import com.filenet.api.meta.MetadataCache;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.util.Id;
import com.filenet.apiimpl.core.ClassDescriptionImpl;
import com.filenet.apiimpl.core.ConnectionImpl;
import com.filenet.apiimpl.core.EngineObjectImpl;
import com.filenet.apiimpl.core.EngineObjectUtil;
import com.filenet.apiimpl.core.GlobalIdentity;
import com.filenet.apiimpl.core.ObjectFactory;
import com.filenet.apiimpl.core.ObjectReferenceBase;
import com.filenet.apiimpl.core.ObjectStoreImpl;
import com.filenet.apiimpl.core.PropertyDescriptionObjectImpl;
import com.filenet.apiimpl.core.Session;
import com.filenet.apiimpl.core.SubSetImpl;
import com.filenet.apiimpl.meta.Cache;
import com.filenet.apiimpl.meta.CachedObject;
import com.filenet.apiimpl.property.PropertyImpl;
import com.filenet.apiimpl.property.UnevaluatedPropertyValue;
import com.filenet.apiimpl.util.BaseLogger;
import com.filenet.apiimpl.util.ConfigValueLookup;
import com.filenet.apiimpl.util.SessionLocator;
import com.filenet.apiimpl.util.SubSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class Util {
    public static final Util INSTANCE = new Util();
    private static final int GUID_LENGTH = 38;
    private static final Set classDescriptionSetPropertyKeys = new HashSet<String>(Arrays.asList("ImmediateSubclassDescriptions".toLowerCase()));
    private static final PropertyFilter filter;
    private static final PropertyFilter filterNoCache;
    private static final PropertyFilter SET_FILTER;
    private static final BaseLogger logger;

    private Util() {
    }

    public ClassDescription getClassDescription(EngineObjectImpl object) {
        return this.getClassDescription(object, "ClassDescription");
    }

    public ClassDescriptionSet getClassDescriptions(ObjectStoreImpl object) {
        return this.getClassDescriptions(object, object, "ClassDescriptions");
    }

    public ClassDescription getSuperclassDescription(ClassDescriptionImpl object) {
        return this.getClassDescription(object, "SuperclassDescription");
    }

    public ClassDescriptionSet getImmediateSubclassDescriptions(ClassDescriptionImpl object) {
        return this.getClassDescriptions(this.getScope(object), object, "ImmediateSubclassDescriptions");
    }

    public ClassDescription getRequiredClass(PropertyDescriptionObjectImpl object) {
        ObjectReference reference;
        String propertyName = "RequiredClass";
        MetadataCache cache = this.getDefaultCache(object);
        if (cache == null) {
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("Intercept cache disabled: propertyName=" + propertyName + ", objectIdent=" + this.getObjectIdent(object) + ", classIdent=" + this.getClassIdent(object));
            }
            return null;
        }
        PropertyImpl property = this.getInterceptProperty(object, propertyName);
        if (property == null) {
            return null;
        }
        Object value = property.getInstanceValue();
        if (value instanceof ClassDescription) {
            reference = ((ClassDescription)value).getObjectReference();
        } else if (value instanceof ObjectReference) {
            reference = (ObjectReference)value;
        } else {
            return null;
        }
        String classIdent = reference.getObjectIdentity();
        if (classIdent == null) {
            return null;
        }
        InstantiatingScope scope = (InstantiatingScope)EngineObjectUtil.getScope((ObjectReferenceBase)reference, object.getConnection());
        return cache.getClassDescription(scope, classIdent);
    }

    private ClassDescription getClassDescription(EngineObjectImpl object, String propertyName) {
        ObjectReference reference;
        MetadataCache cache = this.getDefaultCache(object);
        if (cache == null) {
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("Intercept cache disabled: propertyName=" + propertyName + ", objectIdent=" + this.getObjectIdent(object) + ", classIdent=" + this.getClassIdent(object));
            }
            return null;
        }
        PropertyImpl property = this.getInterceptProperty(object, propertyName);
        if (property == null) {
            return null;
        }
        Object value = property.getInstanceValue();
        if (value instanceof ClassDescription) {
            reference = ((ClassDescription)value).getObjectReference();
        } else if (value instanceof ObjectReference) {
            reference = (ObjectReference)value;
        } else {
            return null;
        }
        String classIdent = reference.getObjectIdentity();
        if (classIdent == null) {
            return null;
        }
        InstantiatingScope scope = this.getScope(object);
        return cache.getClassDescription(scope, classIdent);
    }

    private ClassDescriptionSet getClassDescriptions(InstantiatingScope scope, EngineObjectImpl object, String propertyName) {
        MetadataCache cache = this.getDefaultCache(object);
        if (cache == null) {
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("Intercept cache disabled: propertyName=" + propertyName + ", objectIdent=" + this.getObjectIdent(object) + ", classIdent=" + this.getClassIdent(object));
            }
            return null;
        }
        if (this.getInterceptProperty(object, propertyName) == null) {
            return null;
        }
        if (object.getConnection() == null) {
            return null;
        }
        return ((Cache)cache).getClassDescriptions(scope, object, propertyName);
    }

    private PropertyImpl getInterceptProperty(EngineObjectImpl object, String propertyName) {
        if (object instanceof CachedObject) {
            return null;
        }
        PropertyImpl property = (PropertyImpl)object.getProperties().get(propertyName);
        if (property instanceof CachedObject) {
            return null;
        }
        return property;
    }

    public Boolean describedIsOfClass(ClassDescription cd, String classIdent) {
        MetadataCache cache = this.getDefaultCache(cd);
        if (cache == null) {
            return null;
        }
        return cache.describedIsOfClass(cd, classIdent);
    }

    boolean isClassDescriptionIdent(String classIdent) {
        if (classIdent == null || (classIdent = classIdent.trim()).length() == 0) {
            return false;
        }
        if ("ClassDescription".equalsIgnoreCase(classIdent)) {
            return true;
        }
        return GuidConstants.Class_ClassDescription.toString().equalsIgnoreCase(classIdent);
    }

    boolean isClassDescriptionReference(Object value) {
        if (!(value instanceof ObjectReference)) {
            return false;
        }
        return this.isClassDescriptionIdent(((ObjectReference)value).getClassIdentity());
    }

    boolean isClassDescriptionPropertyUnevaluatedSet(PropertyImpl property) {
        if (!(property.getInstanceValue() instanceof UnevaluatedPropertyValue)) {
            return false;
        }
        return classDescriptionSetPropertyKeys.contains(property.getPropertyName().toLowerCase());
    }

    private MetadataCache getDefaultCache(EngineObject object) {
        Connection connection = object.getConnection();
        if (connection == null) {
            return null;
        }
        Object value = connection.getParameter(ConfigurationParameter.CONNECTION_CLIENT_METADATA_CACHE);
        if (Boolean.TRUE.equals(value)) {
            value = Factory.MetadataCache.getDefaultInstance();
        } else if (Boolean.FALSE.equals(value)) {
            return null;
        }
        MetadataCache cache = (MetadataCache)value;
        if (cache == null) {
            cache = Factory.MetadataCache.getDefaultInstance();
        }
        if (!this.isEnabled(cache)) {
            cache = null;
        }
        return cache;
    }

    private boolean isEnabled(MetadataCache cache) {
        return cache != null ? !Boolean.FALSE.equals(((Cache)cache).getParameter(ConfigurationParameter.CMC_ENABLED)) : false;
    }

    public boolean isCacheEnabled(EngineObject object) {
        return this.isEnabled(this.getDefaultCache(object));
    }

    String getIdent(String ident) {
        if (ident == null) {
            return null;
        }
        if (Id.isId(ident = ident.trim().toUpperCase()) && ident.length() != 38) {
            StringBuffer buffer = new StringBuffer(38);
            ident = buffer.append('{').append(ident).append('}').toString();
        }
        return ident;
    }

    ArrayList getClassIdents(SubSetImpl cds) {
        ArrayList<String> classIdents = new ArrayList<String>();
        Iterator i = cds.iterator();
        while (i.hasNext()) {
            ClassDescription cd = (ClassDescription)i.next();
            classIdents.add(cd.get_Id().toString());
        }
        return classIdents;
    }

    InstantiatingScope getScope(EngineObject object) {
        Scope scope = ((EngineObjectImpl)object).getScope();
        if (scope instanceof InstantiatingScope) {
            return (InstantiatingScope)scope;
        }
        if (object instanceof Domain) {
            return (Domain)object;
        }
        if (object instanceof ClassDescription) {
            ClassDescription cd = (ClassDescription)object;
            String id = cd.getObjectReference().getObjectIdentity();
            if (Id.isId(id)) {
                id = new Id(id).toString();
            }
            if ("Domain".equalsIgnoreCase(id) || GuidConstants.Class_Domain.toString().equals(id)) {
                return Factory.Domain.getInstance(this.getConnection(cd), null);
            }
        }
        throw new EngineRuntimeException(ExceptionCode.E_OBJECT_NOT_FOUND);
    }

    InstantiatingScope normalizeScope(InstantiatingScope scope, String scopeGuid) {
        String classIdent = this.getClassName(scope);
        Id objectIdent = new Id(scopeGuid);
        GlobalIdentity reference = new GlobalIdentity(classIdent, objectIdent);
        ConnectionImpl connection = this.getConnection((EngineObject)((Object)scope));
        return (InstantiatingScope)((Object)ObjectFactory.getInstance(reference, null, connection));
    }

    InstantiatingScope createScope(InstantiatingScope scope) {
        IndependentObject object = (IndependentObject)((Object)scope);
        ObjectReference reference = object.getObjectReference();
        ConnectionImpl connection = this.getConnection(object);
        return (InstantiatingScope)((Object)ObjectFactory.getInstance(reference, null, connection));
    }

    String getClassName(InstantiatingScope scope) {
        if (scope instanceof ObjectStore) {
            return "ObjectStore";
        }
        if (scope instanceof Domain) {
            return "Domain";
        }
        throw new InternalError("scope.class=" + scope.getClass().getName());
    }

    Class getClassInstance(InstantiatingScope scope) {
        if (scope instanceof ObjectStore) {
            return ObjectStore.class;
        }
        if (scope instanceof Domain) {
            return Domain.class;
        }
        throw new InternalError("scope.class=" + scope.getClass().getName());
    }

    String getObjectIdent(Object object) {
        if (!(object instanceof IndependentObject)) {
            return null;
        }
        return ((IndependentObject)object).getObjectReference().getObjectIdentity();
    }

    String getClassIdent(Object object) {
        if (!(object instanceof IndependentObject)) {
            return null;
        }
        return ((IndependentObject)object).getObjectReference().getClassIdentity();
    }

    List getList(String[] strings) {
        if (strings == null) {
            return null;
        }
        return Arrays.asList(strings);
    }

    ClassDescriptionImpl fetchClassDescription(InstantiatingScope scope, String classIdent) {
        return this.fetchClassDescriptions(scope, new String[]{classIdent})[0];
    }

    ClassDescriptionImpl[] fetchClassDescriptions(InstantiatingScope scope, String[] classIdents) {
        int batchSize = ConfigValueLookup.getValueAsInt("CmcCdBatchSize", 50);
        int batchItems = 0;
        ClassDescriptionImpl[] cds = new ClassDescriptionImpl[classIdents.length];
        Domain domain = this.getDomain(scope);
        RetrievingBatch batch = null;
        for (int j = 0; j < classIdents.length; ++j) {
            cds[j] = (ClassDescriptionImpl)Factory.ClassDescription.getInstance((Scope)scope, classIdents[j]);
            if (j % batchSize == 0) {
                if (batch != null) {
                    batch.retrieveBatch();
                }
                batchItems = 0;
                batch = RetrievingBatch.createRetrievingBatchInstance(domain);
            }
            PropertyFilter pf = this.isCacheEnabled(domain) ? filter : filterNoCache;
            batch.add(cds[j], pf);
            ++batchItems;
        }
        if (batchItems > 0) {
            batch.retrieveBatch();
        }
        List bihs = batch.getBatchItemHandles(null);
        for (BatchItemHandle bih : bihs) {
            if (!bih.hasException()) continue;
            throw bih.getException();
        }
        return cds;
    }

    SubSetImpl fetchClassDescriptions(Connection connection, UnevaluatedPropertyValue upv) {
        connection = this.getConnection(connection);
        Session session = SessionLocator.getSession(connection);
        PropertyImpl property = session.getProperty((ConnectionImpl)connection, upv, null, SET_FILTER, null);
        return (SubSetImpl)property.getInstanceValue();
    }

    private Domain getDomain(InstantiatingScope scope) {
        if (scope instanceof ObjectStoreImpl) {
            return (Domain)((ObjectStoreImpl)scope).getScope();
        }
        if (scope instanceof Domain) {
            return (Domain)scope;
        }
        throw new InternalError("scope.class=" + scope.getClass().getName());
    }

    ConnectionImpl getConnection(EngineObject object) {
        return this.getConnection(object.getConnection());
    }

    ConnectionImpl getConnection(Connection candidate) {
        if (candidate == null) {
            throw new EngineRuntimeException(ExceptionCode.API_UNABLE_TO_USE_CONNECTION, "null");
        }
        return (ConnectionImpl)candidate;
    }

    void validateScope(InstantiatingScope scope) {
        if (scope == null) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_ARGUMENT, "scope");
        }
    }

    void validateEngineObject(EngineObject eo) {
        if (eo == null) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_ARGUMENT, "eo");
        }
    }

    void validateClassDescription(ClassDescription cd) {
        if (cd == null) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_ARGUMENT, "cd");
        }
    }

    void validateClassIdent(String classIdent) {
        if (classIdent == null) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_ARGUMENT, "classIdent");
        }
    }

    void validateClassIdents(String[] classIdents) {
        if (classIdents == null) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_ARGUMENT, "classIdents");
        }
        for (int i = 0; i < classIdents.length; ++i) {
            if (classIdents[i] != null) continue;
            throw new EngineRuntimeException(ExceptionCode.E_NULL_ARGUMENT, "classIdents[" + i + "]");
        }
    }

    static {
        String LAZY_DEPENDENT_LISTS_NO_CACHE = "ProperSubclassPropertyDescriptions DefaultInstancePermissions PermissionDescriptions Ids PropertyDescriptions ImmediateSubclassDescriptions";
        String PREFETCH_VALUES_NO_CACHE = "SuperclassDescription Id SymbolicName";
        String LAZY_DEPENDENT_LISTS_WITH_CACHE_ENABLED = "ProperSubclassPropertyDescriptions DefaultInstancePermissions PermissionDescriptions";
        filter = new PropertyFilter();
        filter.addIncludeProperty(0, null, null, "ProperSubclassPropertyDescriptions DefaultInstancePermissions PermissionDescriptions", null);
        filter.addIncludeType(0, null, Boolean.TRUE, FilteredPropertyType.ANY, null);
        filterNoCache = new PropertyFilter();
        filterNoCache.addIncludeProperty(0, null, null, "ProperSubclassPropertyDescriptions DefaultInstancePermissions PermissionDescriptions Ids PropertyDescriptions ImmediateSubclassDescriptions", null);
        filterNoCache.addIncludeProperty(2, null, null, "SuperclassDescription Id SymbolicName", null);
        filterNoCache.addIncludeType(0, null, Boolean.TRUE, FilteredPropertyType.ANY, null);
        SET_FILTER = new PropertyFilter();
        SET_FILTER.addIncludeProperty(0, null, null, "Id", null);
        logger = BaseLogger.getBaseLogger(Cache.class, SubSystem.API);
    }
}

