/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.meta;

import com.filenet.apiimpl.meta.ScopeKey;
import com.filenet.apiimpl.meta.Util;
import com.filenet.apiimpl.util.ContextCache;
import com.filenet.apiimpl.util.ContextKey;

class PropertyCache {
    private final ContextCache cache = new ContextCache();
    private static final Util util = Util.INSTANCE;
    private static final int MAX_ALIASES = 16;

    PropertyCache() {
        this.cache.setMaxAliases(16);
    }

    synchronized void setEnabled(boolean enabled) {
        this.cache.setEnabled(enabled);
    }

    synchronized void setTTL(long duration) {
        this.cache.setTTL(duration);
    }

    synchronized void clear() {
        this.cache.clear();
    }

    synchronized Object get(ScopeKey scopeKey, String classIdent, String objectIdent, String propertyName) {
        ContextKey classKey = this.cache.find(scopeKey, classIdent);
        ContextKey objectKey = this.cache.find(classKey, objectIdent);
        ContextKey propertyKey = this.cache.find(objectKey, propertyName);
        Object value = this.cache.getValue(propertyKey);
        if (value != null) {
            return value;
        }
        classKey = this.cache.find(scopeKey, util.getIdent(classIdent));
        objectKey = this.cache.find(classKey, util.getIdent(objectIdent));
        propertyKey = this.cache.find(objectKey, util.getIdent(propertyName));
        value = this.cache.getValue(propertyKey);
        if (value != null) {
            classKey = this.cache.make(scopeKey, classIdent);
            objectKey = this.cache.make(classKey, objectIdent);
            this.cache.alias(propertyKey, new ContextKey(objectKey, propertyName));
            return value;
        }
        return null;
    }

    synchronized void put(ScopeKey scopeKey, String classIdent, String objectIdent, String propertyName, Object value) {
        ContextKey classKey = this.cache.make(scopeKey, util.getIdent(classIdent));
        ContextKey objectKey = this.cache.make(classKey, util.getIdent(objectIdent));
        ContextKey propertyKey = this.cache.make(objectKey, util.getIdent(propertyName));
        this.cache.putValue(propertyKey, value);
        this.cache.alias(propertyKey, this.cache.make(objectKey, propertyName));
        classKey = this.cache.make(scopeKey, classIdent);
        objectKey = this.cache.make(classKey, objectIdent);
        this.cache.alias(propertyKey, this.cache.make(objectKey, propertyName));
    }
}

