/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.meta;

import com.filenet.api.constants.ConfigurationParameter;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.util.ConfigurationParameters;
import com.filenet.apiimpl.meta.Cache;
import com.filenet.apiimpl.util.ConfigValueLookup;
import com.filenet.apiimpl.util.EnumValues;
import com.filenet.apiimpl.util.SessionLocator;

class Parameters {
    private final Cache metaCache;
    private final ConfigurationParameters parameters = new ConfigurationParameters();
    private static Parameters DEFAULT = null;
    private static final long TTL = 36000000L;
    private static boolean enableOverride = ConfigValueLookup.getValueAsBoolean("CMCEnableOverride", false);

    Parameters(Cache metaCache, boolean defaultCache) {
        if (defaultCache) {
            if (DEFAULT != null) {
                throw new IllegalStateException("DEFAULT != null");
            }
            DEFAULT = this;
        }
        this.metaCache = metaCache;
        Boolean enabled = SessionLocator.isExecutingInServer() ? Boolean.FALSE : (defaultCache ? Parameters.getDefaultEnabled() : Boolean.TRUE);
        if (enableOverride) {
            enabled = Boolean.TRUE;
        }
        this.putParameter(ConfigurationParameter.CMC_ENABLED, enabled);
        this.putParameter(ConfigurationParameter.CMC_TIME_TO_LIVE, Parameters.getDefaultTTL());
    }

    synchronized Object getParameter(ConfigurationParameter parameter) {
        return this.parameters.getParameter(parameter);
    }

    synchronized Object setParameter(ConfigurationParameter parameter, Object value) {
        if (this == DEFAULT || SessionLocator.isExecutingInServer()) {
            throw new EngineRuntimeException(ExceptionCode.E_READ_ONLY);
        }
        Object previous = this.parameters.getParameter(parameter);
        this.putParameter(parameter, value);
        return previous;
    }

    private void putParameter(ConfigurationParameter parameter, Object value) {
        this.parameters.setParameter(parameter, value);
        switch (parameter.getIntValue()) {
            case 2: {
                this.metaCache.setEnabled(ConfigValueLookup.getBoolean(this.parameters, parameter, true));
                break;
            }
            case 3: {
                this.metaCache.setTTL(ConfigValueLookup.getLongDefault(this.parameters, parameter, 36000000L));
            }
        }
    }

    synchronized void setParameters(ConfigurationParameters parameters) {
        ConfigurationParameter[] keys = EnumValues.CONFIGURATION_PARAMETERS;
        for (int i = 0; i < keys.length; ++i) {
            ConfigurationParameter key = keys[i];
            Object value = parameters.getParameter(key);
            if (value == null) continue;
            this.setParameter(key, value);
        }
    }

    private static Boolean getDefaultEnabled() {
        return ConfigValueLookup.getBoolean(ConfigurationParameter.CMC_ENABLED, true);
    }

    private static Long getDefaultTTL() {
        return new Long(ConfigValueLookup.getLong(ConfigurationParameter.CMC_TIME_TO_LIVE, 36000000L));
    }
}

