/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.meta;

import com.filenet.api.core.Connection;
import com.filenet.api.core.EngineObject;
import com.filenet.api.core.InstantiatingScope;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.util.AliasCache;

class ConnectionKeys {
    private final AliasCache aliases = new AliasCache();
    private static final int MAX_VALUES = 32;
    private static final int MAX_ALIASES = 8;

    ConnectionKeys() {
        this.aliases.setLRUMaxSize(32);
        this.aliases.setMaxAliases(8);
    }

    synchronized void setEnabled(boolean enabled) {
        this.aliases.setEnabled(enabled);
    }

    synchronized void setTTL(long duration) {
        this.aliases.setTTL(duration);
    }

    synchronized void clear() {
        this.aliases.clear();
    }

    String get(InstantiatingScope scope) {
        return this.get((EngineObject)((Object)scope));
    }

    String get(EngineObject object) {
        return this.get(object.getConnection());
    }

    String get(Connection connection) {
        if (connection == null) {
            throw new EngineRuntimeException(ExceptionCode.API_UNABLE_TO_USE_CONNECTION, "null");
        }
        return this.get(connection.getURI());
    }

    synchronized String get(String uri) {
        if (uri == null) {
            throw new EngineRuntimeException(ExceptionCode.API_UNABLE_TO_USE_CONNECTION, "uri == null");
        }
        String id = (String)this.aliases.get(uri);
        if (id == null) {
            id = this.make(uri);
            this.aliases.add(id, id);
            this.aliases.add(id, uri);
        }
        return id;
    }

    private String make(String uri) {
        if ((uri = uri.trim().toLowerCase().replace('\\', '/')).length() == 0) {
            throw new EngineRuntimeException(ExceptionCode.API_UNABLE_TO_USE_CONNECTION, "uri.length == 0");
        }
        if (!uri.endsWith("/")) {
            uri = uri + '/';
        }
        return uri;
    }
}

