/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.meta;

import com.filenet.api.collection.ClassDescriptionSet;
import com.filenet.api.constants.ConfigurationParameter;
import com.filenet.api.constants.GuidConstants;
import com.filenet.api.core.EngineObject;
import com.filenet.api.core.InstantiatingScope;
import com.filenet.api.core.ObjectReference;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.core.Scope;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.meta.ClassDescription;
import com.filenet.api.meta.MetadataCache;
import com.filenet.api.util.ConfigurationParameters;
import com.filenet.api.util.Id;
import com.filenet.api.util.UserContext;
import com.filenet.apiimpl.core.ClassDescriptionImpl;
import com.filenet.apiimpl.core.EngineObjectImpl;
import com.filenet.apiimpl.core.ObjectReferenceBase;
import com.filenet.apiimpl.core.SubSetImpl;
import com.filenet.apiimpl.meta.AccessCache;
import com.filenet.apiimpl.meta.CachedClassDescription;
import com.filenet.apiimpl.meta.CachedClassDescriptionSet;
import com.filenet.apiimpl.meta.ClassObjects;
import com.filenet.apiimpl.meta.Parameters;
import com.filenet.apiimpl.meta.PropertyCache;
import com.filenet.apiimpl.meta.ScopeKey;
import com.filenet.apiimpl.meta.ScopeKeys;
import com.filenet.apiimpl.meta.Util;
import com.filenet.apiimpl.property.UnevaluatedPropertyValue;
import com.filenet.apiimpl.util.BaseLogger;
import com.filenet.apiimpl.util.ConfigValueLookup;
import com.filenet.apiimpl.util.SubSystem;
import com.filenet.apiimpl.util.Subjects;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;

public class Cache
implements MetadataCache {
    public static final Cache DEFAULT = new Cache(true);
    private final ClassObjects objects = new ClassObjects();
    private final AccessCache accessCache = new AccessCache();
    private final ScopeKeys scopeKeys = new ScopeKeys();
    private final PropertyCache propertyCache = new PropertyCache();
    private final Parameters parameters;
    private static final Util util = Util.INSTANCE;
    private static final BaseLogger logger = BaseLogger.getBaseLogger(Cache.class, SubSystem.API);
    private static final String STORE_CLASS_IDENT = util.getIdent(GuidConstants.Class_ObjectStore.toString());
    private static boolean cmcUserSpecificAccessCheck = ConfigValueLookup.getValueAsBoolean("FileNet.CMC.UserSpecific", true);

    private Cache(boolean defaultCache) {
        this.parameters = new Parameters(this, defaultCache);
    }

    public Cache() {
        this(false);
    }

    public Cache(ConfigurationParameters parameters) {
        this(false);
        if (parameters != null) {
            this.setParameters(parameters);
        }
    }

    void setEnabled(boolean enabled) {
        this.objects.setEnabled(enabled);
        this.accessCache.setEnabled(enabled);
        this.scopeKeys.setEnabled(enabled);
        this.propertyCache.setEnabled(enabled);
    }

    void setTTL(long duration) {
        this.objects.setTTL(duration);
        this.accessCache.setTTL(duration);
        this.scopeKeys.setTTL(duration);
        this.propertyCache.setTTL(duration);
    }

    public ClassDescription getClassDescription(InstantiatingScope scope, String classIdent) {
        ClassDescriptionImpl cd;
        if (!this.objects.isEnabled()) {
            this.traceDisabled(scope, classIdent);
            return util.fetchClassDescription(scope, classIdent);
        }
        util.validateScope(scope);
        util.validateClassIdent(classIdent);
        ScopeKey scopeKey = this.scopeKeys.get(scope);
        Subject subject = null;
        boolean isAccessible = true;
        if (cmcUserSpecificAccessCheck) {
            subject = Subjects.getCurrent();
            isAccessible = this.accessCache.isAccessible(scopeKey, subject);
        }
        if (isAccessible) {
            cd = this.objects.get(scopeKey, classIdent);
            if (cd != null) {
                this.traceHit(scopeKey, classIdent);
                return cd;
            }
        } else {
            this.traceInaccessible(scopeKey, subject);
        }
        scope = util.normalizeScope(scope, scopeKey.guid);
        cd = util.fetchClassDescription(scope, classIdent);
        cd.setReadOnly(true);
        if (subject != null) {
            this.accessCache.setAccessible(scopeKey, subject);
        }
        return this.putClassDescription(scope, scopeKey, classIdent, cd);
    }

    public ClassDescription[] getClassDescriptions(InstantiatingScope scope, String[] classIdents) {
        if (!this.objects.isEnabled()) {
            this.traceDisabled(scope, classIdents);
            return util.fetchClassDescriptions(scope, classIdents);
        }
        util.validateScope(scope);
        util.validateClassIdents(classIdents);
        int length = classIdents.length;
        if (length == 0) {
            return new ClassDescription[0];
        }
        ClassDescription[] cds = new ClassDescription[length];
        ScopeKey scopeKey = this.scopeKeys.get(scope);
        ArrayList<String> misses = null;
        for (int next = 0; next < length; ++next) {
            String classIdent = classIdents[next];
            CachedClassDescription cd = this.objects.get(scopeKey, classIdent);
            if (cd == null) {
                if (misses == null) {
                    misses = new ArrayList(length - next);
                }
                misses.add(classIdent);
                continue;
            }
            cds[next] = cd;
            cd.setReadOnly(true);
            this.traceHit(scopeKey, classIdent);
        }
        Subject subject = null;
        boolean isAccessible = true;
        if (cmcUserSpecificAccessCheck) {
            subject = Subjects.getCurrent();
            isAccessible = this.accessCache.isAccessible(scopeKey, subject);
        }
        if (misses == null && !isAccessible) {
            this.traceInaccessible(scopeKey, subject);
            misses = new ArrayList<String>(1);
            misses.add(classIdents[0]);
            cds[0] = null;
        }
        if (misses != null) {
            scope = util.normalizeScope(scope, scopeKey.guid);
            String[] ids = misses.toArray(new String[misses.size()]);
            ClassDescriptionImpl[] fetched = util.fetchClassDescriptions(scope, ids);
            if (subject != null) {
                this.accessCache.setAccessible(scopeKey, subject);
            }
            int next = -1;
            for (int i = 0; i < fetched.length; ++i) {
                ClassDescriptionImpl cd = fetched[i];
                cd.setReadOnly(true);
                while (cds[++next] != null) {
                }
                String classIdent = classIdents[next];
                cds[next] = this.putClassDescription(scope, scopeKey, classIdent, cd);
            }
        }
        return cds;
    }

    private CachedClassDescription putClassDescription(InstantiatingScope scope, ScopeKey scopeKey, String classIdent, ClassDescriptionImpl cd) {
        CachedClassDescription cached = new CachedClassDescription(this, scope, cd);
        this.objects.put(scopeKey, classIdent, cached);
        this.tracePut(scopeKey, classIdent);
        return cached;
    }

    public ClassDescription getClassDescription(EngineObject eo) {
        util.validateEngineObject(eo);
        return this.getClassDescription(util.getScope(eo), eo.getClassName());
    }

    public boolean objectIsOfClass(EngineObject eo, String classIdent) {
        return this.describedIsOfClass(this.getClassDescription(eo), classIdent);
    }

    public boolean describedIsOfClass(ClassDescription cd, String classIdent) {
        if (!this.objects.isEnabled()) {
            return Boolean.TRUE.equals(cd.describedIsOfClass(classIdent));
        }
        util.validateClassDescription(cd);
        util.validateClassIdent(classIdent);
        InstantiatingScope scope = util.getScope(cd);
        cd = this.getClassDescription(scope, cd.getObjectReference().getObjectIdentity());
        try {
            Id typeId = this.getClassDescription(scope, classIdent).get_Id();
            while (true) {
                if (cd.get_Id().equals(typeId)) {
                    return true;
                }
                ClassDescription next = cd.get_SuperclassDescription();
                if (next == null) {
                    return false;
                }
                cd = next;
            }
        }
        catch (EngineRuntimeException e) {
            return false;
        }
    }

    ClassDescriptionSet getClassDescriptions(InstantiatingScope scope, EngineObjectImpl object, String propertyName) {
        ScopeKey scopeKey = this.scopeKeys.get(scope);
        ObjectReference or = object.getObjectReference();
        String classIdent = or.getClassIdentity();
        String objectIdent = or.getObjectIdentity();
        if (object instanceof ObjectStore) {
            ScopeKey storeKey = this.scopeKeys.get((ObjectStore)((Object)object));
            classIdent = STORE_CLASS_IDENT;
            objectIdent = storeKey.guid;
        } else if (object instanceof ClassDescription && !(object instanceof CachedClassDescription)) {
            object = (EngineObjectImpl)((Object)this.getClassDescription(scope, objectIdent));
            or = object.getObjectReference();
            classIdent = or.getClassIdentity();
            objectIdent = or.getObjectIdentity();
        }
        ArrayList classIdents = (ArrayList)this.propertyCache.get(scopeKey, classIdent, objectIdent, propertyName);
        if (classIdents != null) {
            this.traceHit(scopeKey, classIdent, objectIdent, propertyName);
            return new CachedClassDescriptionSet(this, scope, classIdents);
        }
        ObjectReferenceBase parentReference = (ObjectReferenceBase)object.getObjectReference();
        UnevaluatedPropertyValue upv = new UnevaluatedPropertyValue(parentReference, propertyName);
        SubSetImpl cds = util.fetchClassDescriptions(object.getConnection(), upv);
        if (cds == null) {
            return null;
        }
        classIdents = util.getClassIdents(cds);
        this.propertyCache.put(scopeKey, classIdent, objectIdent, propertyName, classIdents);
        this.tracePut(scopeKey, classIdent, objectIdent, propertyName);
        return new CachedClassDescriptionSet(this, scope, classIdents);
    }

    public ClassDescription refreshClassDescription(InstantiatingScope scope, String classIdent) {
        this.evictClassDescription(scope, classIdent);
        return this.getClassDescription(scope, classIdent);
    }

    public ClassDescription[] refreshClassDescriptions(InstantiatingScope scope, String[] classIdents) {
        this.evictClassDescriptions(scope, classIdents);
        return this.getClassDescriptions(scope, classIdents);
    }

    public void refreshAllClassDescriptions() {
        Map map = this.objects.getAllScopeClassIdents();
        this.objects.clear();
        for (Map.Entry entry : map.entrySet()) {
            InstantiatingScope scope = (InstantiatingScope)entry.getKey();
            Set set = (Set)entry.getValue();
            String[] classIdents = set.toArray(new String[set.size()]);
            this.getClassDescriptions(scope, classIdents);
        }
    }

    public void evictClassDescription(InstantiatingScope scope, String classIdent) {
        if (!this.objects.isEnabled()) {
            return;
        }
        util.validateScope(scope);
        util.validateClassIdent(classIdent);
        ScopeKey scopeKey = this.scopeKeys.get(scope);
        this.objects.remove(scopeKey, classIdent);
    }

    public void evictClassDescriptions(InstantiatingScope scope, String[] classIdents) {
        for (int i = 0; i < classIdents.length; ++i) {
            this.evictClassDescription(scope, classIdents[i]);
        }
    }

    public void evictClassDescriptions(Scope scope) {
        Map map = this.objects.getAllScopeClassIdents();
        Set classIdsSet = (Set)map.get(scope);
        if (classIdsSet == null || classIdsSet.size() < 1) {
            return;
        }
        String[] classIdents = classIdsSet.toArray(new String[classIdsSet.size()]);
        for (int i = 0; i < classIdents.length; ++i) {
            this.evictClassDescription((InstantiatingScope)scope, classIdents[i]);
        }
    }

    public void evictAllClassDescriptions() {
        this.objects.clear();
        this.accessCache.clear();
        this.scopeKeys.clear();
        this.propertyCache.clear();
    }

    public Object getParameter(ConfigurationParameter parameter) {
        return this.parameters.getParameter(parameter);
    }

    public Object setParameter(ConfigurationParameter parameter, Object value) {
        return this.parameters.setParameter(parameter, value);
    }

    public void setParameters(ConfigurationParameters parameters) {
        this.parameters.setParameters(parameters);
    }

    private void traceInaccessible(ScopeKey scopeKey, Subject subject) {
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("Cache" + this.getCacheAddress() + " miss: scopeKey=" + scopeKey + ", subject=" + subject);
        }
    }

    private void traceHit(ScopeKey scopeKey, String classIdent) {
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("Cache" + this.getCacheAddress() + " hit: classIdent=" + classIdent + ", scopeKey=" + scopeKey + ", locale=" + UserContext.get().getLocale());
        }
    }

    private void tracePut(ScopeKey scopeKey, String classIdent) {
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("Cache" + this.getCacheAddress() + " put: classIdent=" + classIdent + ", scopeKey=" + scopeKey + ", locale=" + UserContext.get().getLocale());
        }
    }

    private void traceHit(ScopeKey scopeKey, String classIdent, String objectIdent, String propertyName) {
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("Cache" + this.getCacheAddress() + " hit: propertyName=" + propertyName + ", objectIdent=" + objectIdent + ", classIdent=" + classIdent + ", scopeKey=" + scopeKey + ", locale=" + UserContext.get().getLocale());
        }
    }

    private void tracePut(ScopeKey scopeKey, String classIdent, String objectIdent, String propertyName) {
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("Cache" + this.getCacheAddress() + " put: propertyName=" + propertyName + ", objectIdent=" + objectIdent + ", classIdent=" + classIdent + ", scopeKey=" + scopeKey + ", locale=" + UserContext.get().getLocale());
        }
    }

    private void traceDisabled(InstantiatingScope scope, String classIdent) {
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("Cache" + this.getCacheAddress() + " disabled: classIdent=" + classIdent + ", scopeIdent=" + util.getObjectIdent(scope));
        }
    }

    private void traceDisabled(InstantiatingScope scope, String[] classIdents) {
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("Cache" + this.getCacheAddress() + " disabled: classIdents=" + util.getList(classIdents) + ", scopeIdent=" + util.getObjectIdent(scope));
        }
    }

    private String getCacheAddress() {
        return "";
    }
}

