/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.meta;

import com.filenet.apiimpl.meta.ScopeKey;
import com.filenet.apiimpl.util.CacheMap;
import com.filenet.apiimpl.util.Subjects;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;

class AccessCache {
    private final CacheMap subjectScopes = new CacheMap();

    AccessCache() {
    }

    synchronized void setEnabled(boolean enabled) {
        this.subjectScopes.setEnabled(enabled);
    }

    synchronized boolean isAccessible(ScopeKey scopeKey, Subject subject) {
        Set scopeKeys = (Set)this.subjectScopes.getValue(subject);
        return scopeKeys != null && scopeKeys.contains(scopeKey);
    }

    synchronized void setAccessible(ScopeKey scopeKey, Subject subject) {
        HashSet<ScopeKey> scopeKeys = (HashSet<ScopeKey>)this.subjectScopes.getValue(subject);
        if (scopeKeys == null) {
            if (!subject.isReadOnly()) {
                subject = Subjects.clone(subject, true);
            }
            scopeKeys = new HashSet<ScopeKey>();
            this.subjectScopes.putValue(subject, scopeKeys);
        }
        scopeKeys.add(scopeKey);
    }

    synchronized void setTTL(long duration) {
        this.subjectScopes.setTTL(duration);
    }

    synchronized void clear() {
        this.subjectScopes.clear();
    }
}

