/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.jdbc;

import com.filenet.api.collection.DependentObjectList;
import com.filenet.api.collection.IndependentObjectSet;
import com.filenet.api.constants.PropertyState;
import com.filenet.api.core.EngineObject;
import com.filenet.api.core.IndependentObject;
import com.filenet.api.core.ObjectReference;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.property.Properties;
import com.filenet.api.property.Property;
import com.filenet.api.property.PropertyDependentObjectList;
import com.filenet.api.property.PropertyEngineObject;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.property.PropertyId;
import com.filenet.api.property.PropertyIndependentObjectSet;
import com.filenet.api.query.RepositoryRow;
import com.filenet.api.util.Id;
import com.filenet.api.util.UserContext;
import com.filenet.apiimpl.jdbc.Connection;
import com.filenet.apiimpl.jdbc.ResultSet;
import com.filenet.apiimpl.jdbc.RowData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import javax.security.auth.Subject;

public class RowDataDynamic
implements RowData {
    private ResultSet owner;
    private int count = 0;
    private Iterator iterator;
    private Object[] currentRow = null;
    private static final PropertyFilter UNEVAL_PF = new PropertyFilter();

    public RowDataDynamic(ResultSet owner, Iterator iterator) {
        this.iterator = iterator;
        this.owner = owner;
    }

    public void addRow(Object[] row) {
        this.currentRow = row;
    }

    public void afterLast() {
    }

    public void beforeFirst() {
    }

    public void beforeLast() {
    }

    public void close() {
    }

    public Object[] getAt(int atIndex) {
        return this.currentRow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNext() {
        Connection conn = this.owner.getConnection();
        Subject pushedSubject = conn.getSubject();
        UserContext uc = UserContext.get();
        uc.setLocale(conn.getLocale());
        try {
            if (pushedSubject != null) {
                uc.pushSubject(pushedSubject);
            }
            boolean bl = this.iterator.hasNext();
            return bl;
        }
        finally {
            if (pushedSubject != null) {
                uc.popSubject();
            }
        }
    }

    public boolean isAfterLast() {
        return false;
    }

    public boolean isBeforeFirst() {
        return false;
    }

    public boolean isDynamic() {
        return true;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean isFirst() {
        return false;
    }

    public boolean isLast() {
        return false;
    }

    public void moveRowRelative(int rowsToMove) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] next() throws SQLException {
        Connection conn = this.owner.getConnection();
        Subject pushedSubject = conn.getSubject();
        UserContext uc = UserContext.get();
        uc.setLocale(conn.getLocale());
        try {
            if (pushedSubject != null) {
                uc.pushSubject(pushedSubject);
            }
            this.currentRow = this.execSQL(this.iterator);
            ++this.count;
            Object[] objectArray = this.currentRow;
            return objectArray;
        }
        finally {
            if (pushedSubject != null) {
                uc.popSubject();
            }
        }
    }

    public int getCurrentRowNumber() {
        return this.count;
    }

    private Object[] execSQL(Iterator iter) throws SQLException {
        try {
            return this.execSQLInternal(iter, "|");
        }
        catch (EngineRuntimeException eRe) {
            SQLException sqlEx = new SQLException(eRe.getLocalizedMessage());
            sqlEx.initCause(eRe);
            throw sqlEx;
        }
    }

    private Object[] execSQLInternal(Iterator iter, String delimiter) {
        if (!iter.hasNext()) {
            return null;
        }
        RepositoryRow rr = (RepositoryRow)iter.next();
        Properties props = rr.getProperties();
        Object[] row = new Object[props.size()];
        Iterator propIter = props.iterator();
        int rowNum = 0;
        while (propIter.hasNext()) {
            Property property = (Property)propIter.next();
            if (property.getState() == PropertyState.UNEVALUATED) {
                if (property instanceof PropertyEngineObject) {
                    ((PropertyEngineObject)property).fetchIndependentObject(UNEVAL_PF);
                } else {
                    property.getObjectValue();
                }
            }
            if (property instanceof PropertyId) {
                Id idValue = property.getIdValue();
                row[rowNum] = idValue == null ? null : idValue.toString();
            } else if (property instanceof PropertyIndependentObjectSet) {
                IndependentObjectSet ios = property.getIndependentObjectSetValue();
                row[rowNum] = ios == null ? null : this.delimitMVP(delimiter, ios.iterator());
            } else if (property instanceof PropertyDependentObjectList) {
                DependentObjectList dol = property.getDependentObjectListValue();
                row[rowNum] = dol == null ? null : this.delimitMVP(delimiter, dol.iterator());
            } else if (property instanceof PropertyEngineObject) {
                PropertyEngineObject peo = (PropertyEngineObject)property;
                ObjectReference or = peo.getObjectReference();
                row[rowNum] = or == null ? null : or.getObjectIdentity();
            } else {
                row[rowNum] = property.getObjectValue();
                if (row[rowNum] instanceof Collection) {
                    row[rowNum] = this.delimitMVP(delimiter, ((Collection)row[rowNum]).iterator());
                }
            }
            ++rowNum;
        }
        return row;
    }

    private String delimitMVP(String delimiter, Iterator valueIter) {
        StringBuffer finalString = new StringBuffer();
        while (valueIter.hasNext()) {
            Object thisValue = valueIter.next();
            if (thisValue instanceof EngineObject) {
                thisValue = this.eoAsString((EngineObject)thisValue);
            }
            finalString.append((Object)(thisValue == null ? "" : thisValue));
            if (!valueIter.hasNext()) continue;
            finalString.append(delimiter);
        }
        return finalString.toString();
    }

    private String eoAsString(EngineObject eo) {
        IndependentObject io;
        ObjectReference or;
        String identity;
        if (eo == null) {
            return null;
        }
        if (eo instanceof IndependentObject && (identity = (or = (io = (IndependentObject)eo).getObjectReference()).getObjectIdentity()) != null) {
            return identity;
        }
        Properties properties = eo.getProperties();
        try {
            Id idValue = properties.getIdValue("Id");
            return idValue == null ? null : idValue.toString();
        }
        catch (EngineRuntimeException eReID) {
            try {
                Object nameValue = properties.getObjectValue("Name");
                return nameValue == null ? null : nameValue.toString();
            }
            catch (EngineRuntimeException eReNAME) {
                return null;
            }
        }
    }

    public void removeRow(int atIndex) {
    }

    public void setCurrentRow(int newIndex) {
    }

    public void setOwner(ResultSet rs) {
        this.owner = rs;
    }

    public int size() {
        return 0;
    }

    public ResultSet getOwner() {
        return this.owner;
    }

    static {
        UNEVAL_PF.setMaxRecursion(0);
        UNEVAL_PF.addIncludeProperty(1, null, null, ".fake.scalar.to.limit.results.", null);
    }
}

