/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.jdbc;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.jdbc.Field;
import java.sql.SQLException;

class ResultSetMetaData
implements java.sql.ResultSetMetaData {
    Field[] fields;

    public ResultSetMetaData(Field[] fields) {
        this.fields = fields;
    }

    public String getCatalogName(int column) throws SQLException {
        return "";
    }

    public String getColumnClassName(int column) throws SQLException {
        Field f = this.getField(column);
        switch (f.getSQLType()) {
            case -7: 
            case 16: {
                return "java.lang.Boolean";
            }
            case -6: {
                return "java.lang.Integer";
            }
            case 5: {
                return "java.lang.Integer";
            }
            case 4: {
                return "java.lang.Integer";
            }
            case -5: {
                return "java.math.BigInteger";
            }
            case 2: 
            case 3: {
                return "java.math.BigDecimal";
            }
            case 7: {
                return "java.lang.Float";
            }
            case 6: 
            case 8: {
                return "java.lang.Double";
            }
            case -1: 
            case 1: 
            case 12: {
                return "java.lang.String";
            }
            case -4: 
            case -3: 
            case -2: {
                return "java.lang.Byte";
            }
            case 91: {
                return "java.sql.Date";
            }
            case 92: {
                return "java.sql.Time";
            }
            case 93: {
                return "java.sql.Timestamp";
            }
        }
        return "java.lang.Object";
    }

    public int getColumnCount() {
        if (null != this.fields) {
            return this.fields.length;
        }
        return 0;
    }

    public int getColumnDisplaySize(int column) throws SQLException {
        return this.getColumnSize(column);
    }

    public String getColumnLabel(int column) throws SQLException {
        return this.getColumnName(column);
    }

    public String getColumnName(int column) throws SQLException {
        return this.getField(column).getName();
    }

    public int getColumnSize(int column) throws SQLException {
        return this.getField(column).getLength();
    }

    public int getColumnType(int column) throws SQLException {
        return this.getField(column).getSQLType();
    }

    public String getColumnTypeName(int column) throws SQLException {
        Field field = this.getField(column);
        int jdbcType = field.getSQLType();
        switch (jdbcType) {
            case -7: 
            case 16: {
                return "java.lang.Boolean";
            }
            case -6: {
                return "java.lang.Integer";
            }
            case 5: {
                return "java.lang.Integer";
            }
            case 4: {
                return "java.lang.Integer";
            }
            case -5: {
                return "java.math.BigInteger";
            }
            case 2: 
            case 3: {
                return "java.math.BigDecimal";
            }
            case 7: {
                return "java.lang.Float";
            }
            case 6: 
            case 8: {
                return "java.lang.Double";
            }
            case -1: 
            case 1: 
            case 12: {
                return "java.lang.String";
            }
            case -4: 
            case -3: 
            case -2: {
                return "java.lang.Byte";
            }
            case 91: {
                return "java.sql.Date";
            }
            case 92: {
                return "java.sql.Time";
            }
            case 93: {
                return "java.sql.Timestamp";
            }
        }
        return "java.lang.Object";
    }

    private Field getField(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.fields.length) {
            EngineRuntimeException eRe = new EngineRuntimeException(ExceptionCode.JDBC_RESULTSETMETADATA_COLUMN_INDEX_ERROR);
            SQLException sqlEx = new SQLException(eRe.getLocalizedMessage());
            sqlEx.initCause(eRe);
            throw sqlEx;
        }
        return this.fields[columnIndex - 1];
    }

    public int getPrecision(int column) {
        return 4;
    }

    public int getScale(int column) {
        return 0;
    }

    public String getSchemaName(int column) {
        return "";
    }

    public String getTableName(int column) throws SQLException {
        return this.getField(column).getTableName();
    }

    public boolean isAutoIncrement(int column) {
        return true;
    }

    public boolean isCaseSensitive(int column) throws SQLException {
        Field field = this.getField(column);
        int sqlType = field.getSQLType();
        switch (sqlType) {
            case -7: 
            case -6: 
            case -5: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 91: 
            case 92: 
            case 93: {
                return false;
            }
            case -1: 
            case 1: 
            case 12: {
                return false;
            }
        }
        return false;
    }

    public boolean isCurrency(int column) {
        return false;
    }

    public boolean isDefinitelyWritable(int column) throws SQLException {
        return this.isWritable(column);
    }

    public int isNullable(int column) {
        return 0;
    }

    public boolean isReadOnly(int column) throws SQLException {
        return this.getField(column).isReadOnly();
    }

    public boolean isSearchable(int column) throws SQLException {
        Field field = this.getField(column);
        String columnName = field.getName();
        return !columnName.equalsIgnoreCase("name");
    }

    public boolean isSigned(int column) throws SQLException {
        Field f = this.getField(column);
        int sqlType = f.getSQLType();
        switch (sqlType) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return false;
            }
            case 91: 
            case 92: 
            case 93: {
                return false;
            }
        }
        return false;
    }

    public boolean isWritable(int column) throws SQLException {
        return !this.isReadOnly(column);
    }

    public String toString() {
        StringBuffer toStringBuf = new StringBuffer();
        toStringBuf.append(super.toString());
        toStringBuf.append(" - Field level information: ");
        for (int i = 0; i < this.fields.length; ++i) {
            toStringBuf.append("\n\t");
            toStringBuf.append(this.fields[i].toString());
        }
        return toStringBuf.toString();
    }
}

