/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.jdbc;

import java.util.Vector;

public class QueryParser {
    private String queryStmnt;
    private int m_ptr = 0;
    private boolean m_selectparsed = false;
    private boolean m_fromparsed = false;
    private Vector vSelectList = null;
    private Vector vFromClasses = null;
    private boolean bhastop = false;
    private int topval = 0;
    private boolean bdistinct = false;

    public QueryParser(String queryStatement) {
        this.queryStmnt = queryStatement;
        this.vSelectList = new Vector();
        this.vFromClasses = new Vector();
    }

    public SelectItem[] getSelectList() {
        if (!this.m_selectparsed) {
            this.parseSelectStmnt();
        }
        SelectItem[] retArray = new SelectItem[this.vSelectList.size()];
        Object[] obj = this.vSelectList.toArray();
        for (int i = 0; i < obj.length; ++i) {
            retArray[i] = (SelectItem)obj[i];
        }
        return retArray;
    }

    public String[] getFromClasses() {
        if (!this.m_fromparsed) {
            this.parseFromClause();
        }
        String[] retArray = new String[this.vFromClasses.size()];
        Object[] obj = this.vFromClasses.toArray();
        for (int i = 0; i < obj.length; ++i) {
            retArray[i] = (String)obj[i];
        }
        return retArray;
    }

    public boolean hasDistinct() {
        if (!this.m_selectparsed) {
            this.parseSelectStmnt();
        }
        return this.bdistinct;
    }

    public boolean hasTop() {
        if (!this.m_selectparsed) {
            this.parseSelectStmnt();
        }
        return this.bhastop;
    }

    public int getTopValue() {
        if (!this.m_selectparsed) {
            this.parseSelectStmnt();
        }
        return this.topval;
    }

    private String nextWord() {
        StringBuffer buff = new StringBuffer();
        char c = this.queryStmnt.charAt(this.m_ptr);
        while (Character.isWhitespace(c)) {
            ++this.m_ptr;
            if (this.m_ptr >= this.queryStmnt.length()) break;
            c = this.queryStmnt.charAt(this.m_ptr);
        }
        if (this.m_ptr < this.queryStmnt.length()) {
            while (!Character.isWhitespace(c = this.queryStmnt.charAt(this.m_ptr++))) {
                buff.append(c);
                if (c != ',' && this.m_ptr < this.queryStmnt.length()) continue;
                break;
            }
        }
        return buff.toString();
    }

    private void parseSelectStmnt() {
        this.m_ptr = this.queryStmnt.toUpperCase().indexOf("SELECT");
        if (this.m_ptr < 0) {
            return;
        }
        this.m_ptr += 6;
        String lastword = null;
        SelectItem entry = new SelectItem();
        boolean bdone = false;
        boolean bdonecolumn = false;
        while (this.m_ptr < this.queryStmnt.length() && !bdone) {
            String nextword = this.nextWord();
            if (nextword != null && nextword.length() > 0) {
                if (nextword.equalsIgnoreCase("TOP")) {
                    this.bhastop = true;
                } else if (nextword.equalsIgnoreCase("ALL")) {
                    this.bdistinct = false;
                } else if (nextword.equalsIgnoreCase("DISTINCT")) {
                    this.bdistinct = true;
                } else if (!nextword.equalsIgnoreCase("PERCENT")) {
                    if (nextword.equalsIgnoreCase("FROM")) {
                        bdone = true;
                    } else if (nextword.equalsIgnoreCase(",")) {
                        bdonecolumn = true;
                    } else if (lastword != null && lastword.equalsIgnoreCase("TOP")) {
                        try {
                            int strval;
                            this.topval = strval = Integer.parseInt(nextword);
                        }
                        catch (NumberFormatException e) {}
                    } else if (!nextword.equalsIgnoreCase("AS")) {
                        int colpos = 0;
                        StringBuffer colbuff = new StringBuffer();
                        boolean inbracket = false;
                        entry.startsAt = this.m_ptr - nextword.length();
                        if (nextword.charAt(nextword.length() - 1) != ',') {
                            --entry.startsAt;
                        }
                        block9: while (colpos < nextword.length()) {
                            char c = nextword.charAt(colpos++);
                            switch (c) {
                                case '.': {
                                    if (!inbracket) {
                                        entry.tablename = colbuff.toString();
                                        colbuff = new StringBuffer();
                                        continue block9;
                                    }
                                    colbuff.append(c);
                                    continue block9;
                                }
                                case ',': {
                                    bdonecolumn = true;
                                    continue block9;
                                }
                                case '[': {
                                    if (colbuff.length() > 0) {
                                        entry.propName = colbuff.toString();
                                        colbuff = new StringBuffer();
                                    }
                                    inbracket = true;
                                    continue block9;
                                }
                                case ']': {
                                    if (entry.propName == null) {
                                        entry.propName = colbuff.toString();
                                    } else {
                                        entry.alias = colbuff.toString();
                                    }
                                    colbuff = new StringBuffer();
                                    inbracket = false;
                                    continue block9;
                                }
                            }
                            colbuff.append(c);
                        }
                        if (colbuff.length() > 0) {
                            if (entry.propName == null) {
                                entry.propName = colbuff.toString();
                            } else {
                                entry.alias = colbuff.toString();
                            }
                        }
                    }
                }
                lastword = nextword;
            }
            if (!bdonecolumn && !bdone || entry.propName == null) continue;
            this.vSelectList.add(entry);
            entry = new SelectItem();
            bdonecolumn = false;
        }
        this.m_selectparsed = true;
    }

    private void parseFromClause() {
        this.m_ptr = 0;
        boolean bNotFound = true;
        while (this.m_ptr < this.queryStmnt.length()) {
            String nextword = this.nextWord();
            if (nextword == null || nextword.length() <= 0 || !nextword.equalsIgnoreCase("FROM")) continue;
            bNotFound = false;
            break;
        }
        if (bNotFound) {
            return;
        }
        String lastword = null;
        boolean bdone = false;
        while (this.m_ptr < this.queryStmnt.length() && !bdone) {
            String nextword = this.nextWord();
            if (nextword == null || nextword.length() <= 0) continue;
            if (!(nextword.equalsIgnoreCase("AS") || nextword.equalsIgnoreCase("WITH") || nextword.equalsIgnoreCase("ON") || nextword.equalsIgnoreCase("CROSS") || nextword.equalsIgnoreCase("JOIN") || nextword.equalsIgnoreCase("INNER") || nextword.equalsIgnoreCase("OUTER") || nextword.equalsIgnoreCase("LEFT") || nextword.equalsIgnoreCase("RIGHT") || nextword.equalsIgnoreCase("FULL") || nextword.equalsIgnoreCase("="))) {
                int colpos = 0;
                StringBuffer tblbuff = new StringBuffer();
                block5: while (colpos < nextword.length()) {
                    char c = nextword.charAt(colpos++);
                    switch (c) {
                        case '(': 
                        case ')': {
                            continue block5;
                        }
                    }
                    tblbuff.append(c);
                }
                if (tblbuff.length() > 0) {
                    if (lastword == null) {
                        this.vFromClasses.add(tblbuff.toString());
                    } else if (lastword.equalsIgnoreCase("JOIN")) {
                        this.vFromClasses.add(tblbuff.toString());
                    }
                }
            }
            lastword = nextword;
        }
        this.m_fromparsed = true;
    }

    public static class SelectItem {
        public String propName = null;
        public String alias = null;
        public String tablename = null;
        public int startsAt = 0;
    }
}

