/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.exception;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ErrorRecord;
import com.filenet.api.exception.ErrorStack;
import com.filenet.api.exception.ExceptionCode;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;

public final class Exceptions {
    private Exceptions() {
    }

    public static EngineRuntimeException evaluate(Throwable e) {
        for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
            if (!(cause instanceof EngineRuntimeException)) continue;
            e = cause;
        }
        if (e instanceof EngineRuntimeException) {
            return (EngineRuntimeException)e;
        }
        return new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
    }

    public static String printStackTrace(Throwable e) {
        return Exceptions.printStackTrace(e, null, false);
    }

    public static String printStackTrace(Throwable e, String newline, boolean trim) {
        StringWriter writer = new StringWriter(8192);
        Exceptions.printStackTrace(e, writer, newline, trim);
        return writer.getBuffer().toString();
    }

    public static void printStackTrace(Throwable e, StringWriter writer, String newline, boolean trim) {
        StringBuffer buffer = writer.getBuffer();
        int start = buffer.length();
        PrintWriter printer = new PrintWriter((Writer)writer, false);
        e.printStackTrace(printer);
        printer.flush();
        if (trim) {
            int length;
            for (length = buffer.length(); length > start && Character.isWhitespace(buffer.charAt(length - 1)); --length) {
            }
            buffer.setLength(length);
        }
        if (newline != null) {
            int position = start;
            int increment = newline.length();
            int length = buffer.length();
            while (position < length) {
                char next;
                char current = buffer.charAt(position);
                char c = next = position == length - 1 ? (char)'\u0000' : buffer.charAt(position + 1);
                if (current == '\r' && next == '\n') {
                    buffer.replace(position, position + 2, newline);
                    position += increment;
                } else if (current == '\r' || current == '\n') {
                    buffer.replace(position, position + 1, newline);
                    position += increment;
                } else {
                    ++position;
                }
                length = buffer.length();
            }
        }
    }

    public static EngineRuntimeException indicateFailedBatchItem(EngineRuntimeException ere, int failedBatchItem) {
        if (failedBatchItem >= 0) {
            for (Throwable t = ere; t != null; t = t.getCause()) {
                if (!(t instanceof EngineRuntimeException)) continue;
                EngineRuntimeException thisERE = t;
                ErrorStack es = thisERE.getAsErrorStack();
                ErrorRecord[] ers = es.getErrorRecords();
                for (int ii = 0; ii < ers.length; ++ii) {
                    ErrorRecord er = ers[ii];
                    HashMap dTypes = er.getDiagnosticTypes();
                    dTypes.put("failedBatchItem", failedBatchItem);
                }
            }
        }
        return ere;
    }

    public static int detectFailedBatchItem(EngineRuntimeException ere) {
        for (Throwable t = ere; t != null; t = t.getCause()) {
            if (!(t instanceof EngineRuntimeException)) continue;
            EngineRuntimeException thisERE = t;
            ErrorStack es = thisERE.getAsErrorStack();
            ErrorRecord[] ers = es.getErrorRecords();
            for (int ii = 0; ii < ers.length; ++ii) {
                ErrorRecord er = ers[ii];
                HashMap dTypes = er.getDiagnosticTypes();
                Object fbi = dTypes.get("failedBatchItem");
                if (fbi instanceof Integer) {
                    return (Integer)fbi;
                }
                if (!(fbi instanceof String)) continue;
                try {
                    return Integer.parseInt((String)fbi);
                }
                catch (NumberFormatException e) {
                    return -1;
                }
            }
        }
        return -1;
    }
}

