/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.exception;

import com.filenet.apiimpl.util.BaseLogger;
import com.filenet.apiimpl.util.SubSystem;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ExceptionContext
implements Serializable {
    private static Map mapNameToExceptionContextInstance = new HashMap();
    private static final String RES_BASE_NAME = "res/ExceptionContext";
    private static final BaseLogger stLogger = BaseLogger.getBaseLogger(ExceptionContext.class, SubSystem.API);
    public static final Locale stDefaultLocale = Locale.getDefault();
    protected String mKey;
    protected String mEnglishString;
    public static final ExceptionContext API_CONNECTION_PARAMETER_NOT_SUPPORTED_FOR_URI = new ExceptionContext("API_CONNECTION_PARAMETER_NOT_SUPPORTED_FOR_URI", "Parameter not supported for {0}.");
    public static final ExceptionContext API_DISALLOW_INITIAL_VER_TO_CANCEL_CHECKOUT = new ExceptionContext("API_DISALLOW_INITIAL_VER_TO_CANCEL_CHECKOUT", "Cannot perform CancelCheckout on the initial version.");
    public static final ExceptionContext API_INVALID_CONFIGURATION_PARAMETER_VALUE_TYPE = new ExceptionContext("API_INVALID_CONFIGURATION_PARAMETER_VALUE_TYPE", "Invalid type of value. Expected type is one of: {0}. Actual type was {1}.");
    public static final ExceptionContext API_INVALID_CONFIGURATION_PARAMETER_STRING_VALUE = new ExceptionContext("API_INVALID_CONFIGURATION_PARAMETER_STRING_VALUE", "Unable to parse string value for {0}: {1}.");
    public static final ExceptionContext API_SAVE_BEFORE_REFRESH = new ExceptionContext("API_SAVE_BEFORE_REFRESH", "A new object must be saved before it can be refreshed.");
    public static final ExceptionContext API_NO_CONTENT_ELEMENTS = new ExceptionContext("API_NO_CONTENT_ELEMENTS", "Document has no content elements.");
    public static final ExceptionContext CBR_NOT_ENABLED = new ExceptionContext("CBR_NOT_ENABLED", "CBR has not been enabled for this object store.");
    public static final ExceptionContext CBR_NO_VERITY_DOMAIN_CONFIGURATION = new ExceptionContext("CBR_NO_VERITY_DOMAIN_CONFIGURATION", "A Verity Domain Configuration object must first be configured.");
    public static final ExceptionContext CBR_VERITY_PARTITIONING_PROP_INVALID_DATA_TYPE = new ExceptionContext("CBR_VERITY_PARTITIONING_PROP_INVALID_DATA_TYPE", "Verity partitioning property value must reference to a property template with date as data type.");
    public static final ExceptionContext CBR_VERITY_PARTITIONING_PROP_INVALID_SETTABILITY = new ExceptionContext("CBR_VERITY_PARTITIONING_PROP_INVALID_SETTABILITY", "Verity partitioning property value must reference to a property template with settability set to SETTABLE_ONLY_ON_CREATE.");
    public static final ExceptionContext CBR_VERITY_PARTITIONING_PROP_INVALID_SETTABILITY_PROPDEF = new ExceptionContext("CBR_VERITY_PARTITIONING_PROP_INVALID_SETTABILITY_PROPDEF", "Property {0} cannot be used as partitioning property because class {1} does not define the property''s settability to SETTABLE_ONLY_ON_CREATE.");
    public static final ExceptionContext CBR_VERITY_PARTITIONING_PROPTEMPLATE_SYMBOLIC_NAME = new ExceptionContext("CBR_VERITY_PARTITIONING_PROPTEMPLATE_SYMBOLIC_NAME", "Property Template is assigned as CBR partitioning property in object store, so changing symbolic name value is not allowed.");
    public static final ExceptionContext CBR_VERITY_PARTITIONING_PROPTEMPLATE_SEATTABILITY = new ExceptionContext("CBR_VERITY_PARTITIONING_PROPTEMPLATE_SEATTABILITY", "Property Template is assigned as CBR partitioning property in object store, so settability value must be SETTABLE_ONLY_ON_CREATE.");
    public static final ExceptionContext CBR_VERITY_PARTITIONING_CLASSDEFINITION_SEATTABILITY = new ExceptionContext("CBR_VERITY_PARTITIONING_CLASSDEFINITION_SEATTABILITY", "CRB is enabled and Property Definition {0} is assigned as partitioning property in object store, so settability value must be SETTABLE_ONLY_ON_CREATE.");
    public static final ExceptionContext CBR_TEXTSEARCH_PARTITIONING_PROP_INVALID_DATA_TYPE = new ExceptionContext("CBR_TEXTSEARCH_PARTITIONING_PROP_INVALID_DATA_TYPE", "For the {0} object store, the attempt to specify the following partition property with an invalid data type for IBM Content Search Services indexes failed: {1}. Revise your code to specify a partition property with a Date or String data type.");
    public static final ExceptionContext CBR_TEXTSEARCH_PARTITIONING_MULTIPLE_DATE_PROPS = new ExceptionContext("CBR_TEXTSEARCH_PARTITIONING_MULTIPLE_DATE_PROPS", "For the {0} object store, the attempt to specify the following partition properties with a Date data type for IBM Content Search Services indexes failed: {1}. Revise your code to specify at most one partition property with a Date data type.");
    public static final ExceptionContext CBR_TEXTSEARCH_PARTITIONING_MULTIPLE_STRING_PROPS = new ExceptionContext("CBR_TEXTSEARCH_PARTITIONING_MULTIPLE_STRING_PROPS", "For the {0} object store, the attempt to specify the following partition properties with a String data type for IBM Content Search Services indexes failed: {1}. Revise your code to specify at most one partition property with a String data type.");
    public static final ExceptionContext CBR_TEXTSEARCH_PARTITIONING_PROP_INVALID_SETTABILITY_PROPDEF = new ExceptionContext("CBR_TEXTSEARCH_PARTITIONING_PROP_INVALID_SETTABILITY_PROPDEF", "Property {0} cannot be used as partitioning property because class {1} does not define the settability for the property as SETTABLE_ONLY_ON_CREATE.");
    public static final ExceptionContext CBR_TS_INDEX_NOT_FOUND_FORINDEXING = new ExceptionContext("CBR_TS_INDEX_NOT_FOUND_FORINDEXING", "The attempt to delete the index failed for the server that runs on the {0}:{1} host and port. Verify that the file permissions for the index file and directory permit access to the server operating system user account. Also verify that the index directory is accessible to the server across the network. If this error reoccurs after you fix the problem, or if the index file does not exist, call IBM Software Support.");
    public static final ExceptionContext CBR_TS_INDEX_NOT_FOUND_FORQUERY = new ExceptionContext("CBR_TS_INDEX_NOT_FOUND_FORQUERY", "The attempt to retrieve information from the index for running a query failed for the server that runs on the {0}:{1} host and port. Verify that the file permissions for the index file and directory permit access to the server operating system user account. Also verify that the index directory is accessible to the server across the network. If this error reoccurs after repeated attempts to fix the problem, or if the index file does not exist, call IBM Software Support.");
    public static final ExceptionContext CBR_TS_INDEX_NOT_FOUND_FORDELETING = new ExceptionContext("CBR_TS_INDEX_NOT_FOUND_FORDELETING", "The attempt to delete the index failed for the server that runs on the {0}:{1} host and port. Verify that the file permissions for the index file and directory permit access to the server operating system user account. Also verify that the index directory is accessible to the server across the network. If this error reoccurs after you fix the problem, or if the index file does not exist, call IBM Software Support.");
    public static final ExceptionContext CBR_TS_TEXT_SEARCH_SERVER_NOT_STARTED = new ExceptionContext("CBR_TS_TEXT_SEARCH_SERVER_NOT_STARTED", "The server is not started. Start the server. For information about starting the server, see \"Starting or stopping IBM Content Search Services servers\" in the IBM FileNet P8 information center.");
    public static final ExceptionContext CBR_TS_NULL_CONNECTION_INSTANCE = new ExceptionContext("CBR_TS_NULL_CONNECTION_INSTANCE", "Application code that calls Content Engine API methods attempted to pass a null CSEConnection instance for an IBM Content Search Services server. Call IBM Software Support.");
    public static final ExceptionContext CBR_TS_BAD_QUERY_ATTRIBUTES = new ExceptionContext("CBR_TS_BAD_QUERY_ATTRIBUTES", "One or more of the following search attribute values are not valid: Summary: {0}, Result limit: {1}, Language: {2}, Page number: {3}, Ranking: {4}. See the p8_server_error.log file for the error message stack that includes this error for more information on the specific cause of the error. For information about the location of this log, see \"Viewing the IBM FileNet P8 log files\" in the IBM FileNet P8 information center. If you cannot determine the cause, contact IBM Software Support.");
    public static final ExceptionContext CBR_TS_QUERY_TIMED_OUT = new ExceptionContext("CBR_TS_QUERY_TIMED_OUT", "The search timed out after {0} milliseconds. Increase the timeout limit for the search. If this error occurs again after you increase the timeout limit, the server might not be able to finish running the search for the following reasons: (a) The search expression might have invalid syntax that the server is not detecting as invalid; (b) The search expression might be too complex; (c) The server might not be properly optimized for this type of search; or (d) The server might be too busy. Submit the query again after you verify your search expression syntax and wait until the server is not busy. For information about search expression syntax, see \"SQL Syntax Reference\" in the IBM FileNet P8 information center. If the error occurs again, simplify your search expression or reconfigure your server to improve performance. For information about optimizing server performance, see the IBM FileNet P8 Performance Tuning Guide.");
    public static final ExceptionContext CBR_TS_QUERY_BAD_SYNTAX = new ExceptionContext("CBR_TS_QUERY_BAD_SYNTAX", "The syntax for the search expression is not valid. Revise the search expression to use correct syntax. For information about search expression syntax, see \"SQL Syntax Reference\" in the IBM FileNet P8 information center.");
    public static final ExceptionContext CBR_TS_DUPLICATE_INDEX_NAME = new ExceptionContext("CBR_TS_DUPLICATE_INDEX_NAME", "The server that runs on the {0}:{1} host and port attempted to use the following name for a newly created index: {2}. Another index with the same name exists. Contact IBM Software Support.");
    public static final ExceptionContext CBR_TS_INDEX_NULL_DOCID = new ExceptionContext("CBR_TS_INDEX_NULL_DOCID", "The request to index an object failed because of the missing object id. The object belongs to the {1} class in the {0} object store.  Contact IBM Software Support.");
    public static final ExceptionContext CBR_TS_INDEX_NULL_OSID = new ExceptionContext("CBR_TS_INDEX_NULL_OSID", "The request to index the object {0} failed because of the missing object store id. The object belongs to the {1} class. Contact IBM Software Support.");
    public static final ExceptionContext CBR_TS_INDEX_CONTENT_TYPE = new ExceptionContext("CBR_TS_INDEX_CONTENT_TYPE", "The request to index object {1} failed because of the missing content type. The object belongs to the {2} class in the {0} object store. Contact IBM Software Support.");
    public static final ExceptionContext CBR_TS_INDEX_NULL_QUERY_CONDITION = new ExceptionContext("CBR_TS_INDEX_NULL_QUERY_CONDITION", "The request to run a text search failed because of the missing query condition. Supply the missing query condition.");
    public static final ExceptionContext CBR_TS_INDEX_CTOR_DOC_ASSOCIATION_FAILED = new ExceptionContext("CBR_TS_INDEX_CTOR_DOC_ASSOCIATION_FAILED", "The constructor identification process failed. See the p8_server_error.log file for the error message stack that includes this error for more information on the specific cause of the error. For information about the location of this log, see \"Viewing the IBM FileNet P8 log files\" in the IBM FileNet P8 information center. If you cannot determine the specific cause of the error, restart the server. If the error continues to occur, contact IBM Software Support.");
    public static final ExceptionContext CBR_TS_BATCH_ALREADY_STARTED = new ExceptionContext("CBR_TS_BATCH_ALREADY_STARTED", "beginBatch cannot be called when a batch is already in progress.");
    public static final ExceptionContext CBR_TS_BATCH_NOT_YET_STARTED = new ExceptionContext("CBR_TS_BATCH_NOT_YET_STARTED", "A batching operation cannot be called when a batch is not in progress.");
    public static final ExceptionContext CBR_TS_BATCH_SIZE_MISMATCH = new ExceptionContext("CBR_TS_BATCH_SIZE_MISMATCH", "endBatch has detected an internal batch queuing error.");
    public static final ExceptionContext CBR_TS_BATCH_OVERFLOW = new ExceptionContext("CBR_TS_BATCH_OVERFLOW", "The batch size specified in beginBatch has been exceeded.");
    public static final ExceptionContext CBR_TS_UNKNOWN_LEASE_EXPIRATION = new ExceptionContext("CBR_TS_UNKNOWN_LEASE_EXPIRATION", "The IBM Content Search Services index is in an unknown state because it does not contain a lease expiration time for the current index server. Because reindexing will resume at a later time, no action is required.");
    public static final ExceptionContext CBR_TS_LEASE_NOT_EXPIRED_FOR_FAILED_SERVER = new ExceptionContext("CBR_TS_LEASE_NOT_EXPIRED_FOR_FAILED_SERVER", "The IBM Content Search Services server {0} is unavailable or in a failed state and the current lease has not yet expired. Because reindexing will resume at a later time, no action is required.");
    public static final ExceptionContext CBR_TS_LEASE_NOT_EXPIRED_FOR_OVERLOADED_SERVER = new ExceptionContext("CBR_TS_LEASE_NOT_EXPIRED_FOR_OVERLOADED_SERVER", "The IBM Content Search Services server {0} is overloaded with more indexes than server {1}, and its current lease has not yet expired. When the lease expires, the index data will be reassigned to a server that is not overloaded. Because reindexing will resume at a later time, no action is required.");
    public static final ExceptionContext CBR_TS_NO_AVAILABLE_INDEX_SERVERS = new ExceptionContext("CBR_TS_NO_AVAILABLE_INDEX_SERVERS", "There are no available indexing IBM Content Search Services servers. Verify that the servers are running and that at least one server is in a mode that allows indexing (its TextSearchServerStatus property is set to ENABLED and its TextSearchServerMode property is set to INDEX).");
    public static final ExceptionContext CBR_TS_BATCH_RETRY = new ExceptionContext("CBR_TS_BATCH_RETRY", "Content Engine failed to  index batch \"{0}\" because of the following error: \"{1}\". For information about the location of this log,  see \"Viewing the IBM FileNet P8 log files\" in the IBM FileNet P8 information center. If you cannot determine the cause of the error, contact IBM Software Support.");
    public static final ExceptionContext CBR_TS_INVALID_INDEX_AREA_STATUS_CHANGE_TO_OPEN = new ExceptionContext("CBR_TS_INVALID_INDEX_AREA_STATUS_CHANGE_TO_OPEN", "To change the resource status (ResourceStatus property) of the IBM Content Search Services index area from a FULL or CLOSED state to an OPEN state, verify that the MaxIndexes property of the index area is greater than the current number of indexes in the index area or that at least one index within the index area has a resource status of OPEN. Then, change the ResourceStatus property of the index area to OPEN.");
    public static final ExceptionContext CBR_TS_STRING_PARTITION_PROP_INVALID_DATA_TYPE = new ExceptionContext("CBR_TS_STRING_PARTITION_PROP_INVALID_DATA_TYPE", "For the {0} object store, the attempt to specify the following property as a String partition property for IBM Content Search Services indexes failed: {1}. Revise your code to specify a partition property with a String data type.");
    public static final ExceptionContext CBR_TS_DATE_PARTITION_PROP_INVALID_DATA_TYPE = new ExceptionContext("CBR_TS_DATE_PARTITION_PROP_INVALID_DATA_TYPE", "For the {0} object store, the attempt to specify the following property as a Date partition property for IBM Content Search Services indexes failed: {1}. Revise your code to specify a partition property with a Date data type.");
    public static final ExceptionContext CBR_TS_BATCH_ERROR = new ExceptionContext("CBR_TS_BATCH_ERROR", "The text for a Content Engine object in batch \"{0}\" could not be indexed for the following reason: \"{1}\". See the p8_server_error.log file for the error message stack that includes this error for more information on the specific cause of the error. For information about the location of this log, see \"Viewing the IBM FileNet P8 log files\" in the IBM FileNet P8 information center. If you cannot determine the specific cause of the error, contact IBM Software Support.");
    public static final ExceptionContext CBR_TS_OPTIMIZED_INDEX_FAILED = new ExceptionContext("CBR_TS_OPTIMIZED_INDEX_FAILED", "The attempt to optimize the index failed. Verify that the file permissions for the index file and directory are such that these items are accessible to the server operating system user account. Also verify that the index directory is accessible to the server across the network. If this error recurs after you fix the problem, or if the index file does not exist, contact IBM Software Support.");
    public static final ExceptionContext CBR_TS_BATCH_WARNING = new ExceptionContext("CBR_TS_BATCH_WARNING", "The following warning applies to a Content Engine object within the \"{1}\" batch: \"{0}\".");
    public static final ExceptionContext CONTENT_CACHE_ACCESS_COUNTERS_FILES = new ExceptionContext("CONTENT_CACHE_ACCESS_COUNTERS_FILES", "Failed to access either or both the master or secondary counters files.");
    public static final ExceptionContext CONTENT_CACHE_ACCESS_PRUNE_LRU = new ExceptionContext("CONTENT_CACHE_ACCESS_PRUNE_LRU", "Failed to access the prune LRU list file.");
    public static final ExceptionContext CONTENT_CACHE_AREA_FULL = new ExceptionContext("CONTENT_CACHE_AREA_FULL", "Cache area is full.");
    public static final ExceptionContext CONTENT_CACHE_AREA_NOT_OPEN = new ExceptionContext("CONTENT_CACHE_AREA_NOT_OPEN", "Cache area is not open.");
    public static final ExceptionContext CONTENT_CACHE_AREA_NOT_OPERATIONAL = new ExceptionContext("CONTENT_CACHE_AREA_NOT_OPERATIONAL", "Cache area is not operational (clearing or not fully created).");
    public static final ExceptionContext CONTENT_CACHE_BACKGROUND_WRITE = new ExceptionContext("CONTENT_CACHE_BACKGROUND_WRITE", "Failed to write to file in background.");
    public static final ExceptionContext CONTENT_CACHE_CLEAR_COUNTERS_FILE = new ExceptionContext("CONTENT_CACHE_CLEAR_COUNTERS_FILE", "Failed to clear a counters file.");
    public static final ExceptionContext CONTENT_CACHE_CLEAR_ELEMENT = new ExceptionContext("CONTENT_CACHE_CLEAR_ELEMENT", "Failed to clear the element or buddy file {0}.");
    public static final ExceptionContext CONTENT_CACHE_CLEARING_UNDERWAY = new ExceptionContext("CONTENT_CACHE_CLEARING_UNDERWAY", "The CacheStatus cannot be modified while a clearing is underway.");
    public static final ExceptionContext CONTENT_CACHE_CLOSE_BUDDY_FILE = new ExceptionContext("CONTENT_CACHE_CLOSE_BUDDY_FILE", "Failed to close the buddy file for object {0}, element sequence {1}.");
    public static final ExceptionContext CONTENT_CACHE_COMPLETE_UPLOAD = new ExceptionContext("CONTENT_CACHE_COMPLETE_UPLOAD", "Failed to complete the upload of content for object {0}, element sequence {1}.");
    public static final ExceptionContext CONTENT_CACHE_CONTINUED_UPLOAD_LENGTH_MISMATCH = new ExceptionContext("CONTENT_CACHE_CONTINUED_UPLOAD_LENGTH_MISMATCH", "Cannot continue the upload from a previous request because the reopened file length {1} is not the same as the previous offset {2}.  Upload file {0}.");
    public static final ExceptionContext CONTENT_CACHE_CREATE_BUDDY_FILE = new ExceptionContext("CONTENT_CACHE_CREATE_BUDDY_FILE", "Failed to create the buddy file for object {0}, element sequence {1}.");
    public static final ExceptionContext CONTENT_CACHE_CREATE_ELEMENT_FILE = new ExceptionContext("CONTENT_CACHE_CREATE_ELEMENT_FILE", "Failed to create the element file for object {0}, element sequence {1}.");
    public static final ExceptionContext CONTENT_CACHE_CREATE_MASTER_COUNTERS_FILE = new ExceptionContext("CONTENT_CACHE_CREATE_MASTER_COUNTERS_FILE", "Failed to create the master counters file.");
    public static final ExceptionContext CONTENT_CACHE_ELEMENT_ABORTING = new ExceptionContext("CONTENT_CACHE_ELEMENT_ABORTING", "The population of the content is aborting for object {0}, element sequence {1}.");
    public static final ExceptionContext CONTENT_CACHE_ELEMENT_BUSY = new ExceptionContext("CONTENT_CACHE_ELEMENT_BUSY", "The element is currently busy being handled for some other purpose.  Object {0}, element sequence {1}.");
    public static final ExceptionContext CONTENT_CACHE_ELEMENT_DATE_MISMATCH = new ExceptionContext("CONTENT_CACHE_ELEMENT_DATE_MISMATCH", "The currently cached element is invalid because the create date does not match what is in the database.  Object {0}, element sequence {1}.");
    public static final ExceptionContext CONTENT_CACHE_ELEMENT_FILE_MISSING = new ExceptionContext("CONTENT_CACHE_ELEMENT_FILE_MISSING", "The element file is missing for object {0}, element sequence {1}.");
    public static final ExceptionContext CONTENT_CACHE_ELEMENT_FILE_SIZE_MISMATCH = new ExceptionContext("CONTENT_CACHE_ELEMENT_FILE_SIZE_MISMATCH", "There is a mismatch between the element file size and the size recorded in the buddy file for object {0}, element sequence {1}.");
    public static final ExceptionContext CONTENT_CACHE_ELEMENT_INVALID_AGE = new ExceptionContext("CONTENT_CACHE_ELEMENT_INVALID_AGE", "The element is considered invalid because it has been left in an incomplete state for the maximum time.  Object {0}, element sequence {1}.");
    public static final ExceptionContext CONTENT_CACHE_EXIT_CLEARING = new ExceptionContext("CONTENT_CACHE_EXIT_CLEARING", "Failed to exit the clearing state.");
    public static final ExceptionContext CONTENT_CACHE_FETCH_DIRECTORY_LISTING = new ExceptionContext("CONTENT_CACHE_FETCH_DIRECTORY_LISTING", "Failed to fetch the file list for the content directory {0}.");
    public static final ExceptionContext CONTENT_CACHE_FETCH_ELEMENT_FILE_SIZE = new ExceptionContext("CONTENT_CACHE_FETCH_ELEMENT_FILE_SIZE", "Failed to fetch the element file size for object {0}, element sequence {1}.");
    public static final ExceptionContext CONTENT_CACHE_INITIALIZE_POPULATION = new ExceptionContext("CONTENT_CACHE_INITIALIZE_POPULATION", "Failed to initialize the population of the content for object {0}, element sequence {1}.");
    public static final ExceptionContext CONTENT_CACHE_LOAD_BUDDY_FILE = new ExceptionContext("CONTENT_CACHE_LOAD_BUDDY_FILE", "Failed to load the contents of the buddy file for object {0}, element sequence {1}.");
    public static final ExceptionContext CONTENT_CACHE_LOAD_DIRECTORY_CONTROL = new ExceptionContext("CONTENT_CACHE_LOAD_DIRECTORY_CONTROL", "Failed to load the contents of the control file for content directory {0}.");
    public static final ExceptionContext CONTENT_CACHE_LOST_GLOBAL_OWNERSHIP = new ExceptionContext("CONTENT_CACHE_LOST_GLOBAL_OWNERSHIP", "Lost ownership of an operation across the content directories.");
    public static final ExceptionContext CONTENT_CACHE_MANAGE_COUNTERS_SWEEP = new ExceptionContext("CONTENT_CACHE_MANAGE_COUNTERS_SWEEP", "Failed to enter or exit a counters file sweep period.");
    public static final ExceptionContext CONTENT_CACHE_MONITOR_GLOBAL = new ExceptionContext("CONTENT_CACHE_MONITOR_GLOBAL", "Failed to monitor the progress of an operation over the content directories.");
    public static final ExceptionContext CONTENT_CACHE_MOVE_INBOUND_BUDDY_INVALID = new ExceptionContext("CONTENT_CACHE_MOVE_INBOUND_BUDDY_INVALID", "Cannot move the inbound file because the buddy file is invalid or a different checksum than expected.  Object {0}, element sequence {1}.");
    public static final ExceptionContext CONTENT_CACHE_MOVE_INBOUND_MISSING = new ExceptionContext("CONTENT_CACHE_MOVE_INBOUND_MISSING", "Cannot move the inbound file because the inbound file no longer exists.  Object {0}, element sequence {1}.");
    public static final ExceptionContext CONTENT_CACHE_MOVE_INBOUND_REAL_EXISTS = new ExceptionContext("CONTENT_CACHE_MOVE_INBOUND_REAL_EXISTS", "Cannot move the inbound file because the real file already exists.  Object {0}, element sequence {1}.");
    public static final ExceptionContext CONTENT_CACHE_OPEN_ELEMENT_FILE = new ExceptionContext("CONTENT_CACHE_OPEN_ELEMENT_FILE", "Failed to open the element file for object {0}, element sequence {1}.");
    public static final ExceptionContext CONTENT_CACHE_POPULATING_OR_MONITORING = new ExceptionContext("CONTENT_CACHE_POPULATING_OR_MONITORING", "Failed to populate the content or monitor the population.  Object {0}, element sequence {1}.");
    public static final ExceptionContext CONTENT_CACHE_POPULATION_BUDDY_INVALID_OR_ABORTING = new ExceptionContext("CONTENT_CACHE_POPULATION_BUDDY_INVALID_OR_ABORTING", "The monitoring of the population is being aborted because the buddy file is invalid or it is being aborted by another process.  Object {0}, element sequence {1}.");
    public static final ExceptionContext CONTENT_CACHE_POPULATION_ELEMENT_ALREADY_CREATED = new ExceptionContext("CONTENT_CACHE_POPULATION_ELEMENT_ALREADY_CREATED", "The element file had already been created while attempting to populate the content for object {0}, element sequence {1}.");
    public static final ExceptionContext CONTENT_CACHE_POPULATION_NO_ACTIVITY = new ExceptionContext("CONTENT_CACHE_POPULATION_NO_ACTIVITY", "The population of the content failed to make any progress.  It may be abandoned.  Object {0}, element sequence {1}.");
    public static final ExceptionContext CONTENT_CACHE_POPULATION_READ_SOURCE_AREA = new ExceptionContext("CONTENT_CACHE_POPULATION_READ_SOURCE_AREA", "Failed to read from the source area to populate the content for object {0}, element sequence {1}.");
    public static final ExceptionContext CONTENT_CACHE_PROCESS_DIRECTORY = new ExceptionContext("CONTENT_CACHE_PROCESS_DIRECTORY", "Failed to process the content directory {0}.");
    public static final ExceptionContext CONTENT_CACHE_PROCESS_INVALID = new ExceptionContext("CONTENT_CACHE_PROCESS_INVALID", "Failed to process a content element or individual file as invalid.");
    public static final ExceptionContext CONTENT_CACHE_PRUNE_DIRECTORY = new ExceptionContext("CONTENT_CACHE_PRUNE_DIRECTORY", "Failed to prune the content directory {0}.");
    public static final ExceptionContext CONTENT_CACHE_PRUNE_ELEMENT = new ExceptionContext("CONTENT_CACHE_PRUNE_ELEMENT", "Failed to prune the element for object {0}, element sequence {1}.");
    public static final ExceptionContext CONTENT_CACHE_READ_ELEMENT_FILE = new ExceptionContext("CONTENT_CACHE_READ_ELEMENT_FILE", "Failed to read from the element file for object {0}, element sequence {1}.");
    public static final ExceptionContext CONTENT_CACHE_REAP_FETCH_INBOUND_LISTING = new ExceptionContext("CONTENT_CACHE_REAP_FETCH_INBOUND_LISTING", "Failed to fetch the file list for the inbound directory.");
    public static final ExceptionContext CONTENT_CACHE_REAP_FETCH_OUTBOUND_LISTING = new ExceptionContext("CONTENT_CACHE_REAP_FETCH_OUTBOUND_LISTING", "Failed to fetch the file list for the outbound directory.");
    public static final ExceptionContext CONTENT_CACHE_REFRESH_CONTROL_FILE = new ExceptionContext("CONTENT_CACHE_REFRESH_CONTROL_FILE", "Failed to save or load the updated contents of a control file.");
    public static final ExceptionContext CONTENT_CACHE_RENAME_UPLOAD_FILE = new ExceptionContext("CONTENT_CACHE_RENAME_UPLOAD_FILE", "Failed to rename the upload file.  Object {0}, element sequence {1}.");
    public static final ExceptionContext CONTENT_CACHE_RENAME_SINGLE_UPLOAD_STITCH = new ExceptionContext("CONTENT_CACHE_RENAME_SINGLE_UPLOAD_STITCH", "Cannot rename single file to stitch from [{0}] to [{1}].");
    public static final ExceptionContext CONTENT_CACHE_REOPEN_CONTROL_FILE_WRITABLE = new ExceptionContext("CONTENT_CACHE_REOPEN_CONTROL_FILE_WRITABLE", "Failed to re-open control file as writable.");
    public static final ExceptionContext CONTENT_CACHE_SAVE_BUDDY_FILE = new ExceptionContext("CONTENT_CACHE_SAVE_BUDDY_FILE", "Failed to save the contents of the buddy file for object {0}, element sequence {1}.");
    public static final ExceptionContext CONTENT_CACHE_SKIP_ELEMENT_FILE = new ExceptionContext("CONTENT_CACHE_SKIP_ELEMENT_FILE", "Failed to skip past the previously read bytes in the element file for object {0}, element sequence {1}.");
    public static final ExceptionContext CONTENT_CACHE_STREAM_OPEN_ELEMENT_MAX_RETRIES = new ExceptionContext("CONTENT_CACHE_STREAM_OPEN_ELEMENT_MAX_RETRIES", "Failed to open the element file after the maximum retries.  Object {0}, element sequence {1}.");
    public static final ExceptionContext CONTENT_CACHE_STREAM_POPULATION_SIZE_MISMATCH = new ExceptionContext("CONTENT_CACHE_STREAM_POPULATION_SIZE_MISMATCH", "Element file failed to reach the size of available data according to the population.  Object {0}, element sequence {1}.");
    public static final ExceptionContext CONTENT_CACHE_STREAM_READ_POPULATED_MAX_RETRIES = new ExceptionContext("CONTENT_CACHE_STREAM_READ_POPULATED_MAX_RETRIES", "After the maximum retries, failed to read all element file data populated so far.  Object {0}, element sequence {1}.");
    public static final ExceptionContext CONTENT_CACHE_STREAM_SKIP_SIZE_MISMATCH = new ExceptionContext("CONTENT_CACHE_STREAM_SKIP_SIZE_MISMATCH", "Element file size {2}, is not large enough to skip past the size {3}, of data read in previous requests.  Object {0}, element sequence {1}.");
    public static final ExceptionContext CONTENT_CACHE_SWEEP_ELEMENT = new ExceptionContext("CONTENT_CACHE_SWEEP_ELEMENT", "Failed to process an element for the sweep operation.  Object {0}, element sequence {1}.");
    public static final ExceptionContext CONTENT_CACHE_SYNCHRONIZE_ELEMENT_FILE = new ExceptionContext("CONTENT_CACHE_SYNCHRONIZE_ELEMENT_FILE", "Failed to synchronize the element file contents for object {0}, element sequence {1}.");
    public static final ExceptionContext CONTENT_CACHE_UPLOAD_BUDDY_WRITTEN = new ExceptionContext("CONTENT_CACHE_UPLOAD_BUDDY_WRITTEN", "The upload cannot continue because the buddy file was already written.  Object {0}, element sequence {1}.");
    public static final ExceptionContext CONTENT_CACHE_UPLOAD_FILE_EXISTS = new ExceptionContext("CONTENT_CACHE_UPLOAD_FILE_EXISTS", "The upload file {0} already exists.");
    public static final ExceptionContext CONTENT_CACHE_WRITE_ELEMENT_FILE = new ExceptionContext("CONTENT_CACHE_WRITE_ELEMENT_FILE", "Failed to write to the element file for object {0}, element sequence {1}.");
    public static final ExceptionContext CONTENT_CA_COOKIE_EMPTY_NAME_VALUE = new ExceptionContext("CONTENT_CA_COOKIE_EMPTY_NAME_VALUE", "Invalid name/value pair; empty name or value: {0}.");
    public static final ExceptionContext CONTENT_CA_COOKIE_MISSING_EQUALS = new ExceptionContext("CONTENT_CA_COOKIE_MISSING_EQUALS", "Invalid name/value pair; missing equals sign: {0}.");
    public static final ExceptionContext CONTENT_CA_SCRUB_FILE = new ExceptionContext("CONTENT_CA_SCRUB_FILE", "An error occured while scrubbing file with pattern: [{0}].");
    public static final ExceptionContext CONTENT_CA_SCRUB_FILE_ENTIRE_FILE_NOT_SCRUBBED = new ExceptionContext("CONTENT_CA_SCRUB_FILE_ENTIRE_FILE_NOT_SCRUBBED", "The entire file was not scrubbed as expected.  File size: [{0}].  Number of bytes scrubbed: [{1}].");
    public static final ExceptionContext CONTENT_CA_SCRUB_FILE_MISMATCH_NUM_BYTE_WRITE = new ExceptionContext("CONTENT_CA_SCRUB_FILE_MISMATCH_NUM_BYTE_WRITE", "The expected number of bytes was not written while scrubbing file.  Current file position: [(0}].  Expected position: [{1}].");
    public static final ExceptionContext CONTENT_CA_SCRUB_NONEXISTANT_FILE = new ExceptionContext("CONTENT_CA_SCRUB_NONEXISTANT_FILE", "Cannot scrub a non-existant file.");
    public static final ExceptionContext CONTENT_CA_SCRUB_NONWRITEABLE_FILE = new ExceptionContext("CONTENT_CA_SCRUB_NONWRITEABLE_FILE", "Cannot scrub a non-writeable file.");
    public static final ExceptionContext CONTENT_CA_SERIALIZE_REQUEST = new ExceptionContext("CONTENT_CA_SERIALIZE_REQUEST", "Failed to serialize roll forward request data.  Command: [{0}].  ElementId: [{1}].");
    public static final ExceptionContext CONTENT_CA_DESERIALIZE_REQUEST = new ExceptionContext("CONTENT_CA_DESERIALIZE_REQUEST", "Failed to deserialize roll forward request data.  Command: [{0}].  ElementId: [{1}].");
    public static final ExceptionContext CONTENT_CA_ROLLFWD_COMMAND_CODE = new ExceptionContext("CONTENT_CA_ROLLFWD_COMMAND_CODE", "The roll forward command code is invalid.  Command: [{0}].  ObjectID: [{1}].");
    public static final ExceptionContext CONTENT_CA_MOVE_CONTENT_MISSING_SOURCE = new ExceptionContext("CONTENT_CA_MOVE_CONTENT_MISSING_SOURCE", "Failed to open the previously staged content during a move content operation.  ObjectID: [{0}].  Filename: [{1}].");
    public static final ExceptionContext CONTENT_CA_MOVE_CONTENT_MISSING_STATE = new ExceptionContext("CONTENT_CA_MOVE_CONTENT_MISSING_STATE", "Failed to locate internal state object during a move content operation.  ObjectID: [{0}].  Key: [{1}].");
    public static final ExceptionContext CONTENT_CA_MOVE_CONTENT_SIZE_MISSMATCH = new ExceptionContext("CONTENT_CA_MOVE_CONTENT_SIZE_MISSMATCH", "The content element size is incorrect for the move content operation.  ObjectID: [{0}].  Excepted Size: [{1}].  Actual Size: [{2}].");
    public static final ExceptionContext CONTENT_CA_CREATE_FEDERATED_NOT_ALLOWED = new ExceptionContext("CONTENT_CA_CREATE_FEDERATED_NOT_ALLOWED", "Requester does not have permission to create federated content.  FixedStorageAreaID: [{0}].");
    public static final ExceptionContext CONTENT_CONSOLIDATING_CHUNK_LENGTH_MISMATCH = new ExceptionContext("CONTENT_CONSOLIDATING_CHUNK_LENGTH_MISMATCH", "Number of bytes transfered from {0} did not match expected.  Transfered [{1}]. Expected [{2}].");
    public static final ExceptionContext CONTENT_CONSOLIDATING_FINAL_LENGTH_MISMATCH = new ExceptionContext("CONTENT_CONSOLIDATING_FINAL_LENGTH_MISMATCH", "Length of consolidated content does not match expected. Actual [{0}]. Expected [{1}].");
    public static final ExceptionContext CONTENT_FCP_CENTERA_ADAPTOR_CONTEXT = new ExceptionContext("CONTENT_FCP_CENTERA_ADAPTOR_CONTEXT", "Adaptor: [{0}].");
    public static final ExceptionContext CONTENT_FCP_CENTERA_ADAPTOR_POOL_NOT_INITIALIZED = new ExceptionContext("CONTENT_FCP_CENTERA_ADAPTOR_POOL_NOT_INITIALIZED", "The Centera pool for the Adaptor is not initialized.");
    public static final ExceptionContext CONTENT_FCP_CENTERA_BASE64_DECODE_FAILED = new ExceptionContext("CONTENT_FCP_CENTERA_BASE64_DECODE_FAILED", "Faield to decode the Base64 encoded ConnectionString.");
    public static final ExceptionContext CONTENT_FCP_CENTERA_CE_CONTEXT = new ExceptionContext("CONTENT_FCP_CENTERA_CE_CONTEXT", "Adaptor: [{0}]; Clip ID: [{1}]; Tag Index: [{2}].");
    public static final ExceptionContext CONTENT_FCP_CENTERA_CLONE_NON_INITIALIZED = new ExceptionContext("CONTENT_FCP_CENTERA_CLONE_NON_INITIALIZED", "Cannot clone from uninitialized Centera provider object.");
    public static final ExceptionContext CONTENT_FCP_CENTERA_CLOSE_PREVIOUS_TAG_FAILED = new ExceptionContext("CONTENT_FCP_CENTERA_CLOSE_PREVIOUS_TAG_FAILED", "Failed to close prevoius Centera tag.");
    public static final ExceptionContext CONTENT_FCP_CENTERA_DELETE_CLIP_FAILED = new ExceptionContext("CONTENT_FCP_CENTERA_DELETE_CLIP_FAILED", "Centare Adaptor failed to delete clip for Content Id: [{0}].");
    public static final ExceptionContext CONTENT_FCP_CENTERA_DELETE_NOT_ENABLED = new ExceptionContext("CONTENT_FCP_CENTERA_DELETE_NOT_ENABLED", "Centera cluster DELETE ALLOWED is set to false.");
    public static final ExceptionContext CONTENT_FCP_CENTERA_FETCH_NEXT_TAG_FAILED = new ExceptionContext("CONTENT_FCP_CENTERA_FETCH_NEXT_TAG_FAILED", "Failed to fetch the next Centera tag.");
    public static final ExceptionContext CONTENT_FCP_CENTERA_GET_TAG_COUNT_FAILED = new ExceptionContext("CONTENT_FCP_CENTERA_GET_TAG_COUNT_FAILED", "Failed to get the total tag numbers for Centera clip [{0}].");
    public static final ExceptionContext CONTENT_FCP_CENTERA_NOT_ENOUGH_CONNSTR_ENTRY = new ExceptionContext("CONTENT_FCP_CENTERA_NOT_ENOUGH_CONNSTR_ENTRY", "The ConnectionString list doesn''t have enough entries.");
    public static final ExceptionContext CONTENT_FCP_CENTERA_NO_CONN_STR = new ExceptionContext("CONTENT_FCP_CENTERA_NO_CONN_STR", "No ConnectionString attribute defined in XML data.");
    public static final ExceptionContext CONTENT_FCP_CENTERA_NO_SITE_DEFINITION = new ExceptionContext("CONTENT_FCP_CENTERA_NO_SITE_DEFINITION", "No SiteDefinition attribute defined in XML data.");
    public static final ExceptionContext CONTENT_FCP_CENTERA_OPEN_CLIP_FAILED = new ExceptionContext("CONTENT_FCP_CENTERA_OPEN_CLIP_FAILED", "Failed to open Centera clip [{0}].");
    public static final ExceptionContext CONTENT_FCP_CENTERA_PURGE_NOT_ENABLED = new ExceptionContext("CONTENT_FCP_CENTERA_PURGE_NOT_ENABLED", "Centera cluster PURGE ALLOWED is set to false.");
    public static final ExceptionContext CONTENT_FCP_CENTERA_PURGE_TAG_BLOB_FAILED = new ExceptionContext("CONTENT_FCP_CENTERA_PURGE_TAG_BLOB_FAILED", "Centare Adaptor failed to purge blob for Content Id: [{0}]]; Tag Index[{1}].");
    public static final ExceptionContext CONTENT_FCP_CENTERA_READ_OFFSET_OUT_OF_RANGE = new ExceptionContext("CONTENT_FCP_CENTERA_READ_OFFSET_OUT_OF_RANGE", "The current Centera reading/seeking offset [{0}] is out of the range of [{1}] : [{2}].");
    public static final ExceptionContext CONTENT_FCP_CENTERA_READ_SEMAPHORE_FAILED = new ExceptionContext("CONTENT_FCP_CENTERA_READ_SEMAPHORE_FAILED", "Too many concurrent readers. Centera adaptor Failed to claim reader semaphore after [{0}] ms.");
    public static final ExceptionContext CONTENT_FCP_CENTERA_TAG_GET_BLOB_SIZE_FAILED = new ExceptionContext("CONTENT_FCP_CENTERA_TAG_GET_BLOB_SIZE_FAILED", "Failed to get the Blob size of the Centera tag.");
    public static final ExceptionContext CONTENT_FCP_CENTERA_TAG_NUM_OUT_OF_RANGE = new ExceptionContext("CONTENT_FCP_CENTERA_TAG_NUM_OUT_OF_RANGE", "Failed to seek the Centera tag. Tag index [{0}] out of range.");
    public static final ExceptionContext CONTENT_FCP_CENTERA_WRONG_CONNSTR_TYPE = new ExceptionContext("CONTENT_FCP_CENTERA_WRONG_CONNSTR_TYPE", "The ConnectionString value is not string type.");
    public static final ExceptionContext CONTENT_FCP_CONNECT_ALREADY_CALLED = new ExceptionContext("CONTENT_FCP_CONNECT_ALREADY_CALLED", "Connect already called.");
    public static final ExceptionContext CONTENT_FCP_CONNECT_NOT_CALLED = new ExceptionContext("CONTENT_FCP_CONNECT_NOT_CALLED", "Connect has not been called.");
    public static final ExceptionContext CONTENT_FCP_CONTENT_ELEMENT_ALREADY_OPEN = new ExceptionContext("CONTENT_FCP_CONTENT_ELEMENT_ALREADY_OPEN", "Content element already opened.");
    public static final ExceptionContext CONTENT_FCP_DOCUMENT_ALREADY_OPEN = new ExceptionContext("CONTENT_FCP_DOCUMENT_ALREADY_OPEN", "Another document is currently opened with referral: {0}.");
    public static final ExceptionContext CONTENT_FCP_EXPECTED_VALUE = new ExceptionContext("CONTENT_FCP_EXPECTED_VALUE", "Expected value: {0}");
    public static final ExceptionContext CONTENT_FCP_FEDERATED_NO_NEW_CONTENT = new ExceptionContext("CONTENT_FCP_FEDERATED_NO_NEW_CONTENT", "Federated device does not allow new content.");
    public static final ExceptionContext CONTENT_FCP_FEDERATED_NO_NEW_DIR = new ExceptionContext("CONTENT_FCP_FEDERATED_NO_NEW_DIR", "Federated device does not allow new directories to be created.");
    public static final ExceptionContext CONTENT_FCP_FEDERATED_RETENTION_NOT_SUPPORTED = new ExceptionContext("CONTENT_FCP_FEDERATED_RETENTION_NOT_SUPPORTED", "Retention is not supported for federated content.");
    public static final ExceptionContext CONTENT_FCP_FSB_CE_CONTEXT = new ExceptionContext("CONTENT_FCP_FSB_CE_CONTEXT", "File: [{0}]");
    public static final ExceptionContext CONTENT_FCP_INIT_ALREADY_CALLED = new ExceptionContext("CONTENT_FCP_INIT_ALREADY_CALLED", "Initialize already called.");
    public static final ExceptionContext CONTENT_FCP_INIT_NOT_CALLED = new ExceptionContext("CONTENT_FCP_INIT_NOT_CALLED", "Initialize has not been called.");
    public static final ExceptionContext CONTENT_FCP_INVALID_ARRAY_LENGTH = new ExceptionContext("CONTENT_FCP_INVALID_ARRAY_LENGTH", "Invalid array length.  Expected bounds (min/max): {0}");
    public static final ExceptionContext CONTENT_FCP_INVALID_FCD = new ExceptionContext("CONTENT_FCP_INVALID_FCD", "Invalid Fixed Content Device [{0}] for this Fixed Content Provider [{1}]");
    public static final ExceptionContext CONTENT_FCP_INVALID_PARAMETER_VALUE = new ExceptionContext("CONTENT_FCP_INVALID_PARAMETER_VALUE", "Invalid parameter value.  Parameter: [{0}]; Value: [{1}].");
    public static final ExceptionContext CONTENT_FCP_INVALID_RANGE = new ExceptionContext("CONTENT_FCP_INVALID_RANGE", "Value does not fall within the required range (min/max): {0}");
    public static final ExceptionContext CONTENT_FCP_IS_ADAPTOR_CONTEXT = new ExceptionContext("CONTENT_FCP_IS_ADAPTOR_CONTEXT", "Adaptor: [{0}]; FCD Id: [{1}]]; IMS Name: [{2}].");
    public static final ExceptionContext CONTENT_FCP_IS_ANNOTATION_ACCESS_DENIED = new ExceptionContext("CONTENT_FCP_IS_ANNOTATION_ACCESS_DENIED", "Cannot create or change content of an IS Annotation.");
    public static final ExceptionContext CONTENT_FCP_IS_ANNOTATION_DELETE_FAILED = new ExceptionContext("CONTENT_FCP_IS_ANNOTATION_DELETE_FAILED", "ISAnnotation delete failed.  DocNum: [{0}]]; Page [{1}]; AnnotIdHi: [{2}]; AnnotIdLow [{3}]; ObjectStoreId: [{4}]");
    public static final ExceptionContext CONTENT_FCP_IS_CE_CONTEXT = new ExceptionContext("CONTENT_FCP_IS_CE_CONTEXT", "Adaptor: [{0}]; FCD Id: [{1}]]; IMS Name: [{2}]; DocNum [{3}]; Page [{4}].");
    public static final ExceptionContext CONTENT_FCP_IS_DELETE_CONTEXT = new ExceptionContext("CONTENT_FCP_IS_DELETE_CONTEXT", "Adaptor: [{0}]; FCD Id: [{1}]]; IMS Name: [{2}]; DocNum: [{3}]; Mode: [{4}]; ObectStoreId: [{5}].");
    public static final ExceptionContext CONTENT_FCP_IS_LOCKDOWN_CONTEXT = new ExceptionContext("CONTENT_FCP_IS_LOCKDOWN_CONTEXT", "Adaptor: [{0}]; FCD Id: [{1}]]; IMS Name: [{2}]; DocNum [{3}]; Mode [{4}].");
    public static final ExceptionContext CONTENT_FCP_MISSING_PARAMETER_DELIMITER = new ExceptionContext("CONTENT_FCP_MISSING_PARAMETER_DELIMITER", "Missing parameter delimiter: [{0}].");
    public static final ExceptionContext CONTENT_FCP_NON_FEDERATED_REFERRAL_URLS = new ExceptionContext("CONTENT_FCP_NON_FEDERATED_REFERRAL_URLS", "Cannot compute referral using URLs for non-federated content.");
    public static final ExceptionContext CONTENT_FCP_NO_OPEN_CONTENT_ELEMENT = new ExceptionContext("CONTENT_FCP_NO_OPEN_CONTENT_ELEMENT", "No currently open content element.");
    public static final ExceptionContext CONTENT_FCP_NO_OPEN_DOCUMENT = new ExceptionContext("CONTENT_FCP_NO_OPEN_DOCUMENT", "No currently opened document.");
    public static final ExceptionContext CONTENT_FCP_SNAPLOCK_ADAPTOR_CONTEXT = new ExceptionContext("CONTENT_FCP_SNAPLOCK_ADAPTOR_CONTEXT", "Adaptor:[{0}]; Root Directory:[{1}]; Snaplock Device Address:[{2}].");
    public static final ExceptionContext CONTENT_FCP_CMOD_MISSING_TRACE_DIR = new ExceptionContext("CONTENT_FCP_CMOD_MISSING_TRACE_DIR", "the ODWEK trace directory doesn''t exist, Directory: [{0}]; Adaptor:[{1}];");
    public static final ExceptionContext CONTENT_FCP_CMOD_LOGON_FAILED = new ExceptionContext("CONTENT_FCP_CMOD_LOGON_FAILED", "CMOD server logon, Server: [{0}]; Port: [{1}]; Username: [{2}]; Adaptor: [{3}]; Method: [{4}];");
    public static final ExceptionContext CONTENT_FCP_CMOD_LOGOFF_FAILED = new ExceptionContext("CONTENT_FCP_CMOD_LOGOFF_FAILED", "CMOD server logoff, Server: [{0}]; Port: [{1}]; Username: [{2}]; Adaptor: [{3}]; Method: [{4}];");
    public static final ExceptionContext CONTENT_FCP_CMOD_RECREATE_HIT = new ExceptionContext("CONTENT_FCP_CMOD_RECREATE_HIT", "CMOD recreate hit, Server: [{0}]; Adaptor: [{1}]; Method: [{2}]; ApGroupId: [{3}]; Docid: [{4}];");
    public static final ExceptionContext CONTENT_FCP_CMOD_RETRIEVE_HIT = new ExceptionContext("CONTENT_FCP_CMOD_RETRIEVE_HIT", "CMOD retrieve hit, Server: [{0}]; Adaptor: [{1}]; ApGroupId: [{2}]; Docid: [{3}]; Viewer: [{4}]; Segment: [{5}];");
    public static final ExceptionContext CONTENT_FCP_CMOD_GET_APPLICATION_GROUP = new ExceptionContext("CONTENT_FCP_CMOD_GET_APPLICATION_GROUP", "CMOD retrieve hit, Server: [{0}]; Adaptor: [{1}]; ApGroupId: [{2}];");
    public static final ExceptionContext CONTENT_FCP_CMOD_GET_APPLICATION_GROUPS = new ExceptionContext("CONTENT_FCP_CMOD_GET_APPLICATION_GROUPS", "CMOD retrieve hit, Server: [{0}]; Adaptor: [{1}];");
    public static final ExceptionContext CONTENT_FCP_CMOD_OPEN_SEGMENT_FILE = new ExceptionContext("CONTENT_FCP_CMOD_OPEN_SEGMENT_FILE", "open segment file, Filename: [{0}]; ApGroupId: [{1}]; DocId: [{2}]; Segment [{3}];");
    public static final ExceptionContext CONTENT_FCP_CMOD_READ_SEGMENT_FILE = new ExceptionContext("CONTENT_FCP_CMOD_READ_SEGMENT_FILE", "read segment file, Filename: [{0}]; ApGroupId: [{1}]; DocId: [{2}]; Segment [{3}];");
    public static final ExceptionContext CONTENT_FCP_CMOD_NULL_DOCUMENT = new ExceptionContext("CONTENT_FCP_CMOD_NULL_DOCUMENT", "null CMOD document object returned by adaptor, Referral: [{0}];");
    public static final ExceptionContext CONTENT_FCP_CMOD_HOLD_DOC = new ExceptionContext("CONTENT_FCP_CMOD_HOLD_DOC", "CMOD hold document, Server: [{0}]; Adaptor: [{1}]; ApGroupId: [{2}]; Docid: [{3}];");
    public static final ExceptionContext CONTENT_FCP_CMOD_RELEASE_DOC = new ExceptionContext("CONTENT_FCP_CMOD_RELEASE_DOC", "CMOD release document, Server: [{0}]; Adaptor: [{1}]; ApGroupId: [{2}]; Docid: [{3}];");
    public static final ExceptionContext CONTENT_FCP_CMOD_TEST_LOCKDOWN = new ExceptionContext("CONTENT_FCP_CMOD_TEST_LOCKDOWN", "CMOD test document lockdown (missing document), Server: [{0}]; Adaptor: [{1}]; ApGroupId: [{2}]; Docid: [{3}];");
    public static final ExceptionContext CONTENT_FCP_STRING_LENGTH_EXCEEDS_MAX = new ExceptionContext("CONTENT_FCP_STRING_LENGTH_EXCEEDS_MAX", "String length of [{0}] exceeds maximum allowed: [{1}].");
    public static final ExceptionContext CONTENT_FXCA_FAILED_PARSING_CONFIG_PARAMS = new ExceptionContext("CONTENT_FXCA_FAILED_PARSING_CONFIG_PARAMS", "Failed parsing configuration parameters XML.");
    public static final ExceptionContext CONTENT_INPUT_STREAM_INVALID = new ExceptionContext("CONTENT_INPUT_STREAM_INVALID", "The input stream is invalid.");
    public static final ExceptionContext CONTENT_INVALID_BITS_PER_SLICE = new ExceptionContext("CONTENT_INVALID_BITS_PER_SLICE", "Bits per slice: [{0}] is not between 1 and 32.");
    public static final ExceptionContext CONTENT_INVALID_DIRECTORIES_PER_LEVEL = new ExceptionContext("CONTENT_INVALID_DIRECTORIES_PER_LEVEL", "Directories per level: [{0}] is not a prime number.");
    public static final ExceptionContext CONTENT_INVALID_STRUCTURE_TYPE = new ExceptionContext("CONTENT_INVALID_STRUCTURE_TYPE", "Structure type: [{0}] is not one of the constants for Flat, 32-bit, 64-bit, or 128-bit directory structures.");
    public static final ExceptionContext CONTENT_LOCKDOWN_ACCESS_DENIED = new ExceptionContext("CONTENT_LOCKDOWN_ACCESS_DENIED", "Need Write ACL for lockdown");
    public static final ExceptionContext CONTENT_LOCKDOWN_DOCUMENT_NOT_CHECKED_IN = new ExceptionContext("CONTENT_LOCKDOWN_DOCUMENT_NOT_CHECKED_IN", "Cannot lockdown a document that has not been checked in.");
    public static final ExceptionContext CONTENT_LOCKDOWN_NOT_SUPPORTED = new ExceptionContext("CONTENT_LOCKDOWN_NOT_SUPPORTED", "Device does not support lockdown");
    public static final ExceptionContext CONTENT_LOCKDOWN_RESERVATION_NOT_ALLOWED = new ExceptionContext("CONTENT_LOCKDOWN_RESERVATION_NOT_ALLOWED", "Cannot lockdown a reservation.");
    public static final ExceptionContext CONTENT_READ_INCORRECT_NUM_BYTES = new ExceptionContext("CONTENT_READ_INCORRECT_NUM_BYTES", "Did not read the expected number of bytes.  Expected {0} bytes, but read {1} bytes.");
    public static final ExceptionContext CONTENT_SA_EXCEEDS_MAX_ELEMENTS = new ExceptionContext("CONTENT_SA_EXCEEDS_MAX_ELEMENTS", "Storage Area [{0}] has exceeded the Max-Element Limit of [{1}].  Current number elements={2}.");
    public static final ExceptionContext CONTENT_SA_EXCEEDS_MAX_SIZE = new ExceptionContext("CONTENT_SA_EXCEEDS_MAX_SIZE", "Storage Area [{0}] has exceeded the Max-Size Limit of [{1}(KB)].  Current size={2}(KB).");
    public static final ExceptionContext CONTENT_SA_PASSES_CLOSURE_DATE = new ExceptionContext("CONTENT_SA_PASSES_CLOSURE_DATE", "Storage Area [{0}] has passed the Closure Date of [{1}].  Current date={2}.");
    public static final ExceptionContext CONTENT_SA_TRANSITIONING_TO_STATUS = new ExceptionContext("CONTENT_SA_TRANSITIONING_TO_STATUS", "Storage Area [{0}] transitioning to status [{1}].");
    public static final ExceptionContext CONTENT_STAKEFILE_ALREADY_EXISTS = new ExceptionContext("CONTENT_STAKEFILE_ALREADY_EXISTS", "A stakefile already exists at {0}.");
    public static final ExceptionContext CONTENT_STATE = new ExceptionContext("CONTENT_STATE", "State: [{0}]");
    public static final ExceptionContext CONTENT_STORAGE_AREA_NOT_FOUND = new ExceptionContext("CONTENT_STORAGE_AREA_NOT_FOUND", "StorageArea {0}, {1} not found.");
    public static final ExceptionContext CONTENT_VALIDATION_FILE_CONTENT = new ExceptionContext("CONTENT_VALIDATION_FILE_CONTENT", "Missing filename={0}.");
    public static final ExceptionContext CONTENT_VALIDATION_FIXED_CONTENT = new ExceptionContext("CONTENT_VALIDATION_FIXED_CONTENT", "Missing fixed content for referral={0}");
    public static final ExceptionContext CONTENT_VALIDATION_FIXED_CONTENT_MIGRATING = new ExceptionContext("CONTENT_VALIDATION_FIXED_CONTENT_MIGRATING", "Content is migrating to fixed device.");
    public static final ExceptionContext CONTENT_LOAD_CONTENT_CONFIG_FAILED = new ExceptionContext("CONTENT_LOAD_CONTENT_CONFIG_FAILED", "Server threw an exception while loading content configuration.");
    public static final ExceptionContext CONTENT_UNABLE_TO_FETCH_CACHE_AREA = new ExceptionContext("CONTENT_UNABLE_TO_FETCH_CACHE_AREA", "Server threw an exception while fetching the CacheArea.");
    public static final ExceptionContext CONTENT_DATECREATED_NOT_AVAILABLE = new ExceptionContext("CONTENT_DATECREATED_NOT_AVAILABLE", "DateCreated property is not available on a Create or Update.  Content cache cannot validate content correctly.");
    public static final ExceptionContext CONTENT_FAILED_TO_CREATE_CONTENT_TABLE = new ExceptionContext("CONTENT_FAILED_TO_CREATE_CONTENT_TABLE", "Error occurred creating Content table.");
    public static final ExceptionContext CONTENT_ERROR_CLOSING_DB_CONTENT_STREAM = new ExceptionContext("CONTENT_ERROR_CLOSING_DB_CONTENT_STREAM", "Error closing database content stream");
    public static final ExceptionContext CONTENT_ERROR_RESUMING_TX_IN_DBREADER = new ExceptionContext("CONTENT_ERROR_RESUMING_TX_IN_DBREADER", "Error resuming transaction in Database Reader background task");
    public static final ExceptionContext CONTENT_ERROR_INITIALIZING_DBINPUTSTREAM = new ExceptionContext("CONTENT_ERROR_INITIALIZING_DBINPUTSTREAM", "Could not initialize database input stream for {0} after {1} retries.");
    public static final ExceptionContext CONTENT_ERROR_CLOSING_INPUT_STREAM = new ExceptionContext("CONTENT_ERROR_CLOSING_INPUT_STREAM", "Error closing content input stream");
    public static final ExceptionContext CONTENT_TARGET_FILE_EXISTS = new ExceptionContext("CONTENT_TARGET_FILE_EXISTS", "File rename failed, target file exists with invalid size ( {0} vs {1} )");
    public static final ExceptionContext CONTENT_FILE_RENAME_FAILED = new ExceptionContext("CONTENT_FILE_RENAME_FAILED", "File rename failed, source file doesn''t exist: {0}");
    public static final ExceptionContext CONTENT_FILE_DELETE_FAILED = new ExceptionContext("CONTENT_FILE_DELETE_FAILED", "Failed to delete content element file: {0}");
    public static final ExceptionContext CONTENT_CREATE_STORAGE_AREA_FAILED = new ExceptionContext("CONTENT_CREATE_STORAGE_AREA_FAILED", "Failed to create storage area: {0}");
    public static final ExceptionContext CONTENT_FCP_SHUTDOWN_FAILED = new ExceptionContext("CONTENT_FCP_SHUTDOWN_FAILED", "Error shutting down cached fixed content provider: {0}");
    public static final ExceptionContext CONTENT_UNEXPECTED_USER = new ExceptionContext("CONTENT_UNEXPECTED_USER", "Unexpected user called getContent, failing operation");
    public static final ExceptionContext CONTENT_FAILED_TO_CLOSE_STREAM = new ExceptionContext("CONTENT_FAILED_TO_CLOSE_STREAM", "Failed to close stream after a read failure");
    public static final ExceptionContext CONTENT_UNABLE_TO_GET_DIRLIST = new ExceptionContext("CONTENT_UNABLE_TO_GET_DIRLIST", "Unable to get directory listing for {0}");
    public static final ExceptionContext CONTENT_FAILED_TO_INSERT_FILE = new ExceptionContext("CONTENT_FAILED_TO_INSERT_FILE", "Failed to insert {0} into {1} after {2} attempts");
    public static final ExceptionContext CONTENT_FAILED_TO_STITCH_DB_CHUNKS = new ExceptionContext("CONTENT_FAILED_TO_STITCH_DB_CHUNKS", "Failed to consolidate database chunks after {0} attempts for {1}");
    public static final ExceptionContext CONTENT_FAILED_CREATE_INSTREAM = new ExceptionContext("CONTENT_FAILED_CREATE_INSTREAM", "Could not create input stream for existing file: {0}");
    public static final ExceptionContext CONTENT_CLOSE_DBCTX_FAILED = new ExceptionContext("CONTENT_CLOSE_DBCTX_FAILED", "Error attempting to close database context");
    public static final ExceptionContext CONTENT_UPLOAD_DBCHUNKS_FAILED = new ExceptionContext("CONTENT_UPLOAD_DBCHUNKS_FAILED", "Delete of upload database chunks failed for {0}");
    public static final ExceptionContext CONTENT_DB_DELETE_FAILED = new ExceptionContext("CONTENT_DB_DELETE_FAILED", "Delete of database content elements failed {0}");
    public static final ExceptionContext CONTENT_COMMIT_ROLLBACK_FAILED = new ExceptionContext("CONTENT_COMMIT_ROLLBACK_FAILED", "Error during commit/rollback after previous failure");
    public static final ExceptionContext CONTENT_FAILED_LOAD_REFERRAL = new ExceptionContext("CONTENT_FAILED_LOAD_REFERRAL", "Failed to load referral blob for objectId = {0}");
    public static final ExceptionContext CONTENT_CLOSE_INSTREAM_FAILED = new ExceptionContext("CONTENT_CLOSE_INSTREAM_FAILED", "Failed to close input stream for {0}");
    public static final ExceptionContext CONTENT_TMPFILE_MISSING = new ExceptionContext("CONTENT_TMPFILE_MISSING", "Temporary file for current chunk is null.");
    public static final ExceptionContext CONTENT_CONTENT_AREA_INIT = new ExceptionContext("CONTENT_CONTENT_AREA_INIT", "Failed to initialize Content Area with Storage Area Id: {0}");
    public static final ExceptionContext CONTENT_CCLIP_DUMP_FAILED = new ExceptionContext("CONTENT_CCLIP_DUMP_FAILED", "Failed to dump cClip to file.");
    public static final ExceptionContext CONTENT_FAILED_CLOSE_CENTERA_POOL = new ExceptionContext("CONTENT_FAILED_CLOSE_CENTERA_POOL", "Failed to close duplicate Centera pool for Centera cluster: {0}");
    public static final ExceptionContext CONTENT_ISDIR_FAILED = new ExceptionContext("CONTENT_ISDIR_FAILED", "Error trying to determine if {0} is a directory.");
    public static final ExceptionContext CONTENT_TTL_STRM_CLOSE_FAILED = new ExceptionContext("CONTENT_TTL_STRM_CLOSE_FAILED", "Failed to close TTL Stream: {0}");
    public static final ExceptionContext CONTENT_WR_STRM_CLOSE_FAILED = new ExceptionContext("CONTENT_WR_STRM_CLOSE_FAILED", "Failed to close wrapper Stream.");
    public static final ExceptionContext CONTENT_STRM_FLUSH_FAILED = new ExceptionContext("CONTENT_STRM_FLUSH_FAILED", "Could not flush stream on close.");
    public static final ExceptionContext CONTENT_ERROR_EXPIRING_STRM = new ExceptionContext("CONTENT_ERROR_EXPIRING_STRM", "TTL Reaper encountered an error expiring a stream: {0}");
    public static final ExceptionContext CONTENT_CENTERA_POOL_INFO = new ExceptionContext("CONTENT_CENTERA_POOL_INFO", "Failed to get Centera FPPool poolInfo.");
    public static final ExceptionContext CONTENT_CENTERA_LOG_CONFIG = new ExceptionContext("CONTENT_CENTERA_LOG_CONFIG", "Centera logging enabled, but cannot access log configuration file: {0}");
    public static final ExceptionContext CONTENT_FCP_IICE_ADAPTOR_CONTEXT = new ExceptionContext("CONTENT_FCP_IICE_ADAPTOR_CONTEXT", "Adaptor: [{0}]; Repository Name: [{1}].");
    public static final ExceptionContext CONTENT_FCP_IICE_DOCITEM_CONTEXT = new ExceptionContext("CONTENT_FCP_IICE_DOCITEM_CONTEXT", "Adaptor: [{0}]; Repository Name: [{1}]; ContentItem: [{2}].");
    public static final ExceptionContext CONTENT_FCP_IICE_OPERATION_NOT_AVAILABLE_ON_REPOSITORY = new ExceptionContext("CONTENT_FCP_IICE_OPERATION_NOT_AVAILABLE_ON_REPOSITORY", "IICE repository does not support the requested operation. Adaptor: [{0}]; Repository Name: [{1}]; Operation: [{2}];");
    public static final ExceptionContext CONTENT_FCP_IICE_OPERATION_NOT_AVAILABLE_ON_ITEM = new ExceptionContext("CONTENT_FCP_IICE_OPERATION_NOT_AVAILABLE_ON_ITEM", "IICE content item does not allow the reqeusted operation. Repository Name: [{0}]; ContentItem: [{1}]; Operation: [{2}].");
    public static final ExceptionContext CONTENT_FCP_IICE_DOCPAGE_CONTEXT = new ExceptionContext("CONTENT_FCP_IICE_DOCPAGE_CONTEXT", "Adaptor: [{0}]; Repository Name: [{1}]; ContentItem: [{2}]; Page: [{3}].");
    public static final ExceptionContext CONTENT_FCP_IICE_CONFIG_URL = new ExceptionContext("CONTENT_FCP_IICE_CONFIG_URL", "The IICE Configuration URL [{0}] did not match the expected pattern of a comma separated list of IICE Session Pool URLs of the form: rmi://host:port/SessionPool-repositoryName for the repository [{1}].");
    public static final ExceptionContext CONTENT_METADATA_PARSER_UNEXPECTED_STATE = new ExceptionContext("CONTENT_METADATA_PARSER_UNEXPECTED_STATE", "Unexpected state. Current state: {0} Expected state {1} at line {2}, col {3}");
    public static final ExceptionContext CONTENT_CFS_METADATA_SAX_PARSE_ERROR = new ExceptionContext("CONTENT_CFS_METADATA_SAX_PARSE_ERROR", "Message: {0} at line {1}, col {2}");
    public static final ExceptionContext CONTENT_CFS_METADATA_INVALID_DATE_FORMAT = new ExceptionContext("CONTENT_CFS_METADATA_INVALID_DATE_FORMAT", "Property: {0} contains invalid date value: {1}");
    public static final ExceptionContext CONTENT_CFS_SERIALIZE_ACTIONPLAN = new ExceptionContext("CONTENT_CFS_SERIALIZE_ACTIONPLAN", "Failed to serialize action plan data.  Item Count: [{0}].");
    public static final ExceptionContext CONTENT_CFS_DESERIALIZE_ACTIONPLAN = new ExceptionContext("CONTENT_CFS_DESERIALIZE_ACTIONPLAN", "Failed to deserialize action plan data.  Data Size: [{0}].");
    public static final ExceptionContext CONTENT_CFS_SERIALIZE_VERSIONMAPPING = new ExceptionContext("CONTENT_CFS_SERIALIZE_VERSIONMAPPING", "Failed to serialize version mapping data.  Item Count: [{0}].");
    public static final ExceptionContext CONTENT_CFS_DESERIALIZE_VERSIONMAPPING = new ExceptionContext("CONTENT_CFS_DESERIALIZE_VERSIONMAPPING", "Failed to deserialize version mapping data.  Data Size: [{0}].");
    public static final ExceptionContext CONTENT_CFS_DESERIALIZE_SIGNATURE = new ExceptionContext("CONTENT_CFS_DESERIALIZE_SIGNATURE", "Failed to deserialize, invalid signature.  Type: [{0}]  Found: [{1}]  Expected: [{2}]  Urn: [{3}].");
    public static final ExceptionContext CONTENT_CFS_DESERIALIZE_VERSION = new ExceptionContext("CONTENT_CFS_DESERIALIZE_VERSION", "Failed to deserialize, invalid data version.  Type: [{0}]  Found: [{1}]  Expected: [{2}]  Urn: [{3}].");
    public static final ExceptionContext CONTENT_CFS_FDB_UPDATE = new ExceptionContext("CONTENT_CFS_FDB_UPDATE", "An error occurred accessing the federation database.  Action: [{0}]  Urn: [{1}]  Epoch Id: [{2}]  Time in Queue: [{3}]  Session Id: [{4}]  Batch No: [{5}].");
    public static final ExceptionContext CONTENT_CFS_UPDATE_DOCUMENT = new ExceptionContext("CONTENT_CFS_UPDATE_DOCUMENT", "Failed to create or update P8 document.  Action: [{0}]  Urn: [{1}]  Epoch Id: [{2}]  Time in Queue: [{3}]  Session Id: [{4}]  Batch No: [{5}].");
    public static final ExceptionContext CONTENT_CFS_DOCUMENT_NOT_FOUND = new ExceptionContext("CONTENT_CFS_DOCUMENT_NOT_FOUND", "The P8 document doesn''t exist.  Action: [{0}]  Urn: [{1}]  Epoch Id: [{2}]  Time in Queue: [{3}]  Session Id: [{4}]  Batch No: [{5}].");
    public static final ExceptionContext CONTENT_CFS_UNEXPECTED_STATE = new ExceptionContext("CONTENT_CFS_UNEXPECTED_STATE", "Unexpected state [{0}].");
    public static final ExceptionContext CONTENT_CFS_FDB_UPDATE_EPOCH = new ExceptionContext("CONTENT_CFS_FDB_UPDATE_EPOCH", "Update failed, the row epoch has changed since the row was retrieved.  Table [{0}]  External Ident: [{1}]  Map Type: [{2}]  Epoch Id: [{3}].");
    public static final ExceptionContext CONTENT_CFS_FDB_UPDATE_P8_IDENT = new ExceptionContext("CONTENT_CFS_FDB_UPDATE_P8_IDENT", "Update failed, the P8 identity cannot be changed after the external mapping has been established.  Table [{0}] External Ident: [{1}]  Map Type: [{2}]  Epoch Id: [{3}].");
    public static final ExceptionContext CONTENT_FCP_NO_SUCH_PROFILE_METHOD = new ExceptionContext("CONTENT_FCP_NO_SUCH_PROFILE_METHOD", "Failed to invoke non-existent method on RepositoryProfile class.  Adaptor: [{0}]  Repository Name: [{1}]  Method Name: [{2}].");
    public static final ExceptionContext CONTENT_FCP_PROPERTIES_NOT_AVAILABLE = new ExceptionContext("CONTENT_FCP_PROPERTIES_NOT_AVAILABLE", "One or more expected content properties not available: [{0}].");
    public static final ExceptionContext CONTENT_FCP_PROPERTIES_INVALID_TYPE = new ExceptionContext("CONTENT_FCP_PROPERTIES_INVALID_TYPE", "One or more expected content properties are an invalid data type: [{0}].");
    public static final ExceptionContext CONTENT_FCP_SNAPLOCK_FAILED_DEVICE_DIRECTORY = new ExceptionContext("CONTENT_FCP_SNAPLOCK_FAILED_DEVICE_DIRECTORY", "The device directory [{0}] could not be validated.");
    public static final ExceptionContext CONTENT_FCP_IICE_ITEM_NOT_FOUND = new ExceptionContext("CONTENT_FCP_IICE_ITEM_NOT_FOUND", "IICE content item does not exist in the repository. Repository Name: [{0}]; ContentItem: [{1}].");
    public static final ExceptionContext CONTENT_FCP_IICE_ACCESS_DENIED = new ExceptionContext("CONTENT_FCP_IICE_ACCESS_DENIED", "Caller does not have sufficient access rights to delete this federated content item. Repository Name: [{0}]; ContentItem: [{1}].");
    public static final ExceptionContext CONTENT_FCP_TSM_TAPE_MOUNT_TIMEOUT = new ExceptionContext("CONTENT_FCP_TSM_TAPE_MOUNT_TIMEOUT", "Timed out after [{0}] seconds.  This may be due to a TSM unmounted tape volume.  Please try again later, allowing sufficient time for tape to be mounted.");
    public static final ExceptionContext CONTENT_FCP_TSM_BAD_FILESPACE_NAME = new ExceptionContext("CONTENT_FCP_TSM_BAD_FILESPACE_NAME", "The filespace name does not contain a leading directory separator character [{0}].");
    public static final ExceptionContext CONTENT_FCP_TSM_TAPE_READ_FAILURE = new ExceptionContext("CONTENT_FCP_TSM_TAPE_READ_FAILURE", "This may be due to a TSM unmounted tape volume.  Please try again later, allowing sufficient time for tape to be mounted.");
    public static final ExceptionContext CONTENT_RETRYABLE_READ_FAILURE = new ExceptionContext("CONTENT_RETRYABLE_READ_FAILURE", "The server is unable to retrieve your document at this time.  Please try again later.");
    public static final ExceptionContext CONTENT_FCP_CONTEXT = new ExceptionContext("CONTENT_FCP_CONTEXT", "{0}");
    public static final ExceptionContext CONTENT_FCP_CAUSED_BY = new ExceptionContext("CONTENT_FCP_CAUSED_BY", "Caused by {0}");
    public static final ExceptionContext CONTENT_FCP_HCP_ADAPTOR_CONTEXT = new ExceptionContext("CONTENT_FCP_HCP_ADAPTOR_CONTEXT", "Namespace: [{0}]; URI: [{1}]; Username: [{2}]; Root Cause [{3}]");
    public static final ExceptionContext CONTENT_FCP_HCP_UNEXPECTED_STATUS = new ExceptionContext("CONTENT_FCP_HCP_UNEXPECTED_STATUS", "An unexpected status code [{0}] was returned from the HCP server: [{1}]; URI: [{2}]");
    public static final ExceptionContext CONTENT_FCP_HCP_INVALID_LOGON = new ExceptionContext("CONTENT_FCP_HCP_INVALID_LOGON", "Could not logon to HCP server for user [{0}]; namespace [{1}]; status [{2}]. Check that this user has been granted access to this namespace with the credentials specified on the Hitachi FCD.");
    public static final ExceptionContext CONTENT_FCP_HCP_INVALID_ROOT_DIRECTORY = new ExceptionContext("CONTENT_FCP_HCP_INVALID_ROOT_DIRECTORY", "Root directory does not exist on HCP server: [{0}]; URI: [{1}]");
    public static final ExceptionContext CONTENT_FCP_HCP_CONNECT_FORBIDDEN = new ExceptionContext("CONTENT_FCP_HCP_CONNECT_FORBIDDEN", "The user [{0}] is unable to perform the requested operation on the HCP namespace [{1}]. Check that the namespace is valid and that this user has been granted read/write/delete/purge access for this namespace.");
    public static final ExceptionContext CONTENT_INVALID_OFFSET = new ExceptionContext("CONTENT_INVALID_OFFSET", "The starting offset value is invalid for a request that you made to the Content Engine API for retrieving or uploading content. Correct your code to specify a value that is a multiple of the 16-byte block size.");
    public static final ExceptionContext CONTENT_DECRYPTION_ERROR = new ExceptionContext("CONTENT_DECRYPTION_ERROR", "Content decryption failed. Contact IBM Software Support.");
    public static final ExceptionContext CONTENT_INVALID_KEY_LENGTH = new ExceptionContext("CONTENT_INVALID_KEY_LENGTH", "The EncryptionKey property value has a length of \"{0}\" bytes and is consequently not valid. Specify a new property value with a length of 16 bytes.");
    public static final ExceptionContext CONTENT_CRYPTO_DEST = new ExceptionContext("CONTENT_CRYPTO_DEST", "The data was being written to \"{0}\".");
    public static final ExceptionContext DB_COLUMN_NAME_REQUIRED = new ExceptionContext("DB_COLUMN_NAME_REQUIRED", "Columns must specify a name.");
    public static final ExceptionContext DB_COLUMN_SIZE_REQUIRED = new ExceptionContext("DB_COLUMN_SIZE_REQUIRED", "String columns must specify a size.");
    public static final ExceptionContext DB_ERROR_SQL_STATEMENT = new ExceptionContext("DB_ERROR_SQL_STATEMENT", "{0}");
    public static final ExceptionContext DB_LOB_SEQUENCE_EXHAUSTED = new ExceptionContext("DB_LOB_SEQUENCE_EXHAUSTED", "The range of values for sequence ''LOBSequence'' have been exhausted.  The DBA must alter the sequence with a larger range of values and create the corresponding LOB tablespaces in database {0}.  The operation corresponding to adding column {1}.{2} can then be reattempted.");
    public static final ExceptionContext DB_NO_COLUMN_SPECIFIED = new ExceptionContext("DB_NO_COLUMN_SPECIFIED", "At least one column must be specified.");
    public static final ExceptionContext DB_NO_DROP_ON_DB2 = new ExceptionContext("DB_NO_DROP_ON_DB2", "Columns cannot be dropped on DB2 databases.");
    public static final ExceptionContext DB_NO_DROP_ON_ORACLE = new ExceptionContext("DB_NO_DROP_ON_ORACLE", "Columns cannot be dropped on Oracle databases.");
    public static final ExceptionContext DB_NO_MIXEDMODE_COLUMN_CREATES = new ExceptionContext("DB_NO_MIXEDMODE_COLUMN_CREATES", "New columns are not allowed during column modifications.");
    public static final ExceptionContext DB_NO_MIXEDMODE_COLUMN_DROPS = new ExceptionContext("DB_NO_MIXEDMODE_COLUMN_DROPS", "Columns cannot be dropped during column creation or modification.");
    public static final ExceptionContext DB_NO_MIXEDMODE_COLUMN_MODS = new ExceptionContext("DB_NO_MIXEDMODE_COLUMN_MODS", "Column cannot be modified during column creation or deletion.");
    public static final ExceptionContext DB_NO_MIXEDMODE_INDEX_CREATES = new ExceptionContext("DB_NO_MIXEDMODE_INDEX_CREATES", "New column indices are not allowed during column modifications.");
    public static final ExceptionContext DB_NO_MIXEDMODE_INDEX_DROPS = new ExceptionContext("DB_NO_MIXEDMODE_INDEX_DROPS", "Column indices cannot be dropped with other column modifications.");
    public static final ExceptionContext DB_NO_MULTIPLE_COLUMN_MODS = new ExceptionContext("DB_NO_MULTIPLE_COLUMN_MODS", "Column modifications are not allowed on multiple columns in same statement.");
    public static final ExceptionContext DB_NO_TABLE_SPECIFIED = new ExceptionContext("DB_NO_TABLE_SPECIFIED", "No table name was specified.");
    public static final ExceptionContext DB_OUT_OF_MEMORY_ON_DB2 = new ExceptionContext("DB_OUT_OF_MEMORY_ON_DB2", "Increase the APPLHEAPSZ configuration parameter of the target database and retry the operation. {0}");
    public static final ExceptionContext DB_ROWLENGTH_LIMIT_EXCEEDED_ON_DB2_CALCULATED = new ExceptionContext("DB_ROWLENGTH_LIMIT_EXCEEDED_ON_DB2_CALCULATED", "Verify that the pagesize of the hosting tablespace is {0}.  If that is correct, set the ObjectStore property TableOverflowEnabled to true and retry the operation. The system has determined that property ''{1}'' of class ''{2}'' cannot have its column added to table ''{3}'' because the column''s additional size ({4}) will exceed the row length limit of the table.  The calculated row length prior to the addition is {5} and the server is using a tablespace pad of {6} with an overflow table limit of {7}.");
    public static final ExceptionContext DB_ROWLENGTH_LIMIT_EXCEEDED_ON_DB2_NATIVE = new ExceptionContext("DB_ROWLENGTH_LIMIT_EXCEEDED_ON_DB2_NATIVE", "Verify that the pagesize of the hosting tablespace is 32K.  If that is correct, set the ObjectStore property TableOverflowEnabled to true and retry the operation. {0}");
    public static final ExceptionContext DB_ROWLENGTH_LIMIT_EXCEEDED_ON_MSSQL = new ExceptionContext("DB_ROWLENGTH_LIMIT_EXCEEDED_ON_MSSQL", "Decrease the lengths of the properties being inserted or updated and/or remove any unnecessary properties. {0}");
    public static final ExceptionContext DB_UPDATE_COUNT_MISMATCHED = new ExceptionContext("DB_UPDATE_COUNT_MISMATCHED", "Expecting {0} row(s) affected, but found {1} row(s) affected.");
    public static final ExceptionContext DB_UPDATE_COUNT_REQUIRED = new ExceptionContext("DB_UPDATE_COUNT_REQUIRED", "The update count is required, but got {0} instead.");
    public static final ExceptionContext DB_PARSE_CONNECTION_MISSING_URL = new ExceptionContext("DB_PARSE_CONNECTION_MISSING_URL", "The connection URL cannot be acquired.  Please set the following JVM property ''{0}'' to a value in the following format: ''{1}'' and retry the operation.  Note that this JVM property can be added to an Engine.properties file located in the JVM''s working folder.");
    public static final ExceptionContext DB_PARSE_CONNECTION_MISSING_USER = new ExceptionContext("DB_PARSE_CONNECTION_MISSING_USER", "The connection''s database user cannot be acquired.  Please set the following JVM property ''{0}'' to a value in the following format: ''{1}'' and retry the operation.  Note that this JVM property can be added to an Engine.properties file located in the JVM''s working folder.");
    public static final ExceptionContext DB_PARSE_CONNECTION_UNKNOWN_URL = new ExceptionContext("DB_PARSE_CONNECTION_UNKNOWN_URL", "The connection URL ''{0}'' cannot be parsed.  Please set the following JVM property ''{1}'' to a value in the following format: ''{2}'' and retry the operation.  Note that this JVM property can be added to an Engine.properties file located in the JVM''s working folder.");
    public static final ExceptionContext E_BAD_VALUE_RESTRICTION = new ExceptionContext("E_BAD_VALUE_RESTRICTION", "Value is limited to {0}.");
    public static final ExceptionContext E_BAD_DATA_TYPE = new ExceptionContext("E_BAD_DATA_TYPE", "Invalid data type encountered for this operation: {0}.");
    public static final ExceptionContext E_CLASS_DEFINITION_NOT_FOUND = new ExceptionContext("E_CLASS_DEFINITION_NOT_FOUND", "Class definition {0} not found.");
    public static final ExceptionContext E_CLASS_SECURITY_NOT_FOUND = new ExceptionContext("E_CLASS_SECURITY_NOT_FOUND", "Class security {0} not found.");
    public static final ExceptionContext E_CUR_DB_RESULT_AT_EOF = new ExceptionContext("E_CUR_DB_RESULT_AT_EOF", "The current DB result is already positioned after the end of the result set.");
    public static final ExceptionContext E_CUR_DB_RESULT_NOT_AT_EOF = new ExceptionContext("E_CUR_DB_RESULT_NOT_AT_EOF", "The current DB result is expected to be positioned after the end of the result set, but it''s not.");
    public static final ExceptionContext E_CVL_NOT_FOUND = new ExceptionContext("E_CVL_NOT_FOUND", "ChoiceList {0} not found.");
    public static final ExceptionContext E_DATABASE_TYPE_MISSING = new ExceptionContext("E_DATABASE_TYPE_MISSING", "DatabaseType missing for node: {0}.");
    public static final ExceptionContext E_ERROR_LOG_FORMAT = new ExceptionContext("E_ERROR_LOG_FORMAT", "method name: {0} principal name: {1} Global Transaction: {2} User Transaction: {3} Exception Info: {4}");
    public static final ExceptionContext E_EVENT_OBJECTS_READONLY = new ExceptionContext("E_EVENT_OBJECTS_READONLY", "Objects of class \"Event\" cannot be modified.");
    public static final ExceptionContext E_FEXP_BAD_IN_ELEMENT = new ExceptionContext("E_FEXP_BAD_IN_ELEMENT", "Invalid IN syntax.");
    public static final ExceptionContext E_FEXP_BAD_IN_ELEMENT_DATATYPE = new ExceptionContext("E_FEXP_BAD_IN_ELEMENT_DATATYPE", "Value types for the left and right IN elements must be the same.");
    public static final ExceptionContext E_FEXP_BAD_IN_ELEMENT_DATATYPE_LHS = new ExceptionContext("E_FEXP_BAD_IN_ELEMENT_DATATYPE_LHS", "The left IN element must has object value when right IN element is of collection type.");
    public static final ExceptionContext E_FEXP_BAD_IN_ELEMENT_LHS = new ExceptionContext("E_FEXP_BAD_IN_ELEMENT_LHS", "The left IN element must has a value.");
    public static final ExceptionContext E_FEXP_BAD_IN_ELEMENT_RIGHT = new ExceptionContext("E_FEXP_BAD_IN_ELEMENT_RIGHT", "The right IN element must either a literal comma sequence or name of some property of type list.");
    public static final ExceptionContext E_FEXP_CANNOT_GET_PROPERTY = new ExceptionContext("E_FEXP_CANNOT_GET_PROPERTY", "Unable to get property \"{0}\".");
    public static final ExceptionContext E_FEXP_EXPECTED_BOOLEAN_EXPRESSION = new ExceptionContext("E_FEXP_EXPECTED_BOOLEAN_EXPRESSION", "Expected a boolean subexpression but got a {0}.");
    public static final ExceptionContext E_FEXP_WRONG_TYPE_IN_ARITHMETIC_EXPRESSION = new ExceptionContext("E_FEXP_WRONG_TYPE_IN_ARITHMETIC_EXPRESSION", "Expected either integer or double type on all operands inside arithmetic expression, but got a {0}.");
    public static final ExceptionContext E_FEXP_MISSING_REQUIRED_VALUE = new ExceptionContext("E_FEXP_MISSING_REQUIRED_VALUE", "Required value is missing in {0}.");
    public static final ExceptionContext E_FEXP_INCOMPATIBLE_TYPES = new ExceptionContext("E_FEXP_INCOMPATIBLE_TYPES", "Incompatible types {0} and {1}.");
    public static final ExceptionContext E_FEXP_INVALID_CLASS_NAME = new ExceptionContext("E_FEXP_INVALID_CLASS_NAME", "Invalid class name \"{0}\".");
    public static final ExceptionContext E_FEXP_INVALID_DATE_FORMAT = new ExceptionContext("E_FEXP_INVALID_DATE_FORMAT", "Invalid date format \"{0}\".");
    public static final ExceptionContext E_FEXP_INVALID_LIKE_ELEMENT = new ExceptionContext("E_FEXP_INVALID_LIKE_ELEMENT", "The LIKE element must have exactly 2 parameters");
    public static final ExceptionContext E_FEXP_LEFT_IN_ELEMENT_BAD = new ExceptionContext("E_FEXP_LEFT_IN_ELEMENT_BAD", "The left IN element must be an EngineObject property.");
    public static final ExceptionContext E_FEXP_LEFT_LIKE_ELEMENT_BAD = new ExceptionContext("E_FEXP_LEFT_LIKE_ELEMENT_BAD", "The left LIKE element must be a string value.");
    public static final ExceptionContext E_FEXP_RIGHT_IN_ELEMENT_BAD = new ExceptionContext("E_FEXP_RIGHT_IN_ELEMENT_BAD", "The right IN element must be a list or enum property.");
    public static final ExceptionContext E_FEXP_RIGHT_LIKE_ELEMENT_BAD = new ExceptionContext("E_FEXP_RIGHT_LIKE_ELEMENT_BAD", "The right LIKE element must be a literal string");
    public static final ExceptionContext E_FEXP_UNEXPECTED_ALIAS = new ExceptionContext("E_FEXP_UNEXPECTED_ALIAS", "Unexpected alias \"{0}\", only \"Source\" is supported.");
    public static final ExceptionContext E_FEXP_UNSUPPORTED_OPERATOR = new ExceptionContext("E_FEXP_UNSUPPORTED_OPERATOR", "Unsupported operator {0}.");
    public static final ExceptionContext E_GENERIC_INSTANCE_NOT_FOUND = new ExceptionContext("E_GENERIC_INSTANCE_NOT_FOUND", "Object {0}, {1} (ClassId, ObjectId) not found.");
    public static final ExceptionContext E_IMPORT_RETURNED_NULL = new ExceptionContext("E_IMPORT_RETURNED_NULL", "The import of node {0} returned a null value.");
    public static final ExceptionContext E_INVALID_DIRECTORY_LEVELS = new ExceptionContext("E_INVALID_DIRECTORY_LEVELS", "Too many directory levels: [{0}].");
    public static final ExceptionContext E_INVALID_DIRECTORY_STRUCTURE = new ExceptionContext("E_INVALID_DIRECTORY_STRUCTURE", "Invalid directory structure: [{0}].  Bad value for: [{1}].");
    public static final ExceptionContext E_INVALID_LIST_INDEX = new ExceptionContext("E_INVALID_LIST_INDEX", "Invalid dependent object list index {0} property {1}.");
    public static final ExceptionContext E_INVALID_PASSWORD = new ExceptionContext("E_INVALID_PASSWORD", "Invalid password for user {0}.");
    public static final ExceptionContext E_INVALID_USER = new ExceptionContext("E_INVALID_USER", "Invalid user {0}.");
    public static final ExceptionContext E_MARKING_ACCESS_DENIED = new ExceptionContext("E_MARKING_ACCESS_DENIED", "Marking access denied.");
    public static final ExceptionContext E_MAX_LESS_THAN_PRUNE_THRESHOLD = new ExceptionContext("E_MAX_LESS_THAN_PRUNE_THRESHOLD", "A maximum cache level is less than the corresponding pruning threshold.");
    public static final ExceptionContext E_MISSING_REQUIRED_PARAMETER = new ExceptionContext("E_MISSING_REQUIRED_PARAMETER", "A required parameter, {0}, is either missing or empty/null.");
    public static final ExceptionContext E_MODIFY_OBJECTS_DENIED = new ExceptionContext("E_MODIFY_OBJECTS_DENIED", "Not granted MODIFY OBJECTS permission on the object store.");
    public static final ExceptionContext E_NAME_NOT_UNIQUE = new ExceptionContext("E_NAME_NOT_UNIQUE", "Name not unique: {0}.");
    public static final ExceptionContext E_OBJECT_IDENTIFICATION = new ExceptionContext("E_OBJECT_IDENTIFICATION", "Object identity: {0}.  Class name: {1}.");
    public static final ExceptionContext E_NONREPOSITORY_OBJECT_NOT_FOUND = new ExceptionContext("E_NONREPOSITORY_OBJECT_NOT_FOUND", "Non-repository object {0} not found.");
    public static final ExceptionContext E_NOT_IN_RANGE = new ExceptionContext("E_NOT_IN_RANGE", "Property {0} must have a value between {1} and {2}");
    public static final ExceptionContext E_OBJECT_STORE_NOT_FOUND = new ExceptionContext("E_OBJECT_STORE_NOT_FOUND", "Object store {0} not found.");
    public static final ExceptionContext E_OVP_INSTANCE_NOT_FOUND = new ExceptionContext("E_OVP_INSTANCE_NOT_FOUND", "propertyName={0}, referenced objectId={1}, referenced className={2}, referenced classId={3}");
    public static final ExceptionContext E_PRINCIPAL_NOT_FOUND = new ExceptionContext("E_PRINCIPAL_NOT_FOUND", "Principal {0} not found.");
    public static final ExceptionContext E_PRINCIPAL_NOT_FOUND_FOR_PROPERTY = new ExceptionContext("E_PRINCIPAL_NOT_FOUND_FOR_PROPERTY", "propertyName={0}, referenced principal={1}");
    public static final ExceptionContext E_PROPERTY_NAME = new ExceptionContext("E_PROPERTY_NAME", "Property {0}.");
    public static final ExceptionContext E_PROPERTY_DEFINITION_NOT_FOUND = new ExceptionContext("E_PROPERTY_DEFINITION_NOT_FOUND", "Can''t retrieve property definition for index {0}.");
    public static final ExceptionContext E_REF_CANNOT_ACCESS_FIELD = new ExceptionContext("E_REF_CANNOT_ACCESS_FIELD", "Cannot access a Java field, {0}.");
    public static final ExceptionContext E_REF_CANNOT_ACCESS_METHOD = new ExceptionContext("E_REF_CANNOT_ACCESS_METHOD", "Cannot access a Java method, {0}.");
    public static final ExceptionContext E_REF_CANNOT_INSTANTIATE = new ExceptionContext("E_REF_CANNOT_INSTANTIATE", "Cannot instantiate a Java class, {0}.");
    public static final ExceptionContext E_REF_CLASS_NOT_FOUND = new ExceptionContext("E_REF_CLASS_NOT_FOUND", "A Java class, {0}, couldn''t be found.");
    public static final ExceptionContext E_REF_ILLEGAL_ACCESS = new ExceptionContext("E_REF_ILLEGAL_ACCESS", "Cannot access a Java class, {0}.");
    public static final ExceptionContext E_REF_LINKAGE_ERROR = new ExceptionContext("E_REF_LINKAGE_ERROR", "Cannot load a Java class, {0}.");
    public static final ExceptionContext E_REF_METHOD_THREW_EXCEPTION = new ExceptionContext("E_REF_METHOD_THREW_EXCEPTION", "Invocation of Java method, {0}, threw an exception.");
    public static final ExceptionContext E_REF_NO_SUCH_FIELD = new ExceptionContext("E_REF_NO_SUCH_FIELD", "Cannot find a Java field, {0}.");
    public static final ExceptionContext E_REF_NO_SUCH_METHOD = new ExceptionContext("E_REF_NO_SUCH_METHOD", "Cannot find a Java method, {0}.");
    public static final ExceptionContext E_REQUIRED_PROPERTY_ABSENT = new ExceptionContext("E_REQUIRED_PROPERTY_ABSENT", "Required property {0} is missing.");
    public static final ExceptionContext E_SERVER_INSTANCE_NOT_DETERMINED = new ExceptionContext("E_SERVER_INSTANCE_NOT_DETERMINED", "The server instance name cannot be determined.  Set the property CEMPServerInstanceName and restart the application server.");
    public static final ExceptionContext E_SQL_STMT_USED = new ExceptionContext("E_SQL_STMT_USED", "SQL: {0}.");
    public static final ExceptionContext E_STORAGE_POLICY_NOT_FOUND = new ExceptionContext("E_STORAGE_POLICY_NOT_FOUND", "StoragePolicy {0} not found.");
    public static final ExceptionContext E_SUPERCLASS_PROPERTIES_EMPTY = new ExceptionContext("E_SUPERCLASS_PROPERTIES_EMPTY", "Property definition list is empty on superclass.");
    public static final ExceptionContext E_TABLE_DEFINITION_NOT_FOUND = new ExceptionContext("E_TABLE_DEFINITION_NOT_FOUND", "TableDefinition {0} not found.");
    public static final ExceptionContext E_UPDATE_SECURITY_OF_PROXIED_OBJECT = new ExceptionContext("E_UPDATE_SECURITY_OF_PROXIED_OBJECT", "Attempt to modify security of proxied object.");
    public static final ExceptionContext E_UTIL_NOT_ENOUGH_DATA_AVAILABLE = new ExceptionContext("E_UTIL_NOT_ENOUGH_DATA_AVAILABLE", "Unable to read {0} bytes.");
    public static final ExceptionContext E_UTIL_READ_EXCEPTION = new ExceptionContext("E_UTIL_READ_EXCEPTION", "Exception while reading data.");
    public static final ExceptionContext E_UTIL_WRITE_EXCEPTION = new ExceptionContext("E_UTIL_WRITE_EXCEPTION", "Exception while writing data.");
    public static final ExceptionContext E_WEBLOGIC_UNABLE_TO_DETERMINE_PROVIDER = new ExceptionContext("E_WEBLOGIC_UNABLE_TO_DETERMINE_PROVIDER", "Unable to determine provider from {0}.");
    public static final ExceptionContext E_TRANSACTION_REQUIRED = new ExceptionContext("E_TRANSACTION_REQUIRED", "Specified operation requires an active transaction.");
    public static final ExceptionContext E_TRANSACTION_COMMIT_FAILED = new ExceptionContext("E_TRANSACTION_COMMIT_FAILED", "An attempt to commit the distributed transaction failed (prior status={0}).");
    public static final ExceptionContext E_TRANSACTION_ROLLBACK_FAILED = new ExceptionContext("E_TRANSACTION_ROLLBACK_FAILED", "An attempt to rollback the distributed transaction failed (prior status={0}).");
    public static final ExceptionContext E_UNFINISHED_DISTRIBUTED_TRANSACTION = new ExceptionContext("E_UNFINISHED_DISTRIBUTED_TRANSACTION", "Internal error; an unfinished distributed transaction was rolled back.");
    public static final ExceptionContext E_UNFINISHED_LOCAL_TRANSACTION = new ExceptionContext("E_UNFINISHED_LOCAL_TRANSACTION", "Internal error; an unfinished local transaction was rolled back.");
    public static final ExceptionContext E_ONE_LOCAL_TRANSACTION_ALLOWED = new ExceptionContext("E_ONE_LOCAL_TRANSACTION_ALLOWED", "Only one local transaction is allowed.");
    public static final ExceptionContext E_EXPECTED_ACTIVE_TRANSACTION = new ExceptionContext("E_EXPECTED_ACTIVE_TRANSACTION", "The current transaction is not active.");
    public static final ExceptionContext E_EXPECTED_ACTIVE_TRANSACTION_STATE = new ExceptionContext("E_EXPECTED_ACTIVE_TRANSACTION_STATE", "The current transaction state is {0} and it was expected to be active");
    public static final ExceptionContext E_ONLY_VALID_WITH_LOCAL_TRANSACTION = new ExceptionContext("E_ONLY_VALID_WITH_LOCAL_TRANSACTION", "The current method is only valid for local transactions");
    public static final ExceptionContext E_WRONG_TYPE_OBJECT = new ExceptionContext("E_WRONG_TYPE_OBJECT", "Can''t retrieve a domain object from an object store");
    public static final ExceptionContext E_UPGRADE_TARGET_NOT_FOUND = new ExceptionContext("E_UPGRADE_TARGET_NOT_FOUND", "Upgrade target id {0} not found in GCD - ObjectStore or Domain expected!");
    public static final ExceptionContext E_INVALID_UPGRADE_TARGET = new ExceptionContext("E_INVALID_UPGRADE_TARGET", "Upgrade target id {0} is not an ObjectStore or a Domain!");
    public static final ExceptionContext E_INVALID_UPGRADE_START_PHASE = new ExceptionContext("E_INVALID_UPGRADE_START_PHASE", "Starting phase {0} has no associated upgrader class!");
    public static final ExceptionContext E_INVALID_UPGRADE_END_PHASE = new ExceptionContext("E_INVALID_UPGRADE_END_PHASE", "Ending phase {0} has no associated upgrader class or is not a final phase!");
    public static final ExceptionContext E_UPGRADE_INREVISION_NOT_SUPPORTED = new ExceptionContext("E_UPGRADE_INREVISION_NOT_SUPPORTED", "inRevision {0} not supported by auto-upgrader.");
    public static final ExceptionContext E_FEXP_INVALID_ISMODIFIED_ELEMENT = new ExceptionContext("E_FEXP_INVALID_ISMODIFIED_ELEMENT", "The ISMODIFIED element can have only one parameter.");
    public static final ExceptionContext E_FEXP_ISMODIFIED_ELEMENT_BAD = new ExceptionContext("E_FEXP_ISMODIFIED_ELEMENT_BAD", "The ISMODIFIED element must be a property type.");
    public static final ExceptionContext E_INVALID_METHOD_DURING_CHANGE_PREPROCESSING = new ExceptionContext("E_INVALID_METHOD_DURING_CHANGE_PREPROCESSING", "Calls to the {0} method are prohibited from Change Preprocessors.");
    public static final ExceptionContext E_UAO_MISSING_METADATA = new ExceptionContext("E_UAO_MISSING_METADATA", "The {0} ''{1}'' cannot be located for upgrade by the UpgradeAddOn.  This metadata must be present for upgrade to continue.  Ensure the proper steps are taken to restore this object which will likely consist of the manual import of the AddOn''s import data.");
    public static final ExceptionContext E_MISSING_SUPERCLASS_DEFINITION = new ExceptionContext("E_MISSING_SUPERCLASS_DEFINITION", "The SuperclassDefinition stanza corresponding to ClassDefinition ''{0}'' is not present in the AddOn import data.  Ensure that this stanza is added to the AddOn import data, update the AddOn, and retry the operation.");
    public static final ExceptionContext EVENT_QUEUED_OBJ_NOT_OF_REQUIRED_CLASS = new ExceptionContext("EVENT_QUEUED_OBJ_NOT_OF_REQUIRED_CLASS", "The object serialized on the storage queue is not an instance of ContentElementList");
    public static final ExceptionContext EVENT_STORAGE_QUEUE_NOT_FOUND = new ExceptionContext("EVENT_STORAGE_QUEUE_NOT_FOUND", "StorageQueue item {0}, not found.");
    public static final ExceptionContext GCD_BAD_ATTRIBUTE_TYPE = new ExceptionContext("GCD_BAD_ATTRIBUTE_TYPE", "The attribute is of the wrong type: {0}.");
    public static final ExceptionContext GCD_CONTAINER_MISSING = new ExceptionContext("GCD_CONTAINER_MISSING", "The container for class {0} cannot be found.");
    public static final ExceptionContext GCD_DELETED_NONREPOSITORY_OBJECT_NOT_FOUND = new ExceptionContext("GCD_DELETED_NONREPOSITORY_OBJECT_NOT_FOUND", "non-repository object {0} not found, it''s been deleted.");
    public static final ExceptionContext GCD_FIXED_CONTENT_DEVICE_NOT_FOUND = new ExceptionContext("GCD_FIXED_CONTENT_DEVICE_NOT_FOUND", "TableDefinition {0} not found.");
    public static final ExceptionContext GCD_INITIALIZE_NOT_CALLED = new ExceptionContext("GCD_INITIALIZE_NOT_CALLED", "GCDCache.initialize has not been called.");
    public static final ExceptionContext GCD_MARKINGSET_NOT_FOUND = new ExceptionContext("GCD_MARKINGSET_NOT_FOUND", "MarkingSet {0} not found.");
    public static final ExceptionContext GCD_MISMATCHED_EPOCH_IDS = new ExceptionContext("GCD_MISMATCHED_EPOCH_IDS", "Persister epoch, {0}, is not the same as the XML epoch, {1}.");
    public static final ExceptionContext GCD_MISSING_BOOTSTRAP_PARAMETER = new ExceptionContext("GCD_MISSING_BOOTSTRAP_PARAMETER", "Cannot access bootstrap parameter from resource. {0}");
    public static final ExceptionContext GCD_MISSING_PARENT = new ExceptionContext("GCD_MISSING_PARENT", "The {0} object could not locate its parent {1} object.");
    public static final ExceptionContext GCD_MISSING_SERVER_INSTANCE = new ExceptionContext("GCD_MISSING_SERVER_INSTANCE", "The ServerInstance object does not exist.");
    public static final ExceptionContext GCD_OBJECT_ID_MISSING = new ExceptionContext("GCD_OBJECT_ID_MISSING", "Missing object id.");
    public static final ExceptionContext GCD_OBJECT_TYPE_MISSING = new ExceptionContext("GCD_OBJECT_TYPE_MISSING", "Missing object type.");
    public static final ExceptionContext GCD_OBJECT_TYPE_NOT_UNIQUE = new ExceptionContext("GCD_OBJECT_TYPE_NOT_UNIQUE", "Object type not unique: {0}.");
    public static final ExceptionContext GCD_VALUE_TYPE = new ExceptionContext("GCD_VALUE_TYPE", "Unknown GCD value type {0}.");
    public static final ExceptionContext IMEX_DB_DERBY_DRIVER_NOT_FOUND = new ExceptionContext("IMEX_DB_DERBY_DRIVER_NOT_FOUND", "Could not find the Apache Derby driver for the temporary export disk cache.");
    public static final ExceptionContext IMEX_DB_ERROR_SQL_STATEMENT = new ExceptionContext("IMEX_DB_ERROR_SQL_STATEMENT", "{0}");
    public static final ExceptionContext IMEX_DB_DERBY_STARTUP_ERROR = new ExceptionContext("IMEX_DB_DERBY_STARTUP_ERROR", "Derby temporary export disk cache failed to startup.");
    public static final ExceptionContext IS_PD_ANNOT_ACTION_NOT_SUP = new ExceptionContext("IS_PD_ANNOT_ACTION_NOT_SUP", "Annotation Export Log action {0} is not supported.");
    public static final ExceptionContext IS_PD_ANNOT_COMMIT_ERROR = new ExceptionContext("IS_PD_ANNOT_COMMIT_ERROR", "{0} annotation log entries have been retrieved, only {1} entries have been processed.");
    public static final ExceptionContext IS_PD_ANNOT_INFO = new ExceptionContext("IS_PD_ANNOT_INFO", "Annotation for document {0} page {1} annotation id {2} {3} is not federated.");
    public static final ExceptionContext IS_PD_ANNOT_XML_LEN = new ExceptionContext("IS_PD_ANNOT_XML_LEN", "The annotation content for document {0} page {1} annotation id {2} {3} cannot be read. Available content length is {4}, only read {5}.");
    public static final ExceptionContext IS_PD_CANNOT_CLEAR_DOC_SHM = new ExceptionContext("IS_PD_CANNOT_CLEAR_DOC_SHM", "The annotation processing data on Image Services cannot be cleared when the Content Engine is being shutdown.");
    public static final ExceptionContext IS_PD_CANNOT_READ_ANNOT_XML = new ExceptionContext("IS_PD_CANNOT_READ_ANNOT_XML", "The annotation content for document {0} page {1} and annotation id {2} {3} cannot be read.");
    public static final ExceptionContext IS_PD_CANT_ADD_COMPENT = new ExceptionContext("IS_PD_CANT_ADD_COMPENT", "The export log or annotation log sequence numbers [{0}] [{1}] cannot be added to the list of completed entries.");
    public static final ExceptionContext IS_PD_DELETE_ANNOT_ERROR = new ExceptionContext("IS_PD_DELETE_ANNOT_ERROR", "Annotation {0} for federated document {1} page {2} annotation id {3} {4} cannot be deleted.");
    public static final ExceptionContext IS_PD_DOC_INFO = new ExceptionContext("IS_PD_DOC_INFO", "The document {0} is not federated.");
    public static final ExceptionContext IS_PD_FETCH_ANNOT_ERROR = new ExceptionContext("IS_PD_FETCH_ANNOT_ERROR", "The annotation {0} for the federated document {1} page {2} annotation id {3} {4} cannot be fetched.");
    public static final ExceptionContext IS_PD_GET_ANNOT_LOG_ERROR = new ExceptionContext("IS_PD_GET_ANNOT_LOG_ERROR", "The annotation log entries from an external repository {0} cannot be retrieved. If the Image Services software is down, start the software as soon as possible.");
    public static final ExceptionContext IS_PD_HOSTID_EXCEED_MAX = new ExceptionContext("IS_PD_HOSTID_EXCEED_MAX", "The Content Engine Host id [{0}] exceeds the maximum length of {1}.");
    public static final ExceptionContext IS_PD_IS_SEC_ID = new ExceptionContext("IS_PD_IS_SEC_ID", "The Image Services principal id is {0}.");
    public static final ExceptionContext IS_PD_MAPPED_INDEX = new ExceptionContext("IS_PD_MAPPED_INDEX", "The document ID is {0}, the mapped Image Services index ID is {1}.");
    public static final ExceptionContext IS_PD_NO_DN = new ExceptionContext("IS_PD_NO_DN", "The Distinguished Name for security object {0} [ID {1}] cannot be obtained from Image Services server {2}.");
    public static final ExceptionContext IS_PD_SAVE_ANNOT_ERROR = new ExceptionContext("IS_PD_SAVE_ANNOT_ERROR", "The annotation {0} for the external document {1}, page {2}, and annotation id {3} {4} cannot be written to the database.");
    public static final ExceptionContext IS_PD_UNSUPPORTED_ENCODING = new ExceptionContext("IS_PD_UNSUPPORTED_ENCODING", "The UTF-8 encoding is not supported.");
    public static final ExceptionContext IS_PD_WRONG_LOG_COUNT = new ExceptionContext("IS_PD_WRONG_LOG_COUNT", "Total log entries are {0}. Processed {1} insert, {2} export, {3} update, {4} delete, {5} skipped, {6} error.");
    public static final ExceptionContext IS_CLOSE_PROVIDER_FAILED = new ExceptionContext("IS_CLOSE_PROVIDER_FAILED", "One or more Image Services workers are busy.  The Image Services replication provider {0} cannot be shutdown.");
    public static final ExceptionContext IS_VERSIONING_NOT_SUPPORTED = new ExceptionContext("IS_VERSIONING_NOT_SUPPORTED", "Image Services Replication does not support versioning of documents.");
    public static final ExceptionContext IS_OUTBOUND_REPLICATION_NOT_SUPPORTED = new ExceptionContext("IS_OUTBOUND_REPLICATION_NOT_SUPPORTED", "Outbound replication is not supported on the Image Services system {0} running version {1}.");
    public static final ExceptionContext IS_REPLICATION_OBJECT_TYPE_NOT_SUPPORTED = new ExceptionContext("IS_REPLICATION_OBJECT_TYPE_NOT_SUPPORTED", "Image Services Replication only supports replication of documents and annotations.");
    public static final ExceptionContext IS_REPLICATION_PUSHWORKER_NOT_AVAILABLE = new ExceptionContext("IS_REPLICATION_PUSHWORKER_NOT_AVAILABLE", "All outbound workers for the Image Services system {0} are busy.  There are {1} outbound workers configured.");
    public static final ExceptionContext IS_REPLICATION_PULLWORKER_NOT_AVAILABLE = new ExceptionContext("IS_REPLICATION_PULLWORKER_NOT_AVAILABLE", "The inbound worker {0} for the Image Services system {1} is busy.");
    public static final ExceptionContext IS_REPLICATION_PROVIDER_NOT_INITIALIZED = new ExceptionContext("IS_REPLICATION_PROVIDER_NOT_INITIALIZED", "The function of the Image Services Replication Provider for {0} was called before it has been initialized.");
    public static final ExceptionContext IS_REPLICATION_PROVIDER_ALREADY_INITIALIZED = new ExceptionContext("IS_REPLICATION_PROVIDER_ALREADY_INITIALIZED", "An attempt was made to reinitialize the Image Services replication provider for {0}.");
    public static final ExceptionContext IS_PULL_WORKER_INDEX_INVALID = new ExceptionContext("IS_PULL_WORKER_INDEX_INVALID", "The inbound worker index {0} is not valid. The index must be non-negative and less than {1}.");
    public static final ExceptionContext IS_UNEXPECTED_JOURNAL_OPERATION = new ExceptionContext("IS_UNEXPECTED_JOURNAL_OPERATION", "The replication operation {0} is not expected.");
    public static final ExceptionContext IS_INV_NUM_EXTOBJID = new ExceptionContext("IS_INV_NUM_EXTOBJID", "The number of external object IDs in object {0} is not expected.");
    public static final ExceptionContext IS_CREATE_ERROR_RETRY = new ExceptionContext("IS_CREATE_ERROR_RETRY", "The create action for document {0} [external id {1}] cannot be replicated to the Image Services system {2}. The error is {3}. The journal will be retried. No action is required.");
    public static final ExceptionContext IS_CREATE_ERROR_DELETE = new ExceptionContext("IS_CREATE_ERROR_DELETE", "The create action for document {0} [external id {1}] cannot be replicated to the Image Services system {2}. The error is {3}. The journal will be deleted.");
    public static final ExceptionContext IS_CREATE_ERROR = new ExceptionContext("IS_CREATE_ERROR", "The create action for document {0} [external id {1}] cannot be replicated to the Image Services system {2}. The error is {3}. The journal will be suspended.");
    public static final ExceptionContext IS_CE_DCL_NOT_MAPPED = new ExceptionContext("IS_CE_DCL_NOT_MAPPED", "The document class {0} is not mapped for outbound replication for object store {1} and Fixed Content Device {2}.");
    public static final ExceptionContext IS_CANNOT_CONVERT_CE_PROP = new ExceptionContext("IS_CANNOT_CONVERT_CE_PROP", "The property {0} in document {1} cannot be converted.");
    public static final ExceptionContext IS_CANNOT_GET_DOC_HDR_SIZE = new ExceptionContext("IS_CANNOT_GET_DOC_HDR_SIZE", "The document header size for document {0} cannot be determined.");
    public static final ExceptionContext IS_NOT_CONTENT_TRANSFER = new ExceptionContext("IS_NOT_CONTENT_TRANSFER", "One of the content elements in document {0} has external content. It cannot be replicated to the Image Services system.");
    public static final ExceptionContext IS_ZERO_CONTENT_SIZE = new ExceptionContext("IS_ZERO_CONTENT_SIZE", "One of the content elements in document {0} has zero size. It cannot be replicated to the Image Services system.");
    public static final ExceptionContext IS_CANNOT_GET_OS_IDX = new ExceptionContext("IS_CANNOT_GET_OS_IDX", "The object store index for object store {0} cannot be obtained from the Image Services system {1}.");
    public static final ExceptionContext IS_INVALID_REPO = new ExceptionContext("IS_INVALID_REPO", "The external repository {0} is not valid for Image Services Fixed Content Device {1}.");
    public static final ExceptionContext IS_NOT_DOCUMENT = new ExceptionContext("IS_NOT_DOCUMENT", "Object {0} is not a document.");
    public static final ExceptionContext IS_INITIALOBJ_DIFFERENT_FROM_FINALOBJ = new ExceptionContext("IS_INITIALOBJ_DIFFERENT_FROM_FINALOBJ", "The initial object Id {0} does not match the final object Id {1} in the replication journal.");
    public static final ExceptionContext IS_UPDATE_ERROR_RETRY = new ExceptionContext("IS_UPDATE_ERROR_RETRY", "The update action for document {0} [external id {1}] cannot be replicated to the Image Services system {2}. The error is {3}. The journal will be retried. No action is required.");
    public static final ExceptionContext IS_UPDATE_ERROR_DELETE = new ExceptionContext("IS_UPDATE_ERROR_DELETE", "The update action for document {0} [external id {1}] cannot be replicated to the Image Services system {2}. The error is {3}. The journal will be deleted.");
    public static final ExceptionContext IS_UPDATE_ERROR = new ExceptionContext("IS_UPDATE_ERROR", "The update action for document {0} [external id {1}] cannot be replicated to the Image Services system {2}. The error is {3}. The journal will be suspended.");
    public static final ExceptionContext IS_UNEXPECTED_CHANGEREQUEST = new ExceptionContext("IS_UNEXPECTED_CHANGEREQUEST", "The Change Request for document {0} is not expected.");
    public static final ExceptionContext IS_MISSING_CE_PROP = new ExceptionContext("IS_MISSING_CE_PROP", "The property {0} is missing from the internal properties map. Document {1} cannot be processed.");
    public static final ExceptionContext IS_REPLICATION_OPERATION_NOT_SUPPORTED = new ExceptionContext("IS_REPLICATION_OPERATION_NOT_SUPPORTED", "Image Services does not support {0} operation for {1} class.");
    public static final ExceptionContext IS_PULLWORKER_ALREADY_INIT = new ExceptionContext("IS_PULLWORKER_ALREADY_INIT", "The Replication worker {0} for Fixed Content Device {1} has already been initialized. It cannot be reinitialized.");
    public static final ExceptionContext IS_PULLWORKER_NOT_INIT = new ExceptionContext("IS_PULLWORKER_NOT_INIT", "Replication worker for Replication Group {0} is not initialized.");
    public static final ExceptionContext IS_DELETE_ERROR_RETRY = new ExceptionContext("IS_DELETE_ERROR_RETRY", "The Delete action for document {0} [external id {1}] cannot be replicated to the Image Services system {2}. The error is {3}. The journal will be retried. No action is required.");
    public static final ExceptionContext IS_DELETE_ERROR_DELETE = new ExceptionContext("IS_DELETE_ERROR_DELETE", "The Delete action for document {0} [external id {1}] cannot be replicated to the Image Services system {2}. The error is {3}. The journal will be deleted.");
    public static final ExceptionContext IS_DELETE_ERROR = new ExceptionContext("IS_DELETE_ERROR", "The Delete action for document {0} [external id {1}] cannot be replicated to the Image Services system {2}. The error is {3}. The journal will be suspended.");
    public static final ExceptionContext IS_PD_UPDATE_DOC_NOT_FOUND = new ExceptionContext("IS_PD_UPDATE_DOC_NOT_FOUND", "The document {0} cannot be retrieved for update. The document may have been deleted.");
    public static final ExceptionContext IS_DEREPL_ERROR_RETRY = new ExceptionContext("IS_DEREPL_ERROR_RETRY", "The Dereplicate action for document {0} [external id {1}] cannot be replicated to the Image Services system {2}. The error is {3}. The journal will be retried. No action is required.");
    public static final ExceptionContext IS_DEREPL_ERROR_DELETE = new ExceptionContext("IS_DEREPL_ERROR_DELETE", "The Dereplicate action for document {0} [external id {1}] cannot be replicated to the Image Services system {2}. The error is {3}. The journal will be deleted.");
    public static final ExceptionContext IS_DEREPL_ERROR = new ExceptionContext("IS_DEREPL_ERROR", "The Dereplicate action for document {0} [external id {1}] cannot be replicated to the Image Services system {2}. The error is {3}. The journal will be suspended.");
    public static final ExceptionContext IS_FAILED_GETTING_IS_DOCID = new ExceptionContext("IS_FAILED_GETTING_IS_DOCID", "The external object ID cannot be obtained from document {0}.");
    public static final ExceptionContext IS_UNEXPECTED_OS = new ExceptionContext("IS_UNEXPECTED_OS", "The worker is servicing object store {0} but got work for object store {1}.");
    public static final ExceptionContext IS_PARSER_ERROR = new ExceptionContext("IS_PARSER_ERROR", "The content in annotation {0} cannot be parsed.");
    public static final ExceptionContext IS_UNEXPECTED_OBJSTORE = new ExceptionContext("IS_UNEXPECTED_OBJSTORE", "Replication worker {0} is initialized for object store {1}, but received work request for object store {2}.");
    public static final ExceptionContext IS_INDEX_DATE_FORMAT_ERROR = new ExceptionContext("IS_INDEX_DATE_FORMAT_ERROR", "The Date property {1} with value [{2}] from the external document {0} cannot be formatted.");
    public static final ExceptionContext IS_CEPROP_DATE_FORMAT_ERROR = new ExceptionContext("IS_CEPROP_DATE_FORMAT_ERROR", "The Date property {1} with value [{2}] from document {0} cannot be formatted.");
    public static final ExceptionContext IS_PD_CE_PROP_OVERRIDDEN = new ExceptionContext("IS_PD_CE_PROP_OVERRIDDEN", "The updated property value on the Content Engine will be overridden by the values from the Image Services system.");
    public static final ExceptionContext IS_CLOSE_WORKERS_FAILED = new ExceptionContext("IS_CLOSE_WORKERS_FAILED", "One or more workers for the replication group {0} cannot be closed.");
    public static final ExceptionContext IS_ANNOT_CREATE_ERROR_RETRY = new ExceptionContext("IS_ANNOT_CREATE_ERROR_RETRY", "The Create action for annotation {0} [external id {1}] cannot be replicated to the Image Services system {2}. The error is {3}. The journal will be retried. No action is required.");
    public static final ExceptionContext IS_ANNOT_CREATE_ERROR_DELETE = new ExceptionContext("IS_ANNOT_CREATE_ERROR_DELETE", "The Create action for annotation {0} [external id {1}] cannot be replicated to the Image Services system {2}. The error is {3}. The journal will be deleted.");
    public static final ExceptionContext IS_ANNOT_CREATE_ERROR = new ExceptionContext("IS_ANNOT_CREATE_ERROR", "The Create action for annotation {0} [external id {1}] cannot be replicated to the Image Services system {2}. The error is {3}. The journal will be suspended.");
    public static final ExceptionContext IS_UNEXPECTED_ANNOT_CONTENT = new ExceptionContext("IS_UNEXPECTED_ANNOT_CONTENT", "The content in annotation {0} is not expected.");
    public static final ExceptionContext IS_ANNOT_EXCEED_MAX_SIZE = new ExceptionContext("IS_ANNOT_EXCEED_MAX_SIZE", "The binary length for annotation {0} exceeds the maximum size of {1}.");
    public static final ExceptionContext IS_UNEXPECTED_ANNOT_ATTR = new ExceptionContext("IS_UNEXPECTED_ANNOT_ATTR", "The attribute {0} in annotation {1} is not expected.");
    public static final ExceptionContext IS_ANNOT_CANT_MAP_PERMISSION = new ExceptionContext("IS_ANNOT_CANT_MAP_PERMISSION", "The access permission in the annotation {0} cannot be mapped to the Image Services security. Fix the security mapping on the Image Services system or the permission in the annotation.");
    public static final ExceptionContext IS_ANNOT_NOT_SUPPORTED = new ExceptionContext("IS_ANNOT_NOT_SUPPORTED", "The class in annotation {0} is not supported, or the number of content elements is not one, or the Annotated Content Element property is null.");
    public static final ExceptionContext IS_NOT_ANNOTATION = new ExceptionContext("IS_NOT_ANNOTATION", "Object {0} is not an annotation.");
    public static final ExceptionContext IS_ANNOT_UPDATE_ERROR_RETRY = new ExceptionContext("IS_ANNOT_UPDATE_ERROR_RETRY", "The update action for annotation {0} [external id {1}] cannot be replicated to the Image Services system {2}. The error is {3}. The journal will be retried. No action is required.");
    public static final ExceptionContext IS_ANNOT_UPDATE_ERROR_DELETE = new ExceptionContext("IS_ANNOT_UPDATE_ERROR_DELETE", "The Update action for annotation {0} [external ID {1}] cannot be replicated to the Image Services system {2}. The error is {3}. The journal will be deleted.");
    public static final ExceptionContext IS_ANNOT_UPDATE_ERROR = new ExceptionContext("IS_ANNOT_UPDATE_ERROR", "The update action for annotation {0} [external ID {1}] cannot be replicated to the Image Services system {2}. The error is {3}. The journal will be suspended.");
    public static final ExceptionContext IS_ANNOT_DELETE_ERROR_RETRY = new ExceptionContext("IS_ANNOT_DELETE_ERROR_RETRY", "The delete action for annotation {0} [external ID {1}] cannot be replicated to the Image Services system {2}. The error is {3}. The journal will be retried. No action is required.");
    public static final ExceptionContext IS_ANNOT_DELETE_ERROR_DELETE = new ExceptionContext("IS_ANNOT_DELETE_ERROR_DELETE", "The delete action for annotation {0} [external ID {1}] cannot be replicated to the Image Services system {2}. The error is {3}. The journal will be deleted.");
    public static final ExceptionContext IS_ANNOT_DELETE_ERROR = new ExceptionContext("IS_ANNOT_DELETE_ERROR", "The delete action for annotation {0} [external ID {1}] cannot be replicated to the Image Services system {2}. The error is {3}. The journal will be suspended.");
    public static final ExceptionContext IS_DEREPL_CANT_RESET_REPL_DATA = new ExceptionContext("IS_DEREPL_CANT_RESET_REPL_DATA", "The replication data in document {0} [external object id {1}] and the associated annotations cannot be reset. The de-replicate request will not be sent to the Image Services system {2}.");
    public static final ExceptionContext IS_ISR_NOT_CREATED = new ExceptionContext("IS_ISR_NOT_CREATED", "The Image Services Repository has not been created for Fixed Content Device {0}.");
    public static final ExceptionContext IS_UNEXPECTED_CAPABILITY = new ExceptionContext("IS_UNEXPECTED_CAPABILITY", "Image Services Replication Provider is being called with an unexpected capability {0}.");
    public static final ExceptionContext IS_CANNOT_MODIFY_EXT_PART = new ExceptionContext("IS_CANNOT_MODIFY_EXT_PART", "The external participant object in replication group [{0}] cannot be modified.");
    public static final ExceptionContext IS_DOC_HAS_NO_CONTENT = new ExceptionContext("IS_DOC_HAS_NO_CONTENT", "Document {0} has no content. It will not be replicated to Image Services.");
    public static final ExceptionContext IS_PD_ANNOT_MODIFY_DATE_ERROR = new ExceptionContext("IS_PD_ANNOT_MODIFY_DATE_ERROR", "The federated annotation for document {0}, page {1} and annotation id {2} {3} cannot be updated. The last modify date {4} on Content Engine is later than the last modify date {5} on Image Services.");
    public static final ExceptionContext IS_INVALID_INDEX_VALUE = new ExceptionContext("IS_INVALID_INDEX_VALUE", "IS property [{0}] with value [{1}] in document {2} is not valid for the target Image Services repository.");
    public static final ExceptionContext IS_INVALID_INDEXES = new ExceptionContext("IS_INVALID_INDEXES", "One or more property values in Document {0} is not valid. It will not be replicated.");
    public static final ExceptionContext IS_CANT_VALIDATE_INDEXES = new ExceptionContext("IS_CANT_VALIDATE_INDEXES", "The index values for document {0} cannot be validated.");
    public static final ExceptionContext IS_DOC_NOT_DELETEABLE = new ExceptionContext("IS_DOC_NOT_DELETEABLE", "The document {0} cannot be deleted. The external document [{1}] is under retention control.");
    public static final ExceptionContext IS_EX_WITH_DOC_IS_DELETEABLE = new ExceptionContext("IS_EX_WITH_DOC_IS_DELETEABLE", "The document {0} cannot be deleted. The provider cannot determine if the external document [{1}] can be deleted. The external repository could be down.");
    public static final ExceptionContext IS_DOC_PROP_MISMATCH_FAILURE = new ExceptionContext("IS_DOC_PROP_MISMATCH_FAILURE", "The value in the external property {0} does not match the Content Engine property {1}.");
    public static final ExceptionContext IS_EXPORT_ANNOT_DISABLED = new ExceptionContext("IS_EXPORT_ANNOT_DISABLED", "Outbound replication of annotation is disabled. You must enable the Export Annotation option on the Image Services system {0}.");
    public static final ExceptionContext IS_TFO_ERROR_RETRY = new ExceptionContext("IS_TFO_ERROR_RETRY", "The TakeFederatedOwnership action for document {0} [external id {1}] cannot be replicated to the Image Services system {2}. The error is {3}. The journal will be retried. No action is required.");
    public static final ExceptionContext IS_TFO_ERROR_DELETE = new ExceptionContext("IS_TFO_ERROR_DELETE", "The TakeFederatedOwnership action for document {0} [external id {1}] cannot be replicated to the Image Services system {2}. The error is {3}. The journal will be deleted.");
    public static final ExceptionContext IS_TFO_ERROR = new ExceptionContext("IS_TFO_ERROR", "The TakeFederatedOwnership action for document {0} [external id {1}] cannot be replicated to the Image Services system {2}. The error is {3}. The journal will be suspended.");
    public static final ExceptionContext IS_DEREPLICATE_ANNOT_NOT_SUPPORTED = new ExceptionContext("IS_DEREPLICATE_ANNOT_NOT_SUPPORTED", "Image Services Replication does not support de-replication of individual annotation. To dereplicate the annotations, you have to dereplicate the document.");
    public static final ExceptionContext IS_CANNOT_MODIFY_INBOUNDONLY_PROP = new ExceptionContext("IS_CANNOT_MODIFY_INBOUNDONLY_PROP", "The property [{0}] cannot be modified on Content Engine. It is mapped as Inbound only.");
    public static final ExceptionContext IS_INV_EXTOBJID_IN_ANNOTATED_DOC = new ExceptionContext("IS_INV_EXTOBJID_IN_ANNOTATED_DOC", "The number of external object ID in document {0} is not expected. The annotation {1} will not be replicated.");
    public static final ExceptionContext IS_MISSING_REQ_INDEXES = new ExceptionContext("IS_MISSING_REQ_INDEXES", "The document {0} cannot be replicated. The following properties [{1}] required by the Image Services system are missing.");
    public static final ExceptionContext IS_ANNOT_PERM_OVERLAP = new ExceptionContext("IS_ANNOT_PERM_OVERLAP", "Annotation {0} cannot be replicated to the Image Services system. It has the same permission for principal {1} and {2}.");
    public static final ExceptionContext IS_ANNOT_MISSING_ADMIN_DN = new ExceptionContext("IS_ANNOT_MISSING_ADMIN_DN", "The security mapping for either SysAdmin or SysAdminG is missing. Fix the security mapping on the Image Services system {0} using the SEC_map tool.");
    public static final ExceptionContext IS_ANNOTATION_ACCESS_DENIED = new ExceptionContext("IS_ANNOTATION_ACCESS_DENIED", "The content or permission of a federated annotation cannot be modified.");
    public static final ExceptionContext IS_ERROR_CONVERTING_TO_LOCALDATE = new ExceptionContext("IS_ERROR_CONVERTING_TO_LOCALDATE", "Error occurred while converting the date property {0} [value {1}] in document {2} to local timezone.");
    public static final ExceptionContext IS_ANNOTATED_DOC_NOT_REPLICATED = new ExceptionContext("IS_ANNOTATED_DOC_NOT_REPLICATED", "The annotated document {0} is not replicated yet. The outbound journal for annotation {1} will be retried.");
    public static final ExceptionContext IS_CANNOT_COMMIT_EXTOBJID_IN_ANNOT = new ExceptionContext("IS_CANNOT_COMMIT_EXTOBJID_IN_ANNOT", "The external object ID {0} cannot be committed to annotation {1}.");
    public static final ExceptionContext IS_MISMATCH_EXT_OBJID = new ExceptionContext("IS_MISMATCH_EXT_OBJID", "The external object ID {0} from document {1} does not match the ID {2} from the referral blob.");
    public static final ExceptionContext IS_INX_DIR_ERROR = new ExceptionContext("IS_INX_DIR_ERROR", "Error occurred while preparing the document index record for document {0} [external object ID {1}].");
    public static final ExceptionContext IS_CANT_UPDATE_BLOB = new ExceptionContext("IS_CANT_UPDATE_BLOB", "Error occurred while updating the referral blob in document {0} [external object ID {1}].");
    public static final ExceptionContext IS_PENDING_MIGRATION = new ExceptionContext("IS_PENDING_MIGRATION", "The content migration for document {0} is still pending. The journal will be retried. No action is required.");
    public static final ExceptionContext IS_CANT_GET_TRIGGER = new ExceptionContext("IS_CANT_GET_TRIGGER", "Cannot get trigger file setting for {0}.");
    public static final ExceptionContext IS_PD_UNEXPECTED_ANNOT_FAILURE = new ExceptionContext("IS_PD_UNEXPECTED_ANNOT_FAILURE", "Error {0} occurred processing IS annotation {1} with Id {2} for CE document {3}: cause {4}");
    public static final ExceptionContext IS_PD_UNEXPECTED_DOC_FAILURE = new ExceptionContext("IS_PD_UNEXPECTED_DOC_FAILURE", "Error {0} occurred processing an IS document {1} for IS doc_id {2}: cause {3}");
    public static final ExceptionContext IS_NO_OUTBOUND_MAPPING = new ExceptionContext("IS_NO_OUTBOUND_MAPPING", "There is no outbound mapping for the document {0} in document class {1}. Update the replication class mapping direction or do not set Replication Group property in the object.");
    public static final ExceptionContext IS_ANNOT_MISSING_CLASSID = new ExceptionContext("IS_ANNOT_MISSING_CLASSID", "The class ID is missing from the annotation {0}. The document annotation that is being replicated from the Content Engine must have a class ID.");
    public static final ExceptionContext IS_ANNOT_PROPRIETARY_CLASSID = new ExceptionContext("IS_ANNOT_PROPRIETARY_CLASSID", "= The {0} annotation contains a proprietary class ID {1}.  Proprietary types cannot be replicated to Image Services.");
    public static final ExceptionContext IS_UNEXPECTED_ANNOT_ENCODING = new ExceptionContext("IS_UNEXPECTED_ANNOT_ENCODING", "The F_TEXT attribute in the {0} annotation specifies {1} encoding. Image Services expects unicode encoding.");
    public static final ExceptionContext IS_UNEXPECTED_ANNOT_TEXT_LEN = new ExceptionContext("IS_UNEXPECTED_ANNOT_TEXT_LEN", "The F_TEXT in the {0} annotation has a length of {1}. The length must be a multiple of 4.");
    public static final ExceptionContext IS_ANNOT_ENCODING_ERR = new ExceptionContext("IS_ANNOT_ENCODING_ERR", "The {0} annotation cannot be encoded using the {1} character set.");
    public static final ExceptionContext JDBC_DRIVER_JAASCONFIGNAME = new ExceptionContext("JDBC_DRIVER_JAASCONFIGNAME", "This Property represents JAASCONFIGNAME Property.");
    public static final ExceptionContext JDBC_DRIVER_MERGEMODE = new ExceptionContext("JDBC_DRIVER_MERGEMODE", "This Property represents MERGEMODE Property.");
    public static final ExceptionContext JDBC_DRIVER_OBJECTSTORE = new ExceptionContext("JDBC_DRIVER_OBJECTSTORE", "This Property represents OBJECT STORES Property.");
    public static final ExceptionContext JDBC_DRIVER_PASSWORD = new ExceptionContext("JDBC_DRIVER_PASSWORD", "This Property represents PASSWORD Property.");
    public static final ExceptionContext JDBC_DRIVER_URI = new ExceptionContext("JDBC_DRIVER_URI", "This Property represents URI Property.");
    public static final ExceptionContext JDBC_DRIVER_USER = new ExceptionContext("JDBC_DRIVER_USER", "This Property represents USER Property.");
    public static final ExceptionContext JDBC_DRIVER_LOCALE = new ExceptionContext("JDBC_DRIVER_LOCALE", "This Property represents LOCALE Property.");
    public static final ExceptionContext METADATA_CLASS_NOT_FOUND = new ExceptionContext("METADATA_CLASS_NOT_FOUND", "Class {0} not found.");
    public static final ExceptionContext METADATA_CONSTANT_NOT_FOUND = new ExceptionContext("METADATA_CONSTANT_NOT_FOUND", "Metadata constant {0} not found.");
    public static final ExceptionContext METADATA_DEFAULT_BOOLEAN_NOT_FOUND = new ExceptionContext("METADATA_DEFAULT_BOOLEAN_NOT_FOUND", "Default boolean {0} not found.");
    public static final ExceptionContext METADATA_DEFAULT_INTEGER_NOT_FOUND = new ExceptionContext("METADATA_DEFAULT_INTEGER_NOT_FOUND", "Default integer {0} not found.");
    public static final ExceptionContext METADATA_DEFAULT_OBJECT_NOT_FOUND = new ExceptionContext("METADATA_DEFAULT_OBJECT_NOT_FOUND", "Default object {0} not found.");
    public static final ExceptionContext METADATA_DEFAULT_STRING_NOT_FOUND = new ExceptionContext("METADATA_DEFAULT_STRING_NOT_FOUND", "Default string {0} not found.");
    public static final ExceptionContext METADATA_GUID_CONSTANT_NOT_FOUND = new ExceptionContext("METADATA_GUID_CONSTANT_NOT_FOUND", "GUID constant {0} not found.");
    public static final ExceptionContext METADATA_INTEGER_CONSTRAINT_NOT_FOUND = new ExceptionContext("METADATA_INTEGER_CONSTRAINT_NOT_FOUND", "Integer constraint {0} not found.");
    public static final ExceptionContext METADATA_OBJECT_CONSTRAINT_NOT_FOUND = new ExceptionContext("METADATA_OBJECT_CONSTRAINT_NOT_FOUND", "Object constraint {0} not found.");
    public static final ExceptionContext METADATA_PROPERTY_TEMPLATE_NOT_FOUND = new ExceptionContext("METADATA_PROPERTY_TEMPLATE_NOT_FOUND", "Property template {0} not found.");
    public static final ExceptionContext METADATA_STRING_CONSTRAINT_NOT_FOUND = new ExceptionContext("METADATA_STRING_CONSTRAINT_NOT_FOUND", "String constraint {0} not found.");
    public static final ExceptionContext PERSIST_ADDON_ALREADY_INSTALLED = new ExceptionContext("PERSIST_ADDON_ALREADY_INSTALLED", "Add-on \"{0}\" is currently installed.");
    public static final ExceptionContext PERSIST_ADDON_CONFLICTING_PREREQUISITES = new ExceptionContext("PERSIST_ADDON_CONFLICTING_PREREQUISITES", "UpgradeAddOn \"{0}\" specifies conflicts between its FromVersions or Prerequisites and its ToVersions properties.");
    public static final ExceptionContext PERSIST_ADDON_FROM_VERSION_INSTALLED = new ExceptionContext("PERSIST_ADDON_FROM_VERSION_INSTALLED", "AddOn \"{0}\", referenced in the FromVersions property of UpgradeAddOn \"{1}\", is currently installed in an ObjectStore.");
    public static final ExceptionContext PERSIST_ADDON_CREATION_REQUIRES_ID = new ExceptionContext("PERSIST_ADDON_CREATION_REQUIRES_ID", "AddOn creation requires a non-null Id.");
    public static final ExceptionContext PERSIST_ADDON_INSTALLATION_REPORT = new ExceptionContext("PERSIST_ADDON_INSTALLATION_REPORT", "The installation report follows: {0}");
    public static final ExceptionContext PERSIST_ADDON_PREREQUISITES_NOT_INSTALLED = new ExceptionContext("PERSIST_ADDON_PREREQUISITES_NOT_INSTALLED", "All prerequisites for add-on \"{0}\" have not been installed into the object store.");
    public static final ExceptionContext PERSIST_ADDON_SCRIPT_TYPE = new ExceptionContext("PERSIST_ADDON_SCRIPT_TYPE", "The script type value ({0}) is not supported.  Must be javascript or jython.");
    public static final ExceptionContext PERSIST_ADDON_SUPERSEDED_INSTALLED = new ExceptionContext("PERSIST_ADDON_SUPERSEDED_INSTALLED", "Add-on \"{0}\" cannot be installed at this time because it references a superseded Add-on that is currently installed.  This indicates that an UpgradeAddOn should be installed that migrates the information to that of this AddOn.");
    public static final ExceptionContext PERSIST_ADDON_SUPERSEDING_INSTALLED = new ExceptionContext("PERSIST_ADDON_SUPERSEDING_INSTALLED", "Add-on \"{0}\" cannot be installed at this time because it superseding Add-on is currently installed.");
    public static final ExceptionContext PERSIST_ADDON_VERSION_INSTALLED = new ExceptionContext("PERSIST_ADDON_VERSION_INSTALLED", "UpgradeAddOn \"{0}\" lists a To-Version AddOn that is already installed in the object store.");
    public static final ExceptionContext PERSIST_ADDON_VERSION_NOT_FOUND = new ExceptionContext("PERSIST_ADDON_VERSION_NOT_FOUND", "UpgradeAddOn \"{0}\" lists a To-Version AddOn that does not exist.");
    public static final ExceptionContext PERSIST_ALIAS_OBJECT_EXISTS = new ExceptionContext("PERSIST_ALIAS_OBJECT_EXISTS", "At least one instance of {0} already exists on class {1} and cannot be used as an alias id.");
    public static final ExceptionContext PERSIST_AST_NO_VERSION_STATE_ID = new ExceptionContext("PERSIST_AST_NO_VERSION_STATE_ID", "Cannot use versioning state id on ApplicationSecurityTemplates.");
    public static final ExceptionContext PERSIST_AUDIT_AS_CANNOT_BE_MODIFIED = new ExceptionContext("PERSIST_AUDIT_AS_CANNOT_BE_MODIFIED", "The operation violates a constraint of the implementation. The value of the Audit As property for \"{0}\" is inherited from its parent class and therefore cannot be modified.  To set a value for the Audit As property for the \"{1}\" class, you must first delete the Audit As value that is set on \"{2}\" in the \"{3}\" parent class.");
    public static final ExceptionContext PERSIST_BAD_ACTION_FOR_CLASS = new ExceptionContext("PERSIST_BAD_ACTION_FOR_CLASS", "A {1} action cannot be applied to an object of class {2}.");
    public static final ExceptionContext PERSIST_BAD_DATABASE_PASSWORD = new ExceptionContext("PERSIST_BAD_DATABASE_PASSWORD", "The database password provided for object store {0} and associated with database user {1} could not be adequately validated.");
    public static final ExceptionContext PERSIST_BAD_HEAD_REL = new ExceptionContext("PERSIST_BAD_HEAD_REL", "Head of relationship object {0} is not this object {1}.");
    public static final ExceptionContext PERSIST_BAD_LIFECYCLE_CHANGE_STATE_FLAG = new ExceptionContext("PERSIST_BAD_LIFECYCLE_CHANGE_STATE_FLAG", "Invalid lifecycle change state flag.");
    public static final ExceptionContext PERSIST_BAD_LIFECYCLE_STATE = new ExceptionContext("PERSIST_BAD_LIFECYCLE_STATE", "The current document state {0} is no longer defined in the lifecycle policy for the document.");
    public static final ExceptionContext PERSIST_BAD_PORT_RANGE = new ExceptionContext("PERSIST_BAD_PORT_RANGE", "The port range value ''{0}'' is not correct.  The value must match a regular expression of the form (n|n-m)(:(n|n-m))* where n and m are numbers between 1 and 65535, n is less than m, and all numbers are in ascending order throughout the value.  The range must consist of at least two ports.  Valid examples include: 300-356:400-556:822:826 or 300:400-994 or 556:822.");
    public static final ExceptionContext PERSIST_BAD_RESERVATION_STATE = new ExceptionContext("PERSIST_BAD_RESERVATION_STATE", "Bad state for the supplied reservation object.");
    public static final ExceptionContext PERSIST_BAD_SYMBOLIC_NAME = new ExceptionContext("PERSIST_BAD_SYMBOLIC_NAME", "The given value of the SymbolicName property ({0}) must begin with an alpha character and can contain only alphanumeric and underscore (''_'') characters.");
    public static final ExceptionContext PERSIST_CANNOT_CREATE_ROOT_FOLDER = new ExceptionContext("PERSIST_CANNOT_CREATE_ROOT_FOLDER", "A root folder cannot be created.");
    public static final ExceptionContext PERSIST_CANNOT_DELETE_ROOT_FOLDER = new ExceptionContext("PERSIST_CANNOT_DELETE_ROOT_FOLDER", "A root folder cannot be deleted.");
    public static final ExceptionContext PERSIST_CANNOT_INITIATE_REPLICATION_ON_RESERVATIONS = new ExceptionContext("PERSIST_CANNOT_INITIATE_REPLICATION_ON_RESERVATIONS", "Replication cannot be initiated on reservation objects.");
    public static final ExceptionContext PERSIST_CANNOT_MOVE_ROOT_FOLDER = new ExceptionContext("PERSIST_CANNOT_MOVE_ROOT_FOLDER", "Cannot move the root folder.");
    public static final ExceptionContext PERSIST_CANT_CBR_ENABLE_FOR_CLASS = new ExceptionContext("PERSIST_CANT_CBR_ENABLE_FOR_CLASS", "The property ''{0}'' is enabled for full text indexing either directly or via inheritance.  However, the class ''{1}'' is not enabled for full text indexing. Enable class ''{2}'' for full-text indexing or remove full-text indexing from the property ''{3}'' and then retry the operation.");
    public static final ExceptionContext PERSIST_CANT_CBR_ENABLE_FOR_DBTYPE = new ExceptionContext("PERSIST_CANT_CBR_ENABLE_FOR_DBTYPE", "Property {0} can''t be enabled for full text indexing because it''s not of type string");
    public static final ExceptionContext PERSIST_CANT_CBR_ENABLE_FOR_INDEXATIONID = new ExceptionContext("PERSIST_CANT_CBR_ENABLE_FOR_INDEXATIONID", "Class {0} can''t be enabled for full text indexing because it doesn''t have an IndexationId property");
    public static final ExceptionContext PERSIST_CANT_CREATE_SERVER_INSTANCE = new ExceptionContext("PERSIST_CANT_CREATE_SERVER_INSTANCE", "ServerInstances cannot be manually created.");
    public static final ExceptionContext PERSIST_CANT_CREATE_VIRTUAL_SERVER = new ExceptionContext("PERSIST_CANT_CREATE_VIRTUAL_SERVER", "VirtualServers cannot be manually created.");
    public static final ExceptionContext PERSIST_CANT_DELETE_SERVER_INSTANCE = new ExceptionContext("PERSIST_CANT_DELETE_SERVER_INSTANCE", "ServerInstance ''{0}'' cannot be deleted at this time since it is the current server instance.");
    public static final ExceptionContext PERSIST_CANT_DELETE_VIRTUAL_SERVER = new ExceptionContext("PERSIST_CANT_DELETE_VIRTUAL_SERVER", "VirtualServer ''{0}'' cannot be deleted at this time since it is the current virtual server.");
    public static final ExceptionContext PERSIST_CANT_GENERATE_COLUMN_NAME = new ExceptionContext("PERSIST_CANT_GENERATE_COLUMN_NAME", "Can''t generate a new column name for property {0}.");
    public static final ExceptionContext PERSIST_CANT_GENERATE_TABLE_NAME = new ExceptionContext("PERSIST_CANT_GENERATE_TABLE_NAME", "Can''t generate a new table name for property {0} last attempted {1} - check the error log for related errors.");
    public static final ExceptionContext PERSIST_CANT_WRITE_AUDITLOG_ENTRY = new ExceptionContext("PERSIST_CANT_WRITE_AUDITLOG_ENTRY", "Can''t persist audit log entry for event class {0}.");
    public static final ExceptionContext PERSIST_CC_CLASS_OBJECT_TYPE_MISMATCHED = new ExceptionContext("PERSIST_CC_CLASS_OBJECT_TYPE_MISMATCHED", "New class is not the same object type as the old class. New class obj type={0}, old class obj type={1}.");
    public static final ExceptionContext PERSIST_CC_CLASS_TABLE_MISMATCHED = new ExceptionContext("PERSIST_CC_CLASS_TABLE_MISMATCHED", "New class table not the same as the old class table. New class table={0}, old class table={1}.");
    public static final ExceptionContext PERSIST_CC_CURRENT_CLASS_NOT_USER_SUBCLASSABLE = new ExceptionContext("PERSIST_CC_CURRENT_CLASS_NOT_USER_SUBCLASSABLE", "Cannot change class when the old class {0} is not user-subclassable.");
    public static final ExceptionContext PERSIST_CC_PROHIBITS_NEW_OBJECT = new ExceptionContext("PERSIST_CC_PROHIBITS_NEW_OBJECT", "Cannot change class of a new object.");
    public static final ExceptionContext PERSIST_CC_REQUIRES_WRITE_PERMISSION = new ExceptionContext("PERSIST_CC_REQUIRES_WRITE_PERMISSION", "Change Class requires write permission.");
    public static final ExceptionContext PERSIST_CC_TARGET_CLASS_DISALLOWED_INSTANCES = new ExceptionContext("PERSIST_CC_TARGET_CLASS_DISALLOWED_INSTANCES", "Target class {0} of Change Class does not allow user instances.");
    public static final ExceptionContext PERSIST_CHANGE_NOT_PERMITTED_IN_ACTIVE_PROXY = new ExceptionContext("PERSIST_CHANGE_NOT_PERMITTED_IN_ACTIVE_PROXY", "Change not permitted when active proxy.");
    public static final ExceptionContext PERSIST_CHOICE_BOTH_NAMES_SET = new ExceptionContext("PERSIST_CHOICE_BOTH_NAMES_SET", "Both DisplayName and DisplayNames properties cannot be set to different values during creation.  Use DisplayNames whenever possible.");
    public static final ExceptionContext PERSIST_CHOICE_MUTLILOCALE = new ExceptionContext("PERSIST_CHOICE_MUTLILOCALE", "DisplayName cannot be set when DisplayNames consists of multiple locales.  Use only DisplayNames for updates in multiple-locale environments.");
    public static final ExceptionContext PERSIST_CLASS_DEFINITION_HAS_INSTANCES = new ExceptionContext("PERSIST_CLASS_DEFINITION_HAS_INSTANCES", "Class definition {0} has instances.");
    public static final ExceptionContext PERSIST_CLASS_DEFINITION_HAS_SUBCLASSES = new ExceptionContext("PERSIST_CLASS_DEFINITION_HAS_SUBCLASSES", "Class definition {0} has subclasses defined.");
    public static final ExceptionContext PERSIST_CLASS_DEFINITION_IS_REQUIRED_CLASS = new ExceptionContext("PERSIST_CLASS_DEFINITION_IS_REQUIRED_CLASS", "Class definition {0} is referenced as a required class.");
    public static final ExceptionContext PERSIST_CLASS_DEFINITION_IS_SYSTEM_OWNED = new ExceptionContext("PERSIST_CLASS_DEFINITION_IS_SYSTEM_OWNED", "Class definition {0} is owned by the system.");
    public static final ExceptionContext PERSIST_CLASS_DEFINITION_MULTIPLE_NAMES = new ExceptionContext("PERSIST_CLASS_DEFINITION_MULTIPLE_NAMES", "Class definition \"{0}\" cannot have more than one name property defined.");
    public static final ExceptionContext PERSIST_CLASS_HAS_NO_TABLE = new ExceptionContext("PERSIST_CLASS_HAS_NO_TABLE", "Class {0} has no table.");
    public static final ExceptionContext PERSIST_CLASS_NOT_PERSISTENT = new ExceptionContext("PERSIST_CLASS_NOT_PERSISTENT", "A persistent property cannot be assigned to a non-persistent class.");
    public static final ExceptionContext PERSIST_CLASS_DISALLOWED_INSTANCES = new ExceptionContext("PERSIST_CLASS_DISALLOWED_INSTANCES", "Class {0} does not allow user instances.");
    public static final ExceptionContext PERSIST_COLUMN_CANT_BE_RESIZED = new ExceptionContext("PERSIST_COLUMN_CANT_BE_RESIZED", "Column {0} cannot be resized on table {1}.");
    public static final ExceptionContext PERSIST_COLUMN_DEF_ONLY_UPDATE_ALLOWED = new ExceptionContext("PERSIST_COLUMN_DEF_ONLY_UPDATE_ALLOWED", "Column Definition objects can only be updated; additions or deletions are not allowed.");
    public static final ExceptionContext PERSIST_COLUMN_ENTRY_UNKNOWN_TABLE = new ExceptionContext("PERSIST_COLUMN_ENTRY_UNKNOWN_TABLE", "Column entry for unknown table.");
    public static final ExceptionContext PERSIST_COMPONENT_RELATIONSHIPS_EXIST = new ExceptionContext("PERSIST_COMPONENT_RELATIONSHIPS_EXIST", "Cannot convert compound document to non-compound document when existing component relationship objects reference the document as their parent.");
    public static final ExceptionContext PERSIST_CREATE_INSTANCE_DENIED = new ExceptionContext("PERSIST_CREATE_INSTANCE_DENIED", "Not granted CREATE INSTANCE permission.");
    public static final ExceptionContext PERSIST_CVL_CHOICE_VALUES_NOT_ALLOWED = new ExceptionContext("PERSIST_CVL_CHOICE_VALUES_NOT_ALLOWED", "ChoiceValues are permitted only on objects of ChoiceType MIDNODE_STRING or MIDNODE_INTEGER.  Change the ChoiceType property value or remove the ChoiceValues and resubmit the request.");
    public static final ExceptionContext PERSIST_CVL_DOES_NOT_EXIST = new ExceptionContext("PERSIST_CVL_DOES_NOT_EXIST", "The ChoiceList {0} referenced by the PropertyTemplate or PropertyDefinition does not exist.");
    public static final ExceptionContext PERSIST_CVL_INCOMPATIBLE_CHOICE_TYPE = new ExceptionContext("PERSIST_CVL_INCOMPATIBLE_CHOICE_TYPE", "ChoiceType must be compatible with DataType {0}.");
    public static final ExceptionContext PERSIST_CVL_INCOMPATIBLE_DATA_TYPE = new ExceptionContext("PERSIST_CVL_INCOMPATIBLE_DATA_TYPE", "DataType must be either Integer or String.");
    public static final ExceptionContext PERSIST_CVL_INCOMPATIBLE_PROPERTY_TYPE = new ExceptionContext("PERSIST_CVL_INCOMPATIBLE_PROPERTY_TYPE", "The DataType of the ChoiceList must match the DataType of the PropertyTemplate or PropertyDefinition to which it is being applied.");
    public static final ExceptionContext PERSIST_CVL_INVALID_MIDNODE_VALUE = new ExceptionContext("PERSIST_CVL_INVALID_MIDNODE_VALUE", "Choices of type {0} must have values of matching type ({1}) if they have a value at all.");
    public static final ExceptionContext PERSIST_CVL_PROP_DEFINITION_REFERENCES = new ExceptionContext("PERSIST_CVL_PROP_DEFINITION_REFERENCES", "This choice list is in use by one or more property definitions.");
    public static final ExceptionContext PERSIST_CVL_PROP_TEMPLATE_REFERENCES = new ExceptionContext("PERSIST_CVL_PROP_TEMPLATE_REFERENCES", "This choice list is in use by one or more property templates.");
    public static final ExceptionContext PERSIST_DATATYPE_MISMATCH_DETAIL = new ExceptionContext("PERSIST_DATATYPE_MISMATCH_DETAIL", "The property {0} expects the datatype to be {1}, but the input value is {2}.");
    public static final ExceptionContext PERSIST_DBSTORAGEAREA_ALREADY_UPGRADED = new ExceptionContext("PERSIST_DBSTORAGEAREA_ALREADY_UPGRADED", "The Database Storage Area has already been upgraded");
    public static final ExceptionContext PERSIST_DBSTORAGEAREA_UPGRADE_NONUPDATE = new ExceptionContext("PERSIST_DBSTORAGEAREA_UPGRADE_NONUPDATE", "Database Storage Area upgrade not allowed except on update");
    public static final ExceptionContext PERSIST_DEFAULT_BINARY_EXCEEDS_MAXLEN = new ExceptionContext("PERSIST_DEFAULT_BINARY_EXCEEDS_MAXLEN", "The length of the default binary value ({0}) exceeds the maximum permitted ({1}).");
    public static final ExceptionContext PERSIST_DEFAULT_CHANGE_NOT_PERMITTED = new ExceptionContext("PERSIST_DEFAULT_CHANGE_NOT_PERMITTED", "Change of default value for property {0} is not permitted.");
    public static final ExceptionContext PERSIST_DEFAULT_GREATER_MAX = new ExceptionContext("PERSIST_DEFAULT_GREATER_MAX", "The default ({0}) is greater than the maximum ({1}).");
    public static final ExceptionContext PERSIST_DEFAULT_LESS_MIN = new ExceptionContext("PERSIST_DEFAULT_LESS_MIN", "The default ({0}) is less than the minimum ({1}).");
    public static final ExceptionContext PERSIST_DEFAULT_NOT_OF_REQUIRED_CLASS = new ExceptionContext("PERSIST_DEFAULT_NOT_OF_REQUIRED_CLASS", "The default object is not of the required class.");
    public static final ExceptionContext PERSIST_DEFAULT_OBJECT_CLASS_UNKNOWN = new ExceptionContext("PERSIST_DEFAULT_OBJECT_CLASS_UNKNOWN", "The class of the default object is not known.");
    public static final ExceptionContext PERSIST_DEFAULT_STRING_EXCEEDS_MAXLEN = new ExceptionContext("PERSIST_DEFAULT_STRING_EXCEEDS_MAXLEN", "The length of the default string value ({0}) exceeds the maximum permitted ({1}).");
    public static final ExceptionContext PERSIST_DELETE_MOVE_SUPERCLASS_PROPS = new ExceptionContext("PERSIST_DELETE_MOVE_SUPERCLASS_PROPS", "Cannot delete or move superclass property definitions when creating subclass.");
    public static final ExceptionContext PERSIST_DELETE_NOT_ALLOWED = new ExceptionContext("PERSIST_DELETE_NOT_ALLOWED", "Component relationship setting does not allow deletion of this document.");
    public static final ExceptionContext PERSIST_DISALLOWED_EVENT_CREATION = new ExceptionContext("PERSIST_DISALLOWED_EVENT_CREATION", "This operation must be performed on a persisted event object.");
    public static final ExceptionContext PERSIST_DISALLOWED_EXCLUSION_RESERVATION_UPDATE = new ExceptionContext("PERSIST_DISALLOWED_EXCLUSION_RESERVATION_UPDATE", "The {0} operation is not permitted because the reservation is exclusively owned by someone else.");
    public static final ExceptionContext PERSIST_DISALLOWED_FROZEN_UPDATE = new ExceptionContext("PERSIST_DISALLOWED_FROZEN_UPDATE", "Disallowed update to frozen version.");
    public static final ExceptionContext PERSIST_DOMAIN_CONFIG_ONLY_UPDATE_ALLOWED = new ExceptionContext("PERSIST_DOMAIN_CONFIG_ONLY_UPDATE_ALLOWED", "Domain-level configuration objects can only be updated; additions or deletions are not allowed.");
    public static final ExceptionContext PERSIST_DOMAIN_CREATE_DELETE_NOT_ALLOWED = new ExceptionContext("PERSIST_DOMAIN_CREATE_DELETE_NOT_ALLOWED", "Creation or deletion of Domain objects are not permitted.");
    public static final ExceptionContext PERSIST_DOMAIN_PERMISSION_UPDATE_NOT_ALLOWED = new ExceptionContext("PERSIST_DOMAIN_PERMISSION_UPDATE_NOT_ALLOWED", "Domain permissions cannot be updated until after DirectoryConfigurations exist.");
    public static final ExceptionContext PERSIST_DUPLICATE_AUDIT_DEFINITION = new ExceptionContext("PERSIST_DUPLICATE_AUDIT_DEFINITION", "There are duplicate audit definitions corresponding to event class {0}.");
    public static final ExceptionContext PERSIST_DUPLICATE_CP_DEFINITION = new ExceptionContext("PERSIST_DUPLICATE_CP_DEFINITION", "The change preprocessor definition with name ''{0}'' on class definition ''{1}'' references the same change preprocessor action as another change preprocessor definition.  Change this definition''s referenced action or remove it from the list and resubmit the request.");
    public static final ExceptionContext PERSIST_DUPLICATE_EXTERNAL_REPOSITORY = new ExceptionContext("PERSIST_DUPLICATE_EXTERNAL_REPOSITORY", "Only one instance of a given ExternalRepository can be present in the ExternalReplicaIdentities list property.  Remove the duplicate instances of class ''{0}'' with ID ''{1}'' and resubmit the request.");
    public static final ExceptionContext PERSIST_DYNAMIC_CR_UPDATE_FAILED = new ExceptionContext("PERSIST_DYNAMIC_CR_UPDATE_FAILED", "Updating a dynamic component relationship to refer to a new child document failed.");
    public static final ExceptionContext PERSIST_DYNAMIC_LABEL_NOT_SUPPORTED = new ExceptionContext("PERSIST_DYNAMIC_LABEL_NOT_SUPPORTED", "The Document class add-on property required to support dynamic label component relationships does not exist.");
    public static final ExceptionContext PERSIST_FALSE_DISALLOWED = new ExceptionContext("PERSIST_FALSE_DISALLOWED", "Property {0} is not permitted to be set to False once set to True.");
    public static final ExceptionContext PERSIST_EXPECT_LIST_PROPERTY = new ExceptionContext("PERSIST_EXPECT_LIST_PROPERTY", "Property {0} is expected to be a list property.");
    public static final ExceptionContext PERSIST_FILESTORAGEAREA_UPGRADE_NONCREATE = new ExceptionContext("PERSIST_FILESTORAGEAREA_UPGRADE_NONCREATE", "File Storage Area upgrade not allowed except on create");
    public static final ExceptionContext PERSIST_FOLDER_LOOPED = new ExceptionContext("PERSIST_FOLDER_LOOPED", "Loop in folder hierarchy; id = {0}.");
    public static final ExceptionContext PERSIST_FOREIGN_OBJECT_REQUIRES_STATIC_CR = new ExceptionContext("PERSIST_FOREIGN_OBJECT_REQUIRES_STATIC_CR", "Foreign object child components only supported for static component relationship type.");
    public static final ExceptionContext PERSIST_GREATER_THAN_MAX_VALUE = new ExceptionContext("PERSIST_GREATER_THAN_MAX_VALUE", "The value ({2}) specified for property {0} is greater than the maximum permitted ({1}).");
    public static final ExceptionContext PERSIST_HEAD_IS_NOT_DOC = new ExceptionContext("PERSIST_HEAD_IS_NOT_DOC", "Head {0} of dynamic relationship object is not a document.");
    public static final ExceptionContext PERSIST_HIERARCHICAL_MARKING_SET_AND_LIST = new ExceptionContext("PERSIST_HIERARCHICAL_MARKING_SET_AND_LIST", "Hierarchical marking sets are not allowed on list properties.");
    public static final ExceptionContext PERSIST_HOMOGENEOUS_INSTANCES = new ExceptionContext("PERSIST_HOMOGENEOUS_INSTANCES", "The {0} property must contain instances of the same sub-class and corresponding to the parent class.");
    public static final ExceptionContext PERSIST_INBOUND_EXTERNAL_ALIAS_EXISTS = new ExceptionContext("PERSIST_INBOUND_EXTERNAL_ALIAS_EXISTS", "Another ClassDefinition is already mapped (INBOUND) to an ExternalClassAlias for ExternalRepository ''{0}'' with ClassIdentity ''{1}''.");
    public static final ExceptionContext PERSIST_INCOMPATIBLE_RESERVATION_CLASS = new ExceptionContext("PERSIST_INCOMPATIBLE_RESERVATION_CLASS", "Reservation class {0} is incompatible with the original class {1}.");
    public static final ExceptionContext PERSIST_INHERITED_ALIAS_MISSING = new ExceptionContext("PERSIST_INHERITED_ALIAS_MISSING", "Inherited alias missing on property {0} of class {1}.");
    public static final ExceptionContext PERSIST_INHERITED_CONSTRAINT = new ExceptionContext("PERSIST_INHERITED_CONSTRAINT", "Inherited {0} constraint on property {1} of class {2}.");
    public static final ExceptionContext PERSIST_INHERITED_PROPERTY_NOT_FOUND = new ExceptionContext("PERSIST_INHERITED_PROPERTY_NOT_FOUND", "The inherited property {0} was not found on the superclass.");
    public static final ExceptionContext PERSIST_INVALID_ACTION_PARAMETER = new ExceptionContext("PERSIST_INVALID_ACTION_PARAMETER", "The action parameter {0} cannot be an empty string or null.");
    public static final ExceptionContext PERSIST_INVALID_APPENDER_CLASS = new ExceptionContext("PERSIST_INVALID_APPENDER_CLASS", "The given appender name \"{0}\" corresponding to class \"{1}\" must be a subclass of class \"{2}\".");
    public static final ExceptionContext PERSIST_INVALID_COMPONENT_RELATIONSHIP_TYPE = new ExceptionContext("PERSIST_INVALID_COMPONENT_RELATIONSHIP_TYPE", "Invalid component relationship type value.");
    public static final ExceptionContext PERSIST_INVALID_DB2_ENCODING = new ExceptionContext("PERSIST_INVALID_DB2_ENCODING", "Unicode encoding (UTF-8) is required for DB2 databases.  Create the database using codeset UTF-8 and reattempt the operation.");
    public static final ExceptionContext PERSIST_INVALID_EMPTY_PATH = new ExceptionContext("PERSIST_INVALID_EMPTY_PATH", "Invalid property {0} -- Empty string is not valid path component.");
    public static final ExceptionContext PERSIST_INVALID_LOCALE_NAME = new ExceptionContext("PERSIST_INVALID_LOCALE_NAME", "The format of the provided locale name \"{0}\" does not resemble that defined in RFC 3066.");
    public static final ExceptionContext PERSIST_INVALID_LONG_MVP_STRING = new ExceptionContext("PERSIST_INVALID_LONG_MVP_STRING", "Multi-valued string properties can only use long columns if PersistenceType is OWN_TABLE.  Update property {0} accordingly and resubmit the request.");
    public static final ExceptionContext PERSIST_INVALID_NEW_CLASS_NAME = new ExceptionContext("PERSIST_INVALID_NEW_CLASS_NAME", "The new class name cannot be an empty string or null.");
    public static final ExceptionContext PERSIST_INVALID_OUTPUT_LOCATION = new ExceptionContext("PERSIST_INVALID_OUTPUT_LOCATION", "The given output location \"{0}\" must correspond to a valid directory.");
    public static final ExceptionContext PERSIST_INVALID_OWNERSHIP_CHANGE = new ExceptionContext("PERSIST_INVALID_OWNERSHIP_CHANGE", "Invalid ownership change.");
    public static final ExceptionContext PERSIST_INVALID_PATH_CHAR = new ExceptionContext("PERSIST_INVALID_PATH_CHAR", "Invalid property {0} -- Invalid character(s) in the path component \"{1}\".");
    public static final ExceptionContext PERSIST_INVALID_PROPERTY_VALUE = new ExceptionContext("PERSIST_INVALID_PROPERTY_VALUE", "Property: \"{0}\", Value: \"{1}\"");
    public static final ExceptionContext PERSIST_INVALID_RETENTION_DAYS_MINIMUM_DEFAULT = new ExceptionContext("PERSIST_INVALID_RETENTION_DAYS_MINIMUM_DEFAULT", "The DefaultRetentionDays value ({1}) is less than the Minimum value ({0}), or is not INFINITE (-1) and Minimum is INFINITE.");
    public static final ExceptionContext PERSIST_INVALID_RETENTION_DAYS_MINIMUM_MAXIMUM = new ExceptionContext("PERSIST_INVALID_RETENTION_DAYS_MINIMUM_MAXIMUM", "The MinimumRetentionDays value ({0}) is greater than the Maximum value ({1}), or is INFINITE (-1) and Maximum is not INFINITE.");
    public static final ExceptionContext PERSIST_INVALID_RETENTION_DAYS_DEFAULT_MAXIMUM = new ExceptionContext("PERSIST_INVALID_RETENTION_DAYS_DEFAULT_MAXIMUM", "The DefaultRetentionDays value ({0}) is greater than the Maximum value ({1}), or is INFINITE (-1) and Maximum is not INFINITE.");
    public static final ExceptionContext PERSIST_INVALID_SCRIPT_VERSION = new ExceptionContext("PERSIST_INVALID_SCRIPT_VERSION", "The SchemaRevision string in the supplied script ({0}) does not match the expected value ({1}).  The proper scripts should first be acquired from the appropriate Domain property, then customized.");
    public static final ExceptionContext PERSIST_INVALID_SECURITY_PROXY_TYPE_UPDATE = new ExceptionContext("PERSIST_INVALID_SECURITY_PROXY_TYPE_UPDATE", "The value ({0}) of the SecurityProxyType property on PropertyDefinition ''{1}'' conflicts with the SecurityProxyType values on an associated PropertyDefintion on another class within the class family.  SecurityProxyType updates are permitted as long as all PropertyDefinitions corresponding to the same PropertyTemplate also have the same SecurityProxyType values within the class family (e.g., Document, Custom Object, Folder).");
    public static final ExceptionContext PERSIST_INVALID_VERITY_PATH = new ExceptionContext("PERSIST_INVALID_VERITY_PATH", "This path must be visible to the CE server if the TempDirectoryPath is null.");
    public static final ExceptionContext PERSIST_ISOLATED_REGION_NOT_UNIQUE = new ExceptionContext("PERSIST_ISOLATED_REGION_NOT_UNIQUE", "IsolatedRegions must be unique across DNSName, BrokerPort and IsolatedRegionNumber properties.");
    public static final ExceptionContext PERSIST_IS_IN_EXCEPTION_STATE = new ExceptionContext("PERSIST_IS_IN_EXCEPTION_STATE", "Cannot change the lifecycle state due to the current exception state.");
    public static final ExceptionContext PERSIST_LESS_THAN_MIN_VALUE = new ExceptionContext("PERSIST_LESS_THAN_MIN_VALUE", "The value ({2}) specified for property {0} is less than the minimum permitted ({1}).");
    public static final ExceptionContext PERSIST_LIFECYCLE_ACTION_HANDLER_CREATION_FAILED = new ExceptionContext("PERSIST_LIFECYCLE_ACTION_HANDLER_CREATION_FAILED", "Unable to create a lifecycle action handler instance.");
    public static final ExceptionContext PERSIST_LIFECYCLE_OP_WITH_NO_POLICY = new ExceptionContext("PERSIST_LIFECYCLE_OP_WITH_NO_POLICY", "Lifecyle operation with no lifecycle policy.");
    public static final ExceptionContext PERSIST_LIFECYCLE_POLICY_IN_USE_BY_DOCS = new ExceptionContext("PERSIST_LIFECYCLE_POLICY_IN_USE_BY_DOCS", "This lifecycle policy is in use by one or more documents.");
    public static final ExceptionContext PERSIST_LIFECYCLE_POLICY_IN_USE_BY_DOC_CLASSES = new ExceptionContext("PERSIST_LIFECYCLE_POLICY_IN_USE_BY_DOC_CLASSES", "This lifecycle policy is being specified as the default lifecycle policy for one or more document classes.");
    public static final ExceptionContext PERSIST_LISTENUM_ATTRIBUTE_NOT_ALLOWED = new ExceptionContext("PERSIST_LISTENUM_ATTRIBUTE_NOT_ALLOWED", "{0} is not allowed on list or enum property.");
    public static final ExceptionContext PERSIST_LISTENUM_DEFAULT_NOT_ALLOWED = new ExceptionContext("PERSIST_LISTENUM_DEFAULT_NOT_ALLOWED", "A default value is not allowed on list or enum property.");
    public static final ExceptionContext PERSIST_LISTENUM_NAME_NOT_ALLOWED = new ExceptionContext("PERSIST_LISTENUM_NAME_NOT_ALLOWED", "A list or enum property cannot be the name property.");
    public static final ExceptionContext PERSIST_LIST_ELEMENT_NOT_UNIQUE = new ExceptionContext("PERSIST_LIST_ELEMENT_NOT_UNIQUE", "List element not unique: {0}.");
    public static final ExceptionContext PERSIST_MARKINGSET_INUSE_BY_PROPERTYTEMPLATE = new ExceptionContext("PERSIST_MARKINGSET_INUSE_BY_PROPERTYTEMPLATE", "The MarkingSet {0} is in use by PropertyTemplate {1}");
    public static final ExceptionContext PERSIST_MARKING_SET_AND_CVL = new ExceptionContext("PERSIST_MARKING_SET_AND_CVL", "A property template cannot specified as both a marking set and a choice list.");
    public static final ExceptionContext PERSIST_MARK_DOCUMENT_AS_CHILD_FAILED = new ExceptionContext("PERSIST_MARK_DOCUMENT_AS_CHILD_FAILED", "Marking a document as a child document failed.");
    public static final ExceptionContext PERSIST_MAX_LENGTH_EXCEEDED = new ExceptionContext("PERSIST_MAX_LENGTH_EXCEEDED", "The length of the value ({2}) specified for property {0} exceeds the maximum permitted length ({1}).");
    public static final ExceptionContext PERSIST_MIME_TYPE_TOO_LONG = new ExceptionContext("PERSIST_MIME_TYPE_TOO_LONG", "Defaulted mime type {0} exceeds {1} characters.");
    public static final ExceptionContext PERSIST_MIN_EXCEEDS_MAX = new ExceptionContext("PERSIST_MIN_EXCEEDS_MAX", "The minimum ({0}) exceeds the maximum ({1}).");
    public static final ExceptionContext PERSIST_MISSING_LIFECYCLE = new ExceptionContext("PERSIST_MISSING_LIFECYCLE", "The lifecycle policy for the document is missing or inaccessible.");
    public static final ExceptionContext PERSIST_MORE_THAN_ONE_PROXY = new ExceptionContext("PERSIST_MORE_THAN_ONE_PROXY", "More than one proxy.");
    public static final ExceptionContext PERSIST_MORE_THAN_ONE_PULL_PROPAGATION_PROP = new ExceptionContext("PERSIST_MORE_THAN_ONE_PULL_PROPAGATION_PROP", "More than 1 pull propagation property.");
    public static final ExceptionContext PERSIST_MULTIPLE_FILE_APPENDERS_NOT_ALLOWED = new ExceptionContext("PERSIST_MULTIPLE_FILE_APPENDERS_NOT_ALLOWED", "Multiple FileAppender classes are not allowed in AppenderNames property.");
    public static final ExceptionContext PERSIST_MULTIPLE_FULL_PROXIES_NOT_PERMITTED = new ExceptionContext("PERSIST_MULTIPLE_FULL_PROXIES_NOT_PERMITTED", "Multiple PropertyDefinitions with SecurityProxyType values of FULL are not permitted on the same ClassDefinition.  Update the SecurityProxyType property on PropertyDefinition ''{0}'' of ClassDefinition ''{1}'' and resubmit the request or update the other PropertyDefinition currently configured with SecurityProxyType = FULL to use a different value.");
    public static final ExceptionContext PERSIST_NEW_SUPERCLASS_PROPS = new ExceptionContext("PERSIST_NEW_SUPERCLASS_PROPS", "New properties cannot be added to superclass definition.");
    public static final ExceptionContext PERSIST_NOT_IN_EXCEPTION_STATE = new ExceptionContext("PERSIST_NOT_IN_EXCEPTION_STATE", "Unable to clear exception for a non exception document.");
    public static final ExceptionContext PERSIST_NO_COMPATIBLE_EXTERNAL_CLASS_ALIAS_EXISTS = new ExceptionContext("PERSIST_NO_COMPATIBLE_EXTERNAL_CLASS_ALIAS_EXISTS", "A compatible ExternalClassAlias does not exist for the ExternalPropertyAlias identified by ExternalRepository ''{0}'', ClassIdentity ''{1}'', and PropertyIdentity ''{2}''.");
    public static final ExceptionContext PERSIST_NO_CUR_VERSION_FOR_DRCR_HEAD = new ExceptionContext("PERSIST_NO_CUR_VERSION_FOR_DRCR_HEAD", "No current version for DRCR Head {0}.");
    public static final ExceptionContext PERSIST_NO_DOC_STATE = new ExceptionContext("PERSIST_NO_DOC_STATE", "Doc lifecycle policy should have at least one state defined.");
    public static final ExceptionContext PERSIST_NO_LIFECYCLE_POLICY_TO_CHANGE_STATE = new ExceptionContext("PERSIST_NO_LIFECYCLE_POLICY_TO_CHANGE_STATE", "No lifecycle policy defined to change the state.");
    public static final ExceptionContext PERSIST_NO_PRESERVE_DIRECT_PERMISSIONS = new ExceptionContext("PERSIST_NO_PRESERVE_DIRECT_PERMISSIONS", "Unable to get the PreserveDirectPermissions property from the lifecycle policy.");
    public static final ExceptionContext PERSIST_NO_REQUIRED_VALUES_ON_OCE_CLASSES = new ExceptionContext("PERSIST_NO_REQUIRED_VALUES_ON_OCE_CLASSES", "Custom properties on subclasses of ObjectChangeEvent that are not also subclasses of CustomEvent cannot be marked to require values.  Set the value for IsValueRequired on property ''{0}'' of class ''{1}'' to false and resubmit the request.");
    public static final ExceptionContext PERSIST_NO_SEC_TEMPLATE_FOUND = new ExceptionContext("PERSIST_NO_SEC_TEMPLATE_FOUND", "No security template found for {0}.");
    public static final ExceptionContext PERSIST_OBJECT_ACCESS_DENIED = new ExceptionContext("PERSIST_OBJECT_ACCESS_DENIED", "Not granted required access.");
    public static final ExceptionContext PERSIST_OBJECT_DELETE_DENIED = new ExceptionContext("PERSIST_OBJECT_DELETE_DENIED", "Not granted object DELETE permission.");
    public static final ExceptionContext PERSIST_OBJECT_ENUM_REFERENCE = new ExceptionContext("PERSIST_OBJECT_ENUM_REFERENCE", "Object enum referenced by property {0} with the deletion action set to prevent.");
    public static final ExceptionContext PERSIST_OBJECT_PROP_ACCESS_DENIED = new ExceptionContext("PERSIST_OBJECT_PROP_ACCESS_DENIED", "Not granted required access on target object.");
    public static final ExceptionContext PERSIST_OBJECT_STORE_SEC_DESC_NOT_FOUND = new ExceptionContext("PERSIST_OBJECT_STORE_SEC_DESC_NOT_FOUND", "Security descriptor for object store {0} not found.");
    public static final ExceptionContext PERSIST_OBJECT_UNLINK_DENIED = new ExceptionContext("PERSIST_OBJECT_UNLINK_DENIED", "Not granted object UNLINK permission.");
    public static final ExceptionContext PERSIST_SCALAR_LISTS_ONLY = new ExceptionContext("PERSIST_SCALAR_LISTS_ONLY", "Only scalar types (e.g., any non-Object type) of list cardinality can be specified with a persistence type of OWN_TABLE.");
    public static final ExceptionContext PERSIST_OVP_NOT_REQUIRED_CLASS = new ExceptionContext("PERSIST_OVP_NOT_REQUIRED_CLASS", "Object-valued property {0} requires to be a class of {1}, but the input class is {2}.");
    public static final ExceptionContext PERSIST_REFLECTIVE_PROP_NOT_REQUIRED_CLASS = new ExceptionContext("PERSIST_REFLECTIVE_PROP_NOT_REQUIRED_CLASS", "The reflective property {0} of object {1} referenced by property {2} requires that the referencing object be of class {3}. The current class {4} does not satisfy this requirement.");
    public static final ExceptionContext PERSIST_PASSWORD_VALUE_INVALID = new ExceptionContext("PERSIST_PASSWORD_VALUE_INVALID", "Failed to decode the password property value, most likely because the property value was not UTF-8 encoded, then encrypted.");
    public static final ExceptionContext PERSIST_PARENT_NOT_COMPOUND_DOCUMENT = new ExceptionContext("PERSIST_PARENT_NOT_COMPOUND_DOCUMENT", "Cannot create component relationship, parent document is not a compound document.");
    public static final ExceptionContext PERSIST_PERSISTER_CREATION_FAILED = new ExceptionContext("PERSIST_PERSISTER_CREATION_FAILED", "Persister creation failed.");
    public static final ExceptionContext PERSIST_PERSISTER_NOT_FOUND = new ExceptionContext("PERSIST_PERSISTER_NOT_FOUND", "Persister class {0} not found.");
    public static final ExceptionContext PERSIST_PREVIOUS_VERSIONS_ALREADY_REPLICATED = new ExceptionContext("PERSIST_PREVIOUS_VERSIONS_ALREADY_REPLICATED", "The attempt to replicate this object cannot occur because previous versions of this object are already replicated.");
    public static final ExceptionContext PERSIST_PROPDEF_ALREADY_PRESENT = new ExceptionContext("PERSIST_PROPDEF_ALREADY_PRESENT", "A property definition for property \"{0}\" is already present on class \"{1}\".");
    public static final ExceptionContext PERSIST_PROPERTY_IS_INHERITED = new ExceptionContext("PERSIST_PROPERTY_IS_INHERITED", "Property {0} is inherited.");
    public static final ExceptionContext PERSIST_PROPERTY_IS_READ_ONLY = new ExceptionContext("PERSIST_PROPERTY_IS_READ_ONLY", "Read-only property {0} cannot be updated.");
    public static final ExceptionContext PERSIST_PROPERTY_IS_SYSTEM_OWNED = new ExceptionContext("PERSIST_PROPERTY_IS_SYSTEM_OWNED", "Property {0} is owned by the system.");
    public static final ExceptionContext PERSIST_PROPERTY_NOT_UNIQUE = new ExceptionContext("PERSIST_PROPERTY_NOT_UNIQUE", "The value for property {0} of class {1} is not unique.");
    public static final ExceptionContext PERSIST_PROPERTY_TEMPLATE_HAS_INSTANCES = new ExceptionContext("PERSIST_PROPERTY_TEMPLATE_HAS_INSTANCES", "The property template has property definition instances.");
    public static final ExceptionContext PERSIST_PROP_COLUMN_NOT_FOUND = new ExceptionContext("PERSIST_PROP_COLUMN_NOT_FOUND", "Unable to find property column info for {0} in metadata.");
    public static final ExceptionContext PERSIST_PROP_VALUE_NOT_SET = new ExceptionContext("PERSIST_PROP_VALUE_NOT_SET", "Property {0} is not set.");
    public static final ExceptionContext PERSIST_PULL_PROPAGATION_PROP_NOT_SINGLE_OBJ_VALUED = new ExceptionContext("PERSIST_PULL_PROPAGATION_PROP_NOT_SINGLE_OBJ_VALUED", "Pull propagation property is not a single object-valued property.");
    public static final ExceptionContext PERSIST_READONLY_PROPERTY = new ExceptionContext("PERSIST_READONLY_PROPERTY", "{0} is a read-only property and cannot be updated at this time.");
    public static final ExceptionContext PERSIST_REMOVE_OBJECTS_DENIED = new ExceptionContext("PERSIST_REMOVE_OBJECTS_DENIED", "Not granted REMOVE OBJECTS permission on the object store.");
    public static final ExceptionContext PERSIST_REPL_BAD_OBJREF = new ExceptionContext("PERSIST_REPL_BAD_OBJREF", "The object cannot be replicated because the reference in property ''{0}'' is to an object that may not be present in a destination repository.");
    public static final ExceptionContext PERSIST_REPL_DUP_FCD_REFERENCE = new ExceptionContext("PERSIST_REPL_DUP_FCD_REFERENCE", "Only one External Repository instance may reference each Fixed ContentDevice. Device {0} is already referenced by repository {1}.");
    public static final ExceptionContext PERSIST_REPL_DUP_PARTICIPANT = new ExceptionContext("PERSIST_REPL_DUP_PARTICIPANT", "More than one instance of Repository ''{0}'' was detected in the ReplicationParticipants list property.");
    public static final ExceptionContext PERSIST_REPL_EXTERNAL_REPO_FCD_MISMATCH = new ExceptionContext("PERSIST_REPL_EXTERNAL_REPO_FCD_MISMATCH", "The class of FixedContentDevice on ExternalRepository ''{0}'' is invalid.  Expected class ''{1}'' but received class ''{2}''.");
    public static final ExceptionContext PERSIST_REPL_MODE_NOT_MASTER = new ExceptionContext("PERSIST_REPL_MODE_NOT_MASTER", "The replication mode of ObjectStore participant ''{0}'' in ReplicationGroup ''{1}'' does not permit updates to replicas.");
    public static final ExceptionContext PERSIST_REPL_GROUP_NOT_FOUND = new ExceptionContext("PERSIST_REPL_GROUP_NOT_FOUND", "ReplicationGroup ''{0}'' does not exist or its reference is invalid.  Update the ReplicationGroup property of the object and resubmit the request.");
    public static final ExceptionContext PERSIST_REPL_INVALID_PARTICIPANTS = new ExceptionContext("PERSIST_REPL_INVALID_PARTICIPANTS", "An invalid combinations of participants was specified for the replication group.");
    public static final ExceptionContext PERSIST_REPL_OS_PARTNER_NOT_FOUND = new ExceptionContext("PERSIST_REPL_OS_PARTNER_NOT_FOUND", "A partner ObjectStore for ExternalRepository ''{0}'' was not found in the ReplicationParticipants list property.");
    public static final ExceptionContext PERSIST_REPL_OS_NOT_PARTICIPANT = new ExceptionContext("PERSIST_REPL_OS_NOT_PARTICIPANT", "ObjectStore ''{0}'' is not listed as a participant in ReplicationGroup ''{1}''.");
    public static final ExceptionContext PERSIST_REPL_TOO_FEW_PARTICIPANTS = new ExceptionContext("PERSIST_REPL_TOO_FEW_PARTICIPANTS", "At least two participants must be present in the ReplicationParticipants list property.");
    public static final ExceptionContext PERSIST_REPO_HAS_MULTIPLE_OUTBOUND_CLASS_ALIASES = new ExceptionContext("PERSIST_REPO_HAS_MULTIPLE_OUTBOUND_CLASS_ALIASES", "The ExternalAliasesList for ClassDefinition ''{0}'' contains multiple OUTBOUND (or BOTH) external class aliases for a single ExternalRepository ''{1}''.");
    public static final ExceptionContext PERSIST_REPO_HAS_MULTIPLE_OUTBOUND_PROPERTY_ALIASES = new ExceptionContext("PERSIST_REPO_HAS_MULTIPLE_OUTBOUND_PROPERTY_ALIASES", "The ExternalAliasesList for a PropertyDefinition of ClassDefinition ''{0}'' contains multiple OUTBOUND (or BOTH) external property aliases for a single ExternalRepository ''{1}'' and Class ''{2}''.");
    public static final ExceptionContext PERSIST_REPO_HAS_MULTIPLE_INBOUND_PROPERTY_ALIASES = new ExceptionContext("PERSIST_REPO_HAS_MULTIPLE_INBOUND_PROPERTY_ALIASES", "Multiple PropertyDefinitions of ClassDefinition ''{0}'' are mapped INBOUND (or BOTH) to the same ExternalRepository ''{1}'' and Class ''{2}''.");
    public static final ExceptionContext PERSIST_REQUIRED_ACTION_PARAM_ABSENT = new ExceptionContext("PERSIST_REQUIRED_ACTION_PARAM_ABSENT", "Required parameter {0} on action {1} is missing.");
    public static final ExceptionContext PERSIST_REQUIRED_CLASS_IS_ABSTRACT = new ExceptionContext("PERSIST_REQUIRED_CLASS_IS_ABSTRACT", "The required class ''{0}'' for persistent property ''{1}'' must permit instances.  The referenced class is abstract and does not permit instances.");
    public static final ExceptionContext PERSIST_REQUIRED_CLASS_IS_INVALID_DOMAIN_CLASS = new ExceptionContext("PERSIST_REQUIRED_CLASS_IS_INVALID_DOMAIN_CLASS", "The required class ''{0}'' for persistent property ''{1}'' cannot be referenced as a required class.  The required class of non-repository objects must be independently retrievable and not be one of User, Group, EntireNetwork or Domain.  In addition, the referencing PropertyDefinition must be of single cardinality, not allow foreign objects, have no reflective property id and have a deletion action of none or null.  Update the PropertyDefinition accordingly and reattempt the operation.");
    public static final ExceptionContext PERSIST_REQUIRED_LIST_PROPERTY_NOT_INITED = new ExceptionContext("PERSIST_REQUIRED_LIST_PROPERTY_NOT_INITED", "Required list property {0} never instantiated.");
    public static final ExceptionContext PERSIST_REQUIRED_LIST_PROPERTY_NO_VALUE = new ExceptionContext("PERSIST_REQUIRED_LIST_PROPERTY_NO_VALUE", "Required list property {0} has no value.");
    public static final ExceptionContext PERSIST_REQUIRED_PROPERTIES_NOT_SET = new ExceptionContext("PERSIST_REQUIRED_PROPERTIES_NOT_SET", "Required properties not set for component relationship: {0}.");
    public static final ExceptionContext PERSIST_REQUIRED_SINGLETON_PROPERTY_NO_VALUE = new ExceptionContext("PERSIST_REQUIRED_SINGLETON_PROPERTY_NO_VALUE", "Required singleton property {0} has no value.");
    public static final ExceptionContext PERSIST_REQUIRE_CHECKED_IN_TO_FREEZE = new ExceptionContext("PERSIST_REQUIRE_CHECKED_IN_TO_FREEZE", "Cannot freeze a non-checked in object.");
    public static final ExceptionContext PERSIST_REQUIRE_CURRENT_TO_CHECKOUT = new ExceptionContext("PERSIST_REQUIRE_CURRENT_TO_CHECKOUT", "Checkout must be performed on the current version.");
    public static final ExceptionContext PERSIST_REQUIRE_IN_PROCESS_TO_PROMOTE = new ExceptionContext("PERSIST_REQUIRE_IN_PROCESS_TO_PROMOTE", "Promote must be performed on the latest minor version of the series (VersionStatus=InProcess).");
    public static final ExceptionContext PERSIST_REQUIRE_NON_FROZEN_TO_FREEZE = new ExceptionContext("PERSIST_REQUIRE_NON_FROZEN_TO_FREEZE", "Cannot freeze a frozen object.");
    public static final ExceptionContext PERSIST_REQUIRE_NON_RESERVATION_TO_CHANGE_STATE = new ExceptionContext("PERSIST_REQUIRE_NON_RESERVATION_TO_CHANGE_STATE", "ChangeState must be performed on a persisted non-reservation object.");
    public static final ExceptionContext PERSIST_REQUIRE_NON_RESERVED_CURRENT_TO_DEMOTE = new ExceptionContext("PERSIST_REQUIRE_NON_RESERVED_CURRENT_TO_DEMOTE", "Demote must be performed on a non-reserved current version.");
    public static final ExceptionContext PERSIST_REQUIRE_NON_RESERVED_CURRENT_TO_PROMOTE = new ExceptionContext("PERSIST_REQUIRE_NON_RESERVED_CURRENT_TO_PROMOTE", "Promote must be performed on a non-reserved current version.");
    public static final ExceptionContext PERSIST_REQUIRE_RELEASED_TO_DEMOTE = new ExceptionContext("PERSIST_REQUIRE_RELEASED_TO_DEMOTE", "Demote must be performed on the latest major version of the series (VersionStatus=Released).");
    public static final ExceptionContext PERSIST_REQUIRE_RESERVATION_TO_CHECKIN = new ExceptionContext("PERSIST_REQUIRE_RESERVATION_TO_CHECKIN", "Checkin must be performed on a reservation object.");
    public static final ExceptionContext PERSIST_REQUIRE_VERSIONING_ENABLED_TO_CHECKOUT = new ExceptionContext("PERSIST_REQUIRE_VERSIONING_ENABLED_TO_CHECKOUT", "Checkout must be performed when versioning is enabled.");
    public static final ExceptionContext PERSIST_RETRIEVAL_NAME_MAX_LENGTH_EXCEEDED = new ExceptionContext("PERSIST_RETRIEVAL_NAME_MAX_LENGTH_EXCEEDED", "The length of the value ({1}) specified for the RetrievalName property exceeds the maximum permitted length of ({0}).  If a path was specified as the value, this limitation refers to the filename portion.");
    public static final ExceptionContext PERSIST_SCHEMA_SCRIPT_FAILURE = new ExceptionContext("PERSIST_SCHEMA_SCRIPT_FAILURE", "A failure occurred processing the ObjectStore schema script.  Check the script and the error that follows and reattempt the operation.");
    public static final ExceptionContext PERSIST_SINGLE_OBJECT_REFERENCE = new ExceptionContext("PERSIST_SINGLE_OBJECT_REFERENCE", "Object {0} referenced by property {1} with the deletion action set to prevent.");
    public static final ExceptionContext PERSIST_NO_FIXED_CONTENT_SIS = new ExceptionContext("PERSIST_NO_FIXED_CONTENT_SIS", "Duplicate content suppression is not currently supported for fixed storage areas.");
    public static final ExceptionContext PERSIST_SORT_ORDER_UPDATE_FAILED = new ExceptionContext("PERSIST_SORT_ORDER_UPDATE_FAILED", "Component sort order failed. SQL Exception: {0}.");
    public static final ExceptionContext PERSIST_STATE_PREVENT_DEMOTION = new ExceptionContext("PERSIST_STATE_PREVENT_DEMOTION", "Document in this state cannot be demoted.");
    public static final ExceptionContext PERSIST_STATE_PREVENT_PROMOTION = new ExceptionContext("PERSIST_STATE_PREVENT_PROMOTION", "Document in this state cannot be promoted.");
    public static final ExceptionContext PERSIST_STORAGE_AREA_HAS_INSTANCES = new ExceptionContext("PERSIST_STORAGE_AREA_HAS_INSTANCES", "Storage area {0} has instances.");
    public static final ExceptionContext PERSIST_STORE_OBJECTS_DENIED = new ExceptionContext("PERSIST_STORE_OBJECTS_DENIED", "Not granted STORE OBJECTS permission on the object store.");
    public static final ExceptionContext PERSIST_STRING_BYTES_OVER_MAX = new ExceptionContext("PERSIST_STRING_BYTES_OVER_MAX", "String {0} contains {1} bytes, which exceeds max limit of {2} bytes.");
    public static final ExceptionContext PERSIST_STRING_MAXLEN_TOO_LARGE = new ExceptionContext("PERSIST_STRING_MAXLEN_TOO_LARGE", "The string''s max length value is too large.");
    public static final ExceptionContext PERSIST_STRING_REPEATS_OVER_MAX = new ExceptionContext("PERSIST_STRING_REPEATS_OVER_MAX", "String {0} has repeated {1} times, which exceeds max limit of {2} times.");
    public static final ExceptionContext PERSIST_SUBCLASSING_NOT_ALLOWED = new ExceptionContext("PERSIST_SUBCLASSING_NOT_ALLOWED", "Subclassing of class definition {0} is not permitted.");
    public static final ExceptionContext PERSIST_SUBSEQUENT_VERSIONS_ALREADY_REPLICATED = new ExceptionContext("PERSIST_SUBSEQUENT_VERSIONS_ALREADY_REPLICATED", "The attempt to replicate this object cannot occur because subsequent versions of this object are already replicated.");
    public static final ExceptionContext PERSIST_SYMBOLIC_NAME_NOT_UNIQUE = new ExceptionContext("PERSIST_SYMBOLIC_NAME_NOT_UNIQUE", "The symbolic name ({0}) must be unique within the class family (e.g., Document, Folder, CustomObject, etc.) and currently exists on class {1}.  Rename the corresponding PropertyTemplate (id={2}) and reattempt the operation.");
    public static final ExceptionContext PERSIST_SYMBOLIC_NAME_NOT_UNIQUE_IN_HIERARCHY = new ExceptionContext("PERSIST_SYMBOLIC_NAME_NOT_UNIQUE_IN_HIERARCHY", "The symbolic name ({0}) must be unique within a given class hierarchy (i.e., amongst subclasses) and currently exists on class {1}.  Rename the corresponding PropertyTemplate (id={2}) and reattempt the operation.");
    public static final ExceptionContext PERSIST_TABLE_ID_NOT_SET = new ExceptionContext("PERSIST_TABLE_ID_NOT_SET", "The table id cannot be determined for persistent property {0}.");
    public static final ExceptionContext PERSIST_UNABLE_TO_DELETE_OBJECT_IN_ENUM = new ExceptionContext("PERSIST_UNABLE_TO_DELETE_OBJECT_IN_ENUM", "Unable to delete object {0} in enum property {1}.");
    public static final ExceptionContext PERSIST_UNABLE_TO_DELETE_REF_OBJECT = new ExceptionContext("PERSIST_UNABLE_TO_DELETE_REF_OBJECT", "Unable to delete referenced object {0} from property {1}.");
    public static final ExceptionContext PERSIST_UNEXPECTED_SECURITY_PROPAGATION = new ExceptionContext("PERSIST_UNEXPECTED_SECURITY_PROPAGATION", "Unexpected security propagation.");
    public static final ExceptionContext PERSIST_UNEXPECTED_VER_SER_CHANGE_OP = new ExceptionContext("PERSIST_UNEXPECTED_VER_SER_CHANGE_OP", "Unexpected version series change op.");
    public static final ExceptionContext PERSIST_UPDATE_NOT_CHECKIN_ACTION = new ExceptionContext("PERSIST_UPDATE_NOT_CHECKIN_ACTION", "Updates to property ''{0}'' must occur during CheckIn action.");
    public static final ExceptionContext PERSIST_UPDATE_OBJECT_WITH_PROXY = new ExceptionContext("PERSIST_UPDATE_OBJECT_WITH_PROXY", "Not allowed on object with proxy.");
    public static final ExceptionContext PERSIST_UPDATE_SETTABLE_ONLY_ON_CREATE_PROP = new ExceptionContext("PERSIST_UPDATE_SETTABLE_ONLY_ON_CREATE_PROP", "Attempt to modify settable only on create property, {0}.");
    public static final ExceptionContext PERSIST_UPDATE_SETTABLE_ONLY_BEFORE_CHECKIN_PROP = new ExceptionContext("PERSIST_UPDATE_SETTABLE_ONLY_BEFORE_CHECKIN_PROP", "Attempt to modify settable only before checkin property, {0}.");
    public static final ExceptionContext PERSIST_USERPROPS_NOT_ALLOWED = new ExceptionContext("PERSIST_USERPROPS_NOT_ALLOWED", "Property modifications are not permitted on class definition {0}.");
    public static final ExceptionContext PERSIST_USN_MISMATCH = new ExceptionContext("PERSIST_USN_MISMATCH", "Update sequence number mismatch; requested USN = {0}, database USN = {1}");
    public static final ExceptionContext PERSIST_VALUE_NOT_IN_CVL = new ExceptionContext("PERSIST_VALUE_NOT_IN_CVL", "The value ({1}) specified for property {0} is not within the range of permitted values.");
    public static final ExceptionContext PERSIST_VERSION_SERIES_ID_EXISTS = new ExceptionContext("PERSIST_VERSION_SERIES_ID_EXISTS", "Unable to create a document with the specified version series id {0} because the VS id already exists.");
    public static final ExceptionContext PERSIST_STORAGE_POLICY_HAS_INSTANCES = new ExceptionContext("PERSIST_STORAGE_POLICY_HAS_INSTANCES", "Storage Policy {0} has instances.");
    public static final ExceptionContext PERSIST_INVALID_RESERVATION_TYPE = new ExceptionContext("PERSIST_INVALID_RESERVATION_TYPE", "The reservation type of {0} is not valid in this context.");
    public static final ExceptionContext PERSIST_TASK_BAD_LIFECYCLE_CHANGE_STATE_FLAG = new ExceptionContext("PERSIST_TASK_BAD_LIFECYCLE_CHANGE_STATE_FLAG", "Do not invoke the {0} operation when a task is in the {1} state. See the documentation for information about task state changes.");
    public static final ExceptionContext PERSIST_TASK_INVALID_DEMOTE_ON_COMPLETE = new ExceptionContext("PERSIST_TASK_INVALID_DEMOTE_ON_COMPLETE", "You cannot demote a task in the Complete state if the task has successors that have already moved past the Ready state.");
    public static final ExceptionContext PERSIST_TASK_RELATIONSHIP_INVALID_SUCCESSOR = new ExceptionContext("PERSIST_TASK_RELATIONSHIP_INVALID_SUCCESSOR", "SuccessorTask should be different from PredecessorTask in a TaskRelationship: {0}");
    public static final ExceptionContext PERSIST_TASK_RELATIONSHIP_INVALID_PREDECESSOR = new ExceptionContext("PERSIST_TASK_RELATIONSHIP_INVALID_PREDECESSOR", "Can not add predecessor task {0} to task {1} while latter is in WORKING state, unless predecessor task is in COMPLETED state.");
    public static final ExceptionContext PERSIST_TASK_RELATIONSHIP_INVALID_COORDINATOR = new ExceptionContext("PERSIST_TASK_RELATIONSHIP_INVALID_COORDINATOR", "The Coordinator of SuccessorTask {0} should be the same as that of PredecessorTask {1} in a TaskRelationship and should not be null");
    public static final ExceptionContext PERSIST_TASK_RELATIONSHIP_CIRCULAR_REFERENCE = new ExceptionContext("PERSIST_TASK_RELATIONSHIP_CIRCULAR_REFERENCE", "Circular reference detected when creating CmTaskRelationship with predecessor {0} and successor {1}");
    public static final ExceptionContext PERSIST_FILTERPROCESSOR_DATATYPE_MISMATCH = new ExceptionContext("PERSIST_FILTERPROCESSOR_DATATYPE_MISMATCH", "Incompatible data types when calculate arithmetic value. v1:{0} and v2:{1}");
    public static final ExceptionContext PERSIST_TASK_UPDATE_SETTABLE_ONLY_ON_CHANGE_STATE_PROP = new ExceptionContext("PERSIST_TASK_UPDATE_SETTABLE_ONLY_ON_CHANGE_STATE_PROP", "You can modify the {0} property only when a task is moving to the {1} state. See the documentation for information about modifying  the property.");
    public static final ExceptionContext PERSIST_EXPECT_LIST_PROPERTY_CONTAINS_NULL = new ExceptionContext("PERSIST_EXPECT_LIST_PROPERTY_CONTAINS_NULL", "The property {0} is a list property. You cannot assign a null value to any elements in a list property.");
    public static final ExceptionContext PERSIST_MODIFY_RETENTION_DENIED = new ExceptionContext("PERSIST_MODIFY_RETENTION_DENIED", "Not granted MODIFY RETENTION permission on the object store.");
    public static final ExceptionContext PERSIST_RETENTION_CONSTRAINT_NULL = new ExceptionContext("PERSIST_RETENTION_CONSTRAINT_NULL", "New retention date value is null, previous value must also be null.  New date {0}, previous date {1}, object id {2}");
    public static final ExceptionContext PERSIST_RETENTION_CONSTRAINT_INDEFINITE = new ExceptionContext("PERSIST_RETENTION_CONSTRAINT_INDEFINITE", "New retention date value is indefinite, previous value must be null.  New date {0}, previous date {1}, object id {2}");
    public static final ExceptionContext PERSIST_RETENTION_CONSTRAINT_GT = new ExceptionContext("PERSIST_RETENTION_CONSTRAINT_GT", "New retention date value must be greater than the previous value.  New date {0}, previous date {1}, object id {2}");
    public static final ExceptionContext PERSIST_RETENTION_DELETE = new ExceptionContext("PERSIST_RETENTION_DELETE", "The retention date of the object must be in the past, and not permanent or indefinite, to allow deletion.  Retention date {0}, object id {1}");
    public static final ExceptionContext PERSIST_RETENTION_SKEW = new ExceptionContext("PERSIST_RETENTION_SKEW", "System time {0}, RDBMS time {1}");
    public static final ExceptionContext PERSIST_CPACTION_HAS_REFERENCING_CPDS = new ExceptionContext("PERSIST_CPACTION_HAS_REFERENCING_CPDS", "This ChangePreprocessorAction is referenced by ChangePreprocessorDefinitions that must first be deleted.");
    public static final ExceptionContext PUBLISH_CONTENT_READ_ERROR = new ExceptionContext("PUBLISH_CONTENT_READ_ERROR", "Failed to read content {0}.");
    public static final ExceptionContext PUBLISH_XML_ELEM_TEXT_INVALID = new ExceptionContext("PUBLISH_XML_ELEM_TEXT_INVALID", "Text value in element {0} is invalid or not supported -- value is: {1}.");
    public static final ExceptionContext PUBLISH_XML_MISSING_CHILD_ELEM = new ExceptionContext("PUBLISH_XML_MISSING_CHILD_ELEM", "Failed to find child element {0} in element {1}.");
    public static final ExceptionContext PUBLISH_XML_MISSING_ELEM = new ExceptionContext("PUBLISH_XML_MISSING_ELEM", "Failed to find element {0}.");
    public static final ExceptionContext PUBLISH_MISSING_APPLY_VALUE = new ExceptionContext("PUBLISH_MISSING_APPLY_VALUE", "Failed to find value for {0} to apply on publication.");
    public static final ExceptionContext PUBLISH_BAD_PROPERTY_DATATYPE = new ExceptionContext("PUBLISH_BAD_PROPERTY_DATATYPE", "Found invalid datatype {0} for property {1}.");
    public static final ExceptionContext RETRIEVE_FOLDER_NOT_FOUND = new ExceptionContext("RETRIEVE_FOLDER_NOT_FOUND", "Folder {0} not found.");
    public static final ExceptionContext RETRIEVE_FOLDER_OR_PARENT_NOT_FOUND = new ExceptionContext("RETRIEVE_FOLDER_OR_PARENT_NOT_FOUND", "Folder {0} or a parent of this folder not found.");
    public static final ExceptionContext RETRIEVE_INVALID_CONTAINMENT_NAME = new ExceptionContext("RETRIEVE_INVALID_CONTAINMENT_NAME", "Invalid containment name.");
    public static final ExceptionContext RETRIEVE_PREVENT_OBJECT = new ExceptionContext("RETRIEVE_PREVENT_OBJECT", "Error occurred while retrieving object {0} from property {1} with the deletion action set to prevent.");
    public static final ExceptionContext RETRIEVE_IDENTITY_TOKEN = new ExceptionContext("RETRIEVE_IDENTITY_TOKEN", "IdentityToken property cannot be retrieved because the RegionKey property is not initialized for IsolatedRegion {0}.  RegionKey is indirectly initialized by setting the Password property.");
    public static final ExceptionContext RETRIEVE_INVALID_DATETIME_ARITHMETIC = new ExceptionContext("RETRIEVE_INVALID_DATETIME_ARITHMETIC", "The datetime property or expression is not allowed in its present location.  Only the TimeSpan function may be added to another datetime expression.");
    public static final ExceptionContext RETRIEVE_INVALID_TIMESPAN_EXPRESSION = new ExceptionContext("RETRIEVE_INVALID_TIMESPAN_EXPRESSION", "The TimeSpan function is not valid in its present location.  TimeSpan cannot be the first or only function in an expression or parenthesized alone with other TimeSpan functions.");
    public static final ExceptionContext RETRIEVE_INVALID_TIMESPAN_PARAMETER = new ExceptionContext("RETRIEVE_INVALID_TIMESPAN_PARAMETER", "The parameter ''{0}'' in ''{1}'' is invalid.  The allowed values for the units are ''seconds'', ''minutes'', ''hours'' or ''days''.  The value parameter must fit in a long datatype but additional range limits may apply, depending on the database vendor and version.");
    public static final ExceptionContext RETRIEVE_REPLICA_NOT_FOUND = new ExceptionContext("RETRIEVE_REPLICA_NOT_FOUND", "The replica externally identified by ''{0}'' in ExternalRepository ''{1}'' could not be found in ObjectStore ''{2}''.");
    public static final ExceptionContext RETRIEVE_PROPERTY_TEMPLATE_BY_NAME = new ExceptionContext("RETRIEVE_PROPERTY_TEMPLATE_BY_NAME", "Attempts to retreive property templates by name are not supported.  The requested PropertyTemplate was ''{0}''.");
    public static final ExceptionContext SECURITY_CANNOT_GET_PROVIDERS = new ExceptionContext("SECURITY_CANNOT_GET_PROVIDERS", "Unable to get Security Providers.");
    public static final ExceptionContext SECURITY_DESC_NOT_FOUND = new ExceptionContext("SECURITY_DESC_NOT_FOUND", "Security descriptor {0} not found.");
    public static final ExceptionContext SECURITY_INVALID_MARKINGSET = new ExceptionContext("SECURITY_INVALID_MARKINGSET", "Invalid MarkingSet {0}");
    public static final ExceptionContext SECURITY_INVALID_MARKING_VALUE = new ExceptionContext("SECURITY_INVALID_MARKING_VALUE", "The specified marking value is invalid");
    public static final ExceptionContext SECURITY_NO_PROVIDERS_CONFIGURED = new ExceptionContext("SECURITY_NO_PROVIDERS_CONFIGURED", "No Security Providers were discovered.");
    public static final ExceptionContext SECURITY_POLICY_DOC_REFERENCES = new ExceptionContext("SECURITY_POLICY_DOC_REFERENCES", "This security policy is in use by one or more documents.");
    public static final ExceptionContext SECURITY_POLICY_FOLDER_REFERENCES = new ExceptionContext("SECURITY_POLICY_FOLDER_REFERENCES", "This security policy is in use by one or more folders.");
    public static final ExceptionContext SECURITY_POLICY_GENERIC_REFERENCES = new ExceptionContext("SECURITY_POLICY_GENERIC_REFERENCES", "This security policy is in use by one or more custom objects.");
    public static final ExceptionContext SECURITY_POLICY_NOT_FOUND = new ExceptionContext("SECURITY_POLICY_NOT_FOUND", "SecurityPolicy {0} not found.");
    public static final ExceptionContext SECURITY_PROVIDER_AUTHENTICATION_FAILURE = new ExceptionContext("SECURITY_PROVIDER_AUTHENTICATION_FAILURE", "Authentication failure - {0}");
    public static final ExceptionContext SECURITY_PROVIDER_RETRIEVAL_TIMEOUT = new ExceptionContext("SECURITY_PROVIDER_RETRIEVAL_TIMEOUT", "Provider retrieval timed out in {0} seconds. The most likely reason is the ApplicationServerUrl property in your CEMPBoot.properties file points to a wrong server.");
    public static final ExceptionContext SECURITY_PROVIDER_UNKNOWN_HOST = new ExceptionContext("SECURITY_PROVIDER_UNKNOWN_HOST", "Unknown application server host: {0}");
    public static final ExceptionContext SECURITY_REALM_NOT_FOUND = new ExceptionContext("SECURITY_REALM_NOT_FOUND", "Realm {0} not found. Please make sure this realm is configured in FEM (as a DirectoryConfiguration object).");
    public static final ExceptionContext SECURITY_TEMPLATE_DISABLED = new ExceptionContext("SECURITY_TEMPLATE_DISABLED", "Security template disabled.");
    public static final ExceptionContext SECURITY_REPORTED_AS_ANONYMOUS = new ExceptionContext("SECURITY_REPORTED_AS_ANONYMOUS", "The application server reported that the user was anonymous.");
    public static final ExceptionContext SECURITY_NO_SECURITY_CONTEXT = new ExceptionContext("SECURITY_NO_SECURITY_CONTEXT", "No security context was found.");
    public static final ExceptionContext SECURITY_MISSING_CREDENTIALS = new ExceptionContext("SECURITY_MISSING_CREDENTIALS", "Expected credentials were not found in the security context.");
    public static final ExceptionContext SECURITY_CANNOT_RETRIEVE_CREDENTIALS = new ExceptionContext("SECURITY_CANNOT_RETRIEVE_CREDENTIALS", "Failed to retrieve the security context and credentials.");
    public static final ExceptionContext SECURITY_MISSING_REQUIRED_SID_VALUE = new ExceptionContext("SECURITY_MISSING_REQUIRED_SID_VALUE", "The configured SID attribute value, is either missing or empty/null.");
    public static final ExceptionContext TRANSPORT_WSI_BINDING_FAILED = new ExceptionContext("TRANSPORT_WSI_BINDING_FAILED", "Unable to determine the binding for {0}.");
    public static final ExceptionContext TRANSPORT_WSI_DESERIALIZATION_PATH = new ExceptionContext("TRANSPORT_WSI_DESERIALIZATION_PATH", "Path when error was detected {0}.");
    public static final ExceptionContext TRANSPORT_WSI_RESPONSE_NOT_HTTP = new ExceptionContext("TRANSPORT_WSI_RESPONSE_NOT_HTTP", "A Web services request received a non-HTTP response.  Response contents: {0}");
    public static final ExceptionContext TRANSPORT_WSI_RESPONSE_NOT_SOAP = new ExceptionContext("TRANSPORT_WSI_RESPONSE_NOT_SOAP", "A Web services request received an HTTP response that did not have a SOAP Content-Type: ({0}).  Response contents: {1}");
    public static final ExceptionContext TRANSPORT_WSI_UNFAMILIAR_SOAP_FAULT = new ExceptionContext("TRANSPORT_WSI_UNFAMILIAR_SOAP_FAULT", "A SOAP fault was received, but its contents were unfamiliar.  This usually indicates an environmental problem.  {0}");
    public static final ExceptionContext TRANSPORT_WSI_NO_MIME_BOUNDARY = new ExceptionContext("TRANSPORT_WSI_NO_MIME_BOUNDARY", "The MIME boundary was missing or was an empty string.");
    public static final ExceptionContext TRANSPORT_WSI_BAD_HTTP_CONTENT_TYPE = new ExceptionContext("TRANSPORT_WSI_BAD_HTTP_CONTENT_TYPE", "HTTP Content-Type header could not be parsed:  {0}");
    public static final ExceptionContext TRANSPORT_WSI_NO_CONTENT_ID = new ExceptionContext("TRANSPORT_WSI_NO_CONTENT_ID", "A message body part had a missing or empty Content-ID value.");
    public static final ExceptionContext TRANSPORT_WSI_UNSUPPORTED_ENCODING = new ExceptionContext("TRANSPORT_WSI_UNSUPPORTED_ENCODING", "A message body part has an unsupported Content-Transfer-Encoding value:  {0}");
    public static final ExceptionContext TRANSPORT_WSI_MISSING_BODY_PART = new ExceptionContext("TRANSPORT_WSI_MISSING_BODY_PART", "The multipart body was missing a body part with this Content-ID:  {0}");
    public static final ExceptionContext TRANSPORT_WSI_UNEXPECTED_EOF = new ExceptionContext("TRANSPORT_WSI_UNEXPECTED_EOF", "Premature end of file on the CEWS input stream.");
    public static final ExceptionContext TRANSPORT_WSI_STAX_MUST_COALESCE = new ExceptionContext("TRANSPORT_WSI_STAX_MUST_COALESCE", "The StAX parser class javax.xml.stream.XMLInputFactory must support javax.xml.stream.isCoalescing being set to true.  Implementation {0} does not.  This is a configuration problem.");
    public static final ExceptionContext TRANSPORT_WSI_STAX_MUST_REPAIR_NAMESPACES = new ExceptionContext("TRANSPORT_WSI_STAX_MUST_REPAIR_NAMESPACES", "The StAX parser class javax.xml.stream.XMLOutputFactory must support javax.xml.stream.isRepairingNamespaces being set to true.  Implementation {0} does not.  This is a configuration problem.");
    public static final ExceptionContext TRANSPORT_WSI_NO_STAX_PARSER = new ExceptionContext("TRANSPORT_WSI_NO_STAX_PARSER", "Cannot find a StAX XML parser XLXP in this environment.  Check application configuration and FileNet P8 documentation.  You may need to put stax-api.jar, xlxpScanner.jar, and xlxpScannerUtils.jar on your classpath.");
    public static final ExceptionContext TRANSPORT_WSI_NETWORK_PROBLEMS_DETAILS = new ExceptionContext("TRANSPORT_WSI_NETWORK_PROBLEMS_DETAILS", "See full stack trace for details.  Message: {0}");
    public static final ExceptionContext TRANSPORT_EJB_UNEXPECTED_CONTENT_EJB = new ExceptionContext("TRANSPORT_EJB_UNEXPECTED_CONTENT_EJB", "Unexpected EJB type {0} for content operation {1}.");
    public static final ExceptionContext TRANSPORT_EJB_NULL_CONTENT_EJB = new ExceptionContext("TRANSPORT_EJB_NULL_CONTENT_EJB", "Content EJB is not set for EJB type {0} and content operation {1}.");
    private static final long serialVersionUID = -4846791583317622768L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];

    private ExceptionContext(String key, String englishString) {
        this.mKey = key;
        this.mEnglishString = englishString;
        mapNameToExceptionContextInstance.put(key, this);
    }

    public String getKey() {
        return this.mKey;
    }

    public String getDefaultEnglishString() {
        return this.mEnglishString;
    }

    public String toString(Object[] args) {
        return this.toStringHelper(RES_BASE_NAME, stDefaultLocale, args);
    }

    public String toString(Locale le, Object[] args) {
        return this.toStringHelper(RES_BASE_NAME, le, args);
    }

    private synchronized String toStringHelper(String BaseName, Locale le, Object[] args) {
        String formattedString;
        String patternString;
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(BaseName, le);
            patternString = bundle.getString(this.mKey);
        }
        catch (MissingResourceException ex) {
            patternString = this.mEnglishString;
            le = Locale.US;
        }
        try {
            MessageFormat form = new MessageFormat(patternString, le);
            formattedString = form.format(args);
        }
        catch (Exception ex) {
            formattedString = this.mEnglishString;
            try {
                stLogger.error("Failed formating resource string: " + patternString, ex);
            }
            catch (Exception exx) {
                // empty catch block
            }
        }
        return formattedString;
    }

    public static ExceptionContext getExceptionContext(String key) {
        return (ExceptionContext)mapNameToExceptionContextInstance.get(key);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeObject(this.mKey);
        s.writeObject(this.mEnglishString);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.mKey = (String)s.readObject();
        this.mEnglishString = (String)s.readObject();
    }

    private Object readResolve() throws ObjectStreamException {
        return ExceptionContext.getExceptionContext(this.mKey);
    }
}

