/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.core;

import com.filenet.api.constants.ConnectionType;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.core.ConnectionImpl;
import com.filenet.apiimpl.core.UserPasswordCallback;
import com.filenet.apiimpl.util.ConfigValueLookup;
import com.filenet.apiimpl.util.J2EEUtil;
import com.filenet.apiimpl.util.J2EEUtilWS;
import com.filenet.apiimpl.util.JaasConfiguration;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class UserPasswordToken {
    private String user;
    private String password;
    private Subject subject;
    private String providerURL;
    private String JAASConfigurationName;

    public UserPasswordToken(String userVal, String passwordVal) {
        this.user = userVal;
        this.password = passwordVal;
        this.JAASConfigurationName = ConfigValueLookup.getValue("JAASConfigurationName", "FileNetP8");
    }

    public UserPasswordToken(String userVal, String passwordVal, String JAASConfigurationNameVal) {
        this.user = userVal;
        this.password = passwordVal;
        this.JAASConfigurationName = JAASConfigurationNameVal != null ? JAASConfigurationNameVal : ConfigValueLookup.getValue("JAASConfigurationName", "FileNetP8");
    }

    public UserPasswordToken(Subject subjectVal) {
        String userVal;
        this.subject = subjectVal;
        Principal princ = this.subject.getPrincipals().iterator().next();
        this.user = userVal = princ.getName();
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public Subject getSubject() {
        return this.getSubject(null);
    }

    public Subject getSubject(ConnectionImpl conn) {
        if (this.subject == null) {
            if (conn != null && conn.getConnectionType() == ConnectionType.EJB && J2EEUtil.getInstance() instanceof J2EEUtilWS) {
                try {
                    InitialContext ic = J2EEUtil.getInitialContextWithParameters(conn);
                    ic.lookup("");
                }
                catch (NamingException e) {
                    // empty catch block
                }
            }
            JaasConfiguration.setConfiguration();
            LoginContext lc = null;
            try {
                lc = this.getPrivilegedLoginContext();
                lc.login();
            }
            catch (Throwable t) {
                if (t instanceof EngineRuntimeException) {
                    throw (EngineRuntimeException)t;
                }
                if (t.getCause() instanceof EngineRuntimeException) {
                    throw (EngineRuntimeException)t.getCause();
                }
                if (t.getMessage() != null && t.getMessage().indexOf("java.net.UnknownHostException") >= 0) {
                    throw new EngineRuntimeException(t, ExceptionCode.API_INVALID_URI, new Object[]{this.providerURL});
                }
                throw new EngineRuntimeException(t, ExceptionCode.E_NOT_AUTHENTICATED, null);
            }
            this.subject = lc.getSubject();
        }
        return this.subject;
    }

    private final LoginContext getPrivilegedLoginContext() throws Throwable {
        PrivilegedExceptionAction paProp = new PrivilegedExceptionAction(){

            public Object run() throws LoginException {
                return new LoginContext(UserPasswordToken.this.JAASConfigurationName, new UserPasswordCallback(UserPasswordToken.this.user, UserPasswordToken.this.password, UserPasswordToken.this.providerURL));
            }
        };
        try {
            return (LoginContext)AccessController.doPrivileged(paProp);
        }
        catch (PrivilegedActionException e) {
            throw e.getCause();
        }
    }

    public void setProviderURL(String providerURLVal) {
        this.providerURL = providerURLVal;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof UserPasswordToken)) {
            return false;
        }
        UserPasswordToken base = (UserPasswordToken)object;
        if (this.user != null && base.user == null || base.user != null && this.user == null) {
            return false;
        }
        if (this.password != null && base.password == null || base.password != null && this.password == null) {
            return false;
        }
        if (this.user != null && !this.user.equalsIgnoreCase(base.user)) {
            return false;
        }
        return this.password == null || this.password.equalsIgnoreCase(base.password);
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.user != null ? this.user.toLowerCase().hashCode() : 0);
        result = 37 * result + (this.password != null ? this.password.toLowerCase().hashCode() : 0);
        return result;
    }
}

