/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.core;

import com.filenet.api.action.PendingAction;
import com.filenet.api.action.Update;
import com.filenet.api.admin.ContentValidationRequest;
import com.filenet.api.collection.ClassDescriptionSet;
import com.filenet.api.collection.IndependentObjectSet;
import com.filenet.api.constants.ConfigurationParameter;
import com.filenet.api.constants.MergeMode;
import com.filenet.api.constants.RefreshMode;
import com.filenet.api.core.EngineObject;
import com.filenet.api.core.IndependentlyPersistableObject;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.property.FilterElement;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.util.UserContext;
import com.filenet.apiimpl.collection.RepositoryRowCollectionImpl;
import com.filenet.apiimpl.constants.SearchMode;
import com.filenet.apiimpl.core.BatchItemHandleImpl;
import com.filenet.apiimpl.core.ConnectionImpl;
import com.filenet.apiimpl.core.DomainImpl;
import com.filenet.apiimpl.core.EngineObjectImpl;
import com.filenet.apiimpl.core.GlobalIdentity;
import com.filenet.apiimpl.core.IndependentObjectImpl;
import com.filenet.apiimpl.core.IndependentlyPersistableObjectImpl;
import com.filenet.apiimpl.core.ObjectReferenceBase;
import com.filenet.apiimpl.core.ObjectStoreImpl;
import com.filenet.apiimpl.core.SetImpl;
import com.filenet.apiimpl.property.ClientInputStream;
import com.filenet.apiimpl.property.PropertyImpl;
import com.filenet.apiimpl.property.UnevaluatedPropertyValue;
import com.filenet.apiimpl.query.PrincipalSearch;
import com.filenet.apiimpl.query.Search;
import com.filenet.apiimpl.query.SearchContext;
import com.filenet.apiimpl.query.SearchObjectPaging;
import com.filenet.apiimpl.query.SearchRowPaging;
import com.filenet.apiimpl.query.SearchScope;
import com.filenet.apiimpl.smm.TimerMeasurement;
import com.filenet.apiimpl.transport.ChangeRequest;
import com.filenet.apiimpl.transport.ChangeResponse;
import com.filenet.apiimpl.transport.ClientCallContext;
import com.filenet.apiimpl.transport.ContentRequest;
import com.filenet.apiimpl.transport.ContentResponse;
import com.filenet.apiimpl.transport.ExecuteChangesRequest;
import com.filenet.apiimpl.transport.ExecuteChangesResponse;
import com.filenet.apiimpl.transport.GetContentRequest;
import com.filenet.apiimpl.transport.GetContentResponse;
import com.filenet.apiimpl.transport.GetObjectRequest;
import com.filenet.apiimpl.transport.GetObjectResponse;
import com.filenet.apiimpl.transport.MetadataSearchRequest;
import com.filenet.apiimpl.transport.MetadataSearchResponse;
import com.filenet.apiimpl.transport.ObjectRequest;
import com.filenet.apiimpl.transport.ObjectResponse;
import com.filenet.apiimpl.transport.SearchRequest;
import com.filenet.apiimpl.transport.SearchResponse;
import com.filenet.apiimpl.transport.TransportLogger;
import com.filenet.apiimpl.util.ConfigValueLookup;
import com.filenet.apiimpl.util.J2EEUtil;
import com.filenet.apiimpl.util.SubSystem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import javax.security.auth.Subject;

public abstract class Session {
    protected final Integer MAX_GET_CONTENT_BYTES = new Integer(ConfigValueLookup.getInt(ConfigurationParameter.CONTENT_GET_BLOCK_SIZE_KB, 1024) * 1024);
    private static final TransportLogger logger = TransportLogger.getLogger(Session.class, SubSystem.API);

    public abstract GetObjectResponse getObjects(ConnectionImpl var1, GetObjectRequest var2, ClientCallContext var3);

    public abstract GetContentResponse getContent(ConnectionImpl var1, GetContentRequest var2, Long var3, ClientCallContext var4);

    public abstract ExecuteChangesResponse executeChanges(ConnectionImpl var1, ExecuteChangesRequest var2, ArrayList var3, ClientCallContext var4);

    public abstract SearchResponse executeSearch(ConnectionImpl var1, SearchRequest var2, ClientCallContext var3);

    public abstract MetadataSearchResponse getSearchMetadata(ConnectionImpl var1, MetadataSearchRequest var2, ClientCallContext var3);

    private GetObjectResponse callGetObjects(ConnectionImpl conn, GetObjectRequest request, ClientCallContext optionalClientCallContext) {
        if (!logger.isCallTraceEnabled()) {
            return this.getObjects(conn, request, optionalClientCallContext);
        }
        logger.traceRequest(optionalClientCallContext, "getObjects       ", request);
        long start = TimerMeasurement.getMillis();
        try {
            GetObjectResponse response = this.getObjects(conn, request, optionalClientCallContext);
            logger.traceResponse(optionalClientCallContext, "getObjects       ", response, start);
            return response;
        }
        catch (Throwable e) {
            logger.traceException("getObjects       ", e, start);
            throw Session.evaluate(e);
        }
    }

    private GetContentResponse callGetContent(ConnectionImpl conn, GetContentRequest request, Long contentSize, ClientCallContext optionalClientCallContext) {
        if (!logger.isCallTraceEnabled()) {
            return this.getContent(conn, request, contentSize, optionalClientCallContext);
        }
        logger.traceRequest(optionalClientCallContext, "getContent       ", request);
        long start = TimerMeasurement.getMillis();
        try {
            GetContentResponse response = this.getContent(conn, request, contentSize, optionalClientCallContext);
            logger.traceResponse(optionalClientCallContext, "getContent       ", response, start);
            return response;
        }
        catch (Throwable e) {
            logger.traceException("getContent       ", e, start);
            throw Session.evaluate(e);
        }
    }

    private ExecuteChangesResponse callExecuteChanges(ConnectionImpl conn, ExecuteChangesRequest request, ArrayList uploadHandles, ClientCallContext optionalClientCallContext) {
        if (!logger.isCallTraceEnabled()) {
            return this.executeChanges(conn, request, uploadHandles, optionalClientCallContext);
        }
        logger.traceRequest(optionalClientCallContext, "executeChanges   ", request);
        long start = TimerMeasurement.getMillis();
        try {
            ExecuteChangesResponse response = this.executeChanges(conn, request, uploadHandles, optionalClientCallContext);
            logger.traceResponse(optionalClientCallContext, "executeChanges   ", response, start);
            return response;
        }
        catch (Throwable e) {
            logger.traceException("executeChanges   ", e, start);
            throw Session.evaluate(e);
        }
    }

    private SearchResponse callExecuteSearch(ConnectionImpl conn, SearchRequest request, ClientCallContext optionalClientCallContext) {
        if (!logger.isCallTraceEnabled()) {
            return this.executeSearch(conn, request, optionalClientCallContext);
        }
        logger.traceRequest(optionalClientCallContext, "executeSearch    ", request);
        long start = TimerMeasurement.getMillis();
        try {
            SearchResponse response = this.executeSearch(conn, request, optionalClientCallContext);
            logger.traceResponse(optionalClientCallContext, "executeSearch    ", response, start);
            return response;
        }
        catch (Throwable e) {
            logger.traceException("executeSearch    ", e, start);
            throw Session.evaluate(e);
        }
    }

    private MetadataSearchResponse callGetSearchMetadata(ConnectionImpl conn, MetadataSearchRequest request, ClientCallContext optionalClientCallContext) {
        if (!logger.isCallTraceEnabled()) {
            return this.getSearchMetadata(conn, request, optionalClientCallContext);
        }
        logger.traceRequest(optionalClientCallContext, "getSearchMetadata", request);
        long start = TimerMeasurement.getMillis();
        try {
            MetadataSearchResponse response = this.getSearchMetadata(conn, request, optionalClientCallContext);
            logger.traceResponse(optionalClientCallContext, "getSearchMetadata", response, start);
            return response;
        }
        catch (Throwable e) {
            logger.traceException("getSearchMetadata", e, start);
            throw Session.evaluate(e);
        }
    }

    private static RuntimeException evaluate(Throwable e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
        return new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
    }

    protected ObjectRequest getObjectRequest(ObjectReferenceBase oa, String continueFrom, PropertyFilter filter, Integer maxElements, String correlationId) {
        return new ObjectRequest(oa, filter, true, correlationId, maxElements, continueFrom);
    }

    public ClientCallContext getClientCallContext(ConnectionImpl conn) {
        ClientCallContext ccc = new ClientCallContext();
        UserContext uc = UserContext.get();
        String locale = uc.getLocale().getLanguage() + "-" + uc.getLocale().getCountry();
        ccc.putParam("loc", (Serializable)((Object)locale));
        ccc.putParam("cliver", new Integer(500));
        if (conn != null && conn.participatesInTransaction()) {
            ccc.putParam("pintran", Boolean.TRUE);
        }
        int clientThreadId = System.identityHashCode(Thread.currentThread());
        ccc.putParam("ctid", (Serializable)((Object)("" + clientThreadId)));
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("Client context prepared for server call; Client-ThreadId=" + clientThreadId + " ClientVersion=" + 500 + " Locale=" + locale);
        }
        return ccc;
    }

    protected ObjectResponse executeGetObject(ConnectionImpl conn, ObjectReferenceBase oa, String continueFrom, PropertyFilter filter, Integer maxElements) {
        ObjectRequest or = this.getObjectRequest(oa, continueFrom, filter, maxElements, "1");
        GetObjectRequest args = new GetObjectRequest(new ObjectRequest[]{or});
        GetObjectResponse resp = null;
        resp = this.callGetObjects(conn, args, null);
        if (resp == null || resp.getBatch() == null || resp.getBatch().length != 1) {
            return null;
        }
        return resp.getBatch()[0];
    }

    public EngineObjectImpl getObject(ConnectionImpl conn, ObjectReferenceBase oa, PropertyFilter filter, Integer maxElements) {
        ObjectResponse resp = this.executeGetObject(conn, oa, null, filter, maxElements);
        if (resp == null) {
            throw new EngineRuntimeException(ExceptionCode.TRANSPORT_EXPECTED_ENGINEOBJECT_RESPONSE, null);
        }
        Object val = resp.getValue();
        if (val instanceof EngineRuntimeException) {
            throw (EngineRuntimeException)val;
        }
        if (val instanceof EngineObjectImpl) {
            ((EngineObjectImpl)val).setFetchLessObject(false);
            return (EngineObjectImpl)val;
        }
        throw new EngineRuntimeException(ExceptionCode.TRANSPORT_EXPECTED_ENGINEOBJECT_RESPONSE, null);
    }

    public void getObjects(ConnectionImpl conn, BatchItemHandleImpl[] batchItems) {
        ObjectResponse[] batchResponse;
        HashMap<String, BatchItemHandleImpl> corMap = new HashMap<String, BatchItemHandleImpl>();
        ObjectRequest[] batchRequests = new ObjectRequest[batchItems.length];
        for (int lp = 0; lp < batchItems.length; ++lp) {
            BatchItemHandleImpl bihi = batchItems[lp];
            String key = Integer.toString(lp);
            corMap.put(key, bihi);
            IndependentObjectImpl ipo = (IndependentObjectImpl)bihi.getObject();
            batchRequests[lp] = this.getObjectRequest((ObjectReferenceBase)ipo.getObjectReference(), null, bihi.getPropertyFilter(), null, key);
        }
        GetObjectResponse resp = null;
        GetObjectRequest request = new GetObjectRequest(batchRequests);
        resp = this.callGetObjects(conn, request, null);
        ObjectResponse[] objectResponseArray = batchResponse = resp != null ? resp.getBatch() : null;
        if (batchResponse == null || batchResponse.length < 1) {
            throw new EngineRuntimeException(ExceptionCode.TRANSPORT_MISSING_SERVER_RESPONSE, null);
        }
        for (int lp = 0; lp < batchResponse.length; ++lp) {
            ObjectResponse response = batchResponse[lp];
            String id = response.getCorrelationId();
            if (id == null) {
                throw new EngineRuntimeException(ExceptionCode.TRANSPORT_CORRELATION_ID_MISSING, null);
            }
            BatchItemHandleImpl bihi = (BatchItemHandleImpl)corMap.remove(id);
            if (bihi == null) {
                throw new EngineRuntimeException(ExceptionCode.TRANSPORT_INVALID_CORRELATION_ID, id);
            }
            Object val = response.getValue();
            if (val instanceof EngineRuntimeException) {
                bihi.setException((EngineRuntimeException)val);
                continue;
            }
            if (val instanceof EngineObjectImpl) {
                EngineObjectImpl eo = (EngineObjectImpl)((Object)bihi.getObject());
                ((EngineObjectImpl)val).setFetchLessObject(false);
                eo.setObject((EngineObjectImpl)val);
                continue;
            }
            throw new EngineRuntimeException(ExceptionCode.TRANSPORT_EXPECTED_ENGINEOBJECT_RESPONSE, null);
        }
        if (corMap.size() > 1) {
            throw new EngineRuntimeException(ExceptionCode.TRANSPORT_MISSING_SERVER_RESPONSE, null);
        }
    }

    public PropertyImpl getProperty(ConnectionImpl conn, UnevaluatedPropertyValue up, String continueFrom, PropertyFilter filter, Integer maxElements) {
        ObjectResponse resp = this.executeGetObject(conn, up, continueFrom, filter, maxElements);
        if (resp == null) {
            throw new EngineRuntimeException(ExceptionCode.TRANSPORT_EXPECTED_PROPERTY_RESPONSE, up.getPropertyName());
        }
        Object val = resp.getValue();
        if (val instanceof EngineRuntimeException) {
            throw (EngineRuntimeException)val;
        }
        if (val instanceof PropertyImpl) {
            PropertyImpl pi = (PropertyImpl)val;
            pi.setDirty(false);
            return pi;
        }
        if (val == null) {
            return null;
        }
        throw new EngineRuntimeException(ExceptionCode.TRANSPORT_EXPECTED_PROPERTY_RESPONSE, up.getPropertyName());
    }

    public ChangeRequest getChangeRequest(IndependentlyPersistableObjectImpl objToUpdate, PendingAction[] actions, PropertyFilter refreshFilter, String correlationId) {
        ChangeRequest cr = new ChangeRequest(actions, this.getExecuteChangesTargetSpecification(actions, objToUpdate), refreshFilter, objToUpdate.getModifiedProperties(), correlationId, objToUpdate.getUpdateSequenceNumber());
        return cr;
    }

    public ObjectReferenceBase getExecuteChangesTargetSpecification(PendingAction[] actions, IndependentlyPersistableObjectImpl objToUpdate) {
        return (ObjectReferenceBase)objToUpdate.getObjectReference();
    }

    public void getChangeRequests(BatchItemHandleImpl[] batchItems, ArrayList changeRequestTypes, HashMap correlationMap, ArrayList uploadHandles) {
        for (int lp = 0; lp < batchItems.length; ++lp) {
            String corId = Integer.toString(lp);
            BatchItemHandleImpl item = batchItems[lp];
            IndependentlyPersistableObjectImpl ipo = (IndependentlyPersistableObjectImpl)item.getObject();
            ChangeRequest changeRequest = this.getChangeRequest(ipo, this.getPendingActions(ipo, null), item.getPropertyFilter(), corId);
            this.getContentToUpload(ipo, changeRequest, uploadHandles);
            changeRequestTypes.add(changeRequest);
            correlationMap.put(corId, item);
        }
    }

    public void getContentToUpload(IndependentlyPersistableObjectImpl obj, ChangeRequest cr, ArrayList uploadHandles) {
    }

    public void executeChanges(ConnectionImpl conn, RefreshMode refreshMode, BatchItemHandleImpl[] batchItems) {
        HashMap correlationMap = new HashMap();
        ArrayList changeRequestList = new ArrayList();
        ArrayList uploadHandles = new ArrayList();
        this.getChangeRequests(batchItems, changeRequestList, correlationMap, uploadHandles);
        ChangeRequest[] args = changeRequestList.toArray(new ChangeRequest[0]);
        ExecuteChangesRequest ecr = new ExecuteChangesRequest(args);
        boolean refresh = refreshMode == RefreshMode.REFRESH;
        ecr.setRefresh(refresh);
        ExecuteChangesResponse resp = this.callExecuteChanges(conn, ecr, uploadHandles, null);
        if (refresh) {
            ChangeResponse[] batch;
            ChangeResponse[] changeResponseArray = batch = resp != null ? resp.getBatch() : null;
            if (batch == null || batch.length < 1) {
                throw new EngineRuntimeException(ExceptionCode.TRANSPORT_EXECUTE_CHG_MISSING_RESPONSE, null);
            }
            for (int lp = 0; lp < batch.length; ++lp) {
                String id = batch[lp].getCorrelationId();
                BatchItemHandleImpl bihi = (BatchItemHandleImpl)correlationMap.remove(id);
                if (bihi == null) {
                    throw new EngineRuntimeException(ExceptionCode.TRANSPORT_INVALID_CORRELATION_ID, id != null ? id : "null");
                }
                EngineObjectImpl beo = (EngineObjectImpl)((Object)bihi.getObject());
                Object val = batch[lp].getValue();
                if (!(val instanceof EngineObjectImpl)) {
                    throw new EngineRuntimeException(ExceptionCode.TRANSPORT_EXECUTE_CHG_MISSING_RESPONSE, null);
                }
                ((EngineObjectImpl)val).setFetchLessObject(false);
                beo.setObject((EngineObjectImpl)val);
            }
        }
        for (BatchItemHandleImpl bihi : correlationMap.values()) {
            IndependentlyPersistableObjectImpl ipo = (IndependentlyPersistableObjectImpl)bihi.getObject();
            if (refreshMode != RefreshMode.REFRESH) {
                ipo.setDirty(false);
            }
            ipo.clearPendingActions();
            if (ipo.getUpdateSequenceNumber() == null) continue;
            ipo.setUpdateSequenceNumber(new Integer(ipo.getUpdateSequenceNumber() + 1));
        }
    }

    public ClientInputStream getContentStream(ConnectionImpl conn, Subject fallbackSubject, ObjectReferenceBase source, Integer elementSequenceNumber, Integer itemIndex, Long startOffset, Long contentSize, String continueFrom) {
        boolean pushedSubject = false;
        try {
            Object chunkSizeConnParam;
            if (fallbackSubject != null) {
                UserContext.get().pushSubject(fallbackSubject);
                pushedSubject = true;
            }
            Integer chunkSize = this.MAX_GET_CONTENT_BYTES;
            if (conn != null && (chunkSizeConnParam = conn.getParameter(ConfigurationParameter.CONTENT_GET_BLOCK_SIZE_KB)) != null && chunkSizeConnParam instanceof Integer) {
                chunkSize = (Integer)chunkSizeConnParam * 1024;
            }
            chunkSize = chunkSize > 0 ? chunkSize : this.MAX_GET_CONTENT_BYTES;
            ContentRequest req = new ContentRequest(source, Boolean.TRUE, "1", elementSequenceNumber, itemIndex, startOffset, chunkSize, continueFrom);
            GetContentRequest arg = new GetContentRequest(new ContentRequest[]{req});
            GetContentResponse resp = null;
            resp = this.callGetContent(conn, arg, contentSize, null);
            if (resp == null || resp.getBatch() == null || resp.getBatch().length < 1) {
                throw new EngineRuntimeException(ExceptionCode.TRANSPORT_MISSING_SERVER_RESPONSE, null);
            }
            ContentResponse response = resp.getBatch()[0];
            if (response.getValue() instanceof EngineRuntimeException) {
                throw (EngineRuntimeException)response.getValue();
            }
            if (response.getValue() instanceof ClientInputStream) {
                ClientInputStream clientInputStream = (ClientInputStream)response.getValue();
                return clientInputStream;
            }
            throw new EngineRuntimeException(ExceptionCode.E_INVALID_OBJECT_TYPE, response.getValue() != null ? response.getValue().getClass().getName() : "null");
        }
        finally {
            if (pushedSubject) {
                UserContext.get().popSubject();
            }
        }
    }

    public RepositoryRowCollectionImpl fetchRows(SearchContext src, String continueFrom) {
        SearchRequest sr = new SearchRequest(SearchMode.ROWS, src.getSearch(), SearchScope.getSearchScopeInstance(src.getObjectStores(), src.getMergeMode()), src.getPageSize(), src.getContinuable(), continueFrom);
        SearchResponse resp = this.callExecuteSearch((ConnectionImpl)src.getConnection(), sr, null);
        Object val = resp.getValue();
        if (!(val instanceof RepositoryRowCollectionImpl)) {
            throw new EngineRuntimeException(ExceptionCode.TRANSPORT_EXPECTED_REPOSITORYROWCOLLECTION_RESPONSE, null);
        }
        RepositoryRowCollectionImpl rrc = (RepositoryRowCollectionImpl)val;
        rrc.setPaging(new SearchRowPaging(src, rrc));
        return rrc;
    }

    public IndependentObjectSet fetchObjects(SearchContext src, String continueFrom) {
        SearchRequest sr = new SearchRequest(SearchMode.OBJECTS, src.getSearch(), SearchScope.getSearchScopeInstance(src.getObjectStores(), src.getMergeMode()), src.getPageSize(), src.getContinuable(), continueFrom);
        SearchResponse resp = this.callExecuteSearch((ConnectionImpl)src.getConnection(), sr, null);
        Object val = resp.getValue();
        if (!(val instanceof IndependentObjectSet)) {
            throw new EngineRuntimeException(ExceptionCode.TRANSPORT_EXPECTED_ENGINEOBJECTCOLLECTION_RESPONSE, null);
        }
        SetImpl si = (SetImpl)val;
        si.setPaging(new SearchObjectPaging(src, si));
        return (IndependentObjectSet)val;
    }

    public ClassDescriptionSet getSearchMetadata(ConnectionImpl conn, GlobalIdentity[] objectStores, MergeMode mergeMode, String[] classNames, PropertyFilter propFilter) {
        if (objectStores == null || objectStores.length < 1) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "objectStores");
        }
        MetadataSearchRequest msr = new MetadataSearchRequest(SearchScope.getSearchScopeInstance(objectStores, mergeMode), classNames, propFilter);
        MetadataSearchResponse resp = this.callGetSearchMetadata(conn, msr, null);
        if (resp == null || resp.getClassDescriptionSet() == null) {
            throw new EngineRuntimeException(ExceptionCode.TRANSPORT_EXPECTED_CLASS_DESCRIPTION);
        }
        return resp.getClassDescriptionSet();
    }

    protected Session() {
    }

    public void executeChange(IndependentlyPersistableObjectImpl objToUpdate, PropertyFilter filter, RefreshMode refreshMode) {
        BatchItemHandleImpl b = new BatchItemHandleImpl(objToUpdate, filter);
        this.executeChanges((ConnectionImpl)objToUpdate.getConnection(), refreshMode, new BatchItemHandleImpl[]{b});
        if (b.getException() != null) {
            throw b.getException();
        }
    }

    public RepositoryRowCollectionImpl fetchRows(ConnectionImpl conn, Search search, ObjectStoreImpl[] objectStores, MergeMode mergeMode, Integer maxElements, Boolean continuable, String continueFrom) {
        if (null == objectStores || objectStores.length < 1) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "objectStores");
        }
        return this.fetchRows(new SearchContext(conn, search, mergeMode, maxElements, continuable, objectStores), continueFrom);
    }

    public RepositoryRowCollectionImpl fetchRows(ConnectionImpl conn, Search search, ObjectStoreImpl objectStore, Integer maxElements, Boolean continuable, String continueFrom) {
        if (null == objectStore) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "objectStore");
        }
        return this.fetchRows(new SearchContext(conn, search, null, maxElements, continuable, new ObjectStore[]{objectStore}), continueFrom);
    }

    public RepositoryRowCollectionImpl fetchRows(ConnectionImpl conn, DomainImpl domain, PrincipalSearch search, Integer maxElements, Boolean continuable, String continueFrom) {
        return this.fetchRows(new SearchContext(conn, search, null, maxElements, continuable, null), continueFrom);
    }

    public IndependentObjectSet fetchObjects(ConnectionImpl conn, Search search, ObjectStore[] objectStores, MergeMode mergeMode, Integer maxElements, Boolean continuable, String continueFrom) {
        if (null == objectStores || objectStores.length < 1) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "objectStores");
        }
        return this.fetchObjects(new SearchContext(conn, search, mergeMode, maxElements, continuable, objectStores), continueFrom);
    }

    public IndependentObjectSet fetchObjects(ConnectionImpl conn, Search search, ObjectStoreImpl objectStore, Integer maxElements, Boolean continuable, String continueFrom) {
        if (null == objectStore) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "objectStore");
        }
        return this.fetchObjects(new SearchContext(conn, search, null, maxElements, continuable, new ObjectStore[]{objectStore}), continueFrom);
    }

    public IndependentObjectSet fetchObjects(ConnectionImpl conn, PrincipalSearch search, Integer maxElements, Boolean continuable, String continueFrom) {
        return this.fetchObjects(new SearchContext(conn, search, null, maxElements, continuable, null), continueFrom);
    }

    public void executeChange(IndependentlyPersistableObjectImpl objToUpdate, RefreshMode refresh) {
        this.executeChange(objToUpdate, null, refresh);
    }

    public ClassDescriptionSet getSearchMetadata(ConnectionImpl conn, ObjectStoreImpl objectStore, String[] classDescriptionNames, PropertyFilter propFilter) {
        return this.getSearchMetadata(conn, new ObjectStoreImpl[]{objectStore}, null, classDescriptionNames, propFilter);
    }

    public ClassDescriptionSet getSearchMetadata(ConnectionImpl conn, ObjectStoreImpl[] objectStores, MergeMode mergeMode, String[] classDescriptionNames, PropertyFilter propFilter) {
        return this.getSearchMetadata(conn, this.getObjectStoreIdentities(objectStores), mergeMode, classDescriptionNames, propFilter);
    }

    public EngineObject getObject(ConnectionImpl conn, ObjectReferenceBase oa) {
        return this.getObject(conn, oa, null, null);
    }

    public PropertyImpl getProperty(ConnectionImpl conn, UnevaluatedPropertyValue up) {
        return this.getProperty(conn, up, null, null, null);
    }

    public PropertyImpl getProperty(ConnectionImpl conn, UnevaluatedPropertyValue up, PropertyFilter filter) {
        return this.getProperty(conn, up, null, filter, null);
    }

    public ClientInputStream getContentStream(ConnectionImpl conn, Subject fallbackSubject, ObjectReferenceBase source, Integer elementSequenceNumber, Long contentSize, String continueFrom) {
        return this.getContentStream(conn, fallbackSubject, source, elementSequenceNumber, null, null, contentSize, continueFrom);
    }

    public static PropertyFilter getDefaultFilter(String[] propertyNames) {
        if (propertyNames == null || propertyNames.length < 1) {
            return null;
        }
        PropertyFilter filter = new PropertyFilter();
        if (propertyNames != null) {
            StringBuffer propsToGet = new StringBuffer();
            for (int lp = 0; lp < propertyNames.length; ++lp) {
                propsToGet.append(propertyNames[lp] + " ");
            }
            filter.addIncludeProperty(new FilterElement(null, null, null, propsToGet.toString().trim(), null));
        }
        filter.setMaxRecursion(1);
        return filter;
    }

    public PendingAction[] getPendingActions(IndependentlyPersistableObjectImpl objToUpdate, PendingAction[] overRideActions) {
        PendingAction[] pas;
        PendingAction[] pendingActionArray = pas = overRideActions == null ? objToUpdate.getPendingActions() : overRideActions;
        if (pas == null || pas.length < 1) {
            if (objToUpdate.getProperties().isDirty()) {
                pas = new PendingAction[]{new Update()};
            }
        } else {
            ArrayList<PendingAction> acts = new ArrayList<PendingAction>();
            for (int lp = 0; lp < pas.length; ++lp) {
                acts.add(pas[lp]);
            }
            pas = acts.size() > 0 ? acts.toArray(new PendingAction[0]) : (objToUpdate.getProperties().isDirty() ? new PendingAction[]{new Update()} : new PendingAction[]{});
        }
        return pas;
    }

    protected GlobalIdentity[] getObjectStoreIdentities(ObjectStoreImpl[] objectStores) {
        GlobalIdentity[] ret = null;
        if (objectStores != null) {
            ret = new GlobalIdentity[objectStores.length];
            for (int lp = 0; lp < objectStores.length; ++lp) {
                ret[lp] = (GlobalIdentity)objectStores[lp].getObjectReference();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EngineRuntimeException[] validateContent(ConnectionImpl conn, Subject fallbackSubject, ContentValidationRequest[] validations) {
        boolean pushedSubject = false;
        EngineRuntimeException[] responseErrors = null;
        try {
            Subject j2eeSub;
            if (fallbackSubject != null && UserContext.get().getSubject() == null && ((j2eeSub = J2EEUtil.getInstance().getCurrentSubject()) == null || j2eeSub != null && j2eeSub.getPrincipals().size() < 1)) {
                UserContext.get().pushSubject(fallbackSubject);
                pushedSubject = true;
            }
            ContentRequest[] contentRequests = new ContentRequest[validations.length];
            for (int i = 0; i < validations.length; ++i) {
                IndependentlyPersistableObject contentObject = validations[i].getContentObject();
                ObjectReferenceBase objRef = (ObjectReferenceBase)contentObject.getObjectReference();
                Integer itemIndex = new Integer(validations[i].getContentElementIndex());
                contentRequests[i] = new ContentRequest(objRef, Boolean.FALSE, Integer.toString(i), null, itemIndex, new Long(0L), new Integer(0), null);
            }
            GetContentRequest getContentRequest = new GetContentRequest(contentRequests);
            getContentRequest.setValidateOnly(true);
            GetContentResponse resp = null;
            resp = this.callGetContent(conn, getContentRequest, null, null);
            if (resp == null || resp.getBatch() == null || resp.getBatch().length != validations.length) {
                throw new EngineRuntimeException(ExceptionCode.TRANSPORT_MISSING_SERVER_RESPONSE, null);
            }
            responseErrors = new EngineRuntimeException[validations.length];
            ContentResponse[] contentResponse = resp.getBatch();
            for (int i = 0; i < validations.length; ++i) {
                int correlationId = Integer.parseInt(contentResponse[i].getCorrelationId());
                responseErrors[correlationId] = contentResponse[i].getValue() instanceof EngineRuntimeException ? (EngineRuntimeException)contentResponse[i].getValue() : (contentResponse[i].getValue() != null ? new EngineRuntimeException(ExceptionCode.E_INVALID_OBJECT_TYPE, contentResponse[i].getValue() != null ? contentResponse[i].getValue().getClass().getName() : "null") : null);
            }
        }
        finally {
            if (pushedSubject) {
                UserContext.get().popSubject();
            }
        }
        return responseErrors;
    }

    public void remove() {
    }

    public void beginGetContentSession(ConnectionImpl conn) {
    }

    public void finishGetContentSession(ConnectionImpl conn) {
    }
}

