/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.core;

import com.filenet.api.core.Connection;
import com.filenet.api.core.ObjectReference;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.util.Id;
import com.filenet.apiimpl.constants.Constants;
import com.filenet.apiimpl.core.GlobalIdentity;
import com.filenet.apiimpl.util.DelegateInputStream;
import com.filenet.apiimpl.util.DelegateOutputStream;
import com.filenet.apiimpl.util.Streamable;
import com.filenet.apiimpl.util.Streams;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;

public abstract class ObjectReferenceBase
implements ObjectReference,
Streamable,
Cloneable {
    protected String classIdentity;
    private static final long serialVersionUID = 7513418598310630743L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];
    public static final int NULL_REFERENCE = 0;
    public static final int DEPENDENT_IDENTITY = 1;
    public static final int GLOBAL_IDENTITY = 2;
    public static final int OBJECT_BY_NAME = 3;
    public static final int OBJECT_BY_PATH = 4;
    public static final int REPOSITORY_IDENTITY = 5;
    public static final int SEARCH_SCOPE_IDENTITY = 6;
    public static final int UNEVALUATED_PROPERTY_VALUE = 7;
    private static final int FIRST_FLAG = 1;
    protected static final int SECOND_FLAG = 2;
    protected static final int THIRD_FLAG = 4;
    protected static final int FOURTH_FLAG = 8;
    protected static final int FIFTH_FLAG = 16;
    protected static final int SIXTH_FLAG = 32;
    private static final int NULL_CLASS_IDENTITY = 1;
    protected static final Integer INTEGER_ZERO = new Integer(0);

    protected ObjectReferenceBase() {
    }

    protected ObjectReferenceBase(String classIdentity) {
        this.classIdentity = classIdentity;
    }

    public Id getObjectId() {
        return null;
    }

    public String getClassIdentity() {
        return this.classIdentity;
    }

    public void setClassIdentity(String nClassIdentity) {
        this.classIdentity = nClassIdentity;
    }

    public boolean isObjectStoreReference() {
        return ObjectReferenceBase.isObjectStoreClassIdentity(this.getClassIdentity());
    }

    public abstract GlobalIdentity getObjectStoreReference();

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ObjectReferenceBase)) {
            return false;
        }
        ObjectReferenceBase base = (ObjectReferenceBase)object;
        if (this.classIdentity != null && base.classIdentity == null || base.classIdentity != null && this.classIdentity == null) {
            return false;
        }
        return this.classIdentity == null || this.classIdentity.equalsIgnoreCase(base.classIdentity);
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.classIdentity != null ? this.classIdentity.toLowerCase().hashCode() : 0);
        return result;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Throwable t) {
            throw new EngineRuntimeException(t, ExceptionCode.E_OBJECT_CLONE_FAILED, null);
        }
    }

    public static boolean isPathIdentity(String objectIdentity) {
        if (objectIdentity == null) {
            return false;
        }
        return objectIdentity.contains("/") || objectIdentity.contains("\\");
    }

    public static boolean isObjectStoreClassIdentity(String classIdentity) {
        if (classIdentity == null) {
            return false;
        }
        return classIdentity.equalsIgnoreCase("ObjectStore") || classIdentity.equalsIgnoreCase(Constants.Class_ObjectStore.toString());
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeShort(5);
        Streams.getInstance().getDelegate(s).putObjectReference(this);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        Streams streams = Streams.getInstance(s.readShort());
        this.copyValue(streams.getDelegate(s, null).getObjectReference());
    }

    public final short getStreamType() {
        return 9;
    }

    public abstract int getClassType();

    protected int getStreamFlags() {
        int flags = 0;
        return flags |= this.classIdentity == null ? 1 : 0;
    }

    public final void putStreamValue(DelegateOutputStream s) throws IOException {
        s.putObjectReference(this);
    }

    public void serializeValue(DelegateOutputStream s) throws IOException {
        s.writeByte(this.getStreamFlags());
        if (this.classIdentity != null) {
            s.writeObject(this.classIdentity);
        }
    }

    public final void deserializeValue(DelegateInputStream s, Connection conn) throws IOException, ClassNotFoundException {
        this.deserializeValue(s, 0xFF & s.readByte());
    }

    protected void deserializeValue(DelegateInputStream s, int flags) throws IOException, ClassNotFoundException {
        if ((flags & 1) == 0) {
            this.classIdentity = (String)s.readObject();
        }
    }

    protected void copyValue(ObjectReferenceBase source) {
        this.classIdentity = source.classIdentity;
    }
}

