/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.core;

import com.filenet.apiimpl.core.GlobalIdentity;
import com.filenet.apiimpl.core.ObjectReferenceBase;
import com.filenet.apiimpl.core.ObjectStoreImpl;
import com.filenet.apiimpl.util.DelegateInputStream;
import com.filenet.apiimpl.util.DelegateOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;

public class ObjectByPath
extends ObjectReferenceBase {
    private GlobalIdentity objectStore;
    private String path;
    private static final long serialVersionUID = 6852478770070694980L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];
    private static final int NULL_OBJECT_STORE = 2;
    private static final int NULL_PATH = 4;

    public ObjectByPath() {
    }

    public ObjectByPath(String classIdentity, ObjectStoreImpl objectStore, String path) {
        super(classIdentity);
        this.objectStore = objectStore.getObjectStoreReference();
        this.path = path;
    }

    public ObjectByPath(String classIdentity, GlobalIdentity objectStore, String path) {
        super(classIdentity);
        this.objectStore = objectStore;
        this.path = path;
    }

    public GlobalIdentity getObjectStoreReference() {
        return this.objectStore;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(128);
        sb.append("classId=");
        sb.append(this.getClassIdentity());
        sb.append("&path=");
        sb.append(this.path);
        sb.append("&objectStore=");
        sb.append(this.getObjectStoreIdentity());
        return sb.toString();
    }

    public String getPath() {
        return this.path;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ObjectByPath)) {
            return false;
        }
        ObjectByPath base = (ObjectByPath)object;
        if (this.path != null && base.path == null || base.path != null && this.path == null) {
            return false;
        }
        if (this.objectStore != null && base.objectStore == null || base.objectStore != null && this.objectStore == null) {
            return false;
        }
        if (this.path != null && !this.path.equalsIgnoreCase(base.path)) {
            return false;
        }
        if (this.objectStore != null && !this.objectStore.equals(base.objectStore)) {
            return false;
        }
        return super.equals(object);
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + super.hashCode();
        result = 37 * result + (this.path != null ? this.path.hashCode() : 0);
        result = 37 * result + (this.objectStore != null ? this.objectStore.hashCode() : 0);
        return result;
    }

    public boolean isResolved() {
        return false;
    }

    public String getObjectIdentity() {
        return this.path;
    }

    public String getObjectStoreIdentity() {
        return this.objectStore != null ? this.objectStore.getObjectIdentity() : null;
    }

    private void writeObject(ObjectOutputStream s) {
    }

    private void readObject(ObjectInputStream s) {
    }

    public int getClassType() {
        return 4;
    }

    protected int getStreamFlags() {
        int flags = super.getStreamFlags();
        flags |= this.objectStore == null ? 2 : 0;
        return flags |= this.path == null ? 4 : 0;
    }

    public void serializeValue(DelegateOutputStream s) throws IOException {
        super.serializeValue(s);
        if (this.objectStore != null) {
            s.putObjectReference(this.objectStore);
        }
        if (this.path != null) {
            s.writeObject(this.path);
        }
    }

    protected void deserializeValue(DelegateInputStream s, int flags) throws IOException, ClassNotFoundException {
        super.deserializeValue(s, flags);
        if ((flags & 2) == 0) {
            this.objectStore = (GlobalIdentity)s.getObjectReference();
        }
        if ((flags & 4) == 0) {
            this.path = (String)s.readObject();
        }
    }

    protected void copyValue(ObjectReferenceBase src) {
        super.copyValue(src);
        ObjectByPath source = (ObjectByPath)src;
        this.objectStore = source.objectStore;
        this.path = source.path;
    }
}

