/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.core;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.core.EngineObjectImpl;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;

public class ListUpdate
implements Serializable {
    public static final int INSERT = 0;
    public static final int MOVE = 1;
    public static final int DELETE = 2;
    public static final int UPDATE = 3;
    private static final String[] actionName = new String[]{"Insert", "Move", "Delete", "Update"};
    private int action;
    private EngineObjectImpl engineObject;
    private int origIndex = -1;
    private int newIndex = -1;
    static final long serialVersionUID = 2293873572898407772L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];

    public ListUpdate(int action, EngineObjectImpl obj, int origIndex, int newIndex) {
        if (action < 0 || action > actionName.length - 1) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "action");
        }
        if (origIndex < -1 || newIndex < -1) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "origIndex/newIndex");
        }
        this.action = action;
        this.engineObject = obj;
        this.origIndex = origIndex;
        this.newIndex = newIndex;
    }

    public int getAction() {
        return this.action;
    }

    public String getActionName() {
        return actionName[this.action];
    }

    public EngineObjectImpl getObject() {
        return this.engineObject;
    }

    public void setObject(EngineObjectImpl eo) {
        this.engineObject = eo;
    }

    public int getOrigIndex() {
        return this.origIndex;
    }

    public int getNewIndex() {
        return this.newIndex;
    }

    public void setNewIndex(int value) {
        this.newIndex = value;
    }

    public void setOrigIndex(int v) {
        this.origIndex = v;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(256);
        sb.append(" Class=");
        sb.append(this.getClass().getName());
        sb.append(" Action=");
        sb.append(this.action);
        sb.append(" EngineObject=(");
        sb.append(this.engineObject);
        sb.append(") NewIndex=");
        sb.append(this.newIndex);
        sb.append(" OrigIndex=");
        sb.append(this.origIndex);
        return sb.toString();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeInt(this.action);
        s.writeInt(this.origIndex);
        s.writeInt(this.newIndex);
        s.writeObject(this.engineObject);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.action = s.readInt();
        this.origIndex = s.readInt();
        this.newIndex = s.readInt();
        this.engineObject = (EngineObjectImpl)s.readObject();
    }
}

