/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.core;

import com.filenet.api.collection.IndependentObjectSet;
import com.filenet.api.core.Connection;
import com.filenet.api.core.IndependentObject;
import com.filenet.api.core.ObjectReference;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.property.Property;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.util.Id;
import com.filenet.apiimpl.core.ConnectionImpl;
import com.filenet.apiimpl.core.EngineObjectImpl;
import com.filenet.apiimpl.core.GlobalIdentity;
import com.filenet.apiimpl.core.IndependentlyPersistableObjectImpl;
import com.filenet.apiimpl.core.ObjectReferenceBase;
import com.filenet.apiimpl.core.RepositoryIdentity;
import com.filenet.apiimpl.core.Session;
import com.filenet.apiimpl.exception.ExceptionContext;
import com.filenet.apiimpl.property.PropertiesImpl;
import com.filenet.apiimpl.property.PropertyImpl;
import com.filenet.apiimpl.property.UnevaluatedPropertyValue;
import com.filenet.apiimpl.util.SessionLocator;
import java.io.ObjectStreamField;

public class IndependentObjectImpl
extends EngineObjectImpl
implements IndependentObject {
    private static final long serialVersionUID = 296860943361381023L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];

    protected IndependentObjectImpl(Connection conn, String className, ObjectReferenceBase newoa) {
        super(conn, className, newoa);
    }

    public void refresh() {
        this.validateChangePreprocessingOperation("refresh");
        this.getObject(null, false);
    }

    public void refresh(String[] propertyNames) {
        if (propertyNames == null || propertyNames.length < 1) {
            throw new EngineRuntimeException(ExceptionCode.E_INVALID_ARGUMENT, "propertyNames");
        }
        this.validateChangePreprocessingOperation("refresh");
        this.getObject(this.getFilter(propertyNames), false);
    }

    protected PropertyFilter getFilter(String[] propertyNames) {
        return Session.getDefaultFilter(propertyNames);
    }

    protected void setObjectValues(EngineObjectImpl source, boolean merge) {
        if (source == null) {
            return;
        }
        if (merge) {
            if (source instanceof IndependentlyPersistableObjectImpl && this instanceof IndependentlyPersistableObjectImpl) {
                IndependentlyPersistableObjectImpl respI = (IndependentlyPersistableObjectImpl)source;
                IndependentlyPersistableObjectImpl thisI = (IndependentlyPersistableObjectImpl)this;
                if (thisI.getUpdateSequenceNumber() != null && respI.getUpdateSequenceNumber() != null && thisI.getUpdateSequenceNumber().intValue() != respI.getUpdateSequenceNumber().intValue()) {
                    throw new EngineRuntimeException(ExceptionCode.API_FETCH_MERGE_PROPERTY_ERROR, null);
                }
            }
            this.mergeProperties(source.getProperties());
        } else {
            this.setObject(source);
        }
        this.setFetchLessObject(source.isFetchLessObject());
    }

    public Property fetchProperty(String propertyName, PropertyFilter pf) {
        return this.fetchProperty(propertyName, pf, null);
    }

    public Property fetchProperty(String propertyName, PropertyFilter pf, Integer pageSize) {
        UnevaluatedPropertyValue upv = new UnevaluatedPropertyValue((ObjectReferenceBase)this.getObjectReference(), propertyName);
        if (this.isNew()) {
            throw new EngineRuntimeException(ExceptionCode.E_OBJECT_NOT_FOUND, null, ExceptionContext.E_OBJECT_IDENTIFICATION, new Object[]{this.getObjectReference(), this.getClassName()});
        }
        ConnectionImpl conn = (ConnectionImpl)this.getConnection();
        Session session = SessionLocator.getSession(conn);
        PropertyImpl pi = session.getProperty(conn, upv, null, pf, pageSize);
        if (pi == null) {
            return null;
        }
        PropertiesImpl props = this.getPropertiesImpl();
        if (props.isPropertyPresent(pi.getPropertyName())) {
            PropertyImpl existingPI = (PropertyImpl)props.get(pi.getPropertyName());
            existingPI.setInstanceValue(pi.getInstanceValue());
            existingPI.setDirty(false);
        } else {
            this.getPropertiesImpl().put(pi);
        }
        return pi;
    }

    protected void getObject(PropertyFilter filter, boolean merge) {
        Session session = SessionLocator.getSession(this.getConnection());
        EngineObjectImpl resp = session.getObject((ConnectionImpl)this.getConnection(), (ObjectReferenceBase)this.getObjectReference(), filter, null);
        this.setObjectValues(resp, merge);
    }

    public void refresh(PropertyFilter filter) {
        this.validateChangePreprocessingOperation("refresh");
        this.getObject(filter, false);
    }

    public void fetchProperties(String[] propertyNames) {
        if (propertyNames == null || propertyNames.length < 1) {
            throw new EngineRuntimeException(ExceptionCode.E_INVALID_ARGUMENT, "propertyNames");
        }
        this.validateChangePreprocessingOperation("fetchProperties");
        this.getObject(this.getFilter(propertyNames), true);
    }

    public void fetchProperties(PropertyFilter filter) {
        if (filter == null) {
            throw new EngineRuntimeException(ExceptionCode.E_INVALID_ARGUMENT, "filter");
        }
        this.validateChangePreprocessingOperation("fetchProperties");
        this.getObject(filter, true);
    }

    public IndependentObjectSet fetchEnumProperty(String propName, PropertyFilter pf) {
        PropertyImpl pi = (PropertyImpl)this.fetchProperty(propName, pf);
        return pi.getIndependentObjectSetValue();
    }

    public Id getObjectId() {
        Id objId = super.getObjectId();
        if (objId == null) {
            ObjectReference oaHere = this.getObjectReference();
            if (oaHere instanceof RepositoryIdentity) {
                objId = ((RepositoryIdentity)oaHere).getObjectId();
            } else if (oaHere instanceof GlobalIdentity) {
                objId = ((GlobalIdentity)oaHere).getObjectId();
            }
            if (objId != null) {
                this.setObjectId(objId);
            }
        }
        return objId;
    }
}

