/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.core;

import com.filenet.api.action.Create;
import com.filenet.api.action.PendingAction;
import com.filenet.api.constants.PropertyState;
import com.filenet.api.core.Connection;
import com.filenet.api.core.Domain;
import com.filenet.api.core.EngineObject;
import com.filenet.api.core.ObjectReference;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.core.Scope;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.meta.ClassDescription;
import com.filenet.api.property.Properties;
import com.filenet.api.property.Property;
import com.filenet.api.util.Id;
import com.filenet.apiimpl.core.ConnectionImpl;
import com.filenet.apiimpl.core.DependentIdentity;
import com.filenet.apiimpl.core.EngineObjectUtil;
import com.filenet.apiimpl.core.GlobalIdentity;
import com.filenet.apiimpl.core.IndependentlyPersistableObjectImpl;
import com.filenet.apiimpl.core.ObjectFactory;
import com.filenet.apiimpl.core.ObjectReferenceBase;
import com.filenet.apiimpl.core.RepositoryIdentity;
import com.filenet.apiimpl.engine.CreateCheckin;
import com.filenet.apiimpl.exception.ExceptionContext;
import com.filenet.apiimpl.meta.Util;
import com.filenet.apiimpl.property.PropertiesImpl;
import com.filenet.apiimpl.util.BinaryInputStream;
import com.filenet.apiimpl.util.BinaryOutputStream;
import com.filenet.apiimpl.util.XMLTraceReader;
import com.filenet.apiimpl.util.XMLTraceable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class EngineObjectImpl
implements EngineObject,
Serializable,
Cloneable,
XMLTraceable {
    protected Scope scope;
    protected ObjectReferenceBase oa;
    protected ObjectReferenceBase domainScope;
    protected Integer accessAllowed;
    protected Connection connection;
    protected String[] superClasses;
    protected ArrayList pendingActions;
    protected Integer updateSequenceNumber;
    private Id objectId;
    private boolean fetchLessObject;
    private boolean readOnly = false;
    private static final String RECURSION_LEVEL = "recursionLevel";
    private static final Util metadata = Util.INSTANCE;
    protected HashMap internalMembers;
    private static final String ObjectId = "ObjectId";
    private static final String HAS_PROXY = "hasProxy";
    private static final String IS_CHANGE_PREPROCESSING = "isChangePreprocessing";
    private PropertiesImpl propertyCache = new PropertiesImpl();
    private static final long serialVersionUID = -7924316246339134108L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];

    public int getRecursionLevel() {
        Object v = this.internalMembers.get(RECURSION_LEVEL);
        return v instanceof Integer ? (Integer)v : 0;
    }

    public void setRecursionLevel(int recursionLevel) {
        this.internalMembers.put(RECURSION_LEVEL, new Integer(recursionLevel));
    }

    public void setHasProxy(boolean hasProxy) {
        this.internalMembers.put(HAS_PROXY, hasProxy);
    }

    public boolean hasProxy() {
        Object v = this.internalMembers.get(HAS_PROXY);
        return v instanceof Boolean ? (Boolean)v : false;
    }

    public void setIsChangePreprocessing(boolean isChangePreprocessing) {
        this.internalMembers.put(IS_CHANGE_PREPROCESSING, isChangePreprocessing);
    }

    public boolean isChangePreprocessing() {
        Object v = this.internalMembers.get(IS_CHANGE_PREPROCESSING);
        return v instanceof Boolean ? (Boolean)v : false;
    }

    protected EngineObjectImpl(Connection conn, String className, ObjectReferenceBase newoa) {
        this.internalMembers = new HashMap();
        this.oa = newoa;
        if (this.oa.getClassIdentity() == null) {
            if (className == null) {
                this.oa.setClassIdentity(EngineObjectUtil.getAPIClassName(this));
            } else {
                this.oa.setClassIdentity(className);
            }
        }
        this.setConnection(conn);
    }

    public ClassDescription get_ClassDescription() {
        ClassDescription cd = metadata.getClassDescription(this);
        if (cd != null) {
            return cd;
        }
        return (ClassDescription)this.propertyCache.getEngineObjectValue("ClassDescription");
    }

    public ObjectReference getObjectReference() {
        return this.oa;
    }

    public void setObjectReference(ObjectReferenceBase or) {
        this.oa = or;
    }

    public boolean equals(Object object) {
        ObjectReference idBase;
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof EngineObjectImpl)) {
            return false;
        }
        EngineObjectImpl base = (EngineObjectImpl)object;
        if (this.isNew() || base.isNew()) {
            return false;
        }
        if (!base.getEqualsClass().getName().equalsIgnoreCase(this.getEqualsClass().getName())) {
            return false;
        }
        if (base.updateSequenceNumber != null && this.updateSequenceNumber != null && !base.updateSequenceNumber.equals(this.updateSequenceNumber)) {
            return false;
        }
        ObjectReference idThis = this.getObjectReference();
        if (idThis.equals(idBase = base.getObjectReference())) {
            if (base.updateSequenceNumber == null || this.updateSequenceNumber == null) {
                return true;
            }
            return base.updateSequenceNumber.equals(this.updateSequenceNumber);
        }
        return false;
    }

    protected Class getEqualsClass() {
        return this.getClass();
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.oa != null ? this.oa.hashCode() : 0);
        return result;
    }

    public void setObject(EngineObjectImpl eo) {
        this.oa = (ObjectReferenceBase)eo.getObjectReference();
        this.propertyCache = eo.propertyCache;
        this.accessAllowed = eo.accessAllowed;
        this.superClasses = eo.superClasses;
        this.pendingActions = eo.pendingActions;
        this.updateSequenceNumber = eo.updateSequenceNumber;
        this.internalMembers = eo.internalMembers;
    }

    protected void mergeProperties(Properties props) {
        Iterator iter = props.iterator();
        while (iter.hasNext()) {
            Property prop = (Property)iter.next();
            this.propertyCache.put(prop);
        }
    }

    public final Connection getConnection() {
        if (this.connection == null) {
            return null;
        }
        Connection realConnection = ((ConnectionImpl)this.connection).getRealConnection();
        if (realConnection != null) {
            return realConnection;
        }
        return this.connection;
    }

    public final void setConnection(Connection connection) {
        this.connection = connection;
    }

    public EngineObjectImpl getModifiedData() {
        try {
            EngineObjectImpl clone = (EngineObjectImpl)super.clone();
            clone.internalMembers = new HashMap(this.internalMembers);
            if (this.pendingActions != null) {
                clone.pendingActions = new ArrayList(this.pendingActions);
            }
            clone.propertyCache = this.propertyCache.getModifiedData(this);
            return clone;
        }
        catch (Throwable t) {
            throw new EngineRuntimeException(t, ExceptionCode.E_OBJECT_CLONE_FAILED, null);
        }
    }

    public Object clone() {
        return this.clone(true, null);
    }

    public EngineObjectImpl clone(boolean includeProperties, ObjectReference newAddress) {
        try {
            EngineObjectImpl clone = (EngineObjectImpl)super.clone();
            clone.internalMembers = new HashMap(this.internalMembers);
            if (this.pendingActions != null) {
                clone.pendingActions = new ArrayList(this.pendingActions);
            }
            clone.propertyCache = includeProperties ? (PropertiesImpl)this.propertyCache.clone() : new PropertiesImpl();
            clone.oa = newAddress != null ? (ObjectReferenceBase)newAddress : (ObjectReferenceBase)this.oa.clone();
            return clone;
        }
        catch (Throwable t) {
            throw new EngineRuntimeException(t, ExceptionCode.E_OBJECT_CLONE_FAILED, null);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(1024);
        sb.append(" Class=");
        sb.append(this.getClass().getName());
        sb.append(" AccessAllowed=");
        sb.append(this.accessAllowed);
        sb.append(" RecursionLevel=");
        sb.append(this.getRecursionLevel());
        sb.append(" UpdateSequenceNumber=");
        sb.append(this.updateSequenceNumber);
        sb.append(" ObjectAddress=(");
        sb.append(this.oa);
        sb.append(") Connection=(");
        sb.append(this.connection);
        sb.append(") SuperClasses=[");
        if (this.superClasses == null) {
            sb.append("null");
        } else if (this.superClasses.length > 0) {
            for (int i = 0; i < this.superClasses.length - 1; ++i) {
                sb.append(this.superClasses[i]);
                sb.append(",");
            }
            sb.append(this.superClasses[this.superClasses.length - 1]);
        }
        sb.append("] PendingActions=");
        sb.append(this.pendingActions);
        return sb.toString();
    }

    public final Properties getProperties() {
        return this.propertyCache;
    }

    public void setDirty(boolean val) {
        this.propertyCache.setDirty(val);
    }

    public final boolean isNew() {
        if (this.oa instanceof DependentIdentity) {
            return ((DependentIdentity)this.oa).isNew();
        }
        if (this instanceof IndependentlyPersistableObjectImpl) {
            return ((IndependentlyPersistableObjectImpl)this).getPendingAction(CreateCheckin.class) != null || ((IndependentlyPersistableObjectImpl)this).getPendingAction(Create.class) != null;
        }
        return false;
    }

    public final String getClassName() {
        return this.oa.getClassIdentity();
    }

    public final void setClassName(String className) {
        this.oa.setClassIdentity(className);
    }

    public Integer getInternalAccessAllowed() {
        return this.accessAllowed;
    }

    public final void setInternalAccessAllowed(Integer accessAllowed) {
        this.accessAllowed = accessAllowed;
    }

    public String[] getSuperClasses() {
        return this.superClasses;
    }

    public void setSuperClasses(String[] superClasses) {
        this.superClasses = superClasses;
    }

    public PropertiesImpl getModifiedProperties() {
        if (this.propertyCache == null) {
            return null;
        }
        return this.propertyCache.getModifiedData(this);
    }

    public PropertiesImpl getInternalModifiedProperties() {
        if (this.propertyCache == null) {
            return null;
        }
        return this.propertyCache.getInternalModifiedData(this);
    }

    public void setProperties(PropertiesImpl props) {
        this.propertyCache = props;
    }

    public PropertiesImpl getPropertiesImpl() {
        return this.propertyCache;
    }

    public Scope getScope() {
        return EngineObjectUtil.getScope(this.oa, this.connection);
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public ObjectStore getObjectStore() {
        Scope thisScope = this.getScope();
        if (thisScope instanceof ObjectStore) {
            return (ObjectStore)thisScope;
        }
        GlobalIdentity reference = this.oa.getObjectStoreReference();
        if (reference != null) {
            return (ObjectStore)((Object)ObjectFactory.getInstance(reference, null, this.connection));
        }
        return null;
    }

    public GlobalIdentity getObjectStoreReference() {
        return this.oa.getObjectStoreReference();
    }

    public ObjectReferenceBase getDomainScope() {
        Scope thisScope;
        if (this.domainScope == null && (thisScope = this.getScope()) instanceof Domain) {
            this.domainScope = (ObjectReferenceBase)((Domain)thisScope).getObjectReference();
        }
        return this.domainScope;
    }

    public void setDomainScope(ObjectReferenceBase domain) {
        this.domainScope = domain;
    }

    public void addPendingAction(PendingAction pa) {
        this.validateChangePreprocessingOperation("addPendingAction");
        if (this.pendingActions == null) {
            Create c;
            this.pendingActions = new ArrayList();
            if (pa instanceof Create && this instanceof IndependentlyPersistableObjectImpl && Id.isId((c = (Create)pa).getObjectId())) {
                this.setObjectId(new Id(c.getObjectId()));
            }
        }
        this.pendingActions.add(pa);
    }

    public PendingAction getPendingAction(Class pendingActionClass) {
        if (this.pendingActions == null) {
            return null;
        }
        for (int lp = 0; lp < this.pendingActions.size(); ++lp) {
            PendingAction pa = (PendingAction)this.pendingActions.get(lp);
            if (!pa.getClass().equals(pendingActionClass)) continue;
            return pa;
        }
        return null;
    }

    public void clearPendingActions() {
        this.validateChangePreprocessingOperation("clearPendingActions");
        this.pendingActions = null;
    }

    public void addPendingActions(PendingAction[] pAs) {
        if (pAs != null) {
            this.validateChangePreprocessingOperation("addPendingActions");
            for (int lp = 0; lp < pAs.length; ++lp) {
                this.addPendingAction(pAs[lp]);
            }
        }
    }

    public void setUpdateSequenceNumber(Integer updateSequenceNumber) {
        this.validateChangePreprocessingOperation("setUpdateSequenceNumber");
        this.updateSequenceNumber = updateSequenceNumber;
    }

    public Integer getUpdateSequenceNumber() {
        return this.updateSequenceNumber;
    }

    public PendingAction[] getPendingActions() {
        if (this.pendingActions == null) {
            return new PendingAction[0];
        }
        return this.pendingActions.toArray(new PendingAction[0]);
    }

    public Property getProperty(String propertyName) {
        return this.getPropertiesImpl().find(propertyName);
    }

    public Property getDirtyProperty(String propertyName) {
        Property prop = this.getProperty(propertyName);
        if (prop != null && prop.isDirty()) {
            return prop;
        }
        return null;
    }

    public Property getPropertyWithValueSet(String propertyName) {
        Property prop = this.getProperty(propertyName);
        if (prop != null && !prop.getState().equals(PropertyState.NO_VALUE)) {
            return prop;
        }
        return null;
    }

    public Property getDirtyPropertyWithValueSet(String propertyName) {
        Property prop = this.getProperty(propertyName);
        if (prop != null && !prop.getState().equals(PropertyState.NO_VALUE) && prop.isDirty()) {
            return prop;
        }
        return null;
    }

    public boolean getBooleanPropVal(String propName) {
        Property prop = this.getPropertyWithValueSet(propName);
        return prop != null && prop.getBooleanValue() != false;
    }

    public HashMap getInternalMembers() {
        return this.internalMembers;
    }

    public void setInternalMembers(HashMap internalMembersMap) {
        this.internalMembers = internalMembersMap;
    }

    public Id getObjectId() {
        if (this.objectId == null) {
            this.objectId = this.oa instanceof RepositoryIdentity ? ((RepositoryIdentity)this.oa).getObjectId() : (this.oa instanceof GlobalIdentity ? ((GlobalIdentity)this.oa).getObjectId() : (Id)this.internalMembers.get(ObjectId));
        }
        return this.objectId;
    }

    public void setObjectId(Id objId) {
        this.objectId = objId;
        if (this.oa instanceof RepositoryIdentity) {
            ((RepositoryIdentity)this.oa).setObjectId(objId);
        } else if (this.oa instanceof GlobalIdentity) {
            ((GlobalIdentity)this.oa).setObjectId(objId);
        } else {
            this.internalMembers.put(ObjectId, objId);
        }
    }

    public boolean isReservation() {
        Property prop = this.getPropertyWithValueSet("VersionStatus");
        return prop != null && prop.getInteger32Value() == 3;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeShort(5);
        s.writeObject(this.connection);
        s.writeObject(this.domainScope);
        BinaryOutputStream tos = BinaryOutputStream.getInstance((short)5, s);
        tos.putEngineObject(this);
        tos.flush();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        short version = s.readShort();
        this.connection = (Connection)s.readObject();
        this.domainScope = (ObjectReferenceBase)s.readObject();
        BinaryInputStream tis = BinaryInputStream.getInstance(version, s, this.connection);
        this.setObject(tis.getEngineObject());
    }

    public void trace(XMLTraceReader reader, String element) throws Exception {
        reader.addAttribute("superClasses", reader.stringArray(reader.emptyAsNull(this.superClasses)));
        reader.addAttribute("updateSequenceNumber", reader.stringValue(this.updateSequenceNumber));
        reader.addAttribute("accessAllowed", reader.stringValue(this.accessAllowed));
        reader.startElement(element, this);
        reader.visitObject("objectReference", this.oa);
        reader.visitObject("pendingActions", reader.emptyAsNull(this.pendingActions));
        reader.visitObject("properties", this.propertyCache);
        reader.endElement(element);
    }

    public boolean isFetchLessObject() {
        return this.fetchLessObject;
    }

    public void setFetchLessObject(boolean fetchLessObject) {
        this.fetchLessObject = fetchLessObject;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        this.propertyCache.setReadOnly(readOnly);
    }

    protected void validateChangePreprocessingOperation(String methodName) {
        if (this.isChangePreprocessing()) {
            throw new EngineRuntimeException(ExceptionCode.E_INVALID_CONTEXT, null, ExceptionContext.E_INVALID_METHOD_DURING_CHANGE_PREPROCESSING, new Object[]{methodName});
        }
    }
}

