/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.core;

import com.filenet.api.action.ApplySecurityTemplate;
import com.filenet.api.action.ChangeClass;
import com.filenet.api.action.ChangeState;
import com.filenet.api.action.Checkin;
import com.filenet.api.action.Checkout;
import com.filenet.api.action.Create;
import com.filenet.api.action.Delete;
import com.filenet.api.action.DemoteVersion;
import com.filenet.api.action.Freeze;
import com.filenet.api.action.InstallAddOn;
import com.filenet.api.action.Lock;
import com.filenet.api.action.MoveContent;
import com.filenet.api.action.PromoteVersion;
import com.filenet.api.action.RaiseEvent;
import com.filenet.api.action.TakeFederatedOwnership;
import com.filenet.api.action.Unlock;
import com.filenet.api.admin.AddOn;
import com.filenet.api.admin.Choice;
import com.filenet.api.admin.ContentValidationRequest;
import com.filenet.api.admin.PropertyDefinition;
import com.filenet.api.admin.PropertyDefinitionBinary;
import com.filenet.api.admin.PropertyDefinitionBoolean;
import com.filenet.api.admin.PropertyDefinitionDateTime;
import com.filenet.api.admin.PropertyDefinitionFloat64;
import com.filenet.api.admin.PropertyDefinitionId;
import com.filenet.api.admin.PropertyDefinitionInteger32;
import com.filenet.api.admin.PropertyDefinitionObject;
import com.filenet.api.admin.PropertyDefinitionString;
import com.filenet.api.admin.PropertyTemplateBinary;
import com.filenet.api.admin.PropertyTemplateBoolean;
import com.filenet.api.admin.PropertyTemplateDateTime;
import com.filenet.api.admin.PropertyTemplateFloat64;
import com.filenet.api.admin.PropertyTemplateId;
import com.filenet.api.admin.PropertyTemplateInteger32;
import com.filenet.api.admin.PropertyTemplateObject;
import com.filenet.api.admin.PropertyTemplateString;
import com.filenet.api.admin.StorageArea;
import com.filenet.api.collection.ContentElementList;
import com.filenet.api.collection.DependentObjectList;
import com.filenet.api.collection.RepositoryRowSet;
import com.filenet.api.constants.AutoClassify;
import com.filenet.api.constants.AutoUniqueName;
import com.filenet.api.constants.CheckinType;
import com.filenet.api.constants.ChoiceType;
import com.filenet.api.constants.DefineSecurityParentage;
import com.filenet.api.constants.LifecycleChangeFlags;
import com.filenet.api.constants.PropertyPersistence;
import com.filenet.api.constants.PropertyState;
import com.filenet.api.constants.PublicationStatus;
import com.filenet.api.constants.ReservationType;
import com.filenet.api.core.Annotation;
import com.filenet.api.core.Connection;
import com.filenet.api.core.Containable;
import com.filenet.api.core.ContentElement;
import com.filenet.api.core.ContentTransfer;
import com.filenet.api.core.CustomObject;
import com.filenet.api.core.Document;
import com.filenet.api.core.Domain;
import com.filenet.api.core.EngineObject;
import com.filenet.api.core.Factory;
import com.filenet.api.core.Folder;
import com.filenet.api.core.IndependentObject;
import com.filenet.api.core.IndependentlyPersistableObject;
import com.filenet.api.core.InstantiatingScope;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.core.ReferentialContainmentRelationship;
import com.filenet.api.core.RepositoryObject;
import com.filenet.api.core.VersionSeries;
import com.filenet.api.core.Versionable;
import com.filenet.api.events.CustomEvent;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.meta.ClassDescription;
import com.filenet.api.meta.MetadataCache;
import com.filenet.api.property.Properties;
import com.filenet.api.property.Property;
import com.filenet.api.property.PropertyContent;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.publishing.PublishRequest;
import com.filenet.api.publishing.PublishTemplate;
import com.filenet.api.query.RepositoryRow;
import com.filenet.api.query.SearchSQL;
import com.filenet.api.util.Id;
import com.filenet.apiimpl.core.AddOnImpl;
import com.filenet.apiimpl.core.ClassDefinitionImpl;
import com.filenet.apiimpl.core.ClassDescriptionImpl;
import com.filenet.apiimpl.core.ConnectionImpl;
import com.filenet.apiimpl.core.ContentTransferImpl;
import com.filenet.apiimpl.core.CustomEventImpl;
import com.filenet.apiimpl.core.DependentIdentity;
import com.filenet.apiimpl.core.DocumentImpl;
import com.filenet.apiimpl.core.DomainImpl;
import com.filenet.apiimpl.core.EngineObjectImpl;
import com.filenet.apiimpl.core.FolderImpl;
import com.filenet.apiimpl.core.GlobalIdentity;
import com.filenet.apiimpl.core.IndependentObjectImpl;
import com.filenet.apiimpl.core.IndependentlyPersistableObjectImpl;
import com.filenet.apiimpl.core.ObjectFactory;
import com.filenet.apiimpl.core.ObjectInstantiator;
import com.filenet.apiimpl.core.ObjectReferenceBase;
import com.filenet.apiimpl.core.ObjectStoreImpl;
import com.filenet.apiimpl.core.PublishRequestImpl;
import com.filenet.apiimpl.core.RepositoryIdentity;
import com.filenet.apiimpl.core.Session;
import com.filenet.apiimpl.core.StorageAreaImpl;
import com.filenet.apiimpl.exception.ExceptionContext;
import com.filenet.apiimpl.meta.Util;
import com.filenet.apiimpl.property.ClientInputStream;
import com.filenet.apiimpl.property.PropertiesImpl;
import com.filenet.apiimpl.property.PropertyContentImpl;
import com.filenet.apiimpl.property.PropertyImpl;
import com.filenet.apiimpl.query.RepositorySearch;
import com.filenet.apiimpl.util.IdGen;
import com.filenet.apiimpl.util.SessionLocator;
import java.io.InputStream;
import java.util.Date;
import java.util.Iterator;

public class DispatchEntries {
    public static final String PUBLISH_OPTIONS = "publishOptions";
    private static final String CONTENT = "Content";

    private DispatchEntries() {
    }

    public static ClassDefinitionImpl CreateSubclass_21(ClassDefinitionImpl superClass, Id id) {
        ObjectReferenceBase superOR = (ObjectReferenceBase)superClass.getObjectReference();
        ObjectReferenceBase newCDOR = null;
        newCDOR = superOR instanceof GlobalIdentity ? ObjectFactory.getGlobalReference(superOR.getClassIdentity(), id) : ObjectFactory.getRepositoryReference(superOR.getClassIdentity(), superOR.getObjectStoreReference(), id);
        Create ca = null;
        if (id != null) {
            ca = new Create(newCDOR.getClassIdentity(), id.toString(), null, null, null, null);
        }
        ClassDefinitionImpl newCD = (ClassDefinitionImpl)ObjectFactory.createInstance(newCDOR, superClass.getSuperClasses(), superClass.getConnection(), ca);
        newCD.getProperties().putObjectValue("SuperclassDefinition", superClass);
        if (!superClass.getProperties().isPropertyPresent("PropertyDefinitions")) {
            superClass.fetchProperty("PropertyDefinitions", null);
        }
        Property superPdl = superClass.getPropertiesImpl().get("PropertyDefinitions");
        Property newPdl = (Property)((PropertyImpl)superPdl).clone();
        newCD.getPropertiesImpl().put(newPdl);
        DependentObjectList pdList = newPdl.getDependentObjectListValue();
        for (EngineObject eo : pdList) {
            if (!(eo instanceof PropertyDefinitionObject)) continue;
            DispatchEntries.unprotectProperties((PropertyDefinitionObject)eo);
        }
        return newCD;
    }

    private static void unprotectProperties(PropertyDefinitionObject pdo) {
        boolean SystemOwned = false;
        if (pdo.getProperties().isPropertyPresent("IsSystemOwned") && pdo.get_IsSystemOwned().booleanValue()) {
            SystemOwned = true;
        }
        boolean Persistent = true;
        if (pdo.getProperties().isPropertyPresent("PersistenceType") && pdo.get_PersistenceType() == PropertyPersistence.NOT_PERSISTENT) {
            Persistent = false;
        }
        boolean IsThis = false;
        if (pdo.getProperties().isPropertyPresent("SymbolicName") && pdo.get_SymbolicName() != null && pdo.get_SymbolicName().equals("This")) {
            IsThis = true;
        }
        PropertyImpl piReqd = DispatchEntries.getPropertyImpl(pdo, "RequiredClassId");
        PropertyImpl piReflect = DispatchEntries.getPropertyImpl(pdo, "ReflectivePropertyId");
        PropertyImpl piDel = DispatchEntries.getPropertyImpl(pdo, "DeletionAction");
        if (!SystemOwned || Persistent && !IsThis) {
            DispatchEntries.resetPropertyAccess(piReqd);
            if (piReflect == null || piReflect.getState() != PropertyState.VALUE) {
                DispatchEntries.resetPropertyAccess(piReflect);
                DispatchEntries.resetPropertyAccess(piDel);
            }
        }
    }

    private static PropertyImpl getPropertyImpl(PropertyDefinitionObject pdo, String PropName) {
        if (pdo.getProperties().isPropertyPresent(PropName)) {
            return (PropertyImpl)pdo.getProperties().get(PropName);
        }
        return null;
    }

    private static void resetPropertyAccess(PropertyImpl pi) {
        if (pi != null) {
            pi.resetPropertyAccess((byte)7);
        }
    }

    public static ClassDefinitionImpl CreateSubclass_21(ClassDefinitionImpl superClass) {
        return DispatchEntries.CreateSubclass_21(superClass, null);
    }

    public static void RaiseEvent_139(IndependentObjectImpl iobj, CustomEvent customEvent) {
        PropertiesImpl properties = new PropertiesImpl();
        Iterator iter = customEvent.getProperties().iterator();
        while (iter.hasNext()) {
            properties.put((Property)iter.next());
        }
        properties.putValue("Id", ((CustomEventImpl)customEvent).getObjectId());
        RaiseEvent re = new RaiseEvent(properties, customEvent.getClassName());
        iobj.addPendingAction(re);
    }

    public static InputStream AccessContentStream_104(EngineObject thisObj) throws EngineRuntimeException {
        InputStream iStream = null;
        if (thisObj instanceof ContentTransfer) {
            ContentTransferImpl ct = (ContentTransferImpl)thisObj;
            DependentIdentity ident = (DependentIdentity)ct.getObjectReference();
            iStream = DispatchEntries.accessContentStream(ct, (ObjectReferenceBase)ident.getParentReference(), ident.getIndex());
        }
        return iStream;
    }

    private static InputStream accessContentStream(ContentTransferImpl thisObj, ObjectReferenceBase parentRef, Integer elementIndex) {
        InputStream iStream = null;
        boolean hasContentProperty = false;
        thisObj.validateChangePreprocessingOperation("accessContentStream");
        PropertyImpl content = (PropertyImpl)thisObj.getPropertiesImpl().find(CONTENT);
        if (content != null) {
            hasContentProperty = true;
            Object cv = content.getInstanceValue();
            if (cv instanceof ClientInputStream) {
                ClientInputStream cistream = (ClientInputStream)cv;
                if (!cistream.isInUse()) {
                    iStream = cistream;
                    cistream.setInUse();
                }
            } else if (cv instanceof InputStream) {
                iStream = (InputStream)cv;
            }
        }
        if (iStream == null) {
            Session session = SessionLocator.getSession(thisObj.getConnection());
            Long contentSize = null;
            PropertyImpl contentSizeProp = (PropertyImpl)thisObj.getPropertiesImpl().find("ContentSize");
            if (contentSizeProp != null && contentSizeProp.getFloat64Value() != null) {
                contentSize = contentSizeProp.getFloat64Value().longValue();
            }
            ClientInputStream ciStream = session.getContentStream((ConnectionImpl)thisObj.getConnection(), null, parentRef, null, elementIndex, null, contentSize, null);
            ciStream.setInUse();
            if (!hasContentProperty) {
                PropertyContentImpl prop = new PropertyContentImpl(CONTENT, ciStream, 1);
                thisObj.getPropertiesImpl().put(prop);
                prop.setDirty(false);
            }
            iStream = ciStream;
        }
        return iStream;
    }

    public static InputStream AccessContentStream_105(EngineObject thisObj, int element) throws EngineRuntimeException {
        ContentElementList contentElements = null;
        if (thisObj instanceof Document) {
            contentElements = ((Document)thisObj).get_ContentElements();
        } else if (thisObj instanceof Annotation) {
            contentElements = ((Annotation)thisObj).get_ContentElements();
        }
        int size = 0;
        if (contentElements == null || (size = contentElements.size()) < 1) {
            throw new EngineRuntimeException(ExceptionCode.E_BAD_INDEX, null, ExceptionContext.API_NO_CONTENT_ELEMENTS, null);
        }
        if (element < 0 || element > size - 1) {
            throw new EngineRuntimeException(ExceptionCode.API_INDEX_OUT_OF_BOUNDS, null);
        }
        ContentElement contentElement = (ContentElement)contentElements.get(element);
        if (contentElement instanceof ContentTransfer) {
            ObjectReferenceBase objRef = (ObjectReferenceBase)((IndependentObject)thisObj).getObjectReference();
            return DispatchEntries.accessContentStream((ContentTransferImpl)contentElement, objRef, new Integer(element));
        }
        throw new EngineRuntimeException(ExceptionCode.API_NOT_A_CONTENT_TRANSFER, new Integer(element));
    }

    public static Integer GetAccessAllowed_154(EngineObjectImpl thisObj) throws EngineRuntimeException {
        return thisObj.getInternalAccessAllowed();
    }

    public static void ApplySecurityTemplate_135(IndependentlyPersistableObjectImpl thisObj, Id applyStateId) {
        if (applyStateId == null || applyStateId.toString().length() == 0) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "applyStateId");
        }
        ApplySecurityTemplate pa = new ApplySecurityTemplate(applyStateId);
        thisObj.addPendingAction(pa);
    }

    public static Versionable CancelCheckout_73(IndependentlyPersistableObject thisObj) {
        Property reservationProp;
        DispatchEntries.fetchRequiredProperties(thisObj, new String[]{"IsReserved", "Reservation"});
        boolean hasReservation = false;
        if (thisObj.getProperties().isPropertyPresent("Reservation") && !(reservationProp = thisObj.getProperties().get("Reservation")).getState().equals(PropertyState.NO_VALUE)) {
            hasReservation = true;
        }
        if (!hasReservation) {
            throw new EngineRuntimeException(ExceptionCode.API_NOT_A_RESERVATION, null);
        }
        IndependentObjectImpl resObj = null;
        if (thisObj instanceof DocumentImpl) {
            DocumentImpl doc = (DocumentImpl)thisObj;
            resObj = (IndependentObjectImpl)doc.get_Reservation();
        } else if (thisObj instanceof VersionSeries) {
            VersionSeries vs = (VersionSeries)thisObj;
            resObj = (IndependentObjectImpl)vs.get_Reservation();
        } else {
            throw new EngineRuntimeException(ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
        Boolean isReserved = resObj.getProperties().getBooleanValue("IsReserved");
        if (isReserved != null && isReserved.booleanValue()) {
            throw new EngineRuntimeException(ExceptionCode.E_NOT_SUPPORTED, null, ExceptionContext.API_DISALLOW_INITIAL_VER_TO_CANCEL_CHECKOUT, null);
        }
        resObj.addPendingAction(new Delete());
        return (Versionable)((Object)resObj);
    }

    public static void ChangeClass_15(IndependentlyPersistableObjectImpl thisObj, String className) {
        if (className == null || className.length() == 0) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "className");
        }
        ChangeClass pa = new ChangeClass(className);
        thisObj.addPendingAction(pa);
    }

    public static void ChangeState_77(IndependentlyPersistableObjectImpl thisObj, LifecycleChangeFlags flags) {
        ChangeState pa = new ChangeState(flags);
        thisObj.addPendingAction(pa);
    }

    public static void Checkin_106(IndependentlyPersistableObjectImpl thisObj, AutoClassify autoClassify, CheckinType checkinType) throws EngineRuntimeException {
        Checkin pa = new Checkin(autoClassify != null ? autoClassify.getBooleanValue() : null, checkinType != null ? checkinType.getBooleanValue() : null);
        thisObj.addPendingAction(pa);
    }

    public static void Checkout_16(IndependentlyPersistableObjectImpl thisObj, ReservationType type, Id reservationId, String reservationClass, Properties reservationProperties) {
        Checkout pa = new Checkout(reservationId != null ? reservationId.toString() : null, type, reservationClass, reservationProperties);
        thisObj.addPendingAction(pa);
    }

    public static Annotation CreateAnnotation_80(IndependentlyPersistableObjectImpl thisObj, int annotatedContentElement, String className) {
        ObjectStore os = thisObj.getObjectStore();
        if (className == null || className.length() == 0) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "className");
        }
        Annotation newAnno = Factory.Annotation.createInstance(os, className);
        newAnno.set_AnnotatedObject(thisObj);
        newAnno.set_AnnotatedContentElement(new Integer(annotatedContentElement));
        return newAnno;
    }

    private static PropertyDefinition createPropertyDefinition(String propDefName) {
        return (PropertyDefinition)((Object)ObjectFactory.getInstance(new DependentIdentity(propDefName), null, null));
    }

    public static PropertyDefinition CreateClassProperty_22(EngineObject thisObj) throws EngineRuntimeException {
        ObjectStore os = ((RepositoryObject)((Object)thisObj)).getObjectStore();
        if (thisObj instanceof PropertyTemplateBinary) {
            PropertyTemplateBinary pt = (PropertyTemplateBinary)thisObj;
            PropertyDefinitionBinary pd = (PropertyDefinitionBinary)DispatchEntries.createPropertyDefinition("PropertyDefinitionBinary");
            pd.getProperties().putValue("PropertyTemplate", pt);
            return pd;
        }
        if (thisObj instanceof PropertyTemplateBoolean) {
            PropertyTemplateBoolean pt = (PropertyTemplateBoolean)thisObj;
            PropertyDefinitionBoolean pd = (PropertyDefinitionBoolean)DispatchEntries.createPropertyDefinition("PropertyDefinitionBoolean");
            pd.getProperties().putValue("PropertyTemplate", pt);
            return pd;
        }
        if (thisObj instanceof PropertyTemplateDateTime) {
            PropertyTemplateDateTime pt = (PropertyTemplateDateTime)thisObj;
            PropertyDefinitionDateTime pd = (PropertyDefinitionDateTime)DispatchEntries.createPropertyDefinition("PropertyDefinitionDateTime");
            pd.getProperties().putValue("PropertyTemplate", pt);
            return pd;
        }
        if (thisObj instanceof PropertyTemplateFloat64) {
            PropertyTemplateFloat64 pt = (PropertyTemplateFloat64)thisObj;
            PropertyDefinitionFloat64 pd = (PropertyDefinitionFloat64)DispatchEntries.createPropertyDefinition("PropertyDefinitionFloat64");
            pd.getProperties().putValue("PropertyTemplate", pt);
            return pd;
        }
        if (thisObj instanceof PropertyTemplateId) {
            PropertyTemplateId pt = (PropertyTemplateId)thisObj;
            PropertyDefinitionId pd = (PropertyDefinitionId)DispatchEntries.createPropertyDefinition("PropertyDefinitionId");
            pd.getProperties().putValue("PropertyTemplate", pt);
            return pd;
        }
        if (thisObj instanceof PropertyTemplateInteger32) {
            PropertyTemplateInteger32 pt = (PropertyTemplateInteger32)thisObj;
            PropertyDefinitionInteger32 pd = (PropertyDefinitionInteger32)DispatchEntries.createPropertyDefinition("PropertyDefinitionInteger32");
            pd.getProperties().putValue("PropertyTemplate", pt);
            return pd;
        }
        if (thisObj instanceof PropertyTemplateObject) {
            PropertyTemplateObject pt = (PropertyTemplateObject)thisObj;
            PropertyDefinitionObject pd = (PropertyDefinitionObject)DispatchEntries.createPropertyDefinition("PropertyDefinitionObject");
            pd.getProperties().putValue("PropertyTemplate", pt);
            return pd;
        }
        if (thisObj instanceof PropertyTemplateString) {
            PropertyTemplateString pt = (PropertyTemplateString)thisObj;
            PropertyDefinitionString pd = (PropertyDefinitionString)DispatchEntries.createPropertyDefinition("PropertyDefinitionString");
            pd.getProperties().putValue("PropertyTemplate", pt);
            return pd;
        }
        throw new EngineRuntimeException(ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
    }

    public static Folder CreateSubFolder_65(EngineObjectImpl thisObj, String name) throws EngineRuntimeException {
        if (name == null || name.length() < 1 || !DispatchEntries.isValidPathCharacters(name)) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "name");
        }
        Folder folder = (Folder)((Object)thisObj);
        ObjectStore os = thisObj.getObjectStore();
        Folder subFolder = Factory.Folder.createInstance(os, null);
        subFolder.set_FolderName(name);
        subFolder.set_Parent(folder);
        return subFolder;
    }

    public static void DemoteVersion_134(IndependentlyPersistableObjectImpl thisObj) {
        DemoteVersion pa = new DemoteVersion();
        thisObj.addPendingAction(pa);
    }

    public static Boolean DescribedIsOfClass_29(EngineObject thisObj, String className) throws EngineRuntimeException {
        String[] requiredProperties;
        if (className == null || className.length() == 0) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "className");
        }
        ClassDescription cd = (ClassDescription)thisObj;
        if (cd.getScope() != null) {
            boolean cmcEnabled = false;
            try {
                cmcEnabled = Util.INSTANCE.isCacheEnabled(cd);
            }
            catch (Throwable t) {
                cmcEnabled = false;
            }
            if (cmcEnabled) {
                MetadataCache cache = Factory.MetadataCache.getDefaultInstance();
                return cache.describedIsOfClass(cd, className);
            }
        }
        String compareString = null;
        if (Id.isId(className)) {
            compareString = ((ClassDescriptionImpl)cd).getObjectId().toString();
            requiredProperties = new String[]{"SuperclassDescription"};
        } else {
            requiredProperties = new String[]{"SuperclassDescription", "SymbolicName"};
        }
        DispatchEntries.fetchRequiredProperties(cd, requiredProperties);
        if (compareString == null) {
            compareString = cd.get_SymbolicName();
        }
        while (compareString != null && compareString.length() > 0) {
            if (compareString.compareToIgnoreCase(className) == 0) {
                return Boolean.TRUE;
            }
            try {
                try {
                    cd = (ClassDescription)cd.getProperties().getEngineObjectValue("SuperclassDescription");
                }
                catch (Throwable t) {
                    try {
                        cd = cd.get_SuperclassDescription();
                    }
                    catch (Throwable e) {
                        cd = null;
                    }
                }
                if (cd == null) break;
                DispatchEntries.fetchRequiredProperties(cd, requiredProperties);
            }
            catch (EngineRuntimeException e) {
                break;
            }
            if (Id.isId(className)) {
                compareString = ((ClassDescriptionImpl)cd).getObjectId().toString();
                continue;
            }
            compareString = cd.get_SymbolicName();
        }
        return Boolean.FALSE;
    }

    public static ReferentialContainmentRelationship File_63(EngineObjectImpl thisObj, IndependentlyPersistableObject containee, AutoUniqueName autoUniqueName, String containmentName, DefineSecurityParentage defineSecurityParentage) {
        if (thisObj == null || !(thisObj instanceof Folder)) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "parentFolder");
        }
        if (containee == null || !(containee instanceof Containable)) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "containee");
        }
        if (defineSecurityParentage == null) {
            defineSecurityParentage = DefineSecurityParentage.DO_NOT_DEFINE_SECURITY_PARENTAGE;
        }
        FolderImpl parentFolder = (FolderImpl)thisObj;
        ObjectStore os = parentFolder.getObjectStore();
        ReferentialContainmentRelationship rcr = null;
        rcr = containee instanceof Versionable ? Factory.DynamicReferentialContainmentRelationship.createInstance(os, "DynamicReferentialContainmentRelationship", autoUniqueName, defineSecurityParentage) : Factory.ReferentialContainmentRelationship.createInstance(os, "ReferentialContainmentRelationship", autoUniqueName, defineSecurityParentage);
        rcr.set_Head(containee);
        rcr.set_Tail(parentFolder);
        rcr.set_ContainmentName(containmentName);
        return rcr;
    }

    public static void Freeze_18(IndependentlyPersistableObjectImpl thisObj) {
        Freeze pa = new Freeze();
        thisObj.addPendingAction(pa);
    }

    public static IndependentObject createObject(InstantiatingScope scope, String classIdentity, Id objectId) {
        IndependentObject object = scope.getObject(classIdentity, objectId);
        if (object instanceof IndependentlyPersistableObjectImpl) {
            IndependentlyPersistableObjectImpl.addCreatePendingAction((IndependentlyPersistableObjectImpl)object, objectId, null, null, null, null);
        }
        return object;
    }

    public static IndependentObject getObject(DomainImpl domain, String classIdentity, String objectIdentity) {
        classIdentity = DispatchEntries.validateClassIdentity(DispatchEntries.initIdentity(classIdentity));
        objectIdentity = DispatchEntries.initIdentity(objectIdentity);
        return DispatchEntries.getObject(ObjectInstantiator.DOMAIN_NAME, domain, classIdentity, objectIdentity);
    }

    public static IndependentObject getObject(DomainImpl domain, String classIdentity, Id objectId) {
        classIdentity = DispatchEntries.validateClassIdentity(DispatchEntries.initIdentity(classIdentity));
        return DispatchEntries.getObject(ObjectInstantiator.DOMAIN_ID, domain, classIdentity, objectId);
    }

    public static IndependentObject fetchObject(DomainImpl domain, String classIdentity, String objectIdentity, PropertyFilter filter) {
        classIdentity = DispatchEntries.validateClassIdentity(DispatchEntries.initIdentity(classIdentity));
        GlobalIdentity objectReference = ObjectFactory.getGlobalReference(classIdentity, objectIdentity);
        ConnectionImpl connection = (ConnectionImpl)domain.getConnection();
        Session session = SessionLocator.getSession(connection);
        return (IndependentObject)((Object)session.getObject(connection, objectReference, filter, null));
    }

    public static IndependentObject fetchObject(Connection connection, String classIdentity, String objectIdentity, PropertyFilter filter) {
        classIdentity = DispatchEntries.validateClassIdentity(DispatchEntries.initIdentity(classIdentity));
        GlobalIdentity objectReference = ObjectFactory.getGlobalReference(classIdentity, objectIdentity);
        Session session = SessionLocator.getSession(connection);
        return (IndependentObject)((Object)session.getObject((ConnectionImpl)connection, objectReference, filter, null));
    }

    public static IndependentObject fetchObject(DomainImpl domain, String classIdentity, Id objectId, PropertyFilter filter) {
        classIdentity = DispatchEntries.validateClassIdentity(DispatchEntries.initIdentity(classIdentity));
        DispatchEntries.validateObjectId(objectId);
        GlobalIdentity objectReference = ObjectFactory.getGlobalReference(classIdentity, objectId);
        ConnectionImpl connection = (ConnectionImpl)domain.getConnection();
        Session session = SessionLocator.getSession(connection);
        return (IndependentObject)((Object)session.getObject(connection, objectReference, filter, null));
    }

    public static IndependentObject getObject(ObjectStoreImpl objectStore, String classIdentity, String objectIdentity) {
        classIdentity = DispatchEntries.validateClassIdentity(DispatchEntries.initIdentity(classIdentity));
        objectIdentity = DispatchEntries.initIdentity(objectIdentity);
        return DispatchEntries.getObject(ObjectInstantiator.OBJECT_STORE_NAME, objectStore, classIdentity, objectIdentity);
    }

    public static IndependentObject getObject(ObjectStoreImpl objectStore, String classIdentity, Id objectId) {
        classIdentity = DispatchEntries.validateClassIdentity(DispatchEntries.initIdentity(classIdentity));
        return DispatchEntries.getObject(ObjectInstantiator.OBJECT_STORE_ID, objectStore, classIdentity, objectId);
    }

    private static IndependentObject getObject(ObjectInstantiator instantiator, InstantiatingScope scope, String classIdentity, Object objectIdentity) {
        boolean classId = false;
        Object filter = null;
        EngineRuntimeException exception = null;
        String[] superClassIdentities = null;
        Object originalDescription = null;
        Object description = null;
        Object superDescription = null;
        while (true) {
            try {
                return (IndependentObject)((Object)instantiator.getInstance(null, scope, classIdentity, superClassIdentities, objectIdentity));
            }
            catch (EngineRuntimeException e) {
                if (!ExceptionCode.API_UNSUPPORTED_API_CLASS.equals(e.getExceptionCode())) {
                    throw e;
                }
                if (exception == null) {
                    exception = e;
                }
                superClassIdentities = ObjectFactory.getSuperClassesFromCMC(scope, classIdentity);
                continue;
            }
            break;
        }
    }

    public static IndependentObject FetchObject_28(ObjectStoreImpl objectStore, String classIdentity, String objectIdentity, PropertyFilter filter) {
        classIdentity = DispatchEntries.validateClassIdentity(DispatchEntries.initIdentity(classIdentity));
        objectIdentity = DispatchEntries.validateObjectIdentity(DispatchEntries.initIdentity(objectIdentity));
        GlobalIdentity storeReference = (GlobalIdentity)objectStore.getObjectReference();
        ObjectReferenceBase objectReference = ObjectFactory.getRepositoryReference(classIdentity, storeReference, objectIdentity);
        ConnectionImpl connection = (ConnectionImpl)objectStore.getConnection();
        Session session = SessionLocator.getSession(connection);
        return (IndependentObject)((Object)session.getObject(connection, objectReference, filter, null));
    }

    public static IndependentObject fetchObject(ObjectStoreImpl objectStore, String classIdentity, Id objectId, PropertyFilter filter) {
        classIdentity = DispatchEntries.validateClassIdentity(DispatchEntries.initIdentity(classIdentity));
        DispatchEntries.validateObjectId(objectId);
        GlobalIdentity storeReference = (GlobalIdentity)objectStore.getObjectReference();
        RepositoryIdentity objectReference = ObjectFactory.getRepositoryReference(classIdentity, storeReference, objectId);
        ConnectionImpl connection = (ConnectionImpl)objectStore.getConnection();
        Session session = SessionLocator.getSession(connection);
        return (IndependentObject)((Object)session.getObject(connection, objectReference, filter, null));
    }

    public static IndependentObject FetchAndLockObject_123(ObjectStoreImpl objectStore, String classIdentity, String objectIdentity, long timeout, String lockOwner, PropertyFilter filter) {
        IndependentObject object = DispatchEntries.FetchObject_28(objectStore, classIdentity, objectIdentity, filter);
        object = DispatchEntries.lockObject(object, timeout, lockOwner);
        return object;
    }

    public static IndependentObject fetchAndLockObject(ObjectStoreImpl objectStore, String classIdentity, Id objectId, long timeout, String lockOwner, PropertyFilter filter) {
        IndependentObject object = DispatchEntries.fetchObject(objectStore, classIdentity, objectId, filter);
        object = DispatchEntries.lockObject(object, timeout, lockOwner);
        return object;
    }

    private static IndependentlyPersistableObjectImpl lockObject(IndependentObject object, long timeout, String lockOwner) {
        if (!(object instanceof Document || object instanceof Folder || object instanceof CustomObject)) {
            throw new EngineRuntimeException(ExceptionCode.E_OBJECT_NOT_LOCKABLE, null);
        }
        IndependentlyPersistableObjectImpl lockable = (IndependentlyPersistableObjectImpl)object;
        DispatchEntries.Lock_119(lockable, timeout, lockOwner);
        return lockable;
    }

    private static String initIdentity(String identity) {
        if (identity != null && (identity = identity.trim()).length() == 0) {
            identity = null;
        }
        return identity;
    }

    private static String validateClassIdentity(String classIdentity) {
        if (classIdentity == null || classIdentity.length() == 0) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "classIdentity");
        }
        return classIdentity;
    }

    private static String validateObjectIdentity(String objectIdentity) {
        if (objectIdentity == null || objectIdentity.length() == 0) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "objectIdentity");
        }
        return objectIdentity;
    }

    private static Id initId(Id id) {
        return id == null ? IdGen.createId() : id;
    }

    private static void validateObjectId(Id objectId) {
        if (objectId == null) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "objectId");
        }
    }

    public static Boolean IsCurrent_34(EngineObject thisObj) {
        if (thisObj.getProperties().isDirty()) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static Boolean IsLocked_122(EngineObject thisObj) {
        DispatchEntries.fetchRequiredProperties((IndependentObject)thisObj, new String[]{"LockToken", "LockTimeout", "DateLastModified"});
        Id token = thisObj.getProperties().getIdValue("LockToken");
        Integer timeoutSeconds = thisObj.getProperties().getInteger32Value("LockTimeout");
        if (token == null || timeoutSeconds == null) {
            return Boolean.FALSE;
        }
        Date lastModifiedDate = thisObj.getProperties().getDateTimeValue("DateLastModified");
        long lastModSecs = lastModifiedDate.getTime() / 1000L;
        long currentTimeSecs = System.currentTimeMillis() / 1000L;
        if (currentTimeSecs - lastModSecs <= (long)timeoutSeconds.intValue()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static void Lock_119(IndependentlyPersistableObjectImpl thisObj, long timeout, String owner) {
        Lock pa = new Lock(new Long(timeout), owner);
        thisObj.addPendingAction(pa);
    }

    public static void Move_68(Folder thisObj, Folder targetFolder) throws EngineRuntimeException {
        if (targetFolder == null) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "targetFolder");
        }
        thisObj.set_Parent(targetFolder);
    }

    public static void MoveContent_116(IndependentlyPersistableObjectImpl thisObj, StorageArea storageArea) throws EngineRuntimeException {
        MoveContent pa = new MoveContent(storageArea.get_Id().toString(), Boolean.FALSE);
        thisObj.addPendingAction(pa);
    }

    public static void PromoteVersion_133(IndependentlyPersistableObjectImpl thisObj) {
        PromoteVersion pa = new PromoteVersion();
        thisObj.addPendingAction(pa);
    }

    public static void SetCaptureSource_101(EngineObject thisObj, InputStream source) throws EngineRuntimeException {
        if (source == null) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "source");
        }
        if (thisObj instanceof ContentTransfer) {
            PropertyContent content = null;
            ((EngineObjectImpl)thisObj).validateChangePreprocessingOperation("setCaptureSource");
            if (thisObj.getProperties().isPropertyPresent(CONTENT)) {
                content = (PropertyContent)thisObj.getProperties().get(CONTENT);
                content.setValue(source);
            } else {
                thisObj.getProperties().putValue(CONTENT, source);
            }
        }
    }

    public static ReferentialContainmentRelationship Unfile_64(IndependentlyPersistableObjectImpl thisObj, IndependentlyPersistableObject ncontainee) {
        if (thisObj == null || !(thisObj instanceof Folder)) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "parentFolder");
        }
        IndependentlyPersistableObjectImpl containee = (IndependentlyPersistableObjectImpl)ncontainee;
        if (containee == null || !(containee instanceof Containable)) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "containee");
        }
        Id tailId = ((RepositoryIdentity)thisObj.getObjectReference()).getObjectId();
        Id headId = ((RepositoryIdentity)containee.getObjectReference()).getObjectId();
        RepositorySearch rs = new RepositorySearch();
        String sqlString = "SELECT Id FROM ReferentialContainmentRelationship WITH INCLUDESUBCLASSES WHERE (Head = Object(" + headId.toString() + ")) AND (Tail = Object(" + tailId.toString() + "))";
        SearchSQL sql = new SearchSQL(sqlString);
        ObjectStore os = thisObj.getObjectStore();
        RepositoryRowSet rrs = rs.fetchRows(new ObjectStore[]{os}, sql, null, new Integer(2), null, Boolean.FALSE);
        Iterator i = rrs.iterator();
        if (!i.hasNext()) {
            throw new EngineRuntimeException(ExceptionCode.API_NOT_FILED_IN_FOLDER, null);
        }
        RepositoryRow rr = (RepositoryRow)i.next();
        if (i.hasNext()) {
            throw new EngineRuntimeException(ExceptionCode.API_MULTIPLY_FILED_IN_FOLDER, null);
        }
        Id id = rr.getProperties().getIdValue("Id");
        ReferentialContainmentRelationship rcr = Factory.ReferentialContainmentRelationship.getInstance(os, "ReferentialContainmentRelationship", id);
        rcr.addPendingAction(new Delete());
        return rcr;
    }

    public static ReferentialContainmentRelationship Unfile(IndependentlyPersistableObjectImpl thisObj, String containmentName) {
        if (thisObj == null || !(thisObj instanceof Folder)) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "parentFolder");
        }
        if (containmentName == null || containmentName.length() == 0) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "containmentName");
        }
        FolderImpl parentFolder = (FolderImpl)thisObj;
        ObjectStore os = parentFolder.getObjectStore();
        if (!parentFolder.getProperties().isPropertyPresent("PathName")) {
            parentFolder.fetchProperties(new String[]{"PathName"});
        }
        RepositorySearch rs = new RepositorySearch();
        String pathName = DispatchEntries.checkSQLQuerySpecicalCharacter(parentFolder.get_PathName());
        String contName = DispatchEntries.checkSQLQuerySpecicalCharacter(containmentName);
        String sqlString = "SELECT Id, ContainmentName FROM ReferentialContainmentRelationship WITH INCLUDESUBCLASSES WHERE Tail = Object('" + pathName + "') and ContainmentName = '" + contName + "'";
        SearchSQL sql = new SearchSQL(sqlString);
        RepositoryRowSet rrs = rs.fetchRows(new ObjectStore[]{os}, sql, null, new Integer(10), null, Boolean.TRUE);
        Iterator it = rrs.iterator();
        if (!it.hasNext()) {
            throw new EngineRuntimeException(ExceptionCode.API_NOT_FILED_IN_FOLDER, null);
        }
        Id id = null;
        while (it.hasNext()) {
            RepositoryRow rr = (RepositoryRow)it.next();
            String name = rr.getProperties().getStringValue("ContainmentName");
            if (name.compareTo(containmentName) != 0) continue;
            id = rr.getProperties().getIdValue("Id");
            break;
        }
        if (id == null) {
            throw new EngineRuntimeException(ExceptionCode.API_NOT_FILED_IN_FOLDER, null);
        }
        ReferentialContainmentRelationship rcr = Factory.ReferentialContainmentRelationship.getInstance(os, "ReferentialContainmentRelationship", id);
        rcr.addPendingAction(new Delete());
        return rcr;
    }

    public static void Unlock_120(IndependentlyPersistableObjectImpl thisObj) {
        thisObj.addPendingAction(new Unlock());
    }

    public static void UpdateLock_121(IndependentlyPersistableObjectImpl thisObj, long timeout) {
        if (thisObj.isNew()) {
            throw new EngineRuntimeException(ExceptionCode.E_NOT_SUPPORTED, null);
        }
        Lock pa = new Lock(new Long(timeout), null);
        thisObj.addPendingAction(pa);
    }

    public static void setValue_39(EngineObject thisObj, Object value) throws EngineRuntimeException {
        throw new EngineRuntimeException(ExceptionCode.E_NOT_SUPPORTED, null);
    }

    public static Object getValue_39(EngineObject thisObj) throws EngineRuntimeException {
        Choice choice = (Choice)thisObj;
        ChoiceType ct = null;
        try {
            ct = choice.get_ChoiceType();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (ct == ChoiceType.INTEGER) {
            return choice.get_ChoiceIntegerValue();
        }
        if (ct == ChoiceType.STRING) {
            return choice.get_ChoiceStringValue();
        }
        if (ct == null) {
            try {
                return choice.get_ChoiceStringValue();
            }
            catch (Exception e) {
                try {
                    return choice.get_ChoiceIntegerValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static Boolean getEnableOnUpdate_146(EngineObject thisObj) throws EngineRuntimeException {
        throw new EngineRuntimeException(ExceptionCode.E_NOT_SUPPORTED, null);
    }

    public static void setEnableOnUpdate_146(EngineObject thisObj, Boolean value) throws EngineRuntimeException {
        throw new EngineRuntimeException(ExceptionCode.E_NOT_SUPPORTED, null);
    }

    public static Boolean getEnableOnClassifyComplete_151(EngineObject thisObj) throws EngineRuntimeException {
        throw new EngineRuntimeException(ExceptionCode.E_NOT_SUPPORTED, null);
    }

    public static void setEnableOnClassifyComplete_151(EngineObject thisObj, Boolean value) throws EngineRuntimeException {
        throw new EngineRuntimeException(ExceptionCode.E_NOT_SUPPORTED, null);
    }

    public static Boolean getEnableOnElementRemove_150(EngineObject thisObj) throws EngineRuntimeException {
        throw new EngineRuntimeException(ExceptionCode.E_NOT_SUPPORTED, null);
    }

    public static void setEnableOnElementRemove_150(EngineObject thisObj, Boolean value) throws EngineRuntimeException {
        throw new EngineRuntimeException(ExceptionCode.E_NOT_SUPPORTED, null);
    }

    public static Boolean getEnableOnDelete_145(EngineObject thisObj) throws EngineRuntimeException {
        throw new EngineRuntimeException(ExceptionCode.E_NOT_SUPPORTED, null);
    }

    public static void setEnableOnDelete_145(EngineObject thisObj, Boolean value) throws EngineRuntimeException {
        throw new EngineRuntimeException(ExceptionCode.E_NOT_SUPPORTED, null);
    }

    public static Boolean getEnableOnCreate_144(EngineObject thisObj) throws EngineRuntimeException {
        throw new EngineRuntimeException(ExceptionCode.E_NOT_SUPPORTED, null);
    }

    public static void setEnableOnCreate_144(EngineObject thisObj, Boolean value) throws EngineRuntimeException {
        throw new EngineRuntimeException(ExceptionCode.E_NOT_SUPPORTED, null);
    }

    public static Boolean getEnableOnAdd_149(EngineObject thisObj) throws EngineRuntimeException {
        throw new EngineRuntimeException(ExceptionCode.E_NOT_SUPPORTED, null);
    }

    public static void setEnableOnAdd_149(EngineObject thisObj, Boolean value) throws EngineRuntimeException {
        throw new EngineRuntimeException(ExceptionCode.E_NOT_SUPPORTED, null);
    }

    public static Boolean getEnableOnCheckOut_148(EngineObject thisObj) throws EngineRuntimeException {
        throw new EngineRuntimeException(ExceptionCode.E_NOT_SUPPORTED, null);
    }

    public static void setEnableOnCheckOut_148(EngineObject thisObj, Boolean value) throws EngineRuntimeException {
        throw new EngineRuntimeException(ExceptionCode.E_NOT_SUPPORTED, null);
    }

    public static Boolean getEnableOnElementAdd_149(EngineObject thisObj) throws EngineRuntimeException {
        throw new EngineRuntimeException(ExceptionCode.E_NOT_SUPPORTED, null);
    }

    public static void setEnableOnElementAdd_149(EngineObject thisObj, Boolean value) throws EngineRuntimeException {
        throw new EngineRuntimeException(ExceptionCode.E_NOT_SUPPORTED, null);
    }

    public static Boolean getEnableOnCheckIn_147(EngineObject thisObj) throws EngineRuntimeException {
        throw new EngineRuntimeException(ExceptionCode.E_NOT_SUPPORTED, null);
    }

    public static void setEnableOnCheckIn_147(EngineObject thisObj, Boolean value) throws EngineRuntimeException {
        throw new EngineRuntimeException(ExceptionCode.E_NOT_SUPPORTED, null);
    }

    public static void setEnableOnPromoteVersion_152(EngineObject thisObj, Boolean value) throws EngineRuntimeException {
        throw new EngineRuntimeException(ExceptionCode.E_NOT_SUPPORTED, null);
    }

    public static Boolean getEnableOnPromoteVersion_152(EngineObject thisObj) throws EngineRuntimeException {
        throw new EngineRuntimeException(ExceptionCode.E_NOT_SUPPORTED, null);
    }

    public static void setEnableOnDemoteVersion_153(EngineObject thisObj, Boolean value) throws EngineRuntimeException {
        throw new EngineRuntimeException(ExceptionCode.E_NOT_SUPPORTED, null);
    }

    public static Boolean getEnableOnDemoteVersion_153(EngineObject thisObj) throws EngineRuntimeException {
        throw new EngineRuntimeException(ExceptionCode.E_NOT_SUPPORTED, null);
    }

    public static void SetPublishOptions_159(EngineObject thisObj, String publishOptions) throws EngineRuntimeException {
        if (thisObj == null || !(thisObj instanceof PublishRequest)) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "publish request");
        }
        ((PublishRequestImpl)thisObj).set_ApplyDefinition(publishOptions);
    }

    public static PublishRequest Publish_160(EngineObject thisObj, PublishTemplate publishTemplate, String publishOptions) throws EngineRuntimeException {
        if (thisObj == null || !(thisObj instanceof Document)) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "source document");
        }
        if (publishTemplate == null) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "publishTemplate");
        }
        ObjectStore os = ((RepositoryObject)((Object)thisObj)).getObjectStore();
        PublishRequest pr = Factory.PublishRequest.createInstance(os);
        pr.set_InputDocument((Document)thisObj);
        pr.set_PublishTemplate(publishTemplate);
        pr.setPublishOptions(publishOptions);
        return pr;
    }

    public static PublishRequest Republish_161(EngineObject thisObj, Document publication, String publishOptions) throws EngineRuntimeException {
        if (thisObj == null || !(thisObj instanceof Document)) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "source document");
        }
        if (publication == null) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "publication");
        }
        ObjectStore os = ((RepositoryObject)((Object)thisObj)).getObjectStore();
        PublishRequest pr = Factory.PublishRequest.createInstance(os);
        pr.set_InputDocument((Document)thisObj);
        pr.set_PublicationDocument(publication);
        pr.setPublishOptions(publishOptions);
        return pr;
    }

    public static PublicationStatus GetPublicationStatus_162(EngineObject thisObj) throws EngineRuntimeException {
        if (thisObj == null || !(thisObj instanceof Document)) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "document");
        }
        ((DocumentImpl)thisObj).fetchProperties(new String[]{"Id", "OwnerDocument", "PublicationInfo"});
        Document ownerSource = ((DocumentImpl)thisObj).get_OwnerDocument();
        byte[] publicationInfo = ((DocumentImpl)thisObj).get_PublicationInfo();
        if (publicationInfo != null && publicationInfo.length > 0) {
            if (ownerSource != null) {
                return PublicationStatus.DOCUMENT_IS_DEPENDENT_PUBLICATION;
            }
            return PublicationStatus.DOCUMENT_IS_INDEPENDENT_PUBLICATION;
        }
        return PublicationStatus.DOCUMENT_IS_NOT_PUBLICATION;
    }

    public static void InstallAddOn_141(ObjectStoreImpl osi, AddOn addOn) {
        ObjectReferenceBase orb = (ObjectReferenceBase)addOn.getObjectReference();
        String addOnId = orb.getObjectIdentity();
        InstallAddOn iao = new InstallAddOn(addOnId);
        osi.addPendingAction(iao);
    }

    public static InputStream AccessImportDataStream_172(EngineObject thisObj) throws EngineRuntimeException {
        return DispatchEntries.accessAddOnStream(thisObj, "ImportData");
    }

    public static InputStream AccessPreImportScriptStream_164(EngineObject thisObj) throws EngineRuntimeException {
        return DispatchEntries.accessAddOnStream(thisObj, "PreImportScript");
    }

    public static InputStream AccessPostImportScriptStream_165(EngineObject thisObj) throws EngineRuntimeException {
        return DispatchEntries.accessAddOnStream(thisObj, "PostImportScript");
    }

    private static InputStream accessAddOnStream(EngineObject thisObj, String propertyName) {
        InputStream iStream = null;
        if (thisObj instanceof AddOn) {
            AddOnImpl aoi = (AddOnImpl)thisObj;
            if (!thisObj.getProperties().isPropertyPresent(propertyName)) {
                aoi.fetchProperties(new String[]{propertyName});
            }
            if (thisObj.getProperties().isPropertyPresent(propertyName)) {
                PropertyContent content = (PropertyContent)thisObj.getProperties().get(propertyName);
                InputStream aStream = content.getInputStreamValue();
                if (aStream instanceof ClientInputStream) {
                    ClientInputStream cistream = (ClientInputStream)aStream;
                    if (!cistream.isInUse()) {
                        iStream = cistream;
                        cistream.setInUse();
                    } else if (aoi.getScope() instanceof Domain) {
                        PropertyFilter pf = new PropertyFilter();
                        pf.addIncludeProperty(0, null, null, propertyName, null);
                        Domain domain = (Domain)aoi.getScope();
                        AddOn aoi2 = Factory.AddOn.fetchInstance(domain, aoi.get_Id(), pf);
                        content = (PropertyContent)aoi2.getProperties().get(propertyName);
                        aStream = content.getInputStreamValue();
                        if (aStream instanceof ClientInputStream) {
                            cistream = (ClientInputStream)aStream;
                            iStream = cistream;
                            cistream.setInUse();
                        } else {
                            iStream = aStream;
                        }
                    }
                } else {
                    iStream = aStream;
                }
            }
        }
        return iStream;
    }

    public static void SetImportDataStream_171(EngineObject thisObj, InputStream importData) throws EngineRuntimeException {
        DispatchEntries.setAddOnStream(thisObj, importData, "ImportData");
    }

    public static void SetPreImportScriptStream_167(EngineObject thisObj, InputStream preImportScript) throws EngineRuntimeException {
        DispatchEntries.setAddOnStream(thisObj, preImportScript, "PreImportScript");
    }

    public static void SetPostImportScriptStream_168(EngineObject thisObj, InputStream postImportScript) throws EngineRuntimeException {
        DispatchEntries.setAddOnStream(thisObj, postImportScript, "PostImportScript");
    }

    private static void setAddOnStream(EngineObject thisObj, InputStream stream, String propertyName) {
        if (thisObj instanceof AddOn) {
            PropertyContent content = null;
            if (thisObj.getProperties().isPropertyPresent(propertyName)) {
                content = (PropertyContent)thisObj.getProperties().get(propertyName);
                content.setValue(stream);
            } else {
                thisObj.getProperties().putValue(propertyName, stream);
            }
        }
    }

    public static void TakeFederatedOwnership_169(IndependentlyPersistableObjectImpl thisObj) {
        TakeFederatedOwnership pa = new TakeFederatedOwnership();
        thisObj.addPendingAction(pa);
    }

    public static void ValidateContent_170(StorageAreaImpl thisObj, IndependentlyPersistableObject contentObject, int contentElementIndex) {
        ContentValidationRequest[] validationRequests = new ContentValidationRequest[]{new ContentValidationRequest(contentObject, contentElementIndex)};
        EngineRuntimeException[] ex = thisObj.validateContent(validationRequests);
        if (ex != null && ex[0] != null) {
            throw ex[0];
        }
    }

    private static void fetchRequiredProperties(IndependentObject obj, String[] requiredProps) {
        int i;
        String[] fetchProps = new String[requiredProps.length];
        int count = 0;
        for (i = 0; i < requiredProps.length; ++i) {
            if (obj.getProperties().isPropertyPresent(requiredProps[i])) continue;
            fetchProps[count++] = requiredProps[i];
        }
        if (count == 0) {
            return;
        }
        obj.fetchProperties(fetchProps);
        for (i = 0; i < count; ++i) {
            if (obj.getProperties().isPropertyPresent(fetchProps[i])) continue;
            throw new EngineRuntimeException(ExceptionCode.API_PROPERTY_NOT_IN_CACHE, fetchProps[i]);
        }
    }

    private static String checkSQLQuerySpecicalCharacter(String value) {
        value = value.replaceAll("'", "''");
        return value;
    }

    private static boolean isValidPathCharacters(String name) {
        int size = name.length();
        for (int i = 0; i < size; ++i) {
            char x = name.charAt(i);
            if (x != '/' && x != '\\' && x != ':' && x != '*' && x != '?' && x != '\"' && x != '<' && x != '>' && x != '|') continue;
            return false;
        }
        return true;
    }
}

