/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.core;

import com.filenet.api.constants.ConfigurationParameter;
import com.filenet.api.constants.ConnectionType;
import com.filenet.api.core.Connection;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.util.ConfigurationParameters;
import com.filenet.apiimpl.exception.ExceptionContext;
import com.filenet.apiimpl.util.ConfigValueLookup;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.net.URI;
import java.net.URISyntaxException;

public class ConnectionImpl
implements Connection {
    private String uri;
    private transient URI asURI;
    private ConfigurationParameters parameters;
    private Connection realConnection = null;
    private static boolean saveLastERE = false;
    private static ThreadLocal<EngineRuntimeException> lastERE = new ThreadLocal();
    private static final long serialVersionUID = -689050182764384929L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];

    public ConnectionImpl() {
        this.init();
    }

    public ConnectionImpl(String URI2) {
        this.uri = URI2;
        this.init();
    }

    public ConnectionImpl(String URI2, ConfigurationParameters parameters) {
        if (parameters != null) {
            parameters = new ConfigurationParameters(parameters);
        }
        this.uri = URI2;
        this.parameters = parameters;
        this.init();
    }

    public void setURI(String URI2) {
        this.uri = URI2;
        this.asURI = null;
        this.init();
    }

    private void init() {
        try {
            if (this.uri != null && this.asURI == null) {
                this.asURI = new URI(this.uri);
            } else if (this.asURI != null && this.uri == null) {
                this.uri = this.asURI.toString();
            }
        }
        catch (URISyntaxException e) {
            throw new EngineRuntimeException(e, ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, new Object[]{"overRideURI"});
        }
        if (this.parameters == null) {
            this.parameters = new ConfigurationParameters();
        } else {
            this.validateParameters(this.parameters);
        }
    }

    public synchronized Object getParameter(ConfigurationParameter parameter) {
        return this.parameters.getParameter(parameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object setParameter(ConfigurationParameter parameter, Object value) {
        Object previous = this.parameters.getParameter(parameter);
        boolean failed = true;
        try {
            this.parameters.setParameter(parameter, value);
            this.validateParameters(this.parameters);
            failed = false;
        }
        finally {
            if (failed) {
                this.parameters.setParameter(parameter, previous);
            }
        }
        return previous;
    }

    public synchronized void setParameters(ConfigurationParameters parameters) {
        if (parameters == null) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_ARGUMENT, "parameters");
        }
        ConfigurationParameters candidate = new ConfigurationParameters(this.parameters);
        candidate.setParameters(parameters);
        this.validateParameters(candidate);
        this.parameters = candidate;
    }

    public synchronized ConfigurationParameters getParameters() {
        if (this.parameters == null) {
            return null;
        }
        return new ConfigurationParameters(this.parameters);
    }

    private void validateParameters(ConfigurationParameters parms) {
        boolean soap;
        ConnectionType connectionType = this.getConnectionType();
        boolean bl = soap = connectionType == ConnectionType.SOAP;
        if (soap && ConfigValueLookup.getBoolean(parms, ConfigurationParameter.CONNECTION_PARTICIPATES_IN_TRANSACTION, false)) {
            throw new EngineRuntimeException(ExceptionCode.API_INVALID_CONNECTION_PARAMETER, new Object[]{ConfigurationParameter.CONNECTION_PARTICIPATES_IN_TRANSACTION.toString()}, ExceptionContext.API_CONNECTION_PARAMETER_NOT_SUPPORTED_FOR_URI, new Object[]{this.uri});
        }
    }

    public String getPath() {
        String scheme;
        String path = this.asURI.getPath();
        if (path == null && (scheme = this.asURI.getScheme()) != null) {
            String asUrl = this.asURI.toString();
            int endIndex = asUrl.indexOf("/");
            path = asUrl.substring(endIndex);
        }
        return path;
    }

    public String getProviderURL() {
        if (this.asURI != null) {
            String scheme = this.asURI.getScheme();
            String authority = this.asURI.getAuthority();
            String providerUrl = null;
            if (scheme != null) {
                if (authority == null) {
                    String asUrl = this.asURI.toString();
                    int endIndex = asUrl.indexOf("/");
                    providerUrl = asUrl.substring(0, endIndex);
                } else {
                    providerUrl = scheme + "://" + authority;
                }
            }
            return providerUrl;
        }
        return null;
    }

    public String getURI() {
        return this.uri;
    }

    public URI getAsURI() {
        return this.asURI;
    }

    public synchronized boolean participatesInTransaction() {
        if (this.getConnectionType() == ConnectionType.SOAP) {
            return false;
        }
        return ConfigValueLookup.getBooleanDefault(this.parameters, ConfigurationParameter.CONNECTION_PARTICIPATES_IN_TRANSACTION, false);
    }

    public ConnectionType getConnectionType() {
        if (this.uri == null || this.uri.length() < 4) {
            return null;
        }
        if (this.uri.substring(0, 4).equalsIgnoreCase("http")) {
            return ConnectionType.SOAP;
        }
        return ConnectionType.EJB;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ConnectionImpl)) {
            return false;
        }
        ConnectionImpl other = (ConnectionImpl)object;
        return this.uri == other.uri || this.uri != null && this.uri.equalsIgnoreCase(other.uri);
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.uri != null ? this.uri.toLowerCase().hashCode() : 0);
        return result;
    }

    public synchronized String toString() {
        if (this.realConnection != null) {
            return "@" + this.realConnection.toString();
        }
        StringBuffer sb = new StringBuffer(128);
        sb.append(" Class=").append(this.getClass().getName());
        sb.append(" URI=").append(this.uri);
        sb.append(" Parameters=").append(this.parameters);
        return sb.toString();
    }

    public void setRealConnection(Connection realConnection) {
        this.realConnection = realConnection;
    }

    public Connection getRealConnection() {
        return this.realConnection;
    }

    public static synchronized void setSaveLastERE(boolean saveLastERE) {
        ConnectionImpl.saveLastERE = saveLastERE;
    }

    public static boolean isSaveLastERE() {
        return saveLastERE;
    }

    public static void setLastERE(EngineRuntimeException theERE) {
        lastERE.set(theERE);
    }

    public static EngineRuntimeException getLastERE() {
        EngineRuntimeException ere = lastERE.get();
        ConnectionImpl.setLastERE(null);
        return ere;
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.writeInt(5);
        s.writeObject(this.uri);
        s.writeObject(this.parameters);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.readInt();
        this.uri = (String)s.readObject();
        this.parameters = (ConfigurationParameters)s.readObject();
        this.init();
    }
}

