/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.collection;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.util.Id;
import com.filenet.apiimpl.collection.BinaryListImpl;
import com.filenet.apiimpl.collection.BooleanListImpl;
import com.filenet.apiimpl.collection.DateTimeListImpl;
import com.filenet.apiimpl.collection.Float64ListImpl;
import com.filenet.apiimpl.collection.IdListImpl;
import com.filenet.apiimpl.collection.Integer32ListImpl;
import com.filenet.apiimpl.collection.StringListImpl;
import com.filenet.apiimpl.core.EngineObjectImpl;
import com.filenet.apiimpl.core.ListImpl;
import com.filenet.apiimpl.core.SubListImpl;
import java.util.Date;
import java.util.List;

public class Lists {
    public static ListImpl createList(Class elementType, List elements) {
        if (elementType == byte[].class) {
            return new BinaryListImpl(elements);
        }
        if (elementType == Boolean.class) {
            return new BooleanListImpl(elements);
        }
        if (elementType == Date.class) {
            return new DateTimeListImpl(elements);
        }
        if (elementType == Double.class) {
            return new Float64ListImpl(elements);
        }
        if (elementType == Id.class) {
            return new IdListImpl(elements);
        }
        if (elementType == Integer.class) {
            return new Integer32ListImpl(elements);
        }
        if (elementType == String.class) {
            return new StringListImpl(elements);
        }
        return new SubListImpl(elementType, elements);
    }

    public static ListImpl createPropertyList(int propertyType, List elements) {
        switch (propertyType) {
            case 1: {
                return new BinaryListImpl(elements);
            }
            case 2: {
                return new BooleanListImpl(elements);
            }
            case 3: {
                return new DateTimeListImpl(elements);
            }
            case 4: {
                return new Float64ListImpl(elements);
            }
            case 5: {
                return new IdListImpl(elements);
            }
            case 6: {
                return new Integer32ListImpl(elements);
            }
            case 8: {
                return new StringListImpl(elements);
            }
        }
        return new SubListImpl(EngineObjectImpl.class, elements);
    }

    public static void checkType(Class expectedType, Object value) {
        if (expectedType == null || value == null) {
            return;
        }
        Class<?> actualType = value.getClass();
        if (!Lists.isCompatibleType(expectedType, actualType)) {
            throw new EngineRuntimeException(ExceptionCode.E_INVALID_OBJECT_TYPE, actualType);
        }
    }

    private static boolean isCompatibleType(Class expectedType, Class actualType) {
        return !Lists.isScalarType(expectedType) || expectedType.isAssignableFrom(actualType);
    }

    private static boolean isScalarType(Class elementType) {
        return byte[].class.isAssignableFrom(elementType) || Boolean.class.isAssignableFrom(elementType) || Date.class.isAssignableFrom(elementType) || Double.class.isAssignableFrom(elementType) || Id.class.isAssignableFrom(elementType) || Integer.class.isAssignableFrom(elementType) || String.class.isAssignableFrom(elementType);
    }
}

