/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.collection;

import com.filenet.api.collection.PageIterator;
import com.filenet.api.collection.PageMark;
import com.filenet.api.core.Connection;
import com.filenet.api.core.IndependentObject;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.collection.AbstractEngineSet;
import com.filenet.apiimpl.collection.ContinuationMark;
import com.filenet.apiimpl.collection.DefaultPaging;
import com.filenet.apiimpl.collection.Paging;
import com.filenet.apiimpl.collection.RepositoryRowCollectionImpl;
import com.filenet.apiimpl.core.SubSetImpl;
import com.filenet.apiimpl.query.SearchRowPaging;
import java.util.Collections;
import java.util.List;

public class EngineSetPageIterator
implements PageIterator {
    private final AbstractEngineSet set;
    private final Paging paging;
    private boolean firstSupported;
    private final String firstContinuation;
    private List firstPage;
    private List current;
    private String continuation;
    private int state = 0;
    private static final int BEFORE_FIRST = 0;
    private static final int AT_CURRENT = 1;
    private static final int AFTER_LAST = 2;
    private Boolean empty;
    private boolean failed;

    public EngineSetPageIterator(AbstractEngineSet set, Paging paging, List firstPage) {
        this.set = set;
        this.paging = paging;
        this.firstPage = firstPage;
        this.firstSupported = paging.firstPageSupported();
        this.firstContinuation = this.firstSupported ? null : paging.getContinuation();
    }

    public boolean nextPage() {
        this.failed = true;
        if (this.state == 0) {
            this.loadFirst();
            this.setCurrent(null, this.firstPage);
            this.clearFirst();
        } else if (this.state != 2) {
            if (this.set.getTraversalError() != null) {
                throw this.set.getTraversalError();
            }
            String cont = this.paging.getContinuation();
            List page = cont == null ? null : this.paging.nextPage();
            this.setCurrent(cont, page);
        }
        this.failed = false;
        return this.state == 1;
    }

    private void loadFirst() {
        if (this.firstSupported && this.firstPage == null) {
            this.firstPage = this.paging.firstPage();
        }
        if (this.firstPage == null) {
            this.firstPage = Collections.EMPTY_LIST;
        }
        Boolean bl = this.empty = this.firstPage.isEmpty() ? Boolean.TRUE : Boolean.FALSE;
        if (this.firstPage.isEmpty() && null != this.paging.getContinuation()) {
            this.paging.nextPage();
        }
    }

    private void clearFirst() {
        if (this.firstSupported) {
            this.firstPage = null;
        } else {
            this.paging.setContinuation(this.firstContinuation);
        }
    }

    private void setCurrent(String mark, List page) {
        if (page == null || page.isEmpty()) {
            this.current = null;
            this.continuation = null;
            this.state = 2;
        } else {
            this.current = page;
            this.continuation = mark;
            this.state = 1;
        }
    }

    public PageMark getPageMark() {
        return new ContinuationMark(this.continuation, this.state);
    }

    public void reset() {
        this.reset(null, 0);
    }

    public void reset(PageMark pageMark) {
        ContinuationMark mark = (ContinuationMark)pageMark;
        int computedState = Math.min(2, Math.max(0, mark.getState()));
        String cont = mark.getContinuation();
        if (computedState == 0) {
            this.reset(null, 0);
        } else if (computedState == 1 && cont == null) {
            this.reset(null, 0);
        } else if (computedState == 1 && cont != null) {
            this.reset(cont, 1);
        } else {
            this.reset(null, 2);
        }
    }

    private void reset(String pagingContinuation, int resetState) {
        this.clearFirst();
        this.current = null;
        this.state = resetState;
        this.continuation = pagingContinuation;
        this.paging.setContinuation(pagingContinuation);
    }

    boolean isEmpty() {
        if (this.empty == null) {
            this.loadFirst();
        }
        return this.empty == Boolean.TRUE;
    }

    boolean hasFailed() {
        return this.failed;
    }

    public Object[] getCurrentPage() {
        this.checkCurrent();
        return this.set.toArray(this.current);
    }

    public int getElementCount() {
        this.checkCurrent();
        return this.current.size();
    }

    private void checkCurrent() {
        if (this.state == 0) {
            throw new EngineRuntimeException(ExceptionCode.API_BEFORE_FIRST_PAGE_ELEMENT);
        }
        if (this.state == 2) {
            throw new EngineRuntimeException(ExceptionCode.API_AFTER_LAST_PAGE_ELEMENT);
        }
        if (this.current == null) {
            throw new EngineRuntimeException(ExceptionCode.API_BEFORE_NEXT_PAGE_ELEMENT);
        }
    }

    public int getPageSize() {
        Integer size = this.paging.getPageSize();
        int value = size == null ? 0 : size;
        return value > 0 ? value : 0;
    }

    public void setPageSize(int pageSize) {
        Integer size = pageSize > 0 ? new Integer(pageSize) : null;
        this.paging.setPageSize(size);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(1024);
        sb.append(" Class=").append(this.getClass().getName());
        sb.append(" Paging=(").append(this.paging).append(')');
        sb.append(" FirstSupported=").append(this.firstSupported);
        sb.append(" FirstContinuation=").append(this.firstContinuation);
        sb.append(" FirstPage=(").append(this.firstPage).append(')');
        sb.append(" Current=(").append(this.current).append(')');
        sb.append(" Continuation=").append(this.continuation);
        sb.append(" State=").append(this.state);
        sb.append(" Empty=").append(this.empty);
        sb.append(" Failed=").append(this.failed);
        return sb.toString();
    }

    public byte[] getCurrentPageCheckpoint() {
        DefaultPaging nextPaging = (DefaultPaging)this.paging;
        if (!nextPaging.isPageable()) {
            throw new EngineRuntimeException(ExceptionCode.API_CHECKPOINT_UNSUPPORTED);
        }
        DefaultPaging thisPaging = nextPaging.newInstance();
        thisPaging.copyValue(nextPaging);
        thisPaging.setContinuation(this.continuation);
        return thisPaging.getPagingCheckpoint();
    }

    public byte[] getNextPageCheckpoint() {
        DefaultPaging nextPaging = (DefaultPaging)this.paging;
        if (!nextPaging.isPageable()) {
            throw new EngineRuntimeException(ExceptionCode.API_CHECKPOINT_UNSUPPORTED);
        }
        return nextPaging.getPagingCheckpoint();
    }

    public static PageIterator resumeFromCheckpoint(Connection conn, byte[] checkpoint) {
        DefaultPaging pg = DefaultPaging.resumeFromCheckpoint(checkpoint);
        pg.setConnection(conn);
        if (pg.isPageable()) {
            pg.setForcedFirstPageSupported(true);
        }
        AbstractEngineSet aes = null;
        aes = pg instanceof SearchRowPaging ? new RepositoryRowCollectionImpl(conn) : new SubSetImpl(IndependentObject.class, null);
        EngineSetPageIterator it = new EngineSetPageIterator(aes, pg, null);
        String thisContinuation = pg.getContinuation();
        ContinuationMark cm = new ContinuationMark(thisContinuation, thisContinuation == null ? 0 : 1);
        it.reset(cm);
        return it;
    }
}

