/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.collection;

import com.filenet.api.core.Connection;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.collection.AbstractEngineSet;
import com.filenet.apiimpl.collection.Paging;
import com.filenet.apiimpl.core.Session;
import com.filenet.apiimpl.util.BinaryInputStream;
import com.filenet.apiimpl.util.BinaryOutputStream;
import com.filenet.apiimpl.util.DelegateInputStream;
import com.filenet.apiimpl.util.DelegateOutputStream;
import com.filenet.apiimpl.util.SessionLocator;
import com.filenet.apiimpl.util.Streams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.List;

public class DefaultPaging
implements Paging,
Serializable {
    private Connection connection;
    private Integer pageSize;
    private String continuation;
    private static final boolean FIRST_PAGE_SUPPORTED = false;
    private Boolean forcedFirstPageSupported = null;
    private static final long serialVersionUID = 2074171330418683643L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];
    public static final int NULL_PAGING = 0;
    public static final int DEFAULT_PAGING = 1;
    public static final int PROPERTY_SET_PAGING = 2;
    public static final int SEARCH_OBJECT_PAGING = 3;
    public static final int SEARCH_ROW_PAGING = 4;
    private static final int FIRST_FLAG = 1;
    private static final int SECOND_FLAG = 2;
    protected static final int THIRD_FLAG = 4;
    protected static final int FOURTH_FLAG = 8;
    private static final int NULL_PAGE_SIZE = 1;
    private static final int NULL_CONTINUATION = 2;

    public final Paging copy() {
        DefaultPaging copy = this.newInstance();
        copy.connection = this.connection;
        copy.copyValue(this);
        return copy;
    }

    protected DefaultPaging newInstance() {
        return new DefaultPaging();
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    protected Integer getPageSize(Integer defaultValue) {
        Integer pgSize = this.getPageSize();
        return pgSize == null ? defaultValue : pgSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getContinuation() {
        return this.continuation;
    }

    public void setContinuation(String continuation) {
        this.continuation = continuation;
    }

    public boolean firstPageSupported() {
        boolean fps = this.forcedFirstPageSupported != null && this.forcedFirstPageSupported != false;
        return fps && this.isPageable();
    }

    public void setForcedFirstPageSupported(boolean b) {
        this.forcedFirstPageSupported = b;
    }

    public List firstPage() {
        if (!this.firstPageSupported()) {
            return null;
        }
        return this.fetchPage(null);
    }

    public List nextPage() {
        String cont = this.getContinuation();
        if (cont == null) {
            return null;
        }
        return this.fetchPage(cont);
    }

    private List fetchPage(String cont) {
        List list;
        if (!this.isPageable()) {
            return null;
        }
        Connection conn = this.getConnection();
        if (conn == null) {
            return null;
        }
        Session session = SessionLocator.getSession(conn);
        if (session == null) {
            return null;
        }
        AbstractEngineSet set = this.fetchSet(session, cont);
        List page = null;
        cont = null;
        if (set != null && (list = set.getList()) != null && list.size() > 0) {
            page = list;
            Paging paging = set.getPaging();
            if (paging != null) {
                cont = paging.getContinuation();
            }
        }
        this.setContinuation(cont);
        return page;
    }

    protected boolean isPageable() {
        return false;
    }

    protected AbstractEngineSet fetchSet(Session session, String cont) {
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(1024);
        sb.append(" Class=").append(this.getClass().getName());
        sb.append(" Connection=(").append(this.connection).append(')');
        sb.append(" PageSize=").append(this.pageSize);
        sb.append(" Continuation=").append(this.continuation);
        return sb.toString();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeShort(5);
        s.writeObject(this.connection);
        Streams.getInstance().getDelegate(s).putPagingContext(this);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        Streams streams = Streams.getInstance(s.readShort());
        this.connection = (Connection)s.readObject();
        this.copyValue(streams.getDelegate(s, this.connection).getPagingContext());
    }

    public int getClassType() {
        return 1;
    }

    protected int getStreamFlags() {
        int flags = 0;
        flags |= this.pageSize == null ? 1 : 0;
        return flags |= this.continuation == null ? 2 : 0;
    }

    public void serializeValue(DelegateOutputStream s) throws IOException {
        s.writeByte(this.getStreamFlags());
        if (this.pageSize != null) {
            s.writeInt(this.pageSize);
        }
        if (this.continuation != null) {
            s.writeObject(this.continuation);
        }
    }

    public final void deserializeValue(DelegateInputStream s, Connection conn) throws IOException, ClassNotFoundException {
        this.connection = conn;
        this.deserializeValue(s, 0xFF & s.readByte());
    }

    protected void deserializeValue(DelegateInputStream s, int flags) throws IOException, ClassNotFoundException {
        if ((flags & 1) == 0) {
            this.pageSize = new Integer(s.readInt());
        }
        if ((flags & 2) == 0) {
            this.continuation = (String)s.readObject();
        }
    }

    protected void copyValue(DefaultPaging source) {
        this.pageSize = source.pageSize;
        this.continuation = source.continuation;
    }

    public byte[] getPagingCheckpoint() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            BinaryOutputStream bos = BinaryOutputStream.getInstance((short)5, baos);
            bos.putPagingContext(this);
        }
        catch (IOException e) {
            throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
        return baos.toByteArray();
    }

    public static DefaultPaging resumeFromCheckpoint(byte[] checkpoint) {
        ByteArrayInputStream bais = new ByteArrayInputStream(checkpoint);
        try {
            BinaryInputStream bis = BinaryInputStream.getInstance((short)5, bais, null);
            DefaultPaging dp = bis.getPagingContext();
            return dp;
        }
        catch (EngineRuntimeException ere) {
            throw ere;
        }
        catch (Exception e) {
            throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
    }
}

