/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.authentication.util;

import com.filenet.apiimpl.authentication.FnceCallbackHandler;
import com.filenet.apiimpl.authentication.util.AuthnUtil;
import com.filenet.apiimpl.authentication.util.J2EEAuthnUtil;
import java.security.Principal;
import java.util.HashMap;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class KrbAuthnUtil {
    private static final long EXPIRATION_FUDGE_MSEC = 120000L;
    private static final long NO_TICKET_EXPIRATION = 0x6DDD00L;
    private static final String FNAME = "[KrbAuthnUtil] ";
    private static HashMap cachedTGTs = new HashMap();

    private KrbAuthnUtil() {
    }

    public static Subject tgtLogin(String name, char[] password, String config, String keytab, String spn, boolean isDebug) throws LoginException {
        return KrbAuthnUtil.tgtLogin(name, password, config, keytab, spn, isDebug, false);
    }

    public static synchronized Subject tgtLogin(String name, char[] password, String config, String keytab, String spn, boolean isDebug, boolean isForceRefresh) throws LoginException {
        LoginInfo linfo = KrbAuthnUtil.cacheCheck(name, spn, isDebug, isForceRefresh);
        boolean isNewSubject = false;
        boolean isNewLoginInfo = false;
        if (linfo == null) {
            isNewSubject = true;
            isNewLoginInfo = true;
            linfo = new LoginInfo();
        } else if (linfo.subject == null) {
            isNewSubject = true;
        }
        if (isNewSubject) {
            if (config != null) {
                FnceCallbackHandler handler = new FnceCallbackHandler(name, password);
                LoginContext context = new LoginContext(config, handler);
                context.login();
                linfo.subject = context.getSubject();
            } else {
                linfo.subject = J2EEAuthnUtil.getInstance().defaultTgtLogin(name, password, keytab, isDebug);
            }
            if (isDebug) {
                AuthnUtil.log("[KrbAuthnUtil] TGT login successful");
            }
            linfo.created = System.currentTimeMillis();
            linfo.expires = -1L;
            if (isNewLoginInfo) {
                String canonicalName = ((Principal)linfo.subject.getPrincipals().toArray()[0]).getName();
                LoginInfo cachedLinfo = KrbAuthnUtil.cacheCheck(canonicalName, spn, isDebug, isForceRefresh);
                if (cachedLinfo != null) {
                    if (cachedLinfo.subject != null) {
                        if (isDebug) {
                            AuthnUtil.log("[KrbAuthnUtil] linking '" + name + "' with cached canonical name entry and using cached entry's subject");
                        }
                    } else {
                        if (isDebug) {
                            AuthnUtil.log("[KrbAuthnUtil] linking '" + name + "' with expired cached canonical name entry and using new subject");
                        }
                        cachedLinfo.subject = linfo.subject;
                        cachedLinfo.created = linfo.created;
                        cachedLinfo.expires = -1L;
                    }
                    linfo = cachedLinfo;
                } else if (!canonicalName.equals(name)) {
                    cachedTGTs.put(canonicalName + '|' + spn, linfo);
                }
                cachedTGTs.put(name + '|' + spn, linfo);
            }
        }
        return linfo.subject;
    }

    public static KerberosTicket findKrbCredentials(Subject subject, String spn) {
        for (Object obj : subject.getPrivateCredentials()) {
            if (!(obj instanceof KerberosTicket)) continue;
            KerberosTicket ticket = (KerberosTicket)obj;
            String s = ticket.getServer().getName();
            if (!(spn == null ? s.startsWith("krbtgt/") : s.startsWith(spn) && (spn.indexOf(64) > 0 ? s.length() == spn.length() : s.charAt(spn.length()) == '@'))) continue;
            return ticket;
        }
        return null;
    }

    public static KerberosKey findKrbKey(Subject subject, String name) {
        KerberosKey key = null;
        for (Object obj : subject.getPrivateCredentials()) {
            KerberosKey kk;
            if (!(obj instanceof KerberosKey) || !name.equals((kk = (KerberosKey)obj).getPrincipal().getName())) continue;
            key = kk;
            break;
        }
        return key;
    }

    private static LoginInfo cacheCheck(String name, String spn, boolean isDebug, boolean isForceRefresh) {
        String key = name + '|' + spn;
        LoginInfo linfo = (LoginInfo)cachedTGTs.get(key);
        if (linfo != null) {
            long timeLeft;
            if (linfo.expires == -1L && linfo.subject != null) {
                KerberosTicket t = KrbAuthnUtil.findKrbCredentials(linfo.subject, spn);
                linfo.expires = t == null ? linfo.created + 0x6DDD00L : t.getEndTime().getTime() - 120000L;
            }
            if ((timeLeft = linfo.expires - System.currentTimeMillis()) < 0L || isForceRefresh) {
                if (isDebug) {
                    if (isForceRefresh) {
                        AuthnUtil.log("[KrbAuthnUtil] cached ticket invalidated because of forced refresh; renewing ticket");
                    } else {
                        AuthnUtil.log("[KrbAuthnUtil] cached ticket expired " + -timeLeft + " msec ago; renewing ticket");
                    }
                }
                linfo.subject = null;
            } else if (isDebug) {
                AuthnUtil.log("[KrbAuthnUtil] reusing cached ticket with " + timeLeft + " msec remaining");
            }
        }
        return linfo;
    }

    private static class LoginInfo {
        Subject subject;
        long expires;
        long created;

        private LoginInfo() {
        }
    }
}

