/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.authentication.util;

import com.filenet.apiimpl.authentication.FnceCallbackHandler;
import com.filenet.apiimpl.authentication.util.AuthnUtil;
import com.filenet.apiimpl.authentication.util.J2EEAuthnUtil;
import com.filenet.apiimpl.authentication.util.LmState;
import com.filenet.apiimpl.exception.ExceptionAuthn;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;

class J2EEAuthnUtilWL
extends J2EEAuthnUtil {
    private static final String FNAME = "[J2EEAuthnUtilWL] ";
    private static Method m_Authenticate_authenticate;
    private static Method m_Authentication_login;
    private static Method m_Environment_setProviderUrl;
    private static Method m_Environment_setSecurityCredentials;
    private static Method m_Environment_setSecurityPrincipal;
    private static Method m_Security_getCurrentSubject;
    private static Method m_Security_runAs;
    private static Method m_Security_runAsEx;
    private static Method m_URLCallback_setURL;
    private static Class m_Environment;
    private static Constructor m_WLSGroupImpl;
    private static Constructor m_WLSUserImpl;

    protected J2EEAuthnUtilWL() {
        fname = FNAME;
    }

    public Subject doServerLogin(String config, String username, char[] password, boolean isDebug) throws LoginException {
        if (isDebug) {
            AuthnUtil.log(fname + "doServerLogin for '" + username + '\'');
        }
        try {
            FnceCallbackHandler handler = new FnceCallbackHandler(username, password);
            return (Subject)m_Authentication_login.invoke(null, handler);
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException && e.getCause() != null) {
                e = (Exception)((InvocationTargetException)e).getCause();
            }
            AuthnUtil.error(fname + "Authentication.login failed: " + e.getLocalizedMessage());
            if (e instanceof LoginException) {
                throw (LoginException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw J2EEAuthnUtilWL.wrappedException(e);
        }
    }

    public Subject doServerLogin(String config, CallbackHandler handler, boolean isDebug) throws LoginException {
        if (isDebug) {
            AuthnUtil.log(fname + "doServerLogin using a callback handler");
        }
        try {
            return (Subject)m_Authentication_login.invoke(null, handler);
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException && e.getCause() != null) {
                e = (Exception)((InvocationTargetException)e).getCause();
            }
            AuthnUtil.error(fname + "Authentication.login failed: " + e.getLocalizedMessage());
            if (e instanceof LoginException) {
                throw (LoginException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw J2EEAuthnUtilWL.wrappedException(e);
        }
    }

    public boolean precommitClientLogin(LmState state, char[] credential) throws LoginException, IOException {
        if (credential == null) {
            throw new IllegalArgumentException();
        }
        try {
            Subject temp = new Subject();
            Object env = m_Environment.newInstance();
            m_Environment_setProviderUrl.invoke(env, J2EEAuthnUtilWL.getProviderURL());
            m_Environment_setSecurityPrincipal.invoke(env, state.fullName);
            m_Environment_setSecurityCredentials.invoke(env, new String(credential));
            if (state.isDebug) {
                AuthnUtil.log(fname + "precommit authenticate");
            }
            m_Authenticate_authenticate.invoke(null, env, temp);
            if (temp == null) {
                AuthnUtil.warn(fname + "precommit authenticate returned null subject");
                throw new FailedLoginException(ExceptionAuthn.SECURITY_SUBJECT_NULL.toString());
            }
            state.newPrincipals.addAll(temp.getPrincipals());
            state.newPublicCredentials.addAll(temp.getPublicCredentials());
            state.newPrivateCredentials.addAll(temp.getPrivateCredentials());
            if (state.extraCred != null) {
                state.newPrivateCredentials.add(state.extraCred);
            }
            return true;
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException && e.getCause() != null) {
                e = (Exception)((InvocationTargetException)e).getCause();
            }
            AuthnUtil.error(fname + "precommitClientLogin: " + e.getLocalizedMessage());
            if (e instanceof LoginException) {
                throw (LoginException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw J2EEAuthnUtilWL.wrappedException(e);
        }
    }

    public void addUserPrincipal(LmState state, String name) {
        Principal princ = (Principal)J2EEAuthnUtilWL.reflectionConstructor(m_WLSUserImpl, new Object[]{name});
        state.newPrincipals.add(princ);
    }

    public void addGroupPrincipal(LmState state, String name) {
        Principal princ = (Principal)J2EEAuthnUtilWL.reflectionConstructor(m_WLSGroupImpl, new Object[]{name});
        state.newPrincipals.add(princ);
    }

    public Object runAs(Subject subject, PrivilegedAction action) {
        return J2EEAuthnUtilWL.reflectionCall(m_Security_runAs, null, new Object[]{subject, action});
    }

    public Object runAs(Subject subject, PrivilegedExceptionAction action) throws Exception {
        try {
            return m_Security_runAsEx.invoke(null, subject, action);
        }
        catch (InvocationTargetException ite) {
            Exception e = (Exception)ite.getCause();
            if (e != null) {
                throw e;
            }
            throw ite;
        }
    }

    public Subject getCurrentSubject() {
        return (Subject)J2EEAuthnUtilWL.reflectionCall(m_Security_getCurrentSubject, null, null);
    }

    public void handleCallback(Callback callback, Map textValues) throws UnsupportedCallbackException {
        String className = callback.getClass().getName();
        if (className.equals("weblogic.security.auth.callback.URLCallback")) {
            String url = (String)textValues.get("URL");
            J2EEAuthnUtilWL.reflectionCall(m_URLCallback_setURL, callback, new Object[]{url != null ? url : J2EEAuthnUtilWL.getProviderURL()});
        } else {
            super.handleCallback(callback, textValues);
        }
    }

    static {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> cAuthenticate = Class.forName("weblogic.security.auth.Authenticate", false, cl);
            Class<?> cAuthentication = Class.forName("weblogic.security.services.Authentication", false, cl);
            Class<?> cEnvironment = Class.forName("weblogic.jndi.Environment", false, cl);
            Class<?> cSecurity = Class.forName("weblogic.security.Security", false, cl);
            Class<?> cURLCallback = Class.forName("weblogic.security.auth.callback.URLCallback", false, cl);
            Class<?> cWLSGroupImpl = Class.forName("weblogic.security.principal.WLSGroupImpl", false, cl);
            Class<?> cWLSUserImpl = Class.forName("weblogic.security.principal.WLSUserImpl", false, cl);
            m_Authenticate_authenticate = cAuthenticate.getMethod("authenticate", cEnvironment, Subject.class);
            m_Authentication_login = cAuthentication.getMethod("login", CallbackHandler.class);
            m_Environment_setProviderUrl = cEnvironment.getMethod("setProviderUrl", String.class);
            m_Environment_setSecurityCredentials = cEnvironment.getMethod("setSecurityCredentials", Object.class);
            m_Environment_setSecurityPrincipal = cEnvironment.getMethod("setSecurityPrincipal", String.class);
            m_Security_getCurrentSubject = cSecurity.getMethod("getCurrentSubject", null);
            m_Security_runAs = cSecurity.getMethod("runAs", Subject.class, PrivilegedAction.class);
            m_Security_runAsEx = cSecurity.getMethod("runAs", Subject.class, PrivilegedExceptionAction.class);
            m_URLCallback_setURL = cURLCallback.getMethod("setURL", String.class);
            m_Environment = cEnvironment;
            m_WLSGroupImpl = cWLSGroupImpl.getConstructor(String.class);
            m_WLSUserImpl = cWLSUserImpl.getConstructor(String.class);
        }
        catch (Exception e) {
            AuthnUtil.error("[J2EEAuthnUtilWL] Failed static initialization: " + e.getLocalizedMessage());
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw J2EEAuthnUtilWL.wrappedException(e);
        }
    }
}

