/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.authentication.util;

import com.filenet.apiimpl.authentication.FnceCallbackHandler;
import com.filenet.apiimpl.authentication.util.AuthnUtil;
import com.filenet.apiimpl.authentication.util.DynLoginContext;
import com.filenet.apiimpl.authentication.util.J2EEAuthnUtil;
import com.filenet.apiimpl.authentication.util.LmState;
import com.filenet.apiimpl.exception.ExceptionAuthn;
import com.filenet.apiimpl.util.J2EEType;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.Principal;
import java.security.PrivilegedExceptionAction;
import java.security.acl.Group;
import java.util.Set;
import javax.security.auth.Destroyable;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class J2EEAuthnUtilJB
extends J2EEAuthnUtil {
    private static final String FNAME = "[J2EEAuthnUtilJB] ";
    private static final String NAME_KEY = "javax.security.auth.login.name";
    private static final String PASSWORD_KEY = "javax.security.auth.login.password";
    private static Constructor m_SimplePrincipal;
    private static Constructor m_SimpleGroup;
    private static Method m_clear;
    private static Method m_getSubject;

    protected J2EEAuthnUtilJB() {
        fname = FNAME;
    }

    public boolean precommitClientLogin(LmState state, char[] credential) throws LoginException, IOException {
        if (credential == null) {
            throw new IllegalArgumentException();
        }
        try {
            if (state.isDebug) {
                AuthnUtil.log(fname + "precommit authenticate");
            }
            if (!J2EEType.isInitialContextOk()) {
                AuthnUtil.warn(fname + "InitialContext not okay!");
            }
            FnceCallbackHandler handler = new FnceCallbackHandler(state.princName, credential);
            LoginContext lc = new LoginContext("FileNetP8", handler);
            lc.login();
            Subject temp = lc.getSubject();
            if (temp == null) {
                AuthnUtil.warn(fname + "precommit authenticate returned null subject");
                throw new FailedLoginException(ExceptionAuthn.SECURITY_SUBJECT_NULL.toString());
            }
            if (state.isDebug) {
                AuthnUtil.log(fname + "precommit ClientContainer login successful");
            }
            state.newPrincipals.addAll(temp.getPrincipals());
            state.newPublicCredentials.addAll(temp.getPublicCredentials());
            state.newPrivateCredentials.addAll(temp.getPrivateCredentials());
            if (state.extraCred != null) {
                state.newPrivateCredentials.add(state.extraCred);
            }
            return true;
        }
        catch (Exception e) {
            AuthnUtil.error(fname + "precommitClientLogin: " + e.getLocalizedMessage());
            if (e instanceof LoginException) {
                throw (LoginException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw J2EEAuthnUtilJB.wrappedException(e);
        }
    }

    public void cleanupLogin(LmState state) {
        if (state.isClient) {
            state.sharedState.remove(NAME_KEY);
            state.sharedState.remove(PASSWORD_KEY);
        }
        super.cleanupLogin(state);
    }

    public void addUserPrincipal(LmState state, String name) {
        Principal princ = J2EEAuthnUtilJB.createPrincipal(name);
        Group group = J2EEAuthnUtilJB.createGroup("CallerPrincipal");
        group.addMember(princ);
        state.newPrincipals.add(princ);
        state.newPrincipals.add(group);
    }

    public void addGroupPrincipal(LmState state, String name) {
        Principal princ = J2EEAuthnUtilJB.createPrincipal(name);
        Group group = J2EEAuthnUtilJB.createGroup("Roles");
        group.addMember(princ);
        state.newPrincipals.add(group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object runAs(Subject subject, PrivilegedExceptionAction action) throws Exception {
        DynLoginContext lc = J2EEAuthnUtilJB.setupSecurity(subject);
        if (lc != null) {
            try {
                Object object = super.runAs(subject, action);
                return object;
            }
            finally {
                try {
                    lc.logout();
                }
                catch (LoginException le) {
                    throw J2EEAuthnUtilJB.wrappedException(le);
                }
            }
        }
        return super.runAs(subject, action);
    }

    public Subject getCurrentSubject() {
        return (Subject)J2EEAuthnUtilJB.reflectionCall(m_getSubject, null, null);
    }

    public void fixupCachedSubject(Subject subject) {
        try {
            AppConfigurationEntry conf = DynLoginContext.buildConf("org.jboss.security.AltClientLoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, null, new String[]{"multi-threaded=true", "password-stacking=useFirstPass"});
            DynLoginContext lc = new DynLoginContext(subject, null, conf, false);
            subject = lc.getSubject();
        }
        catch (Exception e) {
            String msg = ExceptionAuthn.SECURITY_FAILED_FIXUP_CACHED_SUBJECT.toString(new Object[]{e.getLocalizedMessage()});
            AuthnUtil.error(FNAME + msg);
            throw (IllegalStateException)new IllegalStateException(msg).initCause(e);
        }
    }

    public boolean isCachingNeeded() {
        return true;
    }

    public static Principal createPrincipal(String name) {
        return (Principal)J2EEAuthnUtilJB.reflectionConstructor(m_SimplePrincipal, new Object[]{name});
    }

    public static Group createGroup(String name) {
        return (Group)J2EEAuthnUtilJB.reflectionConstructor(m_SimpleGroup, new Object[]{name});
    }

    public static void securityClear() {
        J2EEAuthnUtilJB.reflectionCall(m_clear, null, null);
    }

    public static Object cacheCred(Object cred) {
        return new Token(cred);
    }

    public static Object getCred(Object token) {
        if (token instanceof Token) {
            return ((Token)token).getCred();
        }
        return null;
    }

    private static DynLoginContext setupSecurity(Subject subject) {
        if (subject == null) {
            J2EEAuthnUtilJB.securityClear();
        } else {
            Set<Principal> prins = subject.getPrincipals();
            if (prins != null && !prins.isEmpty()) {
                Set<Token> creds = subject.getPrivateCredentials(Token.class);
                if (creds != null && !creds.isEmpty()) {
                    Token token = creds.iterator().next();
                    Object cred = J2EEAuthnUtilJB.getCred(token);
                    if (cred == null) {
                        return null;
                    }
                    Principal curPrin = prins.iterator().next();
                    char[] pw = null;
                    pw = cred instanceof char[] ? (char[])cred : cred.toString().toCharArray();
                    FnceCallbackHandler ch = new FnceCallbackHandler(curPrin.getName(), pw);
                    DynLoginContext lc = null;
                    try {
                        AppConfigurationEntry conf = DynLoginContext.buildConf("org.jboss.security.ClientLoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, null, new String[]{"restore-login-identity=true", "multi-threaded=true"});
                        lc = new DynLoginContext(null, (CallbackHandler)ch, conf, false);
                        lc.login();
                    }
                    catch (LoginException le) {
                        throw J2EEAuthnUtilJB.wrappedException(le);
                    }
                    return lc;
                }
            } else {
                AuthnUtil.warn("[J2EEAuthnUtilJB] setupSecurity: subject has no principal");
            }
        }
        return null;
    }

    static {
        J2EEType.setAppServerType(2);
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> cSimplePrincipal = Class.forName("org.jboss.security.SimplePrincipal", false, cl);
            Class<?> cSimpleGroup = Class.forName("org.jboss.security.SimpleGroup", false, cl);
            Class<?> cSecurityAssociation = Class.forName("org.jboss.security.SecurityAssociation", false, cl);
            m_SimplePrincipal = cSimplePrincipal.getConstructor(String.class);
            m_SimpleGroup = cSimpleGroup.getConstructor(String.class);
            m_getSubject = cSecurityAssociation.getMethod("getSubject", null);
            m_clear = cSecurityAssociation.getMethod("clear", null);
        }
        catch (Exception e) {
            AuthnUtil.error("[J2EEAuthnUtilJB] Failed static initialization: " + e.getLocalizedMessage());
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw J2EEAuthnUtilJB.wrappedException(e);
        }
    }

    private static class Token
    implements Destroyable {
        private static final byte[] m = J2EEAuthnUtilJB.class.getName().getBytes();
        private static final int mmax = m.length;
        private Object eCred;
        private long tm;

        Token(Object cred) {
            this.eCred = cred;
            if (cred instanceof char[]) {
                int addr = System.identityHashCode(this);
                this.tm = System.currentTimeMillis() + 1000L * (long)addr;
                this.eCred = this.crypt();
            }
        }

        Object getCred() {
            if (this.eCred instanceof char[]) {
                return this.crypt();
            }
            return this.eCred;
        }

        public void destroy() {
            if (this.eCred != null && !(this.eCred instanceof char[])) {
                AuthnUtil.destroyCred(this.eCred);
            }
        }

        public boolean isDestroyed() {
            if (this.eCred != null && this.eCred instanceof Destroyable) {
                return ((Destroyable)this.eCred).isDestroyed();
            }
            return false;
        }

        private char[] crypt() {
            long t = this.tm;
            byte[] b = new byte[3];
            b[0] = (byte)(t & 0xFFL);
            for (int i = 1; i < 3; ++i) {
                b[i] = (byte)((t >>= 8) & 0xFFL ^ (long)(b[i - 1] << 1));
            }
            char[] s = (char[])this.eCred;
            int cmax = s.length;
            char[] c = new char[cmax];
            int bx = 0;
            int mx = 0;
            for (int i = 0; i < cmax; ++i) {
                int x = s[i] & 0xFF;
                int y = s[i] >> 8 & 0xFF;
                x ^= b[bx++] ^ m[mx++];
                if (bx >= 3) {
                    bx = 0;
                }
                if (mx >= mmax) {
                    mx = 0;
                }
                y ^= b[bx++] ^ m[mx++];
                if (bx >= 3) {
                    bx = 0;
                }
                if (mx >= mmax) {
                    mx = 0;
                }
                int z = y << 8 | x & 0xFF;
                c[i] = (char)z;
            }
            return c;
        }
    }
}

